/*
 * dostatfs - the heart of spacefor.statfs
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/mount.h>
#ifndef MNAMELEN
/* this does not seem to be a 4.4BSD, try for SunOS */
#include <sys/vfs.h>
#define	f_fsize	f_bsize		/* idiotic incompatible naming in 4.4 */
#endif

int debug = 0;
char *progname;

extern void error(), exit();

/*
 - main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int errflg = 0;
	extern int optind;
	extern char *optarg;
	void process();
	extern long atol();
	extern double atof();

	progname = argv[0];

	while ((c = getopt(argc, argv, "d")) != EOF)
		switch (c) {
		case 'd':	/* Debugging. */
			debug++;
			break;
		case '?':
		default:
			errflg++;
			break;
		}
	if (errflg || optind != argc-4 || !num(argv[optind]) ||
						!num(argv[optind+2]) ||
						!num(argv[optind+3])) {
		fprintf(stderr, "usage: %s ", progname);
		fprintf(stderr, "filesize fileonfs wantspace wantinodes\n");
		exit(2);
	}

	process((long)atof(argv[optind]), argv[optind+1],
				atol(argv[optind+2]), atol(argv[optind+3]));
	exit(0);
}

/*
 - num - is a string numeric?
 */
int				/* predicate */
num(s)
char *s;
{
	return(strspn(s, "0123456789.eE+-") == strlen(s));
}

/*
 - process - do the work
 */
void
process(filesize, fileonfs, wantspace, wantinodes)
long filesize;
char *fileonfs;
long wantspace;
long wantinodes;
{
	struct statfs info;
	register long n;
#	define	LOTS	10000

	if (statfs(fileonfs, &info) < 0)
		error("cannot do statfs(%s)", fileonfs);
	if (debug)
		fprintf(stderr, "bsize %ld, avail %ld, inodes %ld\n",
				info.f_fsize, info.f_bavail, info.f_ffree);

	n = LOTS;
	if (info.f_bavail <= wantspace)
		n = 0;
	else if (info.f_fsize > 0 && filesize > 0)
		n = (info.f_bavail - wantspace) / (filesize/info.f_fsize + 1);

	if (info.f_ffree <= wantinodes)
		n = 0;
	else if (info.f_ffree - wantinodes < n)
		n = info.f_ffree - wantinodes;

	if (n < 0)
		n = 0;
	else if (n > LOTS)
		n = LOTS;	/* to avert 16-bit trouble elsewhere */

	printf("%ld\n", n);
}
