
/*
 *
$Log: print.c,v $
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

void
printCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    String s;
    char line[MAXLINE], command[MAXLINE];
    char filename[MAXLINE];
    FILE *fp;
    int retval;

    if (currentDisplayText == NULL) {
        return;
    }


    /* get text */
    s = XawUtkGetText(currentDisplayText);

    if ((s == NULL) || (strlen(s) < 1)) {
        set_status("nothing to print", YELLOW);
        return;
    }

    /* get tmp file name */
    strcpy(filename, tmpnam(NULL));
    if (!filename) {
        set_status("couldn't allocate temporay file name", RED);
        XtFree(s);
        return;
    }

    /* load tmp file */
    fp = fopen(filename, "w");
    if ( fp ) {
        fputs(s, fp);
        fclose(fp);
    } else {
        sprintf(line, "couldn't open temp file ( %s )", filename);
        set_status(line, RED);
    }

    XtFree(s);

    /* print it */
    sprintf(command, PRINT_COMMAND, filename);
    retval = system(command);
    retval &= 127;
    if ( retval ) {
        sprintf(line, "couldn't print using ( %s )", command);
        set_status(line, RED);
    } else {
        set_status("printed the text", GREEN);
    }

    /* remove the tmp file */
    unlink(filename);

}

