#include "xnl.h"

/*
 *
$Log: file_access.c,v $
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */



/* the logic of getFile goes like this:

	get the local tag and age
	  if the age is < IDX_LIFE return True
	  
	get the remote tag for the file
	
	  	if the tags don't match (like maybe we don't have the local one)
	  	then get the remote file
	  	
	  return True

  Tags are put on the first line in the local index file.
*/
getFile(server, file, lib, pub, idle_display, quiet)
char *server, *file, *lib;
int pub;
Boolean idle_display, quiet;
{
    FILE *fp, *fp2;
    int c;
    int s; /* the socket */
    int retval;
    unsigned long age;
    char xnlpath[MAXLINE];
    char filename[MAXLINE], tagname[MAXLINE], remotefilename[MAXLINE];
    char localtag[MAXLINE], localage[MAXLINE], remotetag[MAXLINE];
	char line[MAXLINE];
    char buf[1024];

     
    /* turn off cursor, set nonsensitive, etc */
	if (idle_display) {
		set_cursor(CURSOR_BUSY, 0);
		grey_the_button(toplevel, False);
		soak_events();
	}
    
    sprintf(xnlpath, "%s/%s/%s", XNL_PATH, server, lib);
    make_dir(xnlpath, pub);
    
    sprintf(filename, "%s/%s", xnlpath, file);
    sprintf(tagname, "%s/%s.tag", xnlpath, file);
    sprintf(remotefilename, "/%s/%s\n", lib, file);
    
    /* now get local tag */
    localage[0] = localtag[0] = '\0';
    fp = fopen(filename, "r");
    if (fp) {
      fgets(localtag, MAXLINE -2, fp);
      fgets(localage, MAXLINE -2, fp); /* how old is the local index? */
      fclose(fp);
      /* check the age of the local index file against the index file lifetime */
      if ((1 == sscanf(localage, "%d", &age)) && (((what_time() -age) / SEC_PER_DAY) < IDX_LIFE)) { 
		if (idle_display) {
			set_cursor(CURSOR_NORMAL, 0);
			grey_the_button(toplevel, True);
		}
        return 1; 
      } 

    }  
        
    /* get the remote tag */
    s = nlrexec_service_open("file-tag", server, EMAIL_ADDRESS);
    if (!s) {
	  if (!quiet)
        fprintf(stderr, "Couldn't open server connection to <%s> for %s/%s\n", 
        	server, lib, file);
	  if (idle_display) {
		  set_cursor(CURSOR_NORMAL, 0);
		  grey_the_button(toplevel, True);
	  }
      return 0;
    }
    swrite(s, remotefilename);

    retval=read(s, remotetag, MAXLINE -2);

	shutdown(s, 2);
	close(s);

    if (retval < 1) {
	  if (!quiet)
        fprintf(stderr, "Had problem getting tag for %s/%s from %s\n", 
        	lib, file, server);
	  if (idle_display) {
		  set_cursor(CURSOR_NORMAL, 0);
		  grey_the_button(toplevel, True);
	  }
      return 0;
    }

	remotetag[retval] = '\0';

    fp = fopen(tagname, "w");
    fprintf(fp, "%s", remotetag);
    fclose(fp);
    
    /* now get remote tag */
    remotetag[0] = '\0';
    fp = fopen(tagname, "r");
    if (fp) {
      fgets(remotetag, MAXLINE -2, fp);
      fclose(fp);
    } else {
	  if (!quiet)
      fprintf(stderr, "Had problem reading temp tag file <%s>\n", tagname);
	  if (idle_display) {
		  set_cursor(CURSOR_NORMAL, 0);
		  grey_the_button(toplevel, True);
	  }
      return 0;
    }


    if ((0 != strcmp(remotetag, localtag)) || (remotetag[0] == 0)) {
      /* get the remote file */
      s = nlrexec_service_open("file-get", server, EMAIL_ADDRESS);
      swrite(s, remotefilename);

      
      fp = fopen(filename, "w");
      sget_line(s, buf);
      if (0==strncmp(buf, "OK ", 3)) {
#ifdef TERM
        while (retval=read(s, buf, 1022)) {
#else
        while (retval=recv(s, buf, 1022, NULL)) {
#endif
            fwrite(buf, 1, retval, fp);
        }
        retval = 1;
      } else {
        retval = 0;
      }
	  shutdown(s, 2);
	  close(s);
      fclose(fp);
    
      if (retval < 1) {
		if (!quiet)
        fprintf(stderr, "Had problem getting %s/%s from %s\n", 
        	lib, file, server);
		if (idle_display) {
			set_cursor(CURSOR_NORMAL, 0);
			grey_the_button(toplevel, True);
		}
		unlink(filename);
		unlink(tagname);
        return 0;
      }

      /* now stick the tag atop the index file we just got */
      fp = fopen(tagname, "a");
      
      /* put Age line below the tag */
      fprintf(fp, "%d\n", what_time());
      
      fp2 = fopen(filename, "r");
      /* now copy the contents of the index file underneath the tag */
      while ((c = fgetc(fp2)) != EOF)
        fputc(c, fp);
      fclose(fp); 
      fclose(fp2);
      /* mv tag file --> index file */
      rename(tagname, filename);
	  retval = 2;
    } else {

		/* We just looked and we know we have the most recent index file.
			Go ahead and put todays date on it so we don't keep checking
			it until another week (or whenever)
		*/

		/* move the file someplace so we can copy it over ,
			really using tagname as a tmp file	*/
		rename(filename, tagname);

		fp = fopen(filename, "w");
		fp2 = fopen(tagname, "r");

		fgets(line, MAXLINE -2, fp2); /* first line is tag */
		fprintf(fp, "%s", line);
		fgets(line, MAXLINE -2, fp2); /* second line is date, discard */
		fprintf(fp, "%d\n", what_time());

		while (fgets(line, MAXLINE -2, fp2))
			fprintf(fp, "%s", line);

		fclose(fp2);
		fclose(fp);
		unlink(tagname);
		retval = 1;
	}
    
    
	if (idle_display) {
		set_cursor(CURSOR_NORMAL, 0);
		grey_the_button(toplevel, True);
	}
    return retval;
    
}

/* confirmFile -- pass it the full path (including XNL_PATH part) of the file
	you want to make appear
*/
confirmFile(name, pub, idle_display, quiet)
char *name;
int pub;
Boolean idle_display, quiet;
{
    char server[1024], *file, *lib;
    register int i;
    
    strcpy(server, name + strlen(XNL_PATH) +1);
    for (i=0; ((server[i]) && (server[i] != '/')); i++) ;
    server[i] = '\0';
    
    lib = server + i + 1;
    for (i=strlen(lib); (i && (lib[i] != '/')); i--) ;
    lib[i] = '\0';
    
    file = lib + i + 1;
    
    return getFile(server, file, lib, pub, idle_display, quiet);
}


