#include "database.h"

Widget descDisplayText;
int CurrentDescNum;
Widget descrecvDisplayText;
char *SubmitLine;
Widget SubmitPopup;

/*
 * GetFields -- given a database name and relation name, 
 *              requests a list of field
 *              and their types for that relation.
 *              no_hardcoded should be set to TRUE if only
 *              fields that are not hardcoded are to be
 *              returned, FALSE if all fields are to be returned.
 *              The function return value is the integer socket descriptor
 *              returned by the call to nlrexec_service_open.  
 *              The database service will return the field information 
 *              via the socket
 *              in the following format:
 * 
 *              fname<TAB>ftypname<newline>
 *              <field_name_1><TAB><field_type_1><newline>
 *              <field_name_1><TAB><field_type_2><newline>
 *                               etc.
 */
int GetFields(dbname, relname, no_hardcoded)
char *dbname, *relname, *no_hardcoded;
{
    char SubmitString[256];
    int dbSocket;

    sprintf(SubmitString,"%s\tgetfields\t%s\t%s\n", 
            dbname, relname, no_hardcoded);
    dbSocket = nlrexec_service_open("dataserve",DatabaseServer,EMAIL_ADDRESS);
    if (dbSocket)
        swrite(dbSocket,SubmitString);
    return(dbSocket);
}

/*
 * GetByOids -- given a database name, relation name, a tab-separated
 *              list of field names,
 *              and a tab-separated list of Postgres oids,
 *              requests records with the given oids with values for 
 *              the given fields.
 *              The function return value is the integer socket descriptor
 *              returned by the call to nlrexec_service_open.
 *              The first line returned via the socket will be the 
 *              tab-separated list
 *              of field names.  The remaining lines will be tab-separated
 *              values for those fields.
 */
int GetByOids(dbname, relname, field_list, oid_list)
char *dbname, *relname;
char *field_list, *oid_list;
{
    char SubmitString[1024];
    int dbSocket;

    sprintf(SubmitString,"%s\tgetbyoids\t%s\tbegin\t%s\tend\tbegin\t%s\tend\n", dbname, relname,
            field_list, oid_list);
    dbSocket = nlrexec_service_open("dataserve",DatabaseServer,EMAIL_ADDRESS);
    if (dbSocket)
        swrite(dbSocket,SubmitString);
    return(dbSocket);
}

/*
 * GetByConditions -- given a database name, relation name, 
 *              a tab-separated 
 *              list of field
 *              names to be retrieved, 
 *              a tab-separated (possibly empty)
 *              list of 4-tuples of dates in the following format:
 *
 *                field_name1<TAB>field_name2<TAB>literal_1<TAB>literal_2
 *
 *              where field_name1 and field_name2 are names of fields 
 *              in relname of type abstime, 
 *              and literal_1 and literal_2 are 
 *              strings in the format <3-letter month code> <day> <year> 
 *              (e.g., "Sep 1 1993").
 *              Records will be retrieved for which the interval formed
 *              by field_name1 and field_name2 overlaps the interval 
 *              formed by literal_1 and literal_2.  
 *              The conditions for multiple 4-tuples
 *              will be logically anded,
 *
 *              and zero or more of the following:
 *
 *              a tab-separated list of
 *              field names for keyword searching, beginning with
 *              "\tbegin\t" and followed
 *              by "\tend\t", followed
 *              a boolean keyword expression using operators | (or),
 *              & (and), ! (not), and parentheses,
 *
 *
 *              The function return value is the integer socket descriptor
 *              returned by the call to nlrexec_service_open.
 *              The first line returned via the socket will be the 
 *              tab-separated list
 *              of field names.  The remaining lines will be tab-separated
 *              values for those fields.
 */
int GetByConditions(dbname, relname, field_list, date_list, 
                    keysearch_list) 
char *dbname, *relname;
char *field_list, *date_list, *keysearch_list;
{
    char *SubmitString;
    int dbSocket;

        SubmitString = (char *) XtMalloc(strlen(dbname)+strlen(relname)+
         strlen(field_list)+strlen(date_list)+strlen(keysearch_list)+100);
	strcpy(SubmitString, dbname);
	strcat(SubmitString, "\tgetbyconditions\t");
	strcat(SubmitString, relname);

	strcat(SubmitString, "\tbegin\t");
	if (field_list && strlen(field_list)) {
		strcat(SubmitString, field_list);
		strcat(SubmitString, "\t");
	}
	strcat(SubmitString, "end\t");

	strcat(SubmitString, "begin\t");
	if (date_list && strlen(date_list)) {
		strcat(SubmitString, date_list);
		strcat(SubmitString, "\t");
	}
	strcat(SubmitString, "end");

	if (keysearch_list && strlen(keysearch_list)) {
		strcat(SubmitString, keysearch_list);
	}

		strcat(SubmitString, "\t");
	strcat(SubmitString, "end\n");

    dbSocket = nlrexec_service_open("dataserve",DatabaseServer,EMAIL_ADDRESS);
#ifdef DEBUG
printf("GetByConditions (%d)\n<%s>\n", dbSocket, SubmitString);
#endif
    if (dbSocket)
        swrite(dbSocket,SubmitString);
    XtFree(SubmitString);
    return(dbSocket);
}

/*
 * SubmitEntry -- given a database name, a relation name, a 
 *              tab-separated list of <field name> = <value> pairs,
 *              and a tab-separated list of fields to be full-text indexed, 
 *              appends the new entry to the relation and adds keyword
 *              entries to the full-text index for the requested fields.
 *              char16 and text type values must be in double quotes.
 *              Array type values must be inside curly braces ({}), and
 *              array items must be separated by commas.
 *              The function return value is the integer socket descriptor
 *              returned by the call to nlrexec_service_open.
 *              A confirmation message including the object id of the
 *              new entry will be returned via the socket.
 */
int SubmitEntry(dbname, relname, field_value_list, keyfield_list)
char *dbname, *relname, *field_value_list, *keyfield_list;
{
    char *SubmitString;
    int dbSocket;
    unsigned int submitlength, nwritten;

    submitlength = strlen(dbname)+strlen(relname)+
                   strlen(field_value_list)+strlen(keyfield_list) + 100;
    SubmitString = (char *) XtMalloc(strlen(dbname)+strlen(relname)+
                   strlen(field_value_list)+strlen(keyfield_list) + 100);
    if (!SubmitString) {
       printf("SubmitEntry: XtMalloc failed\n");
       return(-1);
    }
  
#ifdef DEBUG
    printf("XtMalloc succeeded, submitlength: %u\n", submitlength);
#endif DEBUG
    if (keyfield_list)
    sprintf(SubmitString,"%s\tsubmitentry\t%s\tbegin\t%s\tend\tbegin\t%s\tend\n",
            dbname, relname, field_value_list, keyfield_list);
    else
    sprintf(SubmitString,"%s\tsubmitentry\t%s\tbegin\t%s\tend\tbegin\tend\n",
            dbname, relname, field_value_list);
#ifdef DEBUG
  printf("sprintf succeeded, strlen(SubmitString): %u\nSubmitString:\n%s",
           strlen(SubmitString), SubmitString);
#endif
   /*  if (strlen(SubmitString) > 8192) {
        printf("SubmitEntry: too long %u bytes\n", strlen(SubmitString));
        return(-1);
    } */
    dbSocket = nlrexec_service_open("dataserve",DatabaseServer,EMAIL_ADDRESS);
    if (dbSocket) {
#ifdef DEBUG
    printf("calling nwrite\n");
#endif
        nwritten = nwrite(dbSocket,SubmitString,strlen(SubmitString));
#ifdef DEBUG
        printf("\nback from nwrite, nwritten: %u\n",nwritten);
#endif
		close(dbSocket);
	}
    XtFree(SubmitString);
#ifdef DEBUG
    printf("XtFree succeeded\n");
#endif
    return(dbSocket);
}

