
/*
 * $Id: contexthelp.c,v 1.8 1993/01/06 20:33:06 wade Exp $
 *
 * $Log: contexthelp.c,v $
 * Revision 1.8  1993/01/06  20:33:06  wade
 * using XtCreatePopupShell now for popups
 *
 * Revision 1.7  1993/01/05  22:16:12  wade
 * changed Class name of popup to Xnetlib
 *
 * Revision 1.6  1993/01/05  22:08:57  wade
 * changed Class name of popup to Xnetlib
 *
 * Revision 1.5  1992/12/16  16:40:29  wade
 * made window a little smaller
 *
 * Revision 1.4  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.3  1992/12/15  20:05:04  wade
 * converting conhelp to text
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

make_contexthelp(w)
Widget w;
{
	int i;

	for (i=0; i< MAX_MODE; i++)
		con_help[i] = NULL;
	helpPic = NULL;
}

void
unsethelpText(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
	helpPic = NULL;
}

void
contexthelpCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup, button, form;
    register int n;

	if (helpPic) /* pop it down */ {
		XtDestroyWidget(XtParent(XtParent(helpPic)));
		helpPic = NULL;
		return;
	}

	if (con_help[Mode] == NULL)
		return; /* nothing good to do */

	n=0;
    XtSetArg(args[n], XtNallowShellResize, True);               n++;
    XtSetArg(args[n], XtNtitle, "Contextual Help");               n++;
	popup = XtCreatePopupShell("Contextual_Help",
        topLevelShellWidgetClass, toplevel, args, n);

    form = XtVaCreateManagedWidget("popupForm", panedWidgetClass,
        popup, XtNresize, True, NULL);

	n = 0;
    XtSetArg(args[n], XtNallowResize, True);               n++;
    button = XtCreateManagedWidget("close", commandWidgetClass,form, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);
    XtAddCallback(button, XtNcallback, unsethelpText, (XtPointer)NULL);

	n = 0;
    XtSetArg(args[n], XtNstring, con_help[Mode]);               n++;
    XtSetArg(args[n], XtNallowResize, True);               n++;
    XtSetArg(args[n], XtNwidth, 510);               n++;
    XtSetArg(args[n], XtNheight, 200);               n++;
    helpPic = XtCreateManagedWidget("con_help", asciiTextWidgetClass,form, args, n);

    XtPopup(popup, XtGrabNone);
}


