
/*
 * $Id: classselect.c,v 1.4 1993/01/01 18:48:08 wade Exp $
 * 
 * $Log: classselect.c,v $
 * Revision 1.4  1993/01/01  18:48:08  wade
 * corrected contextual help message for class selection mode
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 * 
 */

#include "xnl.h"

Widget classSelForm;

static void classDoSelect();
int num_lines;

make_classSelect(w)
Widget w;
{
    Arg args[10];
    register int n;

    n = 0;
    XtSetArg(args[n], XtNallowHoriz, True);        n++;
    XtSetArg(args[n], XtNallowVert, True);        n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    classSelPop = XtCreateManagedWidget("classSelViewport",
            viewportWidgetClass, topPane, args, n);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    /*XtSetArg(args[n], XtNlist, ClassList); n++;*/
    XtSetArg(args[n], XtNdefaultColumns, 4); n++;
	XtSetArg(args[n], XtNforceColumns, True); n++;
    classSelForm = XtCreateManagedWidget("classSelList",
            listWidgetClass, classSelPop, args, n);
    XtAddCallback(classSelForm, XtNcallback,
        classDoSelect, (XtPointer)NULL);
}

Popup_classSelect(list_index)
int list_index;
{
    Dimension label_height;
    Arg args[10];

    LibOrClass = Mode = MODE_CLASSSELECT;

    if (helpPic) {
        Arg args[3];
        XtSetArg(args[0], XtNstring, con_help[Mode]);
        XtSetValues (helpPic, args, 1);
    }


    XtSetArg(args[0], XtNheight, &label_height);
    XtGetValues(exitButton, args, 1);

    XtManageChild(classSelPop);

    /* now set up the list of selections */

    classLibLoadList(mainclassFileList[list_index]);

    XawListChange(classSelForm, ClassList, 0, 0, True);

    set_status(LIB_HEADER, GREEN);
    
    grey_the_button(gobackButton, True);

    return 1;
}

Popdown_classSelect(w)
Widget w;
{
    XtUnmanageChild(classSelPop);

    grey_the_button(gobackButton, False);
    
    return 1;
}



classLibLoadList(s)
char *s;
{
    FILE *fp;
    char filename[MAXLINE];
    char line[MAXLINE];
    char name[MAXLINE], file[MAXLINE];
	
    sprintf(filename, "%s/%s", XNL_PATH, s);

	confirmFile(filename, (PUBDATA) ? 1 : 0, True, False);

    /* first open the file and discover num_lines */
    fp = fopen(filename, "r");
    if (!fp) {
        fprintf(stderr,
            "couldn't open <%s> to read library index\n", filename);
        exit(-1);
    }

    /* first free the old stuff in this list */
    freeclassList();

    num_lines = 0;
    fgets(line, MAXLINE, fp);
    fgets(line, MAXLINE, fp); /* tag and age */
    while (fgets(line, MAXLINE, fp)) {
        line[ strlen(line) -1] = '\0';

        strcpy(name, line);
		strcpy(file, line);
		strcat(file, "/index");

        ClassList[num_lines] = XtNewString(name);
        classFileList[num_lines] = XtNewString(file);
        num_lines++;
    }

    /* NULL term */
    ClassList[num_lines] = NULL;

    fclose(fp);
}

static void
classDoSelect(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
    XawListReturnStruct *item = (XawListReturnStruct*)call_data;

	Popdown_classSelect(libraryButton);
	Popup_libSelect(item->string);
}

freeclassList()
{
    register int i;

    i=0;
    while (ClassList[i]) {
        XtFree(ClassList[i]);
        XtFree(classFileList[i]);
        i++;
    }
}
