/* $XConsortium: UtkasciiText.c,v 1.44 91/07/12 11:27:23 converse Exp $ */

/*
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/

/***********************************************************************
 *
 * UtkasciiText Widget
 *
 ***********************************************************************/

/*
 * UtkasciiText.c - Source code for UtkasciiText Widget.
 *
 * This Widget is intended to be used as a simple front end to the 
 * text widget with an utkascii source and utkascii sink attached to it.
 *
 * Date:    June 29, 1989
 *
 * By:      Chris D. Peterson
 *          MIT X Consortium 
 *          kit@expo.lcs.mit.edu
 */

/*
 * $Id: UtkasciiText.c,v 1.4 1993/01/05 22:59:58 wade Exp $
 *
 * $Log: UtkasciiText.c,v $
 * Revision 1.4  1993/01/05  22:59:58  wade
 * added more keys to scrollbar Xlations
 *
 * Revision 1.3  1993/01/05  22:13:12  wade
 * *** empty log message ***
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 */


#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Cardinals.h>
#include "UtkasciiTextP.h"
#include "UtkasciiSrc.h"
#include "UtkasciiSink.h"

#include "xnl.h"

#define TAB_COUNT 32

static void Initialize(), Destroy();

static void pickFile();

static XtActionsRec actionsList[] =
{
  {"pick-file",        pickFile},
};

static char defaultTranslations[] = " \
Ctrl<Key>Up: beginning-of-file() \n\
Ctrl<Key>Down: end-of-file() \n\
<Key>Up: previous-page() \n\
<Key>Down: next-page() \n\
Ctrl<Key>space: scroll-one-line-down() \n\
<Key>space: scroll-one-line-up() \n\
<Key>Home: beginning-of-file() \n\
<Key>End: end-of-file() \n\
<Key>Prior: previous-page() \n\
<Key>Next: next-page() \n\
<Key>BackSpace: scroll-one-line-down() \n\
<Key>Return: scroll-one-line-up() \n\
<Btn1Down>,<Btn1Up>: select-start() extend-end(PRIMARY, CUT_BUFFER0) pick-file() \n\
<Btn3Down>: select-start() \n\
<Btn3Motion>:   extend-adjust() \n\
<Btn3Up>:   extend-end(PRIMARY, CUT_BUFFER0) \
";


static void ProcessExposeRegion();

UtkasciiTextClassRec utkasciiTextClassRec = {
  { /* core fields */
    /* superclass       */      (WidgetClass) &textClassRec,
    /* class_name       */      "Text",
    /* widget_size      */      sizeof(UtkasciiRec),
    /* class_initialize */      XawInitializeWidgetSet,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      Initialize,
    /* initialize_hook  */	NULL,
    /* realize          */      XtInheritRealize,
    /* actions          */      actionsList,
    /* num_actions      */      XtNumber(actionsList),
    /* resources        */      NULL,
    /* num_resource     */      0,
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      XtExposeGraphicsExpose | XtExposeNoExpose,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      Destroy,
    /* resize           */      XtInheritResize,
    /* expose           */      ProcessExposeRegion,
    /* set_values       */      NULL,
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      defaultTranslations,
    /* query_geometry	*/	XtInheritQueryGeometry
  },
  { /* Simple fields */
    /* change_sensitive	*/	XtInheritChangeSensitive
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* utkascii fields */
    /* empty            */      0
  }
};

WidgetClass utkasciiTextWidgetClass = (WidgetClass)&utkasciiTextClassRec;


static void
Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
{
  UtkasciiWidget w = (UtkasciiWidget) new;
  int i;
  int tabs[TAB_COUNT], tab;
  static XawTextSelectType selectArray[] = {XawselectLine,XawselectNull};

  w->text.sarray = selectArray;

  /* superclass Initialize can't set the following,
   * as it didn't know the source or sink when it was called */
  if (request->core.height == DEFAULT_TEXT_HEIGHT)
    new->core.height = DEFAULT_TEXT_HEIGHT;

  w->text.source = XtCreateWidget( "textSource", utkasciiSrcObjectClass,
				  new, args, *num_args );
  w->text.sink = XtCreateWidget( "textSink", utkasciiSinkObjectClass,
				new, args, *num_args );

  if (w->core.height == DEFAULT_TEXT_HEIGHT)
    w->core.height = VMargins(w) + XawTextSinkMaxHeight(w->text.sink, 1);

  for (i=0, tab=0 ; i < TAB_COUNT ; i++) 
    tabs[i] = (tab += 8);
  
  XawTextSinkSetTabs(w->text.sink, TAB_COUNT, tabs);

  XawTextDisableRedisplay(new);
  XawTextEnableRedisplay(new);
}

static void 
Destroy(w)
Widget w;
{
    if (w == XtParent(((UtkasciiWidget)w)->text.source))
	XtDestroyWidget( ((UtkasciiWidget)w)->text.source );

    if (w == XtParent(((UtkasciiWidget)w)->text.sink))
	XtDestroyWidget( ((UtkasciiWidget)w)->text.sink );
}

#ifdef ASCII_STRING

/************************************************************
 *
 * Utkascii String Compatibility Code.
 *
 ************************************************************/

UtkasciiStringClassRec utkasciiStringClassRec = {
  { /* core fields */
    /* superclass       */      (WidgetClass) &utkasciiTextClassRec,
    /* class_name       */      "Text",
    /* widget_size      */      sizeof(UtkasciiStringRec),
    /* class_initialize */      NULL,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      NULL,
    /* initialize_hook  */	NULL,
    /* realize          */      XtInheritRealize,
    /* actions          */      NULL,
    /* num_actions      */      0,
    /* resources        */      NULL,
    /* num_ resource    */      0,
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      XtExposeGraphicsExpose,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      NULL,
    /* resize           */      XtInheritResize,
    /* expose           */      XtInheritExpose,
    /* set_values       */      NULL,
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      XtInheritTranslations,
    /* query_geometry	*/	XtInheritQueryGeometry
  },
  { /* Simple fields */
    /* change_sensitive	*/	XtInheritChangeSensitive
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* utkascii fields */
    /* empty            */      0
  }
};

WidgetClass utkasciiStringWidgetClass = (WidgetClass)&utkasciiStringClassRec;

#endif /* ASCII_STRING */

#ifdef ASCII_DISK

/************************************************************
 *
 * Utkascii Disk Compatibility Code.
 *
 ************************************************************/

UtkasciiDiskClassRec utkasciiDiskClassRec = {
  { /* core fields */
    /* superclass       */      (WidgetClass) &utkasciiTextClassRec,
    /* class_name       */      "Text",
    /* widget_size      */      sizeof(UtkasciiDiskRec),
    /* class_initialize */      NULL,
    /* class_part_init  */	NULL,
    /* class_inited     */      FALSE,
    /* initialize       */      NULL,
    /* initialize_hook  */	NULL,
    /* realize          */      XtInheritRealize,
    /* actions          */      NULL,
    /* num_actions      */      0,
    /* resources        */      NULL,
    /* num_ resource    */      0,
    /* xrm_class        */      NULLQUARK,
    /* compress_motion  */      TRUE,
    /* compress_exposure*/      XtExposeGraphicsExpose,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */      FALSE,
    /* destroy          */      NULL,
    /* resize           */      XtInheritResize,
    /* expose           */      XtInheritExpose,
    /* set_values       */      NULL,
    /* set_values_hook  */	NULL,
    /* set_values_almost*/	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */      XtInheritAcceptFocus,
    /* version          */	XtVersion,
    /* callback_private */      NULL,
    /* tm_table         */      XtInheritTranslations,
    /* query_geometry	*/	XtInheritQueryGeometry
  },
  { /* Simple fields */
    /* change_sensitive	*/	XtInheritChangeSensitive
  },
  { /* text fields */
    /* empty            */      0
  },
  { /* utkascii fields */
    /* empty            */      0
  }
};

WidgetClass utkasciiDiskWidgetClass = (WidgetClass)&utkasciiDiskClassRec;

#endif /* ASCII_DISK */



static void
pickFile(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;     /* unused */
Cardinal *num_params;   /* unused */
{
	XawTextPosition begin, end;
	int nbytes;
	static char line[255];
	char *ptr;

	XawTextGetSelectionPos(w, &begin, &end);

	XawTextUnsetSelection(w);

	if (begin == end)
		return;

	ptr = XFetchBuffer(XtDisplay(w), &nbytes, 0);

	if (nbytes != 0) {
		strncpy(line, ptr, nbytes); line[nbytes] = '\0';
		if (line[nbytes-1] == '\n') line[nbytes-1] = '\0';
		if (strncmp(line, "lib", 3) ==0) {
			change_dir(w,line);
		} else if (strncmp(line, "file", 4) ==0) {
			toggle_file(w, begin, end, line);
		} else if (strncmp(line, GET_ALL, strlen(GET_ALL)) ==0) {
			add_all_to_list(w);
		} else if (strncmp(line, UN_GET_ALL, strlen(UN_GET_ALL)) ==0) {
			remove_all_from_list(w);
		}
	}
}



change_dir(w,s)
Widget w;
char *s;
{
	char dir[255];

	sscanf(s, "lib %s", dir);

	Mode_desired = MODE_NORMAL;

	Handle_state(w, NULL, NULL);

    Popup_libSelect(dir);
}

toggle_file(w, begin, end, s)
Widget w;
XawTextPosition begin, end;
char *s;
{

	if (file_in_list(s)) {
        remove_from_download_list(s);
    } else {
        add_to_download_list(s);
    }

	XawTextInvalidate(w, begin, end);
}

add_all_to_list(w)
Widget w;
{
	FILE *fp;
	String s;
	Arg args[3];
	char line[255];

    XtSetArg(args[0], XtNstring, &s);
    XtGetValues(w, args, 1);

	if (NULL == (fp = fopen(s, "r"))) {
		fprintf(stderr, "Couldn't open file (%s) to discover file names\n", s);
		return;
	}
	while (fgets(line, 250, fp)) {
		if (0==strncmp("file", line, 4)) {
			line[ strlen(line) -1] = '\0';
			detab(line);
			if (!file_in_list(line)) {
				add_to_download_list(line);
			}
		}
	}
	fclose(fp);
	XawTextInvalidate(w, 0, 9999);
}

remove_all_from_list(w)
Widget w;
{
    FILE *fp;
    String s;
    Arg args[3];
    char line[255];

    XtSetArg(args[0], XtNstring, &s);
    XtGetValues(w, args, 1);

    if (NULL == (fp = fopen(s, "r"))) {
        fprintf(stderr, "Couldn't open file (%s) to discover file names\n", s);
        return;
    }
    while (fgets(line, 250, fp)) {
        if (0==strncmp("file", line, 4)) {
			line[ strlen(line) -1] = '\0';
			detab(line);
            if (file_in_list(line)) {
                remove_from_download_list(line);
            }
        }
    }
    fclose(fp);
    XawTextInvalidate(w, 0, 9999);
}




#define SinkClearToBG          XawTextSinkClearToBackground
#define SrcScan                XawTextSourceScan
#define IsValidLine(ctx, num) ( ((num) == 0) || \
                    ((ctx)->text.lt.info[(num)].position != 0) )




static void UpdateTextInRectangle(), PopCopyQueue(), UpdateTextInLine();
static Boolean RectanglesOverlap(), TranslateExposeRegion();

static Boolean
TranslateExposeRegion(ctx, expose)
TextWidget ctx;
XRectangle * expose;
{
#if ProjectX > 4
    struct text_move * offsets = ctx->text.copy_area_offsets;
    int value;
    int x, y, width, height;

    /*
     * Skip over the first one, this has already been taken into account.
     */

    if (!offsets || !(offsets = offsets->next))
    return(TRUE);

    x = expose->x;
    y = expose->y;
    width = expose->width;
    height = expose->height;

    while (offsets) {
    x += offsets->h;
    y += offsets->v;
    offsets = offsets->next;
    }

    /*
     * remove that area of the region that is now outside the window.
     */

    if (y < 0) {
    height += y;
    y = 0;
    }

    value = y + height - ctx->core.height;
    if (value > 0)
    height -= value;

    if (height <= 0)
    return(FALSE);      /* no need to draw outside the window. */

    /*
     * and now in the horiz direction...
     */

    if (x < 0) {
    width += x;
    x = 0;
    }

    value = x + width - ctx->core.width;
    if (value > 0)
    width -= value;

    if (width <= 0)
    return(FALSE);      /* no need to draw outside the window. */

    expose->x = x;
    expose->y = y;
    expose->width = width;
    expose->height = height;
    return(TRUE);
#endif
}


static void
UpdateTextInLine(ctx, line, left, right)
TextWidget ctx;
int line;
Position left, right;
{
  XawTextPosition pos1, pos2;
  int width, height, local_left, local_width;
  XawTextLineTableEntry * lt = ctx->text.lt.info + line;

  if ( ((int)(lt->textWidth + ctx->text.margin.left) < left) ||
       ( ctx->text.margin.left > right ) )
    return;         /* no need to update. */

  local_width = left - ctx->text.margin.left;
  XawTextSinkFindPosition(ctx->text.sink, lt->position,
              (int) ctx->text.margin.left,
              local_width, FALSE, &pos1, &width, &height);

  if (right >= (Position) lt->textWidth - ctx->text.margin.left)
    if ( (IsValidLine(ctx, line + 1)) &&
     (ctx->text.lt.info[line + 1].position <= ctx->text.lastPos) )
      pos2 = SrcScan( ctx->text.source, (lt + 1)->position, XawstPositions,
               XawsdLeft, 1, TRUE);
    else
      pos2 = GETLASTPOS;
  else {
    XawTextPosition t_pos;

    local_left = ctx->text.margin.left + width;
    local_width = right  - local_left;
    XawTextSinkFindPosition(ctx->text.sink, pos1, local_left,
                local_width, FALSE, &pos2, &width, &height);

    t_pos = SrcScan( ctx->text.source, pos2,
             XawstPositions, XawsdRight, 1, TRUE);
    if (t_pos < (lt + 1)->position)
      pos2 = t_pos;
  }

  _XawTextNeedsUpdating(ctx, pos1, pos2);
}


static void
PopCopyQueue(ctx)
TextWidget ctx;
{
#if ProjectX > 4
    struct text_move * offsets = ctx->text.copy_area_offsets;

    if (offsets == NULL)
    printf("empty copy queue\n");
    else {
    ctx->text.copy_area_offsets = offsets->next;
    XtFree((char *) offsets);   /* free what you allocate. */
    }
#endif
}

static Boolean
RectanglesOverlap(rect1, rect2)
XRectangle *rect1, *rect2;
{
  return ( (rect1->x < rect2->x + (short) rect2->width) &&
       (rect2->x < rect1->x + (short) rect1->width) &&
       (rect1->y < rect2->y + (short) rect2->height) &&
       (rect2->y < rect1->y + (short) rect1->height) );
}


static void
UpdateTextInRectangle(ctx, rect)
TextWidget ctx;
XRectangle * rect;
{
  XawTextLineTableEntry *info = ctx->text.lt.info;
  int line, x = rect->x, y = rect->y;
  int right = rect->width + x, bottom = rect->height + y;

  for (line = 0;( (line < ctx->text.lt.lines) &&
         IsValidLine(ctx, line) && (info->y < bottom)); line++, info++)
    if ( (info + 1)->y >= y )
      UpdateTextInLine(ctx, line, x, right);
}


/* ARGSUSED */
static void
ProcessExposeRegion(w, event, region)
Widget w;
XEvent *event;
Region region;          /* Unused. */
{
    TextWidget ctx = (TextWidget) w;
    XRectangle expose, cursor;
    Boolean need_to_draw;

    if (event->type == Expose) {
    expose.x = event->xexpose.x;
    expose.y = event->xexpose.y;
    expose.width = event->xexpose.width;
    expose.height = event->xexpose.height;
    }
    else if (event->type == GraphicsExpose) {
    expose.x = event->xgraphicsexpose.x;
    expose.y = event->xgraphicsexpose.y;
    expose.width = event->xgraphicsexpose.width;
    expose.height = event->xgraphicsexpose.height;
    }
    else { /* No Expose */
    PopCopyQueue(ctx);
    return;         /* no more processing necessary. */
    }


	/* set left margin of region to 0 in order to force drawing
		of any file icons	*/
	expose.width += expose.x;
	expose.x = 0;

#if ProjectX > 4
    need_to_draw = TranslateExposeRegion(ctx, &expose);
    if ((event->type == GraphicsExpose) && (event->xgraphicsexpose.count == 0))
    PopCopyQueue(ctx);

    if (!need_to_draw)
    return;         /* don't draw if we don't need to. */
#endif

    _XawTextPrepareToUpdate(ctx);
    UpdateTextInRectangle(ctx, &expose);
    XawTextSinkGetCursorBounds(ctx->text.sink, &cursor);
    if (RectanglesOverlap(&cursor, &expose)) {
    SinkClearToBG(ctx->text.sink, (Position) cursor.x, (Position) cursor.y,
              (Dimension) cursor.width, (Dimension) cursor.height);
    UpdateTextInRectangle(ctx, &cursor);
    }
    _XawTextExecuteUpdate(ctx);
}


/* must be same as detab method in UtkasciiSrc.c:LoadPieces()   */
detab(line)
char *line;
{
	char new_line[2550];
	register int i, j;

	for (j=i=0; line[i] ; j++,i++)
		if (line[i] == '\t') {
			new_line[j] = ' '; j++;
			new_line[j] = ' '; j++;
			new_line[j] = ' '; j++;
			new_line[j] = ' '; j++;
			new_line[j] = ' ';
		} else {
			new_line[j] = line[i];
		}
	new_line[j] = '\0';

	strcpy(line, new_line);
}
