.\" +----------
.\" |
.\" |			      UITACTION man page
.\" | 			  Release 4.3.1, August 1994
.\" |
.\" |		Copyright 1993, 1994 Tudor Hulubei & Andrei Pitis
.\" |
.\" |	This file is part of UIT (UNIX Interactive Tools)
.\" |
.\" |	UIT is free software; you can redistribute it and/or modify it under
.\" | the terms of the GNU General Public License as published by the Free
.\" | Software Foundation; either version 2, or (at your option) any later
.\" | version.
.\" |
.\" | UIT is distributed in the hope that it will be useful, but WITHOUT ANY
.\" | WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
.\" | FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
.\" | details.
.\" |
.\" | You should have received a copy of the GNU General Public License along
.\" | with UIT; see the file COPYING. If not, write to the Free Software
.\" | Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.\" |
.\" |
.TH uitaction 1 "August 1994" "Release 4.3.1"
.SH NAME
uitaction \- UNIX Interactive Tools version 4.3.1 - per file type action script
.SH SYNTAX
.I uitaction
.I directory, file
.br
.I .uitaction directory, file

.SH DESCRIPTION
.I uitaction
is a script that executes a different action for each file type
specified. It is called by the
.I uit
program when pressing
.B F2
or
.B ^Kz
(see the
.B .uitrc.TERM
configuration files in the
.I uit
manual). The first parameter is the current directory name and the second
one is the file name to be matched against the default patterns. The
matching is done using the
.I uitmatch
utility.
If you press
.B F2
or
.B ^Kz
on a
.B "*.c"
file,
.I uit
will compile it, if you press
.B F2
or
.B ^Kz
on a
.B "*.tar.gz"
file,
.I uit
will list the tar archive contents, if you press the same keys on a
.B "*.gz"
file,
.I uit
will display its uncompressed contents on the screen, etc ...
By default
.I uitaction
checks for the following patterns:

"*.cc" "*.c" "*.l" "*.y" "*.h" "*.s" "*.S" "*.o" "*.a" "*.sa"
"Makefile" "makefile"
"*.tar.gz" "*.tgz" "*.tar.z" "*.tar.Z" "*.taz" "*.tar" "*.gz"
"*.z" "*.Z"
"*.doc" "*.txt"
"*.gif" "*.jpg" "*.tif" "*.bmp"

and acts as appropriate. If  no  pattern is found, the file is displayed
using more. Feel free to change this. If you want to find out what the
default action for each file type is (or if you want to modify it), just
read/modify the
.I uitaction
script.

If you press
.B F2
or
.B ^Kz
on a
.B "*.gif"
file or
.B "*.jpg"
file and you have the
.I zgv
utility installed, you will be able to see it. If you want to change
the gif/jpeg viewer, all you need to do is to change its name in the
.I uitaction
script. I don't know a
.B "*.bmp"
or
.B "*.tif"
viewer. Feel free to add one in the
.I uitaction
script.

The script can be easy enhanced. Just read it.

The
.I .uitaction
script is a local version of the
.I uitaction
script. When started,
.I uitaction
tries to search a script called
.B .uitaction
in the current directory and, if it finds it, it starts it. If
.IR .uitaction 's
exit code is 0 (
.I .uitaction
couldn't find a matching pattern),
.I uitaction
starts its own case statement trying to match the current file name (the
second parameter) against its default patterns.

The
.I .uitaction
script *must* be executable. An example of
.I .uitaction
can be fount in
.BR /usr/local/lib .
You should copy the example in the current directory and then modify it.


.SH BUGS
None so far. :-)

Please send bug reports to
.IR tudor@ulise.cs.pub.ro " or to " tudor@habarnam.cs.pub.ro "."

.SH SEE ALSO
uit(1) uitps(1) uitview(1) uitmount(1) uitcmp(1) uitkeys(1) uitmatch(1)

.SH FILES
/usr/local/bin/uitaction
.br
/usr/local/lib/.uitaction
.br
/usr/local/man/man1/uitaction.1

.SH AUTHORS
.I Tudor Hulubei
.br
- tudor@ulise.cs.pub.ro, tudor@habarnam.cs.pub.ro
.br
.I Andrei Pitis
.br
- pink@ulise.cs.pub.ro, pink@habarnam.cs.pub.ro
.br
.B Politechnic University of Bucharest
.br
.B Romania
