/*
    Edit line management header file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _EDIT_H
#define _EDIT_H


#include "window.h"


#define EDIT_BUFLEN	0x800
#define EDIT_RECORD	0
#define EDIT_PREVIOUS	1
#define EDIT_NEXT	2


typedef struct
{
    window *win;
    unsigned index, columns;
    unsigned static_size;
    char *buf;
    char *history_file;
} edit;


edit *edit_init(int columns, int begin_y);
void  edit_end(edit *this);
int   edit_putch(edit *this, char key);
int   edit_puts(edit *this, char *str);
char *edit_gets(edit *this, char *static_text, char **dest, char *default_str);
char *edit_gettext(edit *this, char **dest);
void  edit_reset(edit *this);
void  edit_del(edit *this);
void  edit_setcursor(edit *this);
void  edit_update(edit *this);
void  edit_eos(edit *this);
void  edit_history(edit *this, int action);


#endif	/* _EDIT_H */
