------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               S Y S T E M                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.18 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Note: although the values in System are target dependent, the source of
--  the package System itself is target independent in GNAT. This is achieved
--  by using attributes for all values, including the special additional GNAT
--  Standard attributes that are provided for exactly this purpose.

package System is
pragma Pure (System);

   type Name is (GNAT);
   System_Name : constant Name := GNAT;

   --  System-Dependent Named Numbers

   Min_Int                : constant := Long_Long_Integer'First;
   Max_Int                : constant := Long_Long_Integer'Last;
   Max_Binary_Modulus     : constant := 2 ** Long_Long_Integer'Size;
   Max_Nonbinary_Modulus  : constant := Integer'Last;
   Max_Base_Digits        : constant := Long_Long_Float'Digits;
   Max_Digits             : constant := Long_Long_Float'Digits;
   Max_Mantissa           : constant := Long_Long_Integer'Size - 1;
   Fine_Delta             : constant := 2.0 ** (-Max_Mantissa);
   Tick                   : constant := Standard'Tick;

   --  Storage related Declarations

   type Address is private;
   Null_Address : constant Address;

   Storage_Unit           : constant := Standard'Storage_Unit;
   Word_Size              : constant := Standard'Word_Size;
   Memory_Size            : constant := 2 ** Standard'Address_Size;

   --  Address comparison

   function "<"  (Left, Right : Address) return Boolean;
   function "<=" (Left, Right : Address) return Boolean;
   function ">"  (Left, Right : Address) return Boolean;
   function ">=" (Left, Right : Address) return Boolean;
   function "="  (Left, Right : Address) return Boolean;

   pragma Import (Intrinsic, "<");
   pragma Import (Intrinsic, "<=");
   pragma Import (Intrinsic, ">");
   pragma Import (Intrinsic, ">=");
   pragma Import (Intrinsic, "=");

   --  Declarations for real time Annex (Annex H)

   subtype Any_Priority is Integer
     range 0 .. Standard'Max_Interrupt_Priority;

   subtype Priority is Any_Priority
     range 0 .. Standard'Max_Priority;

   subtype Interrupt_Priority is Any_Priority
     range Standard'Max_Priority + 1 .. Standard'Max_Interrupt_Priority;

   Default_Priority : constant Priority :=
     (Priority'First + Priority'Last) / 2;

private

   type Address is mod Memory_Size;
   Null_Address : constant Address := 0;

end System;
