-----------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                        S Y S T E M . I M G _ W C                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Storage_Elements; use System.Storage_Elements;
with System.Img_C;

function System.Img_WC (V : Wide_Character; B : Address) return Natural is
   Val    : constant Natural := Wide_Character'Pos (V);
   Hi, Lo : Natural;
   Flag   : Natural;

   package Cnv is new Address_To_Access_Conversions (Character);
   use Cnv;

begin
   --  If in range of standard character, use standard character routine

   if Val <= 16#FF# then
      return System.Img_C (Character'Val (Val), B);

   --  Otherwise return an appropriate escape sequence (i.e. one that matches
   --  the convention implemented by Scn.Wide_Char)

   else
      To_Pointer (B + Storage_Offset (0)).all := ''';
      To_Pointer (B + Storage_Offset (1)).all := Ascii.ESC;

      Hi := Val / 256;
      Lo := Val mod 256;

      if Hi >= 32 and then Lo >= 32 then
         To_Pointer (B + Storage_Offset (2)).all := Character'Val (Hi);
         To_Pointer (B + Storage_Offset (3)).all := Character'Val (Lo);
         To_Pointer (B + Storage_Offset (4)).all := ''';
         return 5;

      else
         Flag := 0;

         if Hi < 32 then
            Hi := Hi + 32;
            Flag := Flag + 1;
         end if;

         if Lo < 32 then
            Lo := Lo + 32;
            Flag := Flag + 2;
         end if;

         To_Pointer (B + Storage_Offset (2)).all := Ascii.Nul;
         To_Pointer (B + Storage_Offset (3)).all := Character'Val (Flag);
         To_Pointer (B + Storage_Offset (4)).all := Character'Val (Hi);
         To_Pointer (B + Storage_Offset (5)).all := Character'Val (Lo);
         To_Pointer (B + Storage_Offset (6)).all := ''';
         return 7;
      end if;
   end if;

end System.Img_WC;
