/*
 * Decompiled with CFR 0.152.
 */
package jep;

import apple.awt.GraphicsClipper;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SimpleLayout;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import jep.AppletFrameContext;
import jep.AppletFramePanel;
import jep.AppletHandlerFactory;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.plugin.AppletViewer;

public class AppletFrame
extends Frame {
    protected static boolean showDebugInfo = false;
    protected long cocoaParentView = 0L;
    protected long prevCocoaParentView = 0L;
    protected int pluginInstance = 0;
    protected URL url = null;
    protected AppletViewer panel = null;
    protected HashSet clipperTable = new HashSet();
    protected HashSet childWindows = new HashSet();
    protected static InheritableThreadLocal currentAppletFrame = new InheritableThreadLocal();
    public boolean isCarbonApp = true;
    public boolean updatesOff = false;
    public boolean asyncUpdatesOff = false;
    public boolean isInvisible = false;
    public boolean destroying = false;
    public Rectangle currentClip = null;
    public final TimedLock clipLock = new TimedLock();
    protected Rectangle initialAppletBounds = null;
    protected Rectangle savedAppletBounds = null;
    public int imposeClipCount = 0;
    public int removeClipCount = 0;

    public AppletFrame() {
    }

    public AppletFrame(long cocoaParentView, int pluginInstance, URL docbase, HashMap attributes, boolean isCarbonApp, boolean createdInvisible) {
        this.cocoaParentView = cocoaParentView;
        this.pluginInstance = pluginInstance;
        this.url = docbase;
        this.panel = new AppletFramePanel(docbase, attributes, this);
        this.add((Component)this.panel);
        this.initialAppletBounds = new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
        this.setBounds(this.initialAppletBounds);
        this.panel.setBounds(this.initialAppletBounds);
        this.panel.setAppletContext((AppletContext)((Object)new AppletFrameContext(this)));
        this.currentClip = new Rectangle(this.initialAppletBounds);
        this.isCarbonApp = isCarbonApp;
        this.isInvisible = createdInvisible;
    }

    protected void displayAllComponents(Component[] components, String indent) {
        for (int i = 1; i <= components.length; ++i) {
            System.err.println(indent + components[i - 1].toString());
            try {
                this.displayAllComponents(((Container)components[i - 1]).getComponents(), new String(indent) + "--");
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    public void showAppletInfo() {
        Component[] components = this.getComponents();
        System.err.println("AppletFrame showAppletInfo(): Self and all components:");
        System.err.println("--" + this.toString());
        this.displayAllComponents(components, "----");
        AllPermission perm = new AllPermission();
        try {
            AccessController.checkPermission(perm);
            System.err.println("AppletFrame: showAppletInfo(): We've got AllPermission");
        }
        catch (AccessControlException e) {
            System.err.println("AppletFrame: showAppletInfo(): We don't have AllPermission");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClipper(GraphicsClipper clipper) {
        if (this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            this.cleanClipperTable();
            this.clipperTable.add(clipper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClipper(GraphicsClipper clipper) {
        if (this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator enumer = this.clipperTable.iterator();
            while (enumer.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)enumer.next();
                if (item.getGraphics() == null) {
                    enumer.remove();
                    continue;
                }
                if (!item.equals(clipper)) continue;
                enumer.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanClipperTable() {
        if (this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator enumer = this.clipperTable.iterator();
            while (enumer.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)enumer.next();
                if (item.getGraphics() != null) continue;
                enumer.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyClipperTable() {
        if (this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            this.clipperTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateClips() {
        if (this.destroying || this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator enumer = this.clipperTable.iterator();
            while (enumer.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)enumer.next();
                if (item.getGraphics() == null) {
                    enumer.remove();
                    continue;
                }
                item.validateDevClip();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroClips() {
        if (this.destroying || this.clipperTable == null) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator enumer = this.clipperTable.iterator();
            while (enumer.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)enumer.next();
                if (item.getGraphics() == null) {
                    enumer.remove();
                    continue;
                }
                item.zeroDevClip();
            }
        }
    }

    public static AppletFrame getCurrentAppletFrame() {
        return (AppletFrame)currentAppletFrame.get();
    }

    public static void setCurrentAppletFrame(AppletFrame aFrame) {
        currentAppletFrame.set(aFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildWindow(Window aWindow) {
        if (this.childWindows == null || aWindow == null) {
            return;
        }
        HashSet hashSet = this.childWindows;
        synchronized (hashSet) {
            if (this.childWindows == null) {
                return;
            }
            this.childWindows.add(new WeakReference<Window>(aWindow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableChildWindows() {
        if (this.childWindows == null) {
            return;
        }
        HashSet hashSet = this.childWindows;
        synchronized (hashSet) {
            if (this.childWindows == null) {
                return;
            }
            Iterator enumer = this.childWindows.iterator();
            while (enumer.hasNext()) {
                Window aWindow = (Window)((WeakReference)enumer.next()).get();
                if (aWindow != null) {
                    aWindow.setVisible(false);
                    Component[] components = aWindow.getComponents();
                    if (components != null) {
                        this.setAllComponentsInvisible(components);
                        this.disableAllComponents(components);
                    }
                    aWindow.setEnabled(false);
                    continue;
                }
                enumer.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeChildWindows() {
        if (this.childWindows == null) {
            return;
        }
        HashSet hashSet = this.childWindows;
        synchronized (hashSet) {
            if (this.childWindows == null) {
                return;
            }
            Iterator enumer = this.childWindows.iterator();
            while (enumer.hasNext()) {
                Window aWindow = (Window)((WeakReference)enumer.next()).get();
                if (aWindow != null) {
                    aWindow.dispose();
                }
                enumer.remove();
            }
            this.childWindows = null;
        }
    }

    public AppletViewer getPanel() {
        return this.panel;
    }

    public Applet getApplet() {
        return this.panel.getApplet();
    }

    public int getLoadingStatus() {
        return this.panel.getLoadingStatus();
    }

    public void validate() {
        if (this.destroying || AppletHandlerFactory.isMainThread()) {
            return;
        }
        super.validate();
    }

    public void invalidate() {
        if (this.destroying || AppletHandlerFactory.isMainThread()) {
            return;
        }
        super.invalidate();
    }

    public void validateApplet() {
        if (this.destroying) {
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHandlerFactory.isMainThread()) {
            this.validate();
        } else {
            SunToolkit.postEvent(context, new PeerEvent(target, new Validate(), 1L));
        }
    }

    public void invalidateAndValidate() {
        if (this.destroying) {
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHandlerFactory.isMainThread()) {
            if (applet != null) {
                applet.invalidate();
            } else {
                this.getPanel().invalidate();
            }
            this.validate();
            return;
        }
        SunToolkit.postEvent(context, new PeerEvent(target, new InvalidateAndValidate(), 1L));
    }

    public void setAppletVisible(boolean visible, boolean flagOnly, boolean wait) {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null || flagOnly || !wait) {
            boolean visibilityChanged = visible == this.isInvisible;
            boolean bl = this.isInvisible = !visible;
            if (visibilityChanged) {
                if (this.isInvisible) {
                    this.zeroClips();
                } else {
                    this.validateClips();
                }
            }
            if (applet == null || flagOnly) {
                return;
            }
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.setAppletVisibleDirectly(applet, visible);
        } else {
            long jobID = 0L;
            if (wait) {
                jobID = AppletHandlerFactory.beforeProcessing(new Object());
            }
            SunToolkit.postEvent(appletContext, new PeerEvent(applet, new SetVisible(visible, wait, jobID), 1L));
            if (wait) {
                AppletHandlerFactory.processMainThreadEvents(200L, jobID);
            }
        }
    }

    public void setAppletVisibleDirectly(Applet applet, boolean visible) {
        boolean visibilityChanged;
        if (this.destroying) {
            return;
        }
        boolean bl = visibilityChanged = visible == this.isInvisible;
        if (applet == null) {
            boolean bl2 = this.isInvisible = !visible;
            if (visibilityChanged) {
                if (this.isInvisible) {
                    this.zeroClips();
                } else {
                    this.validateClips();
                }
            }
            return;
        }
        if (this.savedAppletBounds != null) {
            if (visible) {
                this.imposeClipDirectly(this.currentClip.x, this.currentClip.y, this.currentClip.width, this.currentClip.height);
            } else {
                this.removeClipTemporarily();
            }
        }
        applet.setVisible(visible);
        boolean bl3 = this.isInvisible = !applet.isVisible();
        if (visibilityChanged) {
            if (this.isInvisible) {
                this.zeroClips();
            } else {
                this.validateClips();
            }
        }
    }

    public boolean isAppletVisible() {
        if (this.destroying) {
            return false;
        }
        try {
            return this.getApplet().isVisible();
        }
        catch (NullPointerException e) {
            return !this.isInvisible;
        }
    }

    public Rectangle getAppletBounds() {
        try {
            return new Rectangle(this.savedAppletBounds);
        }
        catch (NullPointerException e) {
            return new Rectangle(this.initialAppletBounds);
        }
    }

    public void setAppletBounds(int x, int y, int width, int height) {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setBounds(x, y, width, height);
    }

    public void setAppletBounds(Rectangle bounds) {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setBounds(bounds);
    }

    public void resizeApplet(int width, int height) {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (width == 0 || height == 0 || applet == null) {
            return;
        }
        if (width != this.panel.getWidth() || height != this.panel.getHeight()) {
            this.currentClip = new Rectangle(0, 0, width, height);
            this.initialAppletBounds = new Rectangle(0, 0, width, height);
            this.savedAppletBounds = null;
        }
        this.panel.appletResize(width, height);
    }

    public void setSimpleLayout() {
        if (this.destroying) {
            return;
        }
        this.setLayout(new SimpleLayout(this.panel.getWidth(), this.panel.getHeight(), this));
        this.panel.setLayout((LayoutManager)new SimpleLayout(this.panel.getWidth(), this.panel.getHeight(), this));
    }

    public void setIgnoreRepaint(boolean flag) {
        super.setIgnoreRepaint(flag);
        this.panel.setIgnoreRepaint(flag);
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setIgnoreRepaint(flag);
    }

    public void setUpdatesOff(boolean b) {
        boolean changed;
        if (showDebugInfo) {
            if (b && !this.updatesOff) {
                System.err.println("AppletFrame: Turning updates off");
            } else if (!b && this.updatesOff) {
                System.err.println("AppletFrame: Turning updates on");
            }
        }
        this.updatesOff = b;
        boolean bl = changed = this.updatesOff != b;
        if (this.updatesOff) {
            if (changed) {
                this.zeroClips();
            }
            this.setAsyncUpdatesOff(true);
        }
    }

    public void setAsyncUpdatesOff(boolean b) {
        if (showDebugInfo) {
            if (b && !this.asyncUpdatesOff) {
                System.err.println("AppletFrame: Turning async updates off");
            } else if (!b && this.asyncUpdatesOff) {
                System.err.println("AppletFrame: Turning async updates on");
            }
        }
        boolean changed = this.asyncUpdatesOff != b;
        this.asyncUpdatesOff = b;
        if (!this.asyncUpdatesOff && changed) {
            this.validateClips();
        }
    }

    public Rectangle translateCurrentClip(Component componentToClip) {
        Rectangle translatedClip;
        if (this.destroying) {
            return new Rectangle();
        }
        AppletHandlerFactory.disableScreenUpdates();
        try {
            if (componentToClip.equals(this.panel)) {
                componentToClip = this;
            } else if (componentToClip.equals(this.getApplet())) {
                componentToClip = this;
            }
            Component comp = componentToClip;
            Point compLocation = comp.getLocation();
            int xDiff = compLocation.x;
            int yDiff = compLocation.y;
            while (!comp.equals(this)) {
                Container parent = comp.getParent();
                if (parent.equals(this.panel)) {
                    parent = this;
                } else if (parent.equals(this.getApplet())) {
                    parent = this;
                }
                if (!parent.equals(this)) {
                    Point parentLocation = parent.getLocation();
                    xDiff += parentLocation.x;
                    yDiff += parentLocation.y;
                }
                comp = parent;
            }
            translatedClip = new Rectangle(this.currentClip);
            if (translatedClip.width >= 0 && translatedClip.height >= 0) {
                translatedClip.x -= xDiff;
                translatedClip.y -= yDiff;
            }
        }
        catch (Throwable e) {
            translatedClip = new Rectangle();
        }
        AppletHandlerFactory.enableScreenUpdates();
        return translatedClip;
    }

    public void imposeClip(int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.destroying) {
            return;
        }
        if (!AppletHandlerFactory.isJava142Update1()) {
            this.imposeClipDirectly(clipX, clipY, clipWidth, clipHeight);
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHandlerFactory.isMainThread()) {
            this.imposeClipDirectly(clipX, clipY, clipWidth, clipHeight);
        } else {
            if (++this.imposeClipCount == 1) {
                AppletHandlerFactory.suspendAppletUpdates(this.getCocoaParentViewLong());
            }
            SunToolkit.postEvent(context, new PeerEvent(target, new ImposeClip(clipX, clipY, clipWidth, clipHeight), 1L));
        }
    }

    public void imposeClipDirectly(int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.destroying) {
            return;
        }
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletFrame.imposeClip(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        Rectangle currentAppletBounds = this.savedAppletBounds;
        if (this.savedAppletBounds == null) {
            currentAppletBounds = this.savedAppletBounds = this.getAppletBounds();
        }
        if (clipX == currentAppletBounds.x && clipY == currentAppletBounds.y && clipWidth == currentAppletBounds.width && clipHeight == currentAppletBounds.height) {
            this.removeClipDirectly();
        } else {
            if (clipX == this.currentClip.x && clipY == this.currentClip.y && clipWidth == this.currentClip.width && clipHeight == this.currentClip.height) {
                this.validateApplet();
                this.clipLock.unlock();
                return;
            }
            Applet applet = this.getApplet();
            if (applet != null) {
                if (AppletHandlerFactory.isJava142Update1()) {
                    this.panel.setBounds(clipX, clipY, currentAppletBounds.width, currentAppletBounds.height);
                } else {
                    this.panel.setBounds(clipX, clipY + 22, currentAppletBounds.width, currentAppletBounds.height);
                }
                this.setAppletBounds(-clipX, -clipY, currentAppletBounds.width, currentAppletBounds.height);
            } else if (AppletHandlerFactory.isJava142Update1()) {
                this.panel.setBounds(0, 0, currentAppletBounds.width, currentAppletBounds.height);
            } else {
                this.panel.setBounds(0, 22, currentAppletBounds.width, currentAppletBounds.height);
            }
            this.currentClip = new Rectangle(clipX, clipY, clipWidth, clipHeight);
            this.invalidateAndValidate();
            this.validateClips();
            if (showDebugInfo) {
                this.showAppletInfo();
            }
        }
        this.clipLock.unlock();
    }

    public void removeClip() {
        if (this.destroying) {
            return;
        }
        if (!AppletHandlerFactory.isJava142Update1()) {
            this.removeClipDirectly();
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHandlerFactory.isMainThread()) {
            this.removeClipDirectly();
        } else {
            if (++this.removeClipCount == 1) {
                AppletHandlerFactory.suspendAppletUpdates(this.getCocoaParentViewLong());
            }
            SunToolkit.postEvent(context, new PeerEvent(target, new RemoveClip(), 1L));
        }
    }

    public void removeClipDirectly() {
        if (this.destroying) {
            return;
        }
        Rectangle boundsToRestore = this.savedAppletBounds;
        if (boundsToRestore == null) {
            boundsToRestore = this.initialAppletBounds;
        }
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletFrame.removeClip(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        if (boundsToRestore.x == this.currentClip.x && boundsToRestore.y == this.currentClip.y && boundsToRestore.width == this.currentClip.width && boundsToRestore.height == this.currentClip.height) {
            this.validateApplet();
            this.clipLock.unlock();
            return;
        }
        if (AppletHandlerFactory.isJava142Update1()) {
            this.panel.setBounds(0, 0, boundsToRestore.width, boundsToRestore.height);
        } else {
            this.panel.setBounds(0, 22, boundsToRestore.width, boundsToRestore.height);
        }
        this.setAppletBounds(boundsToRestore);
        this.savedAppletBounds = null;
        this.currentClip = new Rectangle(boundsToRestore);
        this.invalidateAndValidate();
        this.validateClips();
        if (showDebugInfo) {
            this.showAppletInfo();
        }
        this.clipLock.unlock();
    }

    protected void removeClipTemporarily() {
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletFrame.removeClipTemporarily(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        Rectangle boundsToRestore = this.savedAppletBounds;
        if (boundsToRestore == null) {
            boundsToRestore = this.initialAppletBounds;
        }
        if (AppletHandlerFactory.isJava142Update1()) {
            this.panel.setBounds(0, 0, boundsToRestore.width, boundsToRestore.height);
        } else {
            this.panel.setBounds(0, 22, boundsToRestore.width, boundsToRestore.height);
        }
        this.setAppletBounds(boundsToRestore);
        this.clipLock.unlock();
    }

    public void activateFrame() {
        this.pack();
        this.setVisible(true);
    }

    public void startApplet() {
        if (this.destroying) {
            return;
        }
        this.panel.appletStart();
        this.isInvisible = false;
        if (showDebugInfo) {
            this.showAppletInfo();
        }
    }

    public void stopApplet() {
        if (this.destroying) {
            return;
        }
        if (this.getApplet() == null) {
            return;
        }
        if (!AppletHandlerFactory.isJava142Tiger() || !AppletHandlerFactory.isMainThread()) {
            this.stopAppletDirectly();
        } else {
            long jobID = AppletHandlerFactory.beforeProcessing(new Object());
            SunToolkit.postEvent(AppletHandlerFactory.mainAppContext, new PeerEvent(this, new StopApplet(jobID), 1L));
            AppletHandlerFactory.processMainThreadEvents(0L, jobID);
        }
    }

    public void stopAppletDirectly() {
        if (this.destroying) {
            return;
        }
        this.isInvisible = true;
        this.panel.appletStop();
    }

    public void appletStartApplet() {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.appletStartAppletDirectly(applet);
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new AppletStartApplet(), 1L));
    }

    public void appletStartAppletDirectly(Applet applet) {
        if (applet == null || this.destroying) {
            return;
        }
        this.setAppletVisibleDirectly(applet, true);
        applet.start();
    }

    public void appletStopApplet() {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.appletStopAppletDirectly(applet);
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new AppletStopApplet(), 1L));
    }

    public void appletStopAppletDirectly(Applet applet) {
        if (applet == null || this.destroying) {
            return;
        }
        this.setAppletVisibleDirectly(applet, false);
        applet.stop();
    }

    protected void setAllComponentsInvisible(Component[] components) {
        for (int i = 1; i <= components.length; ++i) {
            components[i - 1].setVisible(false);
            try {
                this.setAllComponentsInvisible(((Container)components[i - 1]).getComponents());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected void disableAllComponents(Component[] components) {
        for (int i = 1; i <= components.length; ++i) {
            components[i - 1].setEnabled(false);
            try {
                this.disableAllComponents(((Container)components[i - 1]).getComponents());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void destroyApplet() {
        if (this.destroying) {
            return;
        }
        this.destroying = true;
        this.prevCocoaParentView = this.cocoaParentView;
        this.cocoaParentView = 0L;
        this.isInvisible = true;
        Applet applet = this.getApplet();
        if (AppletHandlerFactory.getPropertyBoolean("jep.debug.release", false)) {
            System.out.println(new Date() + " AppletFrame.destroyApplet() for " + (applet != null ? applet.getClass().getName() : "0x" + Long.toHexString(this.prevCocoaParentView)));
        }
        if (applet == null) {
            this.emptyClipperTable();
            this.clipperTable = null;
            this.panel.setLayout(null);
            this.setLayout(null);
            SunToolkit.postEvent(AppletHandlerFactory.mainAppContext, new PeerEvent(this, new Destroy2(), 0L));
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.destroyAppletDirectly1();
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new Destroy1(), 1L));
    }

    public void destroyAppletDirectly1() {
        this.destroying = true;
        this.cocoaParentView = 0L;
        this.isInvisible = true;
        this.disableChildWindows();
        this.panel.setVisible(false);
        Component[] components = this.panel.getComponents();
        if (components != null) {
            this.setAllComponentsInvisible(components);
            this.disableAllComponents(components);
        }
        this.panel.setEnabled(false);
        this.panel.setLayout(null);
        this.setLayout(null);
        this.emptyClipperTable();
        this.clipperTable = null;
        this.disposeChildWindows();
        SunToolkit.postEvent(AppletHandlerFactory.mainAppContext, new PeerEvent(this, new Destroy2(), 0L));
    }

    public void destroyAppletDirectly2() {
        if (this.getApplet() == null) {
            this.panel.setVisible(false);
            this.panel.setEnabled(false);
        }
        AppletHandlerFactory.deleteAppletJNIGlobalRefs(this.prevCocoaParentView);
        ((AppletFramePanel)this.panel).cleanup();
        Runnable croak = new Runnable(){

            public void run() {
                AppletFrame.this.panel.appletDestroy(0L);
                AppletFrame.this.panel = null;
                SunToolkit.postEvent(AppletHandlerFactory.mainAppContext, new PeerEvent(AppletFrame.this, new Destroy3(), 0L));
            }
        };
        Thread croaker = new Thread(croak);
        croaker.start();
    }

    public void destroyAppletDirectly3() {
        this.dispose();
    }

    public int getCocoaParentViewInt() {
        return (int)this.cocoaParentView;
    }

    public long getCocoaParentViewLong() {
        return this.cocoaParentView;
    }

    public int getPluginInstance() {
        return this.pluginInstance;
    }

    public void changeFrameAppContext(AppContext appcontext) {
        SunToolkit.insertTargetMapping(this, appcontext);
        SunToolkit.insertTargetMapping(this.panel, appcontext);
    }

    public AppletContext getAppletContext() {
        return this.panel.getAppletContext();
    }

    public String toString() {
        return super.toString() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private class Destroy3
    implements Runnable {
        private Destroy3() {
        }

        public void run() {
            AppletFrame.this.destroyAppletDirectly3();
            if (showDebugInfo) {
                System.err.println("AppletFrame Destroy3 run() called");
            }
        }
    }

    private class Destroy2
    implements Runnable {
        private Destroy2() {
        }

        public void run() {
            AppletFrame.this.destroyAppletDirectly2();
            if (showDebugInfo) {
                System.err.println("AppletFrame Destroy2 run() called");
            }
        }
    }

    private class Destroy1
    implements Runnable {
        private Destroy1() {
        }

        public void run() {
            AppletFrame.this.destroyAppletDirectly1();
            if (showDebugInfo) {
                System.err.println("AppletFrame Destroy1 run() called");
            }
        }
    }

    private class RemoveClip
    implements Runnable {
        private RemoveClip() {
        }

        public void run() {
            if (--AppletFrame.this.removeClipCount == 0) {
                AppletFrame.this.removeClipDirectly();
                AppletHandlerFactory.resumeAppletUpdates(AppletFrame.this.getCocoaParentViewLong());
            } else if (AppletFrame.this.removeClipCount < 0) {
                AppletFrame.this.removeClipCount = 0;
            }
            if (showDebugInfo) {
                System.err.println("AppletFrame RemoveClip run() called");
            }
        }
    }

    private class ImposeClip
    implements Runnable {
        private final int clipX;
        private final int clipY;
        private final int clipWidth;
        private final int clipHeight;

        ImposeClip(int clipX, int clipY, int clipWidth, int clipHeight) {
            this.clipX = clipX;
            this.clipY = clipY;
            this.clipWidth = clipWidth;
            this.clipHeight = clipHeight;
        }

        public void run() {
            if (--AppletFrame.this.imposeClipCount == 0) {
                AppletFrame.this.imposeClipDirectly(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
                AppletHandlerFactory.resumeAppletUpdates(AppletFrame.this.getCocoaParentViewLong());
            } else if (AppletFrame.this.imposeClipCount < 0) {
                AppletFrame.this.imposeClipCount = 0;
            }
            if (showDebugInfo) {
                System.err.println("AppletFrame ImposeClip run() called");
            }
        }
    }

    private class AppletStopApplet
    implements Runnable {
        private AppletStopApplet() {
        }

        public void run() {
            AppletFrame.this.appletStopAppletDirectly(AppletFrame.this.getApplet());
            if (showDebugInfo) {
                System.err.println("AppletFrame AppletStopApplet run() called");
            }
        }
    }

    private class AppletStartApplet
    implements Runnable {
        private AppletStartApplet() {
        }

        public void run() {
            AppletFrame.this.appletStartAppletDirectly(AppletFrame.this.getApplet());
            if (showDebugInfo) {
                System.err.println("AppletFrame AppletStartApplet run() called");
            }
        }
    }

    private class StopApplet
    implements Runnable {
        private final long jobID;

        StopApplet(long jobID) {
            this.jobID = jobID;
        }

        public void run() {
            AppletFrame.this.stopAppletDirectly();
            AppletHandlerFactory.stopProcessing(this.jobID);
            if (showDebugInfo) {
                System.err.println("AppletFrame StopApplet run() called");
            }
        }
    }

    private class SetVisible
    implements Runnable {
        private final boolean flag;
        private final boolean wait;
        private final long jobID;

        SetVisible(boolean flag, boolean wait, long jobID) {
            this.flag = flag;
            this.wait = wait;
            this.jobID = jobID;
        }

        public void run() {
            AppletFrame.this.setAppletVisibleDirectly(AppletFrame.this.getApplet(), this.flag);
            if (this.wait) {
                AppletHandlerFactory.stopProcessing(this.jobID);
            }
            if (showDebugInfo) {
                System.err.println("AppletFrame SetVisible run() called, flag is " + (this.flag ? "true" : "false"));
            }
        }
    }

    private class InvalidateAndValidate
    implements Runnable {
        private InvalidateAndValidate() {
        }

        public void run() {
            Applet applet = AppletFrame.this.getApplet();
            if (applet != null) {
                applet.invalidate();
            } else {
                AppletFrame.this.getPanel().invalidate();
            }
            AppletFrame.this.validate();
            if (showDebugInfo) {
                System.err.println("AppletFrame InvalidateAndValidate run() called on " + AppletFrame.this.toString());
            }
        }
    }

    private class Validate
    implements Runnable {
        private Validate() {
        }

        public void run() {
            AppletFrame.this.validate();
            if (showDebugInfo) {
                System.err.println("AppletFrame Validate run() called on " + AppletFrame.this.toString());
            }
        }
    }

    public static class TimedLock {
        private Stack lockStack = new Stack();

        public void lock() {
            this.lock(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(long timeout) {
            Thread newLock = null;
            Thread firstLock = null;
            Object object = this.lockStack;
            synchronized (object) {
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                newLock = Thread.currentThread();
                this.lockStack.push(newLock);
                if (firstLock == null) {
                    return true;
                }
                if (newLock.equals(firstLock)) {
                    return true;
                }
            }
            object = newLock;
            synchronized (object) {
                try {
                    newLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            object = this.lockStack;
            synchronized (object) {
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    firstLock = null;
                }
                if (firstLock == null) {
                    System.err.println("AppletFrame.TimedLock.lock(): Lock stack is empty!");
                    Throwable barf = new Throwable();
                    barf.fillInStackTrace();
                    barf.printStackTrace();
                    return false;
                }
                Thread currentThread = Thread.currentThread();
                if (!currentThread.equals(firstLock)) {
                    for (int i = this.lockStack.size(); i >= 2; --i) {
                        Thread lock = (Thread)this.lockStack.elementAt(i - 1);
                        if (!currentThread.equals(lock)) continue;
                        this.lockStack.removeElementAt(i - 1);
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean trylock() {
            Stack stack = this.lockStack;
            synchronized (stack) {
                Thread firstLock = null;
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (firstLock == null) {
                    this.lock();
                    return true;
                }
                if (Thread.currentThread().equals(firstLock)) {
                    this.lock();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Stack stack = this.lockStack;
            synchronized (stack) {
                int currentThreadLockCount = 0;
                Thread currentThread = Thread.currentThread();
                for (int i = this.lockStack.size(); i >= 1; --i) {
                    Thread lock = (Thread)this.lockStack.elementAt(i - 1);
                    if (!currentThread.equals(lock) || ++currentThreadLockCount != 1) continue;
                    this.lockStack.removeElementAt(i - 1);
                }
                if (currentThreadLockCount >= 2) {
                    return;
                }
                if (currentThreadLockCount == 0) {
                    System.err.println("AppletFrame.TimedLock.unlock() called without matching call to lock()!");
                    Throwable barf = new Throwable();
                    barf.fillInStackTrace();
                    barf.printStackTrace();
                    return;
                }
                if (!this.lockStack.empty()) {
                    Thread firstLock;
                    Thread thread = firstLock = (Thread)this.lockStack.elementAt(0);
                    synchronized (thread) {
                        firstLock.notify();
                    }
                }
            }
        }
    }
}

