/*
 * $XConsortium: driver.c,v 1.2 91/08/20 15:11:50 gildea Exp $
 *
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THOMAS ROELL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Thomas Roell, roell@informatik.tu-muenchen.de
 */

#include "X.h"
#include "input.h"
#include "screenint.h"

#include "compiler.h"

#include "x386.h"
#include "x386Priv.h"
#include "x386OSD.h"
#include "vga.h"

typedef struct {
  vgaHWRec std;               /* good old IBM VGA */
  unsigned char ExtStart;     /* Tseng S3 specials   CRTC 0x33/0x34/0x35 */
  unsigned char Compatibility;
  unsigned char OverflowHigh;
  unsigned char StateControl;    /* TS 6 & 7 */
  unsigned char AuxillaryMode;
  unsigned char Misc;           /* ATC 0x16 */
  unsigned char SegSel;
  } vgaS3Rec, *vgaS3Ptr;

#define	S3_801	0xa0
#define S3_911  0x81
int	        s3801;

static Bool     S3Probe();
static void     S3ClockSelect();
static void     LegendClockSelect();
static void     S3EnterLeave();
static char *   S3Ident();
static void     S3Init();
static void *   S3Save();
static void     S3Restore();
static void     S3Adjust();
extern void     S3SetRead();
extern void     S3SetRead();
extern void     S3SetRead();

#define JNT
vgaVideoChipRec S3 = {
  S3Probe,
  S3Ident,
  S3EnterLeave,
  S3Init,
  S3Save,
  S3Restore,
  S3Adjust,
  S3SetRead,
  S3SetRead,
  S3SetRead,
  0x10000,
  0x10000,
  16,
  0xFFFF,
  0x00000, 0x10000,
  0x00000, 0x10000,
  FALSE,
};

#define new ((vgaS3Ptr)vgaNewVideoState)

void (*ClockSelect)();


/*
 * S3ClockSelect --
 *      select one of the possible clocks ...
 */

static void
S3ClockSelect(no)
     int no;
{
  unsigned char temp;


  temp = inb(0x3CC);
  outb(0x3C2, /*temp | 0x01*/ 0x3f); /*JNT */
  outb(vgaIOBase + 4, 0x42); 

/*  outb(vgaIOBase + 5, 0x10 | (no &  4)); */
  
  outb(vgaIOBase + 5, no); /* JNT, for interlace | 0x20 */

}



/*
 * LegendClockSelect --
 *      select one of the possible clocks ...
 */

static void
LegendClockSelect(no)
     int no;
{
  /*
   * Sigma Legend special handling
   *
   * The Legend uses an ICS 1394-046 clock generator.  This can generate 32
   * different frequencies.  The Legend can use all 32.  Here's how:
   *
   * There are two flip/flops used to latch two inputs into the ICS clock
   * generator.  The five inputs to the ICS are then
   *
   * ICS     ET-4000
   * ---     ---
   * FS0     CS0
   * FS1     CS1
   * FS2     ff0     flip/flop 0 output
   * FS3     CS2
   * FS4     ff1     flip/flop 1 output
   *
   * The flip/flops are loaded from CS0 and CS1.  The flip/flops are
   * latched by CS2, on the rising edge. After CS2 is set low, and then high,
   * it is then set to its final value.
   *
   */
  unsigned char temp = inb(0x3CC);

  outb(0x3C2, (temp & 0xF3) | ((no & 0x10) >> 1) | (no & 0x04));
  outw(vgaIOBase + 4, 0x0034);
  outw(vgaIOBase + 4, 0x0234);
  outw(vgaIOBase + 4, ((no & 0x08) << 6) | 0x34);
  outb(0x3C2, (temp & 0xF3) | ((no << 2) & 0x0C));
}



/*
 * S3Probe --
 *      check up whether a S3 based board is installed
 */

static Bool
S3Probe()
{
  int numClocks;
  unsigned char temp;
  
  if (vga256InfoRec.chipset)
    {
      if (strcmp(vga256InfoRec.chipset, "s3") &&
		  strcmp(vga256InfoRec.chipset, "S3") &&
		  strcmp(vga256InfoRec.chipset, "s3801") &&
		  strcmp(vga256InfoRec.chipset, "S3801") &&
		  strcmp(vga256InfoRec.chipset, "s3911") &&
		  strcmp(vga256InfoRec.chipset, "S3911"))
	return (FALSE);
    }
#ifdef __linux__  /* the s3 uses too many IO addresses JNT */
	  iopl(3); /* This shouldn't be here MOVE ME */
#endif

      outb(0x3d4, 0x38);                       /* unlock S3 special */
      outb(0x3d5, 0x48);

      outb (0x3d4, 0x30);
      temp = inb(0x3d5);

      if (temp != S3_801 && temp != S3_911) {
	  S3EnterLeave(LEAVE);
	  return(FALSE);
	}

      if (temp == S3_801) {
	 vga256InfoRec.chipset = "S3801";
	 s3801 = 1;
      } else
	 vga256InfoRec.chipset = "S3911";

      S3EnterLeave(ENTER);



  /*
   * Detect how much memory is installed
   */
  if (!vga256InfoRec.videoRam)
    {
      unsigned char config;
      
      outb(0x3d4, 0x36);
      config = inb(0x3d5);        /* get amount of vram installed */

      if ((config & 0x20) == 0 ) {    /* JNT was wrong way round */
	vga256InfoRec.videoRam = 1024; 
      } else {
	vga256InfoRec.videoRam = 512;
      }



    }

  if (!strcmp(vga256InfoRec.vendor, "legend"))
    {
      ClockSelect = LegendClockSelect;
      numClocks   = 32;
    }
  else
    {
      ClockSelect = S3ClockSelect;
      numClocks   = 16;
    }
  
  if (!vga256InfoRec.clocks) vgaGetClocks(numClocks, ClockSelect);

  return(TRUE);
}



/*
 * S3EnterLeave --
 *      enable/disable io-mapping
 */

static void 
S3EnterLeave(enter)
     Bool enter;
{
  unsigned char temp;

  if (enter)
    {
#ifdef SYSV
      ioctl(x386Info.consoleFd, KDADDIO, 0x3BF);
      ioctl(x386Info.consoleFd, KDENABIO, 0);
#endif


/*      vgaIOBase = (inb(0x3CC) & 0x01) ? 0x3D0 : 0x3B0; */
      vgaIOBase = 0x3D0;
      outb(0x3d4, 0x39);
      outb(0x3d5, 0xa0);                       /* unlock system control reg*/
      outb(0x3d4, 0x3A);

#ifdef JNT
      outb(0x3d5, 0x95);	    /* JNT this works for XS3 */
#else
      outb(0x3d5, 0x80);               /* set memcs16 bus signal */
#endif      

      
      outb(0x3d4, 0x31);                       /* enable banking and vga16*/
      temp = inb(0x3d5);

#ifdef JNT
      outb(0x3d5, 0x8d);	     /* JNT this works for XS3 */
#else
      outb(0x3d5, 3);
#endif

      outb(0x3ce, 0x6);                        /* set graphics mode & 64k */
      temp = inb(0x3cf);
      outb(0x3cf, temp | 5);

/*      outb(0x3c0, 0x10);   this was to enable the palette
      outb(0x3c1, 0x41); */

      temp = inb(0x3CC);                      /* enable ram address decoder */
      outb(0x3C2, temp | 2);


/*      outb(vgaIOBase + 8, 0xA0); */
/* vertical retrace low-end */
      outb(vgaIOBase + 4, 0x11); temp = inb(vgaIOBase + 5);
      outb(vgaIOBase + 5, temp & 0x7F); 

/* enable linear mapping 
      outb(0x3d4, 0x31);
      temp = inb(0x3d5);
      outb(0x3d5, temp | 8); */ /* enable enhanced memory mapping */



#ifdef JNT
      outb(0x3d4,0x40);
      if (s3801) {
	 int i;

	 outb(0x3d5,0x83);
	 outb(0x3d4, 0x58);
	 outb(0x3d5, 0x00);
	 outb(0x3d4,0x59);
	 outb(0x3d5,0x0a);
	 outb(0x3d4,0x54);
	 outb(0x3d5,0xa0);
	 outb(0x3d4,0x60);
	 outb(0x3d5,0x2f);
	 outb(0x3d4, 0x61);
	 outb(0x3d5, 0x81);
	 outb(0x3d4, 0x62);
	 outb(0x3d5, 0);
	      /* begin 801 sequence for going in to linear mode */
	 outb(0x3d4, 0x40);
	 temp = inb(0x3d5);
	 i = (temp & 0xf6) | 0x0a; /* enable fast write buffer and 
			 disable 8514/a mode */
	 outb(0x3d5, (unsigned char) i);
	 outb(0x3d4,0x59);
	 outb(0x3d5,0x0a);  
	 outb(0x3d4, 0x53);
	 outb(0x3d5, 1);
	 outb(0x3d4, 0x58);
	 outb(0x3d5, 0x10);      /* go on to linear mode */
     /* end  801 sequence to go into linear mode */

      }else
	  outb(0x3d5,0x09);

      outb(0x3d4,0x41);
      outb(0x3d5, 0x1a);
#endif
      
    }
  else
    {
/*      outb(0x3BF, 0x01);                            relock S3 special 
      outb(vgaIOBase + 8, 0xA0); */

#ifdef SYSV
      ioctl(x386Info.consoleFd, KDDISABIO, 0);
      ioctl(x386Info.consoleFd, KDDELIO, 0x3BF);
#endif
    }
}





/*
 * S3Restore --
 *      restore a video mode
 */

static void 
S3Restore(restore)
  vgaS3Ptr restore;
{
  unsigned char i;

  outb(0x3d4, 0x35);   /* JNT set to first bank */
  i = inb(0x3d5);
  outb(0x3d5, (i & 0xf0));
  
  vgaHWRestore(restore);

  (ClockSelect)(restore->std.NoClock);

  outw(0x3C4, 0x0300); /* now reenable the timing sequencer */
  return;

  outb(0x3CD, 0x00); /* segment select */

  outw(0x3C4, (restore->StateControl << 8)  | 0x06);
  outw(0x3C4, (restore->AuxillaryMode << 8) | 0x07);
  i = inb(vgaIOBase + 0x0A); /* reset flip-flop */
  outb(0x3C0, 0x36); outb(0x3C0, restore->Misc);
  outw(vgaIOBase + 4, (restore->ExtStart << 8)      | 0x33);
  outw(vgaIOBase + 4, (restore->Compatibility << 8) | 0x34);
  outw(vgaIOBase + 4, (restore->OverflowHigh << 8)  | 0x35);
  outb(0x3CD, restore->SegSel);


}



/*
 * S3Save --
 *      save the current video mode
 */

static void *
S3Save(save)
     vgaS3Ptr save;
{
  unsigned char             i;
  unsigned char             temp1, temp2;



  /*
   * we need this here , cause we MUST disable the ROM SYNC feature
   */
/*  outb(vgaIOBase + 4, 0x34); temp1 = inb(vgaIOBase + 5);
/*  outb(vgaIOBase + 5, temp1 & 0x0F);
  temp2 = inb(0x3CD); outb(0x3CD, 0x00);  segment select */

  save = (vgaS3Ptr)vgaHWSave(save, sizeof(vgaS3Rec));
  save->Compatibility = temp1;
  save->SegSel = 0;

/*  outb(vgaIOBase + 4, 0x33); save->ExtStart     = inb(vgaIOBase + 5); */
  outb(vgaIOBase + 4, 0x7); save->OverflowHigh = inb(vgaIOBase + 5);
/*  outb(0x3C4, 6); save->StateControl  = inb(0x3C5); */
/*  outb(0x3C4, 7); save->AuxillaryMode = inb(0x3C5); */
  i = inb(vgaIOBase + 0x0A); /* reset flip-flop */
/*  outb(0x3C0,0x36); save->Misc = inb(0x3C1); outb(0x3C0, save->Misc); */

  return ((void *) save);
}


/*
 * S3Ident --
 */
char *
S3Ident()
{
   return("s3");
}
  

/*
 * S3Init --
 *      Handle the initialization of the VGAs registers
 */

static void
S3Init(mode)
     DisplayModePtr mode;
{
  vgaHWInit(mode,sizeof(vgaS3Rec));

  new->std.Attribute[16] = 0x01;  /* use the FAST 256 Color Mode */
  new->std.CRTC[19] = vga256InfoRec.virtualX >> 3;
  new->std.CRTC[20] = 0x60;
  new->std.CRTC[23] = 0xAB;
  new->StateControl = 0x00; 
/*  new->AuxillaryMode = */

  new->ExtStart = 0x00;

/* DON'T forget to set Interlace else where!!!!!! */
  new->OverflowHigh = 
       ((mode->VSyncStart & 0x400) >> 7 )       
	| (((mode->VDisplay -1) & 0x400) >> 9 ) 
	  | (((mode->VTotal -2) & 0x400) >> 5 ) 
	  | (((mode->VTotal -2) & 0x200) >> 9 ) 
	    | (((mode->VSyncStart) & 0x200) >> 3 ); 

#ifdef JNT
   if (mode->HDisplay < 800)  {  /* MOVE ME - JNT */
      outw(0x4ae8,0x0003);
   }
   else 
      outw(0x4ae8,0x0007);
#endif
}



/*
 * S3Adjust --
 *      adjust the current video frame to display the mousecursor
 */

static void 
S3Adjust(x, y)
     int x, y;
{   
  int Base = (y * vga256InfoRec.virtualX + x) >> 2;

  x = Base & 0x0fff00;
  if (x > 0xff00) x = 0xff00;
  outw(vgaIOBase + 4, x | 0x000C);

  y = Base & 0xff;
  outw(vgaIOBase + 4, (y << 8) | 0x000D);

}

