#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 6; apic id = 06
# fault virtual address   = 0xb8
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xffffffff80d3c17b
# stack pointer           = 0x28:0xfffffe00e49fab80
# frame pointer           = 0x28:0xfffffe00e49facc0
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 12 (swi1: netisr 0)
# rdi: fffff802d2d8daa0 rsi: fffffe00e49fab48 rdx: ffffffff819d5a90
# rcx: ffffffff819d5a98  r8: 00000000ffffffff  r9: 0000000000000000
# rax: 0000000000000000 rbx: 0000000000000002 rbp: fffffe00e49facc0
# r10: fffff802d2d8daa0 r11: 0000000000010000 r12: 0000000000000000
# r13: fffff802d2d8da80 r14: 0000000000000060 r15: fffff802d2d8dab8
# trap number             = 12
# panic: page fault
# cpuid = 6
# time = 1689053386
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e49fa930
# vpanic() at vpanic+0x149/frame 0xfffffe00e49fa980
# panic() at panic+0x43/frame 0xfffffe00e49fa9e0
# trap_fatal() at trap_fatal+0x40c/frame 0xfffffe00e49faa40
# trap_pfault() at trap_pfault+0xae/frame 0xfffffe00e49faab0
# calltrap() at calltrap+0x8/frame 0xfffffe00e49faab0
# --- trap 0xc, rip = 0xffffffff80d3c17b, rsp = 0xfffffe00e49fab80, rbp = 0xfffffe00e49facc0 ---
# tcp_input_with_port() at tcp_input_with_port+0x70b/frame 0xfffffe00e49facc0
# tcp6_input_with_port() at tcp6_input_with_port+0x6a/frame 0xfffffe00e49facf0
# tcp6_input() at tcp6_input+0xb/frame 0xfffffe00e49fad00
# ip6_input() at ip6_input+0xc97/frame 0xfffffe00e49fade0
# swi_net() at swi_net+0x19b/frame 0xfffffe00e49fae60
# ithread_loop() at ithread_loop+0x266/frame 0xfffffe00e49faef0
# fork_exit() at fork_exit+0x82/frame 0xfffffe00e49faf30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00e49faf30
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 12 tid 100089 ]
# Stopped at      kdb_enter+0x32: movq    $0,0xde5053(%rip)
# db> x/s version
# version:        FreeBSD 14.0-CURRENT #0 main-n264110-43ed91e00bbb1: Tue Jul 11 06:28:21 CEST 2023
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

uname -p | grep -Eq "amd64" || exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=44d933862f436b628c77db28122dbfa4e00990aa
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+e7d2e451f89fb444319b@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static __thread int clone_ongoing;
static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  if (__atomic_load_n(&clone_ongoing, __ATOMIC_RELAXED) != 0) {
    exit(sig);
  }
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS)
    valid = 1;
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void reset_flags(const char* filename)
{
  struct stat st;
  if (lstat(filename, &st))
    exit(1);
  st.st_flags &= ~(SF_NOUNLINK | UF_NOUNLINK | SF_IMMUTABLE | UF_IMMUTABLE |
                   SF_APPEND | UF_APPEND);
  if (lchflags(filename, st.st_flags))
    exit(1);
}
static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename)) {
      if (errno == EPERM) {
        reset_flags(filename);
        reset_flags(dir);
        if (unlink(filename) == 0)
          continue;
      }
      exit(1);
    }
  }
  closedir(dp);
  while (rmdir(dir)) {
    if (errno == EPERM) {
      reset_flags(dir);
      if (rmdir(dir) == 0)
        break;
    }
    exit(1);
  }
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  for (call = 0; call < 7; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (call == 3)
        break;
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    NONFAILING(*(uint32_t*)0x20000080 = 9);
    syscall(SYS_setsockopt, r[0], 0xffff, 0x10000, 0x20000080ul, 4ul);
    break;
  case 2:
    NONFAILING(*(uint8_t*)0x200000c0 = 0x1c);
    NONFAILING(*(uint8_t*)0x200000c1 = 0x1c);
    NONFAILING(*(uint16_t*)0x200000c2 = htobe16(0x4e20 + procid * 4));
    NONFAILING(*(uint32_t*)0x200000c4 = 0);
    NONFAILING(memset((void*)0x200000c8, 0, 16));
    NONFAILING(*(uint32_t*)0x200000d8 = 0);
    syscall(SYS_bind, r[0], 0x200000c0ul, 0x1cul);
    break;
  case 3:
    NONFAILING(*(uint32_t*)0x20000080 = 9);
    syscall(SYS_setsockopt, r[0], 0xffff, 0x10000, 0x20000080ul, 4ul);
    break;
  case 4:
    NONFAILING(*(uint32_t*)0x20000040 = 0x72);
    NONFAILING(*(uint8_t*)0x20000048 = 0x10);
    NONFAILING(*(uint8_t*)0x20000049 = 2);
    NONFAILING(*(uint16_t*)0x2000004a = htobe16(0x4e21 + procid * 4));
    NONFAILING(*(uint32_t*)0x2000004c = htobe32(0x7f000001));
    NONFAILING(memset((void*)0x20000050, 0, 8));
    NONFAILING(memset((void*)0x20000058, 0, 112));
    syscall(SYS_setsockopt, r[0], 0, 0x51, 0x20000040ul, 0x88ul);
    break;
  case 5:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0);
    if (res != -1)
      r[1] = res;
    break;
  case 6:
    NONFAILING(*(uint8_t*)0x20000140 = 0x1c);
    NONFAILING(*(uint8_t*)0x20000141 = 0x1c);
    NONFAILING(*(uint16_t*)0x20000142 = htobe16(0x4e20 + procid * 4));
    NONFAILING(*(uint32_t*)0x20000144 = 0);
    NONFAILING(memset((void*)0x20000148, 0, 16));
    NONFAILING(*(uint32_t*)0x20000158 = 0);
    syscall(SYS_connect, r[1], 0x20000140ul, 0x1cul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      use_temporary_dir();
      do_sandbox_none();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 2m -i 10 -l 100 > /dev/null 2>&1) &

(cd /tmp; timeout 2m ./$prog)
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/syzkaller.*
exit 0
