#!/bin/sh

# panic: Assertion clen >= sizeof(*cm) && clen <= cm->cmsg_len failed at ../../../kern/uipc_usrreq.c:2018
# cpuid = 8
# time = 1653654831
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0158aebaa0
# vpanic() at vpanic+0x17f/frame 0xfffffe0158aebaf0
# panic() at panic+0x43/frame 0xfffffe0158aebb50
# unp_externalize() at unp_externalize+0x3b7/frame 0xfffffe0158aebbe0
# soreceive_generic() at soreceive_generic+0x73d/frame 0xfffffe0158aebca0
# soreceive() at soreceive+0x4b/frame 0xfffffe0158aebcc0
# kern_recvit() at kern_recvit+0x1ba/frame 0xfffffe0158aebd70
# sys_recvfrom() at sys_recvfrom+0x95/frame 0xfffffe0158aebe00
# amd64_syscall() at amd64_syscall+0x145/frame 0xfffffe0158aebf30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0158aebf30
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x8230797da, rsp = 0x827bc4f48, rbp = 0x827bc4f70 ---
# KDB: enter: panic
# [ thread pid 32490 tid 141239 ]
# Stopped at      78043(%rip)
# db> x/s version
# FreeBSD 14.0-CURRENT #0 n255820-4682ac697ce9b: Fri May 27 07:06:21 CEST 2022
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 


[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller56.c <<EOF
// https://syzkaller.appspot.com/bug?id=10ad96d3c8f58f42ad73650e339a4952f9d82254
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+c48c62e7fbd8ef327088@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  for (call = 0; call < 3; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socketpair, 1ul, 5ul, 0, 0x20000100ul);
    if (res != -1) {
      r[0] = *(uint32_t*)0x20000100;
      r[1] = *(uint32_t*)0x20000104;
    }
    break;
  case 1:
    syscall(SYS_recvfrom, r[0], 0x20000140ul, 0x1000ul, 0ul, 0ul, 0ul);
    break;
  case 2:
    *(uint64_t*)0x20001e40 = 0;
    *(uint32_t*)0x20001e48 = 0;
    *(uint64_t*)0x20001e50 = 0;
    *(uint64_t*)0x20001e58 = 0;
    *(uint64_t*)0x20001e60 = 0x20001f80;
    memcpy((void*)0x20001f80,
           "\x60\x00\x00\x00\xff\xff\x00\x00\x03\x00\x00\x00", 12);
    *(uint32_t*)0x20001f8c = -1;
    *(uint32_t*)0x20001f90 = 0;
    *(uint32_t*)0x20001f94 = 0;
    *(uint32_t*)0x20001f98 = 0;
    memcpy((void*)0x20001f9c, "\x10\x00\x26\x00", 4);
    *(uint32_t*)0x20001fa0 = 0;
    *(uint32_t*)0x20001fa4 = 0;
    *(uint32_t*)0x20001fa8 = 0;
    *(uint32_t*)0x20001fac = 0;
    *(uint32_t*)0x20001fb0 = 0;
    *(uint32_t*)0x20001fb4 = 0;
    *(uint32_t*)0x20001fb8 = -1;
    *(uint32_t*)0x20001fbc = 0;
    *(uint32_t*)0x20001fc0 = -1;
    *(uint32_t*)0x20001fc4 = 0;
    *(uint32_t*)0x20001fc8 = 0;
    *(uint32_t*)0x20001fcc = 0;
    *(uint32_t*)0x20001fd0 = 0;
    *(uint32_t*)0x20001fd4 = 0;
    *(uint32_t*)0x20001fd8 = 0;
    *(uint32_t*)0x20001fdc = 0;
    memcpy((void*)0x20001fe0,
           "\x60\x00\x00\x00\xff\xff\x00\x00\x03\x00\x00\x00", 12);
    *(uint32_t*)0x20001fec = 0;
    *(uint32_t*)0x20001ff0 = 0;
    *(uint32_t*)0x20001ff4 = 0;
    *(uint32_t*)0x20001ff8 = -1;
    memcpy((void*)0x20001ffc, "\x10\x00\x00\x00", 4);
    *(uint32_t*)0x20002000 = -1;
    *(uint32_t*)0x20002004 = 0;
    *(uint32_t*)0x20002008 = 0;
    *(uint32_t*)0x2000200c = 0;
    *(uint32_t*)0x20002010 = 0;
    *(uint32_t*)0x20002014 = 0;
    *(uint32_t*)0x20002018 = -1;
    *(uint32_t*)0x2000201c = 0;
    *(uint32_t*)0x20002020 = -1;
    *(uint32_t*)0x20002024 = 0;
    *(uint32_t*)0x20002028 = 0;
    *(uint32_t*)0x2000202c = 0;
    *(uint32_t*)0x20002030 = 0;
    *(uint32_t*)0x20002034 = 0;
    *(uint32_t*)0x20002038 = 0;
    *(uint32_t*)0x2000203c = -1;
    memcpy((void*)0x20002040,
           "\x14\x00\x00\x00\xff\xff\x00\x00\x01\x00\x00\x00", 12);
    *(uint32_t*)0x2000204c = -1;
    *(uint32_t*)0x20002050 = r[1];
    *(uint64_t*)0x20001e68 = 0xd4;
    *(uint32_t*)0x20001e70 = 0;
    syscall(SYS_sendmsg, r[1], 0x20001e40ul, 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller56 -Wall -Wextra -O0 /tmp/syzkaller56.c -lpthread ||
    exit 1

start=`date +%s`
while [ $((`date +%s` - start)) -lt 60 ]; do
	(cd /tmp; timeout 3m ./syzkaller56)
done

rm -rf /tmp/syzkaller56 /tmp/syzkaller56.c /tmp/syzkaller56.core \
    /tmp/syzkaller.??????
exit 0
