/* Definitions for WaveLAN driver */
/* HISTORY
 * $Log: if_wl.h,v $
 * Revision 1.9  1994/06/07  21:43:35  klemets
 * Added 50 microsecond delay after each CMD operation.
 * Split include file in two parts.  All stuff generic to all different
 * WaveLAN models go to chips/wavelan.h, the AT-bus specific stuff
 * remains here.
 *
 * Revision 1.8  1994/04/16  06:19:00  klemets
 * Added more flavor definitions, and made some minor changes to
 * earlier definitions.
 *
 * Revision 1.7  1994/04/15  21:45:02  klemets
 * Defined flavors for use by wlsetstat and wlgetstat when called
 * by the wlstat program.  Also defined corresponding structures
 * and command codes.
 *
 * Revision 1.6  1994/03/01  00:14:44  klemets
 * Added new Parameter Storage Area definitions.  Redefined NETW_ADDR
 * and NETW_ID.  Added HASR_MMC_BUSY check to definition of MMC_WRITE.
 *
 * Revision 1.5  1994/02/28  23:37:07  klemets
 * Added MMC_MODE_SEL definition
 *
 * Revision 1.4  1991/11/22  14:46:43  klemets
 * Added definition of address to the location of the IRQ number.
 *
 * Revision 1.3  91/05/08  20:40:02  klemets
 * Added SNR statistics fields, and removed two unused counters.
 * 
 * Revision 1.2  91/03/27  16:13:58  klemets
 * Added structure of MMC counters to struct wl_cntrs.
 * 
 * Revision 1.1  91/02/11  15:09:26  klemets
 * Initial revision
 * 
 */

#ifndef	_I386AT_IF_WL_H
#define _I386AT_IF_WL_H

#define	STATUS_TRIES	15000

#define N_FD			100
#define N_RBD			100
#define N_TBD			72
#define RCVBUFSIZE		540
#define I82586NULL		0xffff

#define DSF_RUNNING	1

#define MOD_ENAL 1
#define MOD_PROM 2

typedef struct {
	rbd_t	r;
	char	rbd_pad[2];
	char	rbuffer[RCVBUFSIZE];
} ru_t;

/* Board 64k RAM layout. Offsets from 0x0000 */
	
#define OFFSET_RU		0x0000		/* 0x64 * fd_t = 0x898 */
#define OFFSET_RBD		0x0900		/* 0x64 * ru_t = 0xd7a0 */
#define OFFSET_CU		0xe0a0		/* 0x100 */
#define OFFSET_TBD		0xe1a0		/* 0x48 * tbd_t = 0x240 */
#define OFFSET_TBUF		0xe3e0		/* 0x1bfe */
#define OFFSET_SCB		0xffde		/* 0x1 * scb_t = 0x10 */
#define OFFSET_ISCP		0xffee		/* 0x1 * iscp_t = 0x8 */
#define OFFSET_SCP		0xfff6		/* 0x1 * scp_t = 0xa */
	
/* WaveLAN host interface definitions */

#define HACR(base)	(base)		/* Host Adapter Command Register */
#define HASR(base)	(base)		/* Host Adapter Status Register */
#define MMCR(base)	(base+0x2)	/* Modem Management Ctrl Register */
#define PIOR0(base)	(base+0x4)	/* Program I/O Address Register 0 */
#define PIOP0(base)	(base+0x6)	/* Program I/O Port 0 */
#define PIOR1(base)	(base+0x8)	/* Program I/O Address Register 1 */
#define PIOP1(base)	(base+0xa)	/* Program I/O Port 1 */
#define PIOR2(base)	(base+0xc)	/* Program I/O Address Register 2 */
#define PIOP2(base)	(base+0xe)	/* Program I/O Port 2 */

/* Program I/O Mode Register values */

#define STATIC_PIO		0	/* Mode 1: static mode */
#define AUTOINCR_PIO		1	/* Mode 2: auto increment mode */
#define AUTODECR_PIO		2	/* Mode 3: auto decrement mode */
#define PARAM_ACCESS_PIO	3	/* Mode 4: LAN parameter access mode */
#define PIO_MASK		3	/* register mask */
#define PIOM(cmd,piono)		((u_short)cmd << 10 << (piono * 2))

/* Host Adapter status register definitions */

#define HASR_INTR		0x0001	/* Interrupt request from 82586 */
#define HASR_MMC_INTR		0x0002	/* Interrupt request from MMC */
#define HASR_MMC_BUSY		0x0004	/* MMC busy indication */
#define HASR_PARA_BUSY		0x0008	/* LAN parameter storage area busy */

/* Host Adapter command register definitions */

#define HACR_RESET		0x0001	/* Reset board */
#define HACR_CA			0x0002	/* Set Channel Attention for 82586 */
#define HACR_16BITS		0x0004	/* 1==16 bits operation, 0==8 bits */
#define HACR_OUT1		0x0008	/* General purpose output pin */
#define HACR_OUT2		0x0010	/* General purpose output pin */
#define HACR_MASK_82586		0x0020	/* Mask 82586 interrupts, 1==unmask */
#define HACR_MASK_MMC		0x0040	/* Mask MMC interrupts, 1==unmask */
#define HACR_INTR_CLEN		0x0080	/* interrupt status clear enable */

#define HACR_DEFAULT	(HACR_OUT1 | HACR_OUT2 | HACR_16BITS | PIOM(STATIC_PIO, 0) | PIOM(AUTOINCR_PIO, 1) | PIOM(PARAM_ACCESS_PIO, 2))
#define HACR_INTRON	(HACR_MASK_82586 | HACR_MASK_MMC | HACR_INTR_CLEN)

#define PCMD(base, hacr) outw((base), (hacr))
#define CMD(unit)	\
		{ \
		   outw(HACR(WLSOFTC(unit)->base),WLSOFTC(unit)->hacr); \
		   /* delay for 50 us, might only be needed sometimes */ \
		   DELAY(DELAYCONST); \
	        }

/* macro for setting the channel attention bit.  No delays here since
 * it is used in critical sections
 */
#define SET_CHAN_ATTN(unit)   \
      { \
         outw(HACR(WLSOFTC(unit)->base),WLSOFTC(unit)->hacr | HACR_CA); \
      }


/* Definitions for hardware block */

#define HWPARAMS		0x07	/* Address of hardware parameters */
#define HW_WAITST		0x0f	/* Wait state mask */
#define HW_AT_EISA_INTR		0x10	/* AT or EISA interrupt logic */
#define HW_IRQTOGGLE		0x20	/* IRQ toggled every 10 ms */
#define IRQNO			0x08	/* Interrupt request number */

#define MMC_WRITE(cmd,val)	\
	while(inw(HASR(WLSOFTC(unit)->base)) & HASR_MMC_BUSY) ; \
	outw(MMCR(WLSOFTC(unit)->base), \
	     (u_short)(((u_short)(val) << 8) | ((cmd) << 1) | 1))

#ifndef	MACH_KERNEL
#ifndef TRUE
#define TRUE            1     
#endif 	TRUE
#define	HZ		100
#endif	MACH_KERNEL

#endif	_I386AT_IF_WL_H

