/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: uncache/uncache.c
    Version 1.17
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include "uncache.h"

static	FILE	*ifp;
static	Cache_entry	cacheitem;
static	void	parse_cache();


char	mfpath[MAXLEN],
	cfpath[MAXLEN];

main( argc, argv)
int	argc;
char	*argv[];
{
	void	uncache();

	init( argc, argv);
	uncache( mfpath, cfpath);
}

void
uncache( mpath, cpath)
char	*mpath,
	*cpath;
{

	FILE	*mfp,
		*cfp;

	struct stat stat_buf;

	Cache_entry	*cip;

	char	*cp,
		mbuf[MAXLEN],
		cbuf[MAXLEN],
		mnewpath[MAXLEN],
		cnewpath[MAXLEN];


	if ( (cfp = fopen( cpath, "r")) == (FILE *) NULL ) {
		fprintf( stderr, "Can't open %s\n", cpath);
		exit( 2);
	}
	if ( (mfp = fopen( mpath, "w")) == (FILE *) NULL ) {
		fprintf( stderr, "Can't open %s\n", mpath);
		exit( 2);
	}


	printf( "Writing menu file %s\n", mpath);
	cip = &cacheitem;

	while ( fgets( cbuf, MAXLEN, cfp)) {
		
		chop( cbuf);

		switch( *cbuf ) {
		case '\0':
		case '\t':
		case 'h':
		case 'i':
			continue;
		}

		parse_cache( cbuf, cip);

		fprintf( mfp,
			"Name=%s\nPath=%s\nType=%c\nHost=%s\nPort=%s\n\n",
		 cip->name, cip->path, cip->type1, cip->host, cip->port);

		if ( recurse && (cbuf[0] == '1')) {
		/* Build new menu and cache path names and recurse */

			if ( cip->basename[0] != '\0') {
				strcpy( mnewpath, mpath);
				cp = strrchr( mnewpath, '/');
				sprintf( ++cp, "%s/%s", cip->basename, mfname);

	        	        strcpy( cnewpath, cpath);
				cp = strrchr( cnewpath, '/');
				sprintf( ++cp, "%s/%s", cip->basename, cfname);
				
				if ( stat( cnewpath, &stat_buf) != 0 ) {
				fprintf( stderr, 
					"Warning: link %s\n", cip->path);
				fprintf( stderr,
					"in %s\n", cpath);
				fprintf( stderr,
					"is not to subdirectory.\n\n");
				} else
					uncache( mnewpath, cnewpath);
			}
		}
	}
}


/*
 * parse_cache( line, cip) looks at a line from a .cache file and fills in
 * the fields of the Cache_entry struct pointed to by cip.  These fields
 * gtype, type1, name, basename, path, host and port.  The path and basename
 * have ending '/' removed.  Basename is empty iff the item refers to 
 * the root directory (it could have path 1/ or 7c/).  Gtype is everything
 * before the first '/' in the path field of the line from .cache and
 * type1 is the single character type which is the first character of
 * the .cache line.
 */


static void
parse_cache( line, cip)
char		*line;
Cache_entry	*cip;
{
	char	*cp,
		*cp2,
		*cp3,
		*cp4,
		cline[MAXLEN];

	strcpy( cline, line);
	if ( (cp = strchr( cline, '\t')) == (char *) NULL) {
		fprintf( stderr, "Corrupt cache entry (no tabs): %s\n", cline);
		exit( 2);
	}

	*cp++ = '\0';
	cip->type1 = cline[0];
	strcpy( cip->name, &cline[1]);
	
	/* cp points after 1st tab */

	strcpy(cip->gtype, cp);
	cp4 = strchr( cip->gtype, '/');
	if ( cp4 == NULL)
		cp4 = strchr( cip->gtype, '\t');
	*cp4 = '\0';
	
	if ( (cp2 = strchr( cp, '\t')) == (char *) NULL) {
		fprintf( stderr, "Corrupt cache entry (no 2nd tab): %s\n", cline);
		exit( 2);
	}
	*cp2++ = '\0';

	/* cp2 points after 2nd tab */

	strcpy( cip->path, cp);

	/* Make sure path does not end in '/' except for root */

	if (cip->path[strlen(cip->path)-1] == '/')
		cip->path[strlen(cip->path)-1] = '\0';

	if ( (cp3 = strrchr( cip->path, '/')) == NULL) {
		/* It's the root */

		*(cip->basename) = '\0';
	} else
		strcpy( cip->basename, ++cp3);

	if ( (cp3 = strchr( cp2, '\t')) == (char *) NULL) {
		fprintf( stderr, "Corrupt cache entry (no 3rd tab): %s\n", cline);
		exit( 2);
	}
	*cp3++ = '\0';

	/* cp3 points after 3rd tab */

	strcpy( cip->host, cp2);
	if ( (cp4 = strchr( cp3, '\t')) !=  NULL)
		*cp4 = '\0';
	strcpy( cip->port,  cp3);

}
	


/* chop( line)  Cut out CRLF at end of line */

void
chop( line)
char *line;
{
	char	*p;

	if ( *line == '\0')
		return;
	p = strchr( line, '\n');
	if ( p == (char *) NULL)
		return;
	if ( *(p-1) == '\r')
		p--;
	*p = '\0';
}













