/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/send.c
    Version 2.16
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "gn.h"
#include "search.h"

char	cache_owner[MAXLEN];

void
sendhead( ip)
Item	*ip;

{
	http_prolog( ip);
	writelog( ip->relpath, "Sent HTTP/1.0 header", ip->selector);
}

void
sendnomod( ip)
Item	*ip;

{
	strcpy( outheader.status, "304 Not Modified");
	http_prolog( ip);
	writelog( ip->relpath, "Sent 304 not modified", ip->selector);
}


/*
 * sendtext( ip)  Send the text file with Item pointer ip.
 */

void
sendtext( ip)
Item	*ip;


{
	FILE	*fp;
	char	linebuf[BUFSIZE],
		commandbuf[BUFSIZE];
	int	send_pre = FALSE;


	if ( ip->compressed) {
		sprintf( commandbuf, "%s %s", DECOMPRESS, ip->filepath);
		if ( (fp = popen( commandbuf, "r")) == (FILE *) NULL ) {
			senderr2( "Can't decompress", ip->filepath);
			exit( 2);
		}
	}
	else {
		if ( (fp = fopen( ip->filepath, "r")) == (FILE *) NULL ) {
			senderr2( "Can't open file", ip->filepath);
			exit( 2);
		}
	}

	http_prolog( ip);
	if ( http == HTTP0_9 && streq( ip->content_type, "text/plain") &&
				!streq( ip->suffix, "txt") )
		send_pre = TRUE;

	if ( send_pre)
		send_text_line( "<BODY><PRE>");

	while ( fgets( linebuf, BUFSIZE-2, fp))
		send_text_line( linebuf);

	if ( send_pre)
		send_text_line( "</PRE>\n</BODY>\n</HTML>");

	if ( !http )
		send_end();

	writelog( ip->relpath, "Sent text", ip->selector);

	if ( ip->compressed)
		pclose( fp);
	else
		fclose( fp);
}



/*
 * sendrange( ip)  Send a range from a textfile
 */

void
sendrange( ip)
Item	*ip;

{
	FILE	*fp;
	int	send_pre = FALSE;

	char	linebuf[BUFSIZE];

	if ( (fp = fopen( ip->filepath, "r")) == (FILE *) NULL ) {
		senderr2( "Can't open file", ip->filepath);
		exit( 2);
	}

	http_prolog( ip);

	if ( http == HTTP0_9 && streq( ip->content_type, "text/plain") &&
				!streq( ip->suffix, "txt") )
		send_pre = TRUE;

	if ( send_pre)
		send_text_line( "<BODY><PRE>");

	fseek( fp, ip->range_start, 0);
	while ( fgets( linebuf, BUFSIZE, fp)
				&& (ftell( fp) <= ip->range_end))
		send_text_line( linebuf);

	if ( send_pre )
		send_text_line( "</PRE>\n</BODY>\n</HTML>");
	if ( !http )
		send_end();
	writelog( ip->relpath, "Sent range", ip->selector);
}




/*
 * sendbin( ip)  Send a binary file.
 */

void
sendbin(  ip)
Item	*ip;

{
	FILE	*fp;
	char	commandbuf[PATHLEN];
	int	c;


	if ( ip->compressed) {
		sprintf( commandbuf, "%s %s", DECOMPRESS, ip->filepath);
		if ( (fp = popen( commandbuf, "r")) == (FILE *) NULL ) {
			senderr2( "Can't decompress", ip->filepath);
			exit( 2);
		}
	}
	else
		if ( (fp = fopen( ip->filepath, "r")) == (FILE *) NULL ) {
			senderr2( "Can't open file", ip->filepath);
			exit( 2);
		}
	
	http_prolog( ip);
	while ( (c = fgetc( fp )) != EOF)
		fputc( c, stdout);
	writelog( ip->relpath, "Sent binary", ip->selector);

	if ( ip->compressed)
		pclose( fp);
	else
		fclose( fp);
}

/*
 * sendcache( ip)  Send the contents of the cachefile
 * in the directory pointed to by selector.  ip->filepath is the complete
 * pathname of the directory with cfname appended.
 */

void
sendcache(  ip)
Item	*ip;

{
	int	empty;
	FILE	*fp;

	Cache_entry	entry;

	if ( (fp = fopen( ip->filepath, "r")) == (FILE *) NULL ) {
		senderr2( "Can't open cache file [sendcache]", 
			ip->filepath);
		exit( 2);
	}

	cache_owner[0] = '\0';

	empty = ( read_cache( &entry, fp) == NULL);
	cache_prolog( ip, "Menu", "");

	do {
		if ( http && !empty)
			www_cache_line( &entry);
		else if ( !empty)
			send_cache_line( &entry);
	} while ( read_cache( &entry, fp));

	cache_epilog(http);

	writelog( ip->relpath, "Sent cache", ip->selector);
}


void
cache_prolog(ip, str, option)
Item	*ip;
char	*str,
	*option;
{

	char	*cp,
		owner[MAXLEN],
		buf[2*MAXLEN];

	if ( !http )
		return;
	http_prolog( ip);

	cp = *cache_owner ? cache_owner : MAINTAINER;
	sprintf( owner, "<LINK REV=\"MADE\" HREF=\"%s\">\n", cp);
	if ( ((*ip->cachepath) == '\0') && ((*ip->name) == '\0') ) {
		/* It's the root dir and there's no ip->name */
		sprintf(buf, "<HTML>\n<HEAD>\n<TITLE>%s root menu</TITLE>%s\n",
				GN_HOSTNAME, option);
		strcat( buf, owner);
		strcat( buf, "</HEAD>\n<BODY>");
		send_text_line( buf);
	}
	else {
		cp = ( (*(ip->name)) ? ip->name : str );
		sprintf(buf,"<HTML>\n<HEAD>\n<TITLE>%s</TITLE>%s\n",
				cp, option);
		send_text_line( buf);
		sprintf(buf,"%s</HEAD>\n<BODY>\n<H2>%s</H2>", owner, cp);
		send_text_line( buf);
	}
}	


/*
 * sendexec( ip)  Open pipe from "ip->filepath" command
 * and send output.
 */

void
sendexec(  ip)
Item	*ip;
{
	FILE	*fp;
	register int	c;
	int	extype,
		send_pre = FALSE;

	char	comargs[PATHLEN],
		buf[MAXLEN];

	Cache_entry	entry;


	cgi_env( ip);
	strcpy(comargs, ip->args);

	/* Append anything in ip->extra  to the args */
	if ( *(ip->extra) ) {
		strcat( comargs, " ");
		strcat( comargs, ip->extra);
	}

	if ( (fp = safer_popen( ip->filepath, comargs, "r"))
				 == (FILE *) NULL ) {
		senderr2( "Can't exec", ip->filepath);
		exit( 2);
	}

	if ((extype = ip->gtype[4]) == '7')
		extype = ( ip->extra[0] == '\0' ? '0' : '1');
	switch (extype) {  /* the char after "exec" in gtype */
		case '1':
			cache_prolog( ip, "Menu", "");
			while ( read_cache( &entry, fp)) {
				if ( http)
					www_cache_line( &entry);
				else
					send_cache_line( &entry);
			}
			cache_epilog(http);
			break;
		case '5':
		case '9':
		case 's':
		case 'I':
			http_prolog( ip);
			while ( (c = fgetc( fp )) != EOF)
				fputc( c, stdout);
			pclose( fp);
			writelog( ip->relpath, "Sent exec binary",
				ip->selector);
			return;
		case '0':
		case '4':
		case ':':
		default:
			http_prolog( ip);
			if ( http == HTTP0_9 && 
				streq( ip->content_type, "text/plain") &&
					!streq( ip->suffix, "txt") )
				send_pre = TRUE;
	
			if ( send_pre)
				send_text_line( "<BODY>\n<PRE>");

			while ( fgets( buf, BUFSIZE, fp))
				send_text_line( buf);
			if ( send_pre )
				send_text_line( "</PRE>\n</BODY>\n</HTML>");
			else if ( !http)
				send_end();
			break;
	}

	pclose( fp);
	writelog( ip->relpath, "Sent exec", ip->selector);
}

void
http_prolog( ip)
Item	*ip;
{

	struct tm *gmt;
	time_t	clock;
	char	buf[BUFSIZE];

	if ( http & HTTP1_0) {
		if ( outheader.status[0])
			sprintf( buf, "%s %s\r", HTTPVERSION,
					outheader.status);
		else
			sprintf( buf, "%s 200 Request fulfilled\r",
					HTTPVERSION);
		send_text_line( buf);
		sprintf( buf, "Server: %s\r", VERSION);
		send_text_line( buf);
		sprintf( buf, "MIME-version: %s\r", "1.0");
		send_text_line( buf);

		time(&clock);
		gmt = gmtime(&clock);
		strcpy( buf, "Date: ");
		strftime( &buf[6], SMALLLEN, "%A, %d-%h-%y %T GMT\r", gmt);
		send_text_line( buf);

		if ( *ip->mod_date) {
			sprintf( buf, "Last-Modified: %s\r", ip->mod_date);
			send_text_line( buf);
		}
		if ( *ip->length) {
			sprintf( buf, "Content-length: %s\r", ip->length);
			send_text_line( buf);
		}
		sprintf( buf, "Content-type: %s\r", ip->content_type);
		send_text_line( buf);
		if ( *ip->encoding) {
			sprintf( buf, "Content-encoding: %s\r",
				ip->encoding);
			send_text_line( buf);
		}
		if ( outheader.list[0] ) {
			outheader.list[strlen(outheader.list)-1] = '\0';
			/* knock off final \n because send_text_line 
			   adds one */
			send_text_line( outheader.list);
		}
		send_text_line( "\r");
	}
}


