/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/csearch.c
    Version 2.06
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include "gn.h"
#include "reg.h"
#include "search.h"


static int	nomatch = TRUE;
static void	csearch();

static struct regprog	*regp;

void
cache_search( ip)
Item	*ip;
{

	int	depth = MAXDEPTH;

	char	querybuf[MIDLEN],
		buf[BUFSIZE];

	if ( http) {
		sprintf(buf, "Document Title Search");
	}

	cache_prolog( ip, buf, "<ISINDEX>");

	strcpy( querybuf, ip->extra);
	if ( http)
		www_unescape( querybuf, '+');

	if ( (regp = regcomp( strlower( querybuf))) == NULL ) {
		senderr2( "Search term regular expression error",
			ip->extra);
		exit( 2);
	}

	if ( http) {
		sprintf(buf, 
		"Here are the matches for the regular expression <B>`%s'</B>.",
				querybuf);
		send_text_line( buf);
		sprintf( buf, "%s <P>", REGRES2);
		send_text_line( buf);
	}
	csearch( ip->filepath, depth);
	if ( http && nomatch) {
		sprintf( buf, "<P>\n%s `%s'.\n<P>",
			REGMISS, querybuf);
		send_text_line( buf);
	}
	cache_epilog( http);
	writelog( ip->relpath, "Sent cache search", ip->selector);
}	

/*
 * csearch( cpath, depth)
 * Search cache file with path cpath for lines which match the compiled
 * regular expression pointed to by static pointer regp.  When found
 * call send_cache_line. If  a cachefile
 * line corresponds to a directory, make a new cpath for this directory
 * and recursively call csearch for that cachefile.  Note: with symbolic
 * links there could be an infinite loop of "subdirectories" -- to handle
 * this problem, go only depth levels deep in the recursion.  This will
 * still result in a virtual directory with many duplicates.
 */

static void
csearch( cpath, depth)
char	*cpath;
int	depth;
{
	FILE	*cfp;

	struct stat stat_buf;

	Cache_entry	entry,
			*cep;

	char	*cp,
		cbuf[MAXLEN],
		cnewpath[MAXLEN];

	if ( depth <= 0 )
		return;

	if ( (cfp = fopen( cpath, "r")) == (FILE *) NULL ) {
		senderr2( "Can't open cachefile [csearch]", cpath);
		exit( 2);
	}

	cep = &entry;
	while ( read_cache( cep, cfp)) {
		switch ( entry.entrytype) {
		case ILINE:
		case HTTPTEXT:
				continue;
		}
	/* Don't search menu comments (type 'i' or "http:"  */

		switch ( cep->attribute) {
		case INVISIBLE:
		case NOSEARCH:
				continue;
		case GOPHERONLY:
				if ( http)
					continue;
				else
					break;
		case HTTPONLY:
				if ( !http)
					continue;
				else
					break;
		}

	/* Don't search menu comments (type 'i' or "http:"  */

		strcpy( cbuf, entry.name);
		
		if ( regfind( regp, strlower( cbuf)) )
			if ( http) {
				nomatch = FALSE;
				www_cache_line( cep);
			}
			else
				send_cache_line( cep);

		if ( cep->type1 == '1' && cep->entrytype == LOCAL) {
		/* It's a directory and it's local */
		/* Build new menu and cache path names and recurse */

			if ( (cp = strchr( cep->path, '/')) == NULL)
				continue;

			strcpy( cnewpath, rootdir);
			strcat( cnewpath, cp);
        	        strcat( cnewpath, "/");

			if ( strncmp( cnewpath, cpath, strlen( cnewpath)) == 0)
	        	        continue;  /* Never go back up toward root */

			if ( (cep->path)[1] == 'm' ) {
	        	        cnewpath[strlen(cnewpath) - 1] = '.';
	        	        strcat( cnewpath, cfname);
			}
			else {
	        	        strcat( cnewpath, cfname);
			}
			if ( stat( cnewpath, &stat_buf) == 0 )
				csearch( cnewpath, depth - 1);
		}
	}
	fclose( cfp);
}





