/*-
 * Copyright (c) 2011-2012 libarchive Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * ATTENTION!
 *  This file is generated by build/utils/gen_archive_string_composition_h.sh
 *  from http://unicode.org/Public/6.0.0/ucd/UnicodeData.txt
 *
 *  See also http://unicode.org/report/tr15/
 */

#ifndef ARCHIVE_STRING_COMPOSITION_H_INCLUDED
#define ARCHIVE_STRING_COMPOSITION_H_INCLUDED

#ifndef __LIBARCHIVE_BUILD
#error This header is only to be used internally to libarchive.
#endif

struct unicode_composition_table {
	uint32_t cp1;
	uint32_t cp2;
	uint32_t nfc;
};

static const struct unicode_composition_table u_composition_table[] = {
	{ 0x0003C , 0x00338 , 0x0226E },
	{ 0x0003D , 0x00338 , 0x02260 },
	{ 0x0003E , 0x00338 , 0x0226F },
	{ 0x00041 , 0x00300 , 0x000C0 },
	{ 0x00041 , 0x00301 , 0x000C1 },
	{ 0x00041 , 0x00302 , 0x000C2 },
	{ 0x00041 , 0x00303 , 0x000C3 },
	{ 0x00041 , 0x00304 , 0x00100 },
	{ 0x00041 , 0x00306 , 0x00102 },
	{ 0x00041 , 0x00307 , 0x00226 },
	{ 0x00041 , 0x00308 , 0x000C4 },
	{ 0x00041 , 0x00309 , 0x01EA2 },
	{ 0x00041 , 0x0030A , 0x000C5 },
	{ 0x00041 , 0x0030C , 0x001CD },
	{ 0x00041 , 0x0030F , 0x00200 },
	{ 0x00041 , 0x00311 , 0x00202 },
	{ 0x00041 , 0x00323 , 0x01EA0 },
	{ 0x00041 , 0x00325 , 0x01E00 },
	{ 0x00041 , 0x00328 , 0x00104 },
	{ 0x00042 , 0x00307 , 0x01E02 },
	{ 0x00042 , 0x00323 , 0x01E04 },
	{ 0x00042 , 0x00331 , 0x01E06 },
	{ 0x00043 , 0x00301 , 0x00106 },
	{ 0x00043 , 0x00302 , 0x00108 },
	{ 0x00043 , 0x00307 , 0x0010A },
	{ 0x00043 , 0x0030C , 0x0010C },
	{ 0x00043 , 0x00327 , 0x000C7 },
	{ 0x00044 , 0x00307 , 0x01E0A },
	{ 0x00044 , 0x0030C , 0x0010E },
	{ 0x00044 , 0x00323 , 0x01E0C },
	{ 0x00044 , 0x00327 , 0x01E10 },
	{ 0x00044 , 0x0032D , 0x01E12 },
	{ 0x00044 , 0x00331 , 0x01E0E },
	{ 0x00045 , 0x00300 , 0x000C8 },
	{ 0x00045 , 0x00301 , 0x000C9 },
	{ 0x00045 , 0x00302 , 0x000CA },
	{ 0x00045 , 0x00303 , 0x01EBC },
	{ 0x00045 , 0x00304 , 0x00112 },
	{ 0x00045 , 0x00306 , 0x00114 },
	{ 0x00045 , 0x00307 , 0x00116 },
	{ 0x00045 , 0x00308 , 0x000CB },
	{ 0x00045 , 0x00309 , 0x01EBA },
	{ 0x00045 , 0x0030C , 0x0011A },
	{ 0x00045 , 0x0030F , 0x00204 },
	{ 0x00045 , 0x00311 , 0x00206 },
	{ 0x00045 , 0x00323 , 0x01EB8 },
	{ 0x00045 , 0x00327 , 0x00228 },
	{ 0x00045 , 0x00328 , 0x00118 },
	{ 0x00045 , 0x0032D , 0x01E18 },
	{ 0x00045 , 0x00330 , 0x01E1A },
	{ 0x00046 , 0x00307 , 0x01E1E },
	{ 0x00047 , 0x00301 , 0x001F4 },
	{ 0x00047 , 0x00302 , 0x0011C },
	{ 0x00047 , 0x00304 , 0x01E20 },
	{ 0x00047 , 0x00306 , 0x0011E },
	{ 0x00047 , 0x00307 , 0x00120 },
	{ 0x00047 , 0x0030C , 0x001E6 },
	{ 0x00047 , 0x00327 , 0x00122 },
	{ 0x00048 , 0x00302 , 0x00124 },
	{ 0x00048 , 0x00307 , 0x01E22 },
	{ 0x00048 , 0x00308 , 0x01E26 },
	{ 0x00048 , 0x0030C , 0x0021E },
	{ 0x00048 , 0x00323 , 0x01E24 },
	{ 0x00048 , 0x00327 , 0x01E28 },
	{ 0x00048 , 0x0032E , 0x01E2A },
	{ 0x00049 , 0x00300 , 0x000CC },
	{ 0x00049 , 0x00301 , 0x000CD },
	{ 0x00049 , 0x00302 , 0x000CE },
	{ 0x00049 , 0x00303 , 0x00128 },
	{ 0x00049 , 0x00304 , 0x0012A },
	{ 0x00049 , 0x00306 , 0x0012C },
	{ 0x00049 , 0x00307 , 0x00130 },
	{ 0x00049 , 0x00308 , 0x000CF },
	{ 0x00049 , 0x00309 , 0x01EC8 },
	{ 0x00049 , 0x0030C , 0x001CF },
	{ 0x00049 , 0x0030F , 0x00208 },
	{ 0x00049 , 0x00311 , 0x0020A },
	{ 0x00049 , 0x00323 , 0x01ECA },
	{ 0x00049 , 0x00328 , 0x0012E },
	{ 0x00049 , 0x00330 , 0x01E2C },
	{ 0x0004A , 0x00302 , 0x00134 },
	{ 0x0004B , 0x00301 , 0x01E30 },
	{ 0x0004B , 0x0030C , 0x001E8 },
	{ 0x0004B , 0x00323 , 0x01E32 },
	{ 0x0004B , 0x00327 , 0x00136 },
	{ 0x0004B , 0x00331 , 0x01E34 },
	{ 0x0004C , 0x00301 , 0x00139 },
	{ 0x0004C , 0x0030C , 0x0013D },
	{ 0x0004C , 0x00323 , 0x01E36 },
	{ 0x0004C , 0x00327 , 0x0013B },
	{ 0x0004C , 0x0032D , 0x01E3C },
	{ 0x0004C , 0x00331 , 0x01E3A },
	{ 0x0004D , 0x00301 , 0x01E3E },
	{ 0x0004D , 0x00307 , 0x01E40 },
	{ 0x0004D , 0x00323 , 0x01E42 },
	{ 0x0004E , 0x00300 , 0x001F8 },
	{ 0x0004E , 0x00301 , 0x00143 },
	{ 0x0004E , 0x00303 , 0x000D1 },
	{ 0x0004E , 0x00307 , 0x01E44 },
	{ 0x0004E , 0x0030C , 0x00147 },
	{ 0x0004E , 0x00323 , 0x01E46 },
	{ 0x0004E , 0x00327 , 0x00145 },
	{ 0x0004E , 0x0032D , 0x01E4A },
	{ 0x0004E , 0x00331 , 0x01E48 },
	{ 0x0004F , 0x00300 , 0x000D2 },
	{ 0x0004F , 0x00301 , 0x000D3 },
	{ 0x0004F , 0x00302 , 0x000D4 },
	{ 0x0004F , 0x00303 , 0x000D5 },
	{ 0x0004F , 0x00304 , 0x0014C },
	{ 0x0004F , 0x00306 , 0x0014E },
	{ 0x0004F , 0x00307 , 0x0022E },
	{ 0x0004F , 0x00308 , 0x000D6 },
	{ 0x0004F , 0x00309 , 0x01ECE },
	{ 0x0004F , 0x0030B , 0x00150 },
	{ 0x0004F , 0x0030C , 0x001D1 },
	{ 0x0004F , 0x0030F , 0x0020C },
	{ 0x0004F , 0x00311 , 0x0020E },
	{ 0x0004F , 0x0031B , 0x001A0 },
	{ 0x0004F , 0x00323 , 0x01ECC },
	{ 0x0004F , 0x00328 , 0x001EA },
	{ 0x00050 , 0x00301 , 0x01E54 },
	{ 0x00050 , 0x00307 , 0x01E56 },
	{ 0x00052 , 0x00301 , 0x00154 },
	{ 0x00052 , 0x00307 , 0x01E58 },
	{ 0x00052 , 0x0030C , 0x00158 },
	{ 0x00052 , 0x0030F , 0x00210 },
	{ 0x00052 , 0x00311 , 0x00212 },
	{ 0x00052 , 0x00323 , 0x01E5A },
	{ 0x00052 , 0x00327 , 0x00156 },
	{ 0x00052 , 0x00331 , 0x01E5E },
	{ 0x00053 , 0x00301 , 0x0015A },
	{ 0x00053 , 0x00302 , 0x0015C },
	{ 0x00053 , 0x00307 , 0x01E60 },
	{ 0x00053 , 0x0030C , 0x00160 },
	{ 0x00053 , 0x00323 , 0x01E62 },
	{ 0x00053 , 0x00326 , 0x00218 },
	{ 0x00053 , 0x00327 , 0x0015E },
	{ 0x00054 , 0x00307 , 0x01E6A },
	{ 0x00054 , 0x0030C , 0x00164 },
	{ 0x00054 , 0x00323 , 0x01E6C },
	{ 0x00054 , 0x00326 , 0x0021A },
	{ 0x00054 , 0x00327 , 0x00162 },
	{ 0x00054 , 0x0032D , 0x01E70 },
	{ 0x00054 , 0x00331 , 0x01E6E },
	{ 0x00055 , 0x00300 , 0x000D9 },
	{ 0x00055 , 0x00301 , 0x000DA },
	{ 0x00055 , 0x00302 , 0x000DB },
	{ 0x00055 , 0x00303 , 0x00168 },
	{ 0x00055 , 0x00304 , 0x0016A },
	{ 0x00055 , 0x00306 , 0x0016C },
	{ 0x00055 , 0x00308 , 0x000DC },
	{ 0x00055 , 0x00309 , 0x01EE6 },
	{ 0x00055 , 0x0030A , 0x0016E },
	{ 0x00055 , 0x0030B , 0x00170 },
	{ 0x00055 , 0x0030C , 0x001D3 },
	{ 0x00055 , 0x0030F , 0x00214 },
	{ 0x00055 , 0x00311 , 0x00216 },
	{ 0x00055 , 0x0031B , 0x001AF },
	{ 0x00055 , 0x00323 , 0x01EE4 },
	{ 0x00055 , 0x00324 , 0x01E72 },
	{ 0x00055 , 0x00328 , 0x00172 },
	{ 0x00055 , 0x0032D , 0x01E76 },
	{ 0x00055 , 0x00330 , 0x01E74 },
	{ 0x00056 , 0x00303 , 0x01E7C },
	{ 0x00056 , 0x00323 , 0x01E7E },
	{ 0x00057 , 0x00300 , 0x01E80 },
	{ 0x00057 , 0x00301 , 0x01E82 },
	{ 0x00057 , 0x00302 , 0x00174 },
	{ 0x00057 , 0x00307 , 0x01E86 },
	{ 0x00057 , 0x00308 , 0x01E84 },
	{ 0x00057 , 0x00323 , 0x01E88 },
	{ 0x00058 , 0x00307 , 0x01E8A },
	{ 0x00058 , 0x00308 , 0x01E8C },
	{ 0x00059 , 0x00300 , 0x01EF2 },
	{ 0x00059 , 0x00301 , 0x000DD },
	{ 0x00059 , 0x00302 , 0x00176 },
	{ 0x00059 , 0x00303 , 0x01EF8 },
	{ 0x00059 , 0x00304 , 0x00232 },
	{ 0x00059 , 0x00307 , 0x01E8E },
	{ 0x00059 , 0x00308 , 0x00178 },
	{ 0x00059 , 0x00309 , 0x01EF6 },
	{ 0x00059 , 0x00323 , 0x01EF4 },
	{ 0x0005A , 0x00301 , 0x00179 },
	{ 0x0005A , 0x00302 , 0x01E90 },
	{ 0x0005A , 0x00307 , 0x0017B },
	{ 0x0005A , 0x0030C , 0x0017D },
	{ 0x0005A , 0x00323 , 0x01E92 },
	{ 0x0005A , 0x00331 , 0x01E94 },
	{ 0x00061 , 0x00300 , 0x000E0 },
	{ 0x00061 , 0x00301 , 0x000E1 },
	{ 0x00061 , 0x00302 , 0x000E2 },
	{ 0x00061 , 0x00303 , 0x000E3 },
	{ 0x00061 , 0x00304 , 0x00101 },
	{ 0x00061 , 0x00306 , 0x00103 },
	{ 0x00061 , 0x00307 , 0x00227 },
	{ 0x00061 , 0x00308 , 0x000E4 },
	{ 0x00061 , 0x00309 , 0x01EA3 },
	{ 0x00061 , 0x0030A , 0x000E5 },
	{ 0x00061 , 0x0030C , 0x001CE },
	{ 0x00061 , 0x0030F , 0x00201 },
	{ 0x00061 , 0x00311 , 0x00203 },
	{ 0x00061 , 0x00323 , 0x01EA1 },
	{ 0x00061 , 0x00325 , 0x01E01 },
	{ 0x00061 , 0x00328 , 0x00105 },
	{ 0x00062 , 0x00307 , 0x01E03 },
	{ 0x00062 , 0x00323 , 0x01E05 },
	{ 0x00062 , 0x00331 , 0x01E07 },
	{ 0x00063 , 0x00301 , 0x00107 },
	{ 0x00063 , 0x00302 , 0x00109 },
	{ 0x00063 , 0x00307 , 0x0010B },
	{ 0x00063 , 0x0030C , 0x0010D },
	{ 0x00063 , 0x00327 , 0x000E7 },
	{ 0x00064 , 0x00307 , 0x01E0B },
	{ 0x00064 , 0x0030C , 0x0010F },
	{ 0x00064 , 0x00323 , 0x01E0D },
	{ 0x00064 , 0x00327 , 0x01E11 },
	{ 0x00064 , 0x0032D , 0x01E13 },
	{ 0x00064 , 0x00331 , 0x01E0F },
	{ 0x00065 , 0x00300 , 0x000E8 },
	{ 0x00065 , 0x00301 , 0x000E9 },
	{ 0x00065 , 0x00302 , 0x000EA },
	{ 0x00065 , 0x00303 , 0x01EBD },
	{ 0x00065 , 0x00304 , 0x00113 },
	{ 0x00065 , 0x00306 , 0x00115 },
	{ 0x00065 , 0x00307 , 0x00117 },
	{ 0x00065 , 0x00308 , 0x000EB },
	{ 0x00065 , 0x00309 , 0x01EBB },
	{ 0x00065 , 0x0030C , 0x0011B },
	{ 0x00065 , 0x0030F , 0x00205 },
	{ 0x00065 , 0x00311 , 0x00207 },
	{ 0x00065 , 0x00323 , 0x01EB9 },
	{ 0x00065 , 0x00327 , 0x00229 },
	{ 0x00065 , 0x00328 , 0x00119 },
	{ 0x00065 , 0x0032D , 0x01E19 },
	{ 0x00065 , 0x00330 , 0x01E1B },
	{ 0x00066 , 0x00307 , 0x01E1F },
	{ 0x00067 , 0x00301 , 0x001F5 },
	{ 0x00067 , 0x00302 , 0x0011D },
	{ 0x00067 , 0x00304 , 0x01E21 },
	{ 0x00067 , 0x00306 , 0x0011F },
	{ 0x00067 , 0x00307 , 0x00121 },
	{ 0x00067 , 0x0030C , 0x001E7 },
	{ 0x00067 , 0x00327 , 0x00123 },
	{ 0x00068 , 0x00302 , 0x00125 },
	{ 0x00068 , 0x00307 , 0x01E23 },
	{ 0x00068 , 0x00308 , 0x01E27 },
	{ 0x00068 , 0x0030C , 0x0021F },
	{ 0x00068 , 0x00323 , 0x01E25 },
	{ 0x00068 , 0x00327 , 0x01E29 },
	{ 0x00068 , 0x0032E , 0x01E2B },
	{ 0x00068 , 0x00331 , 0x01E96 },
	{ 0x00069 , 0x00300 , 0x000EC },
	{ 0x00069 , 0x00301 , 0x000ED },
	{ 0x00069 , 0x00302 , 0x000EE },
	{ 0x00069 , 0x00303 , 0x00129 },
	{ 0x00069 , 0x00304 , 0x0012B },
	{ 0x00069 , 0x00306 , 0x0012D },
	{ 0x00069 , 0x00308 , 0x000EF },
	{ 0x00069 , 0x00309 , 0x01EC9 },
	{ 0x00069 , 0x0030C , 0x001D0 },
	{ 0x00069 , 0x0030F , 0x00209 },
	{ 0x00069 , 0x00311 , 0x0020B },
	{ 0x00069 , 0x00323 , 0x01ECB },
	{ 0x00069 , 0x00328 , 0x0012F },
	{ 0x00069 , 0x00330 , 0x01E2D },
	{ 0x0006A , 0x00302 , 0x00135 },
	{ 0x0006A , 0x0030C , 0x001F0 },
	{ 0x0006B , 0x00301 , 0x01E31 },
	{ 0x0006B , 0x0030C , 0x001E9 },
	{ 0x0006B , 0x00323 , 0x01E33 },
	{ 0x0006B , 0x00327 , 0x00137 },
	{ 0x0006B , 0x00331 , 0x01E35 },
	{ 0x0006C , 0x00301 , 0x0013A },
	{ 0x0006C , 0x0030C , 0x0013E },
	{ 0x0006C , 0x00323 , 0x01E37 },
	{ 0x0006C , 0x00327 , 0x0013C },
	{ 0x0006C , 0x0032D , 0x01E3D },
	{ 0x0006C , 0x00331 , 0x01E3B },
	{ 0x0006D , 0x00301 , 0x01E3F },
	{ 0x0006D , 0x00307 , 0x01E41 },
	{ 0x0006D , 0x00323 , 0x01E43 },
	{ 0x0006E , 0x00300 , 0x001F9 },
	{ 0x0006E , 0x00301 , 0x00144 },
	{ 0x0006E , 0x00303 , 0x000F1 },
	{ 0x0006E , 0x00307 , 0x01E45 },
	{ 0x0006E , 0x0030C , 0x00148 },
	{ 0x0006E , 0x00323 , 0x01E47 },
	{ 0x0006E , 0x00327 , 0x00146 },
	{ 0x0006E , 0x0032D , 0x01E4B },
	{ 0x0006E , 0x00331 , 0x01E49 },
	{ 0x0006F , 0x00300 , 0x000F2 },
	{ 0x0006F , 0x00301 , 0x000F3 },
	{ 0x0006F , 0x00302 , 0x000F4 },
	{ 0x0006F , 0x00303 , 0x000F5 },
	{ 0x0006F , 0x00304 , 0x0014D },
	{ 0x0006F , 0x00306 , 0x0014F },
	{ 0x0006F , 0x00307 , 0x0022F },
	{ 0x0006F , 0x00308 , 0x000F6 },
	{ 0x0006F , 0x00309 , 0x01ECF },
	{ 0x0006F , 0x0030B , 0x00151 },
	{ 0x0006F , 0x0030C , 0x001D2 },
	{ 0x0006F , 0x0030F , 0x0020D },
	{ 0x0006F , 0x00311 , 0x0020F },
	{ 0x0006F , 0x0031B , 0x001A1 },
	{ 0x0006F , 0x00323 , 0x01ECD },
	{ 0x0006F , 0x00328 , 0x001EB },
	{ 0x00070 , 0x00301 , 0x01E55 },
	{ 0x00070 , 0x00307 , 0x01E57 },
	{ 0x00072 , 0x00301 , 0x00155 },
	{ 0x00072 , 0x00307 , 0x01E59 },
	{ 0x00072 , 0x0030C , 0x00159 },
	{ 0x00072 , 0x0030F , 0x00211 },
	{ 0x00072 , 0x00311 , 0x00213 },
	{ 0x00072 , 0x00323 , 0x01E5B },
	{ 0x00072 , 0x00327 , 0x00157 },
	{ 0x00072 , 0x00331 , 0x01E5F },
	{ 0x00073 , 0x00301 , 0x0015B },
	{ 0x00073 , 0x00302 , 0x0015D },
	{ 0x00073 , 0x00307 , 0x01E61 },
	{ 0x00073 , 0x0030C , 0x00161 },
	{ 0x00073 , 0x00323 , 0x01E63 },
	{ 0x00073 , 0x00326 , 0x00219 },
	{ 0x00073 , 0x00327 , 0x0015F },
	{ 0x00074 , 0x00307 , 0x01E6B },
	{ 0x00074 , 0x00308 , 0x01E97 },
	{ 0x00074 , 0x0030C , 0x00165 },
	{ 0x00074 , 0x00323 , 0x01E6D },
	{ 0x00074 , 0x00326 , 0x0021B },
	{ 0x00074 , 0x00327 , 0x00163 },
	{ 0x00074 , 0x0032D , 0x01E71 },
	{ 0x00074 , 0x00331 , 0x01E6F },
	{ 0x00075 , 0x00300 , 0x000F9 },
	{ 0x00075 , 0x00301 , 0x000FA },
	{ 0x00075 , 0x00302 , 0x000FB },
	{ 0x00075 , 0x00303 , 0x00169 },
	{ 0x00075 , 0x00304 , 0x0016B },
	{ 0x00075 , 0x00306 , 0x0016D },
	{ 0x00075 , 0x00308 , 0x000FC },
	{ 0x00075 , 0x00309 , 0x01EE7 },
	{ 0x00075 , 0x0030A , 0x0016F },
	{ 0x00075 , 0x0030B , 0x00171 },
	{ 0x00075 , 0x0030C , 0x001D4 },
	{ 0x00075 , 0x0030F , 0x00215 },
	{ 0x00075 , 0x00311 , 0x00217 },
	{ 0x00075 , 0x0031B , 0x001B0 },
	{ 0x00075 , 0x00323 , 0x01EE5 },
	{ 0x00075 , 0x00324 , 0x01E73 },
	{ 0x00075 , 0x00328 , 0x00173 },
	{ 0x00075 , 0x0032D , 0x01E77 },
	{ 0x00075 , 0x00330 , 0x01E75 },
	{ 0x00076 , 0x00303 , 0x01E7D },
	{ 0x00076 , 0x00323 , 0x01E7F },
	{ 0x00077 , 0x00300 , 0x01E81 },
	{ 0x00077 , 0x00301 , 0x01E83 },
	{ 0x00077 , 0x00302 , 0x00175 },
	{ 0x00077 , 0x00307 , 0x01E87 },
	{ 0x00077 , 0x00308 , 0x01E85 },
	{ 0x00077 , 0x0030A , 0x01E98 },
	{ 0x00077 , 0x00323 , 0x01E89 },
	{ 0x00078 , 0x00307 , 0x01E8B },
	{ 0x00078 , 0x00308 , 0x01E8D },
	{ 0x00079 , 0x00300 , 0x01EF3 },
	{ 0x00079 , 0x00301 , 0x000FD },
	{ 0x00079 , 0x00302 , 0x00177 },
	{ 0x00079 , 0x00303 , 0x01EF9 },
	{ 0x00079 , 0x00304 , 0x00233 },
	{ 0x00079 , 0x00307 , 0x01E8F },
	{ 0x00079 , 0x00308 , 0x000FF },
	{ 0x00079 , 0x00309 , 0x01EF7 },
	{ 0x00079 , 0x0030A , 0x01E99 },
	{ 0x00079 , 0x00323 , 0x01EF5 },
	{ 0x0007A , 0x00301 , 0x0017A },
	{ 0x0007A , 0x00302 , 0x01E91 },
	{ 0x0007A , 0x00307 , 0x0017C },
	{ 0x0007A , 0x0030C , 0x0017E },
	{ 0x0007A , 0x00323 , 0x01E93 },
	{ 0x0007A , 0x00331 , 0x01E95 },
	{ 0x000A8 , 0x00300 , 0x01FED },
	{ 0x000A8 , 0x00301 , 0x00385 },
	{ 0x000A8 , 0x00342 , 0x01FC1 },
	{ 0x000C2 , 0x00300 , 0x01EA6 },
	{ 0x000C2 , 0x00301 , 0x01EA4 },
	{ 0x000C2 , 0x00303 , 0x01EAA },
	{ 0x000C2 , 0x00309 , 0x01EA8 },
	{ 0x000C4 , 0x00304 , 0x001DE },
	{ 0x000C5 , 0x00301 , 0x001FA },
	{ 0x000C6 , 0x00301 , 0x001FC },
	{ 0x000C6 , 0x00304 , 0x001E2 },
	{ 0x000C7 , 0x00301 , 0x01E08 },
	{ 0x000CA , 0x00300 , 0x01EC0 },
	{ 0x000CA , 0x00301 , 0x01EBE },
	{ 0x000CA , 0x00303 , 0x01EC4 },
	{ 0x000CA , 0x00309 , 0x01EC2 },
	{ 0x000CF , 0x00301 , 0x01E2E },
	{ 0x000D4 , 0x00300 , 0x01ED2 },
	{ 0x000D4 , 0x00301 , 0x01ED0 },
	{ 0x000D4 , 0x00303 , 0x01ED6 },
	{ 0x000D4 , 0x00309 , 0x01ED4 },
	{ 0x000D5 , 0x00301 , 0x01E4C },
	{ 0x000D5 , 0x00304 , 0x0022C },
	{ 0x000D5 , 0x00308 , 0x01E4E },
	{ 0x000D6 , 0x00304 , 0x0022A },
	{ 0x000D8 , 0x00301 , 0x001FE },
	{ 0x000DC , 0x00300 , 0x001DB },
	{ 0x000DC , 0x00301 , 0x001D7 },
	{ 0x000DC , 0x00304 , 0x001D5 },
	{ 0x000DC , 0x0030C , 0x001D9 },
	{ 0x000E2 , 0x00300 , 0x01EA7 },
	{ 0x000E2 , 0x00301 , 0x01EA5 },
	{ 0x000E2 , 0x00303 , 0x01EAB },
	{ 0x000E2 , 0x00309 , 0x01EA9 },
	{ 0x000E4 , 0x00304 , 0x001DF },
	{ 0x000E5 , 0x00301 , 0x001FB },
	{ 0x000E6 , 0x00301 , 0x001FD },
	{ 0x000E6 , 0x00304 , 0x001E3 },
	{ 0x000E7 , 0x00301 , 0x01E09 },
	{ 0x000EA , 0x00300 , 0x01EC1 },
	{ 0x000EA , 0x00301 , 0x01EBF },
	{ 0x000EA , 0x00303 , 0x01EC5 },
	{ 0x000EA , 0x00309 , 0x01EC3 },
	{ 0x000EF , 0x00301 , 0x01E2F },
	{ 0x000F4 , 0x00300 , 0x01ED3 },
	{ 0x000F4 , 0x00301 , 0x01ED1 },
	{ 0x000F4 , 0x00303 , 0x01ED7 },
	{ 0x000F4 , 0x00309 , 0x01ED5 },
	{ 0x000F5 , 0x00301 , 0x01E4D },
	{ 0x000F5 , 0x00304 , 0x0022D },
	{ 0x000F5 , 0x00308 , 0x01E4F },
	{ 0x000F6 , 0x00304 , 0x0022B },
	{ 0x000F8 , 0x00301 , 0x001FF },
	{ 0x000FC , 0x00300 , 0x001DC },
	{ 0x000FC , 0x00301 , 0x001D8 },
	{ 0x000FC , 0x00304 , 0x001D6 },
	{ 0x000FC , 0x0030C , 0x001DA },
	{ 0x00102 , 0x00300 , 0x01EB0 },
	{ 0x00102 , 0x00301 , 0x01EAE },
	{ 0x00102 , 0x00303 , 0x01EB4 },
	{ 0x00102 , 0x00309 , 0x01EB2 },
	{ 0x00103 , 0x00300 , 0x01EB1 },
	{ 0x00103 , 0x00301 , 0x01EAF },
	{ 0x00103 , 0x00303 , 0x01EB5 },
	{ 0x00103 , 0x00309 , 0x01EB3 },
	{ 0x00112 , 0x00300 , 0x01E14 },
	{ 0x00112 , 0x00301 , 0x01E16 },
	{ 0x00113 , 0x00300 , 0x01E15 },
	{ 0x00113 , 0x00301 , 0x01E17 },
	{ 0x0014C , 0x00300 , 0x01E50 },
	{ 0x0014C , 0x00301 , 0x01E52 },
	{ 0x0014D , 0x00300 , 0x01E51 },
	{ 0x0014D , 0x00301 , 0x01E53 },
	{ 0x0015A , 0x00307 , 0x01E64 },
	{ 0x0015B , 0x00307 , 0x01E65 },
	{ 0x00160 , 0x00307 , 0x01E66 },
	{ 0x00161 , 0x00307 , 0x01E67 },
	{ 0x00168 , 0x00301 , 0x01E78 },
	{ 0x00169 , 0x00301 , 0x01E79 },
	{ 0x0016A , 0x00308 , 0x01E7A },
	{ 0x0016B , 0x00308 , 0x01E7B },
	{ 0x0017F , 0x00307 , 0x01E9B },
	{ 0x001A0 , 0x00300 , 0x01EDC },
	{ 0x001A0 , 0x00301 , 0x01EDA },
	{ 0x001A0 , 0x00303 , 0x01EE0 },
	{ 0x001A0 , 0x00309 , 0x01EDE },
	{ 0x001A0 , 0x00323 , 0x01EE2 },
	{ 0x001A1 , 0x00300 , 0x01EDD },
	{ 0x001A1 , 0x00301 , 0x01EDB },
	{ 0x001A1 , 0x00303 , 0x01EE1 },
	{ 0x001A1 , 0x00309 , 0x01EDF },
	{ 0x001A1 , 0x00323 , 0x01EE3 },
	{ 0x001AF , 0x00300 , 0x01EEA },
	{ 0x001AF , 0x00301 , 0x01EE8 },
	{ 0x001AF , 0x00303 , 0x01EEE },
	{ 0x001AF , 0x00309 , 0x01EEC },
	{ 0x001AF , 0x00323 , 0x01EF0 },
	{ 0x001B0 , 0x00300 , 0x01EEB },
	{ 0x001B0 , 0x00301 , 0x01EE9 },
	{ 0x001B0 , 0x00303 , 0x01EEF },
	{ 0x001B0 , 0x00309 , 0x01EED },
	{ 0x001B0 , 0x00323 , 0x01EF1 },
	{ 0x001B7 , 0x0030C , 0x001EE },
	{ 0x001EA , 0x00304 , 0x001EC },
	{ 0x001EB , 0x00304 , 0x001ED },
	{ 0x00226 , 0x00304 , 0x001E0 },
	{ 0x00227 , 0x00304 , 0x001E1 },
	{ 0x00228 , 0x00306 , 0x01E1C },
	{ 0x00229 , 0x00306 , 0x01E1D },
	{ 0x0022E , 0x00304 , 0x00230 },
	{ 0x0022F , 0x00304 , 0x00231 },
	{ 0x00292 , 0x0030C , 0x001EF },
	{ 0x00391 , 0x00300 , 0x01FBA },
	{ 0x00391 , 0x00301 , 0x00386 },
	{ 0x00391 , 0x00304 , 0x01FB9 },
	{ 0x00391 , 0x00306 , 0x01FB8 },
	{ 0x00391 , 0x00313 , 0x01F08 },
	{ 0x00391 , 0x00314 , 0x01F09 },
	{ 0x00391 , 0x00345 , 0x01FBC },
	{ 0x00395 , 0x00300 , 0x01FC8 },
	{ 0x00395 , 0x00301 , 0x00388 },
	{ 0x00395 , 0x00313 , 0x01F18 },
	{ 0x00395 , 0x00314 , 0x01F19 },
	{ 0x00397 , 0x00300 , 0x01FCA },
	{ 0x00397 , 0x00301 , 0x00389 },
	{ 0x00397 , 0x00313 , 0x01F28 },
	{ 0x00397 , 0x00314 , 0x01F29 },
	{ 0x00397 , 0x00345 , 0x01FCC },
	{ 0x00399 , 0x00300 , 0x01FDA },
	{ 0x00399 , 0x00301 , 0x0038A },
	{ 0x00399 , 0x00304 , 0x01FD9 },
	{ 0x00399 , 0x00306 , 0x01FD8 },
	{ 0x00399 , 0x00308 , 0x003AA },
	{ 0x00399 , 0x00313 , 0x01F38 },
	{ 0x00399 , 0x00314 , 0x01F39 },
	{ 0x0039F , 0x00300 , 0x01FF8 },
	{ 0x0039F , 0x00301 , 0x0038C },
	{ 0x0039F , 0x00313 , 0x01F48 },
	{ 0x0039F , 0x00314 , 0x01F49 },
	{ 0x003A1 , 0x00314 , 0x01FEC },
	{ 0x003A5 , 0x00300 , 0x01FEA },
	{ 0x003A5 , 0x00301 , 0x0038E },
	{ 0x003A5 , 0x00304 , 0x01FE9 },
	{ 0x003A5 , 0x00306 , 0x01FE8 },
	{ 0x003A5 , 0x00308 , 0x003AB },
	{ 0x003A5 , 0x00314 , 0x01F59 },
	{ 0x003A9 , 0x00300 , 0x01FFA },
	{ 0x003A9 , 0x00301 , 0x0038F },
	{ 0x003A9 , 0x00313 , 0x01F68 },
	{ 0x003A9 , 0x00314 , 0x01F69 },
	{ 0x003A9 , 0x00345 , 0x01FFC },
	{ 0x003AC , 0x00345 , 0x01FB4 },
	{ 0x003AE , 0x00345 , 0x01FC4 },
	{ 0x003B1 , 0x00300 , 0x01F70 },
	{ 0x003B1 , 0x00301 , 0x003AC },
	{ 0x003B1 , 0x00304 , 0x01FB1 },
	{ 0x003B1 , 0x00306 , 0x01FB0 },
	{ 0x003B1 , 0x00313 , 0x01F00 },
	{ 0x003B1 , 0x00314 , 0x01F01 },
	{ 0x003B1 , 0x00342 , 0x01FB6 },
	{ 0x003B1 , 0x00345 , 0x01FB3 },
	{ 0x003B5 , 0x00300 , 0x01F72 },
	{ 0x003B5 , 0x00301 , 0x003AD },
	{ 0x003B5 , 0x00313 , 0x01F10 },
	{ 0x003B5 , 0x00314 , 0x01F11 },
	{ 0x003B7 , 0x00300 , 0x01F74 },
	{ 0x003B7 , 0x00301 , 0x003AE },
	{ 0x003B7 , 0x00313 , 0x01F20 },
	{ 0x003B7 , 0x00314 , 0x01F21 },
	{ 0x003B7 , 0x00342 , 0x01FC6 },
	{ 0x003B7 , 0x00345 , 0x01FC3 },
	{ 0x003B9 , 0x00300 , 0x01F76 },
	{ 0x003B9 , 0x00301 , 0x003AF },
	{ 0x003B9 , 0x00304 , 0x01FD1 },
	{ 0x003B9 , 0x00306 , 0x01FD0 },
	{ 0x003B9 , 0x00308 , 0x003CA },
	{ 0x003B9 , 0x00313 , 0x01F30 },
	{ 0x003B9 , 0x00314 , 0x01F31 },
	{ 0x003B9 , 0x00342 , 0x01FD6 },
	{ 0x003BF , 0x00300 , 0x01F78 },
	{ 0x003BF , 0x00301 , 0x003CC },
	{ 0x003BF , 0x00313 , 0x01F40 },
	{ 0x003BF , 0x00314 , 0x01F41 },
	{ 0x003C1 , 0x00313 , 0x01FE4 },
	{ 0x003C1 , 0x00314 , 0x01FE5 },
	{ 0x003C5 , 0x00300 , 0x01F7A },
	{ 0x003C5 , 0x00301 , 0x003CD },
	{ 0x003C5 , 0x00304 , 0x01FE1 },
	{ 0x003C5 , 0x00306 , 0x01FE0 },
	{ 0x003C5 , 0x00308 , 0x003CB },
	{ 0x003C5 , 0x00313 , 0x01F50 },
	{ 0x003C5 , 0x00314 , 0x01F51 },
	{ 0x003C5 , 0x00342 , 0x01FE6 },
	{ 0x003C9 , 0x00300 , 0x01F7C },
	{ 0x003C9 , 0x00301 , 0x003CE },
	{ 0x003C9 , 0x00313 , 0x01F60 },
	{ 0x003C9 , 0x00314 , 0x01F61 },
	{ 0x003C9 , 0x00342 , 0x01FF6 },
	{ 0x003C9 , 0x00345 , 0x01FF3 },
	{ 0x003CA , 0x00300 , 0x01FD2 },
	{ 0x003CA , 0x00301 , 0x00390 },
	{ 0x003CA , 0x00342 , 0x01FD7 },
	{ 0x003CB , 0x00300 , 0x01FE2 },
	{ 0x003CB , 0x00301 , 0x003B0 },
	{ 0x003CB , 0x00342 , 0x01FE7 },
	{ 0x003CE , 0x00345 , 0x01FF4 },
	{ 0x003D2 , 0x00301 , 0x003D3 },
	{ 0x003D2 , 0x00308 , 0x003D4 },
	{ 0x00406 , 0x00308 , 0x00407 },
	{ 0x00410 , 0x00306 , 0x004D0 },
	{ 0x00410 , 0x00308 , 0x004D2 },
	{ 0x00413 , 0x00301 , 0x00403 },
	{ 0x00415 , 0x00300 , 0x00400 },
	{ 0x00415 , 0x00306 , 0x004D6 },
	{ 0x00415 , 0x00308 , 0x00401 },
	{ 0x00416 , 0x00306 , 0x004C1 },
	{ 0x00416 , 0x00308 , 0x004DC },
	{ 0x00417 , 0x00308 , 0x004DE },
	{ 0x00418 , 0x00300 , 0x0040D },
	{ 0x00418 , 0x00304 , 0x004E2 },
	{ 0x00418 , 0x00306 , 0x00419 },
	{ 0x00418 , 0x00308 , 0x004E4 },
	{ 0x0041A , 0x00301 , 0x0040C },
	{ 0x0041E , 0x00308 , 0x004E6 },
	{ 0x00423 , 0x00304 , 0x004EE },
	{ 0x00423 , 0x00306 , 0x0040E },
	{ 0x00423 , 0x00308 , 0x004F0 },
	{ 0x00423 , 0x0030B , 0x004F2 },
	{ 0x00427 , 0x00308 , 0x004F4 },
	{ 0x0042B , 0x00308 , 0x004F8 },
	{ 0x0042D , 0x00308 , 0x004EC },
	{ 0x00430 , 0x00306 , 0x004D1 },
	{ 0x00430 , 0x00308 , 0x004D3 },
	{ 0x00433 , 0x00301 , 0x00453 },
	{ 0x00435 , 0x00300 , 0x00450 },
	{ 0x00435 , 0x00306 , 0x004D7 },
	{ 0x00435 , 0x00308 , 0x00451 },
	{ 0x00436 , 0x00306 , 0x004C2 },
	{ 0x00436 , 0x00308 , 0x004DD },
	{ 0x00437 , 0x00308 , 0x004DF },
	{ 0x00438 , 0x00300 , 0x0045D },
	{ 0x00438 , 0x00304 , 0x004E3 },
	{ 0x00438 , 0x00306 , 0x00439 },
	{ 0x00438 , 0x00308 , 0x004E5 },
	{ 0x0043A , 0x00301 , 0x0045C },
	{ 0x0043E , 0x00308 , 0x004E7 },
	{ 0x00443 , 0x00304 , 0x004EF },
	{ 0x00443 , 0x00306 , 0x0045E },
	{ 0x00443 , 0x00308 , 0x004F1 },
	{ 0x00443 , 0x0030B , 0x004F3 },
	{ 0x00447 , 0x00308 , 0x004F5 },
	{ 0x0044B , 0x00308 , 0x004F9 },
	{ 0x0044D , 0x00308 , 0x004ED },
	{ 0x00456 , 0x00308 , 0x00457 },
	{ 0x00474 , 0x0030F , 0x00476 },
	{ 0x00475 , 0x0030F , 0x00477 },
	{ 0x004D8 , 0x00308 , 0x004DA },
	{ 0x004D9 , 0x00308 , 0x004DB },
	{ 0x004E8 , 0x00308 , 0x004EA },
	{ 0x004E9 , 0x00308 , 0x004EB },
	{ 0x00627 , 0x00653 , 0x00622 },
	{ 0x00627 , 0x00654 , 0x00623 },
	{ 0x00627 , 0x00655 , 0x00625 },
	{ 0x00648 , 0x00654 , 0x00624 },
	{ 0x0064A , 0x00654 , 0x00626 },
	{ 0x006C1 , 0x00654 , 0x006C2 },
	{ 0x006D2 , 0x00654 , 0x006D3 },
	{ 0x006D5 , 0x00654 , 0x006C0 },
	{ 0x00928 , 0x0093C , 0x00929 },
	{ 0x00930 , 0x0093C , 0x00931 },
	{ 0x00933 , 0x0093C , 0x00934 },
	{ 0x009C7 , 0x009BE , 0x009CB },
	{ 0x009C7 , 0x009D7 , 0x009CC },
	{ 0x00B47 , 0x00B3E , 0x00B4B },
	{ 0x00B47 , 0x00B56 , 0x00B48 },
	{ 0x00B47 , 0x00B57 , 0x00B4C },
	{ 0x00B92 , 0x00BD7 , 0x00B94 },
	{ 0x00BC6 , 0x00BBE , 0x00BCA },
	{ 0x00BC6 , 0x00BD7 , 0x00BCC },
	{ 0x00BC7 , 0x00BBE , 0x00BCB },
	{ 0x00C46 , 0x00C56 , 0x00C48 },
	{ 0x00CBF , 0x00CD5 , 0x00CC0 },
	{ 0x00CC6 , 0x00CC2 , 0x00CCA },
	{ 0x00CC6 , 0x00CD5 , 0x00CC7 },
	{ 0x00CC6 , 0x00CD6 , 0x00CC8 },
	{ 0x00CCA , 0x00CD5 , 0x00CCB },
	{ 0x00D46 , 0x00D3E , 0x00D4A },
	{ 0x00D46 , 0x00D57 , 0x00D4C },
	{ 0x00D47 , 0x00D3E , 0x00D4B },
	{ 0x00DD9 , 0x00DCA , 0x00DDA },
	{ 0x00DD9 , 0x00DCF , 0x00DDC },
	{ 0x00DD9 , 0x00DDF , 0x00DDE },
	{ 0x00DDC , 0x00DCA , 0x00DDD },
	{ 0x01025 , 0x0102E , 0x01026 },
	{ 0x01B05 , 0x01B35 , 0x01B06 },
	{ 0x01B07 , 0x01B35 , 0x01B08 },
	{ 0x01B09 , 0x01B35 , 0x01B0A },
	{ 0x01B0B , 0x01B35 , 0x01B0C },
	{ 0x01B0D , 0x01B35 , 0x01B0E },
	{ 0x01B11 , 0x01B35 , 0x01B12 },
	{ 0x01B3A , 0x01B35 , 0x01B3B },
	{ 0x01B3C , 0x01B35 , 0x01B3D },
	{ 0x01B3E , 0x01B35 , 0x01B40 },
	{ 0x01B3F , 0x01B35 , 0x01B41 },
	{ 0x01B42 , 0x01B35 , 0x01B43 },
	{ 0x01E36 , 0x00304 , 0x01E38 },
	{ 0x01E37 , 0x00304 , 0x01E39 },
	{ 0x01E5A , 0x00304 , 0x01E5C },
	{ 0x01E5B , 0x00304 , 0x01E5D },
	{ 0x01E62 , 0x00307 , 0x01E68 },
	{ 0x01E63 , 0x00307 , 0x01E69 },
	{ 0x01EA0 , 0x00302 , 0x01EAC },
	{ 0x01EA0 , 0x00306 , 0x01EB6 },
	{ 0x01EA1 , 0x00302 , 0x01EAD },
	{ 0x01EA1 , 0x00306 , 0x01EB7 },
	{ 0x01EB8 , 0x00302 , 0x01EC6 },
	{ 0x01EB9 , 0x00302 , 0x01EC7 },
	{ 0x01ECC , 0x00302 , 0x01ED8 },
	{ 0x01ECD , 0x00302 , 0x01ED9 },
	{ 0x01F00 , 0x00300 , 0x01F02 },
	{ 0x01F00 , 0x00301 , 0x01F04 },
	{ 0x01F00 , 0x00342 , 0x01F06 },
	{ 0x01F00 , 0x00345 , 0x01F80 },
	{ 0x01F01 , 0x00300 , 0x01F03 },
	{ 0x01F01 , 0x00301 , 0x01F05 },
	{ 0x01F01 , 0x00342 , 0x01F07 },
	{ 0x01F01 , 0x00345 , 0x01F81 },
	{ 0x01F02 , 0x00345 , 0x01F82 },
	{ 0x01F03 , 0x00345 , 0x01F83 },
	{ 0x01F04 , 0x00345 , 0x01F84 },
	{ 0x01F05 , 0x00345 , 0x01F85 },
	{ 0x01F06 , 0x00345 , 0x01F86 },
	{ 0x01F07 , 0x00345 , 0x01F87 },
	{ 0x01F08 , 0x00300 , 0x01F0A },
	{ 0x01F08 , 0x00301 , 0x01F0C },
	{ 0x01F08 , 0x00342 , 0x01F0E },
	{ 0x01F08 , 0x00345 , 0x01F88 },
	{ 0x01F09 , 0x00300 , 0x01F0B },
	{ 0x01F09 , 0x00301 , 0x01F0D },
	{ 0x01F09 , 0x00342 , 0x01F0F },
	{ 0x01F09 , 0x00345 , 0x01F89 },
	{ 0x01F0A , 0x00345 , 0x01F8A },
	{ 0x01F0B , 0x00345 , 0x01F8B },
	{ 0x01F0C , 0x00345 , 0x01F8C },
	{ 0x01F0D , 0x00345 , 0x01F8D },
	{ 0x01F0E , 0x00345 , 0x01F8E },
	{ 0x01F0F , 0x00345 , 0x01F8F },
	{ 0x01F10 , 0x00300 , 0x01F12 },
	{ 0x01F10 , 0x00301 , 0x01F14 },
	{ 0x01F11 , 0x00300 , 0x01F13 },
	{ 0x01F11 , 0x00301 , 0x01F15 },
	{ 0x01F18 , 0x00300 , 0x01F1A },
	{ 0x01F18 , 0x00301 , 0x01F1C },
	{ 0x01F19 , 0x00300 , 0x01F1B },
	{ 0x01F19 , 0x00301 , 0x01F1D },
	{ 0x01F20 , 0x00300 , 0x01F22 },
	{ 0x01F20 , 0x00301 , 0x01F24 },
	{ 0x01F20 , 0x00342 , 0x01F26 },
	{ 0x01F20 , 0x00345 , 0x01F90 },
	{ 0x01F21 , 0x00300 , 0x01F23 },
	{ 0x01F21 , 0x00301 , 0x01F25 },
	{ 0x01F21 , 0x00342 , 0x01F27 },
	{ 0x01F21 , 0x00345 , 0x01F91 },
	{ 0x01F22 , 0x00345 , 0x01F92 },
	{ 0x01F23 , 0x00345 , 0x01F93 },
	{ 0x01F24 , 0x00345 , 0x01F94 },
	{ 0x01F25 , 0x00345 , 0x01F95 },
	{ 0x01F26 , 0x00345 , 0x01F96 },
	{ 0x01F27 , 0x00345 , 0x01F97 },
	{ 0x01F28 , 0x00300 , 0x01F2A },
	{ 0x01F28 , 0x00301 , 0x01F2C },
	{ 0x01F28 , 0x00342 , 0x01F2E },
	{ 0x01F28 , 0x00345 , 0x01F98 },
	{ 0x01F29 , 0x00300 , 0x01F2B },
	{ 0x01F29 , 0x00301 , 0x01F2D },
	{ 0x01F29 , 0x00342 , 0x01F2F },
	{ 0x01F29 , 0x00345 , 0x01F99 },
	{ 0x01F2A , 0x00345 , 0x01F9A },
	{ 0x01F2B , 0x00345 , 0x01F9B },
	{ 0x01F2C , 0x00345 , 0x01F9C },
	{ 0x01F2D , 0x00345 , 0x01F9D },
	{ 0x01F2E , 0x00345 , 0x01F9E },
	{ 0x01F2F , 0x00345 , 0x01F9F },
	{ 0x01F30 , 0x00300 , 0x01F32 },
	{ 0x01F30 , 0x00301 , 0x01F34 },
	{ 0x01F30 , 0x00342 , 0x01F36 },
	{ 0x01F31 , 0x00300 , 0x01F33 },
	{ 0x01F31 , 0x00301 , 0x01F35 },
	{ 0x01F31 , 0x00342 , 0x01F37 },
	{ 0x01F38 , 0x00300 , 0x01F3A },
	{ 0x01F38 , 0x00301 , 0x01F3C },
	{ 0x01F38 , 0x00342 , 0x01F3E },
	{ 0x01F39 , 0x00300 , 0x01F3B },
	{ 0x01F39 , 0x00301 , 0x01F3D },
	{ 0x01F39 , 0x00342 , 0x01F3F },
	{ 0x01F40 , 0x00300 , 0x01F42 },
	{ 0x01F40 , 0x00301 , 0x01F44 },
	{ 0x01F41 , 0x00300 , 0x01F43 },
	{ 0x01F41 , 0x00301 , 0x01F45 },
	{ 0x01F48 , 0x00300 , 0x01F4A },
	{ 0x01F48 , 0x00301 , 0x01F4C },
	{ 0x01F49 , 0x00300 , 0x01F4B },
	{ 0x01F49 , 0x00301 , 0x01F4D },
	{ 0x01F50 , 0x00300 , 0x01F52 },
	{ 0x01F50 , 0x00301 , 0x01F54 },
	{ 0x01F50 , 0x00342 , 0x01F56 },
	{ 0x01F51 , 0x00300 , 0x01F53 },
	{ 0x01F51 , 0x00301 , 0x01F55 },
	{ 0x01F51 , 0x00342 , 0x01F57 },
	{ 0x01F59 , 0x00300 , 0x01F5B },
	{ 0x01F59 , 0x00301 , 0x01F5D },
	{ 0x01F59 , 0x00342 , 0x01F5F },
	{ 0x01F60 , 0x00300 , 0x01F62 },
	{ 0x01F60 , 0x00301 , 0x01F64 },
	{ 0x01F60 , 0x00342 , 0x01F66 },
	{ 0x01F60 , 0x00345 , 0x01FA0 },
	{ 0x01F61 , 0x00300 , 0x01F63 },
	{ 0x01F61 , 0x00301 , 0x01F65 },
	{ 0x01F61 , 0x00342 , 0x01F67 },
	{ 0x01F61 , 0x00345 , 0x01FA1 },
	{ 0x01F62 , 0x00345 , 0x01FA2 },
	{ 0x01F63 , 0x00345 , 0x01FA3 },
	{ 0x01F64 , 0x00345 , 0x01FA4 },
	{ 0x01F65 , 0x00345 , 0x01FA5 },
	{ 0x01F66 , 0x00345 , 0x01FA6 },
	{ 0x01F67 , 0x00345 , 0x01FA7 },
	{ 0x01F68 , 0x00300 , 0x01F6A },
	{ 0x01F68 , 0x00301 , 0x01F6C },
	{ 0x01F68 , 0x00342 , 0x01F6E },
	{ 0x01F68 , 0x00345 , 0x01FA8 },
	{ 0x01F69 , 0x00300 , 0x01F6B },
	{ 0x01F69 , 0x00301 , 0x01F6D },
	{ 0x01F69 , 0x00342 , 0x01F6F },
	{ 0x01F69 , 0x00345 , 0x01FA9 },
	{ 0x01F6A , 0x00345 , 0x01FAA },
	{ 0x01F6B , 0x00345 , 0x01FAB },
	{ 0x01F6C , 0x00345 , 0x01FAC },
	{ 0x01F6D , 0x00345 , 0x01FAD },
	{ 0x01F6E , 0x00345 , 0x01FAE },
	{ 0x01F6F , 0x00345 , 0x01FAF },
	{ 0x01F70 , 0x00345 , 0x01FB2 },
	{ 0x01F74 , 0x00345 , 0x01FC2 },
	{ 0x01F7C , 0x00345 , 0x01FF2 },
	{ 0x01FB6 , 0x00345 , 0x01FB7 },
	{ 0x01FBF , 0x00300 , 0x01FCD },
	{ 0x01FBF , 0x00301 , 0x01FCE },
	{ 0x01FBF , 0x00342 , 0x01FCF },
	{ 0x01FC6 , 0x00345 , 0x01FC7 },
	{ 0x01FF6 , 0x00345 , 0x01FF7 },
	{ 0x01FFE , 0x00300 , 0x01FDD },
	{ 0x01FFE , 0x00301 , 0x01FDE },
	{ 0x01FFE , 0x00342 , 0x01FDF },
	{ 0x02190 , 0x00338 , 0x0219A },
	{ 0x02192 , 0x00338 , 0x0219B },
	{ 0x02194 , 0x00338 , 0x021AE },
	{ 0x021D0 , 0x00338 , 0x021CD },
	{ 0x021D2 , 0x00338 , 0x021CF },
	{ 0x021D4 , 0x00338 , 0x021CE },
	{ 0x02203 , 0x00338 , 0x02204 },
	{ 0x02208 , 0x00338 , 0x02209 },
	{ 0x0220B , 0x00338 , 0x0220C },
	{ 0x02223 , 0x00338 , 0x02224 },
	{ 0x02225 , 0x00338 , 0x02226 },
	{ 0x0223C , 0x00338 , 0x02241 },
	{ 0x02243 , 0x00338 , 0x02244 },
	{ 0x02245 , 0x00338 , 0x02247 },
	{ 0x02248 , 0x00338 , 0x02249 },
	{ 0x0224D , 0x00338 , 0x0226D },
	{ 0x02261 , 0x00338 , 0x02262 },
	{ 0x02264 , 0x00338 , 0x02270 },
	{ 0x02265 , 0x00338 , 0x02271 },
	{ 0x02272 , 0x00338 , 0x02274 },
	{ 0x02273 , 0x00338 , 0x02275 },
	{ 0x02276 , 0x00338 , 0x02278 },
	{ 0x02277 , 0x00338 , 0x02279 },
	{ 0x0227A , 0x00338 , 0x02280 },
	{ 0x0227B , 0x00338 , 0x02281 },
	{ 0x0227C , 0x00338 , 0x022E0 },
	{ 0x0227D , 0x00338 , 0x022E1 },
	{ 0x02282 , 0x00338 , 0x02284 },
	{ 0x02283 , 0x00338 , 0x02285 },
	{ 0x02286 , 0x00338 , 0x02288 },
	{ 0x02287 , 0x00338 , 0x02289 },
	{ 0x02291 , 0x00338 , 0x022E2 },
	{ 0x02292 , 0x00338 , 0x022E3 },
	{ 0x022A2 , 0x00338 , 0x022AC },
	{ 0x022A8 , 0x00338 , 0x022AD },
	{ 0x022A9 , 0x00338 , 0x022AE },
	{ 0x022AB , 0x00338 , 0x022AF },
	{ 0x022B2 , 0x00338 , 0x022EA },
	{ 0x022B3 , 0x00338 , 0x022EB },
	{ 0x022B4 , 0x00338 , 0x022EC },
	{ 0x022B5 , 0x00338 , 0x022ED },
	{ 0x03046 , 0x03099 , 0x03094 },
	{ 0x0304B , 0x03099 , 0x0304C },
	{ 0x0304D , 0x03099 , 0x0304E },
	{ 0x0304F , 0x03099 , 0x03050 },
	{ 0x03051 , 0x03099 , 0x03052 },
	{ 0x03053 , 0x03099 , 0x03054 },
	{ 0x03055 , 0x03099 , 0x03056 },
	{ 0x03057 , 0x03099 , 0x03058 },
	{ 0x03059 , 0x03099 , 0x0305A },
	{ 0x0305B , 0x03099 , 0x0305C },
	{ 0x0305D , 0x03099 , 0x0305E },
	{ 0x0305F , 0x03099 , 0x03060 },
	{ 0x03061 , 0x03099 , 0x03062 },
	{ 0x03064 , 0x03099 , 0x03065 },
	{ 0x03066 , 0x03099 , 0x03067 },
	{ 0x03068 , 0x03099 , 0x03069 },
	{ 0x0306F , 0x03099 , 0x03070 },
	{ 0x0306F , 0x0309A , 0x03071 },
	{ 0x03072 , 0x03099 , 0x03073 },
	{ 0x03072 , 0x0309A , 0x03074 },
	{ 0x03075 , 0x03099 , 0x03076 },
	{ 0x03075 , 0x0309A , 0x03077 },
	{ 0x03078 , 0x03099 , 0x03079 },
	{ 0x03078 , 0x0309A , 0x0307A },
	{ 0x0307B , 0x03099 , 0x0307C },
	{ 0x0307B , 0x0309A , 0x0307D },
	{ 0x0309D , 0x03099 , 0x0309E },
	{ 0x030A6 , 0x03099 , 0x030F4 },
	{ 0x030AB , 0x03099 , 0x030AC },
	{ 0x030AD , 0x03099 , 0x030AE },
	{ 0x030AF , 0x03099 , 0x030B0 },
	{ 0x030B1 , 0x03099 , 0x030B2 },
	{ 0x030B3 , 0x03099 , 0x030B4 },
	{ 0x030B5 , 0x03099 , 0x030B6 },
	{ 0x030B7 , 0x03099 , 0x030B8 },
	{ 0x030B9 , 0x03099 , 0x030BA },
	{ 0x030BB , 0x03099 , 0x030BC },
	{ 0x030BD , 0x03099 , 0x030BE },
	{ 0x030BF , 0x03099 , 0x030C0 },
	{ 0x030C1 , 0x03099 , 0x030C2 },
	{ 0x030C4 , 0x03099 , 0x030C5 },
	{ 0x030C6 , 0x03099 , 0x030C7 },
	{ 0x030C8 , 0x03099 , 0x030C9 },
	{ 0x030CF , 0x03099 , 0x030D0 },
	{ 0x030CF , 0x0309A , 0x030D1 },
	{ 0x030D2 , 0x03099 , 0x030D3 },
	{ 0x030D2 , 0x0309A , 0x030D4 },
	{ 0x030D5 , 0x03099 , 0x030D6 },
	{ 0x030D5 , 0x0309A , 0x030D7 },
	{ 0x030D8 , 0x03099 , 0x030D9 },
	{ 0x030D8 , 0x0309A , 0x030DA },
	{ 0x030DB , 0x03099 , 0x030DC },
	{ 0x030DB , 0x0309A , 0x030DD },
	{ 0x030EF , 0x03099 , 0x030F7 },
	{ 0x030F0 , 0x03099 , 0x030F8 },
	{ 0x030F1 , 0x03099 , 0x030F9 },
	{ 0x030F2 , 0x03099 , 0x030FA },
	{ 0x030FD , 0x03099 , 0x030FE },
	{ 0x11099 , 0x110BA , 0x1109A },
	{ 0x1109B , 0x110BA , 0x1109C },
	{ 0x110A5 , 0x110BA , 0x110AB },
};

#define CANONICAL_CLASS_MIN	0x0300
#define CANONICAL_CLASS_MAX	0x1D244

#define IS_DECOMPOSABLE_BLOCK(uc)	\
	(((uc)>>8) <= 0x1D2 && u_decomposable_blocks[(uc)>>8])
static const char u_decomposable_blocks[0x1D2+1] = {
	0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,1,1,0,0,
	1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,
	0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
};

/* Get Canonical Combining Class(CCC). */
#define CCC(uc)	\
	(((uc) > 0x1D244)?0:\
	ccc_val[ccc_val_index[ccc_index[(uc)>>8]][((uc)>>4)&0x0F]][(uc)&0x0F])

/* The table of the value of Canonical Combining Class */
static const unsigned char ccc_val[][16] = {
 /* idx=0: XXXX0 - XXXXF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=1: 00300 - 0030F */
 {230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=2: 00310 - 0031F */
 {230, 230, 230, 230, 230, 232, 220, 220, 220, 220, 232, 216, 220, 220, 220, 220 },
 /* idx=3: 00320 - 0032F */
 {220, 202, 202, 220, 220, 220, 220, 202, 202, 220, 220, 220, 220, 220, 220, 220 },
 /* idx=4: 00330 - 0033F */
 {220, 220, 220, 220, 1, 1, 1, 1, 1, 220, 220, 220, 220, 230, 230, 230 },
 /* idx=5: 00340 - 0034F */
 {230, 230, 230, 230, 230, 240, 230, 220, 220, 220, 230, 230, 230, 220, 220, 0 },
 /* idx=6: 00350 - 0035F */
 {230, 230, 230, 220, 220, 220, 220, 230, 232, 220, 220, 230, 233, 234, 234, 233 },
 /* idx=7: 00360 - 0036F */
 {234, 234, 233, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=8: 00480 - 0048F */
 {0, 0, 0, 230, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=9: 00590 - 0059F */
 {0, 220, 230, 230, 230, 230, 220, 230, 230, 230, 222, 220, 230, 230, 230, 230 },
 /* idx=10: 005A0 - 005AF */
 {230, 230, 220, 220, 220, 220, 220, 220, 230, 230, 220, 230, 230, 222, 228, 230 },
 /* idx=11: 005B0 - 005BF */
 {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 0, 23 },
 /* idx=12: 005C0 - 005CF */
 {0, 24, 25, 0, 230, 220, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=13: 00610 - 0061F */
 {230, 230, 230, 230, 230, 230, 230, 230, 30, 31, 32, 0, 0, 0, 0, 0 },
 /* idx=14: 00640 - 0064F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31 },
 /* idx=15: 00650 - 0065F */
 {32, 33, 34, 230, 230, 220, 220, 230, 230, 230, 230, 230, 220, 230, 230, 220 },
 /* idx=16: 00670 - 0067F */
 {35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=17: 006D0 - 006DF */
 {0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 230, 230, 230, 0, 0, 230 },
 /* idx=18: 006E0 - 006EF */
 {230, 230, 230, 220, 230, 0, 0, 230, 230, 0, 220, 230, 230, 220, 0, 0 },
 /* idx=19: 00710 - 0071F */
 {0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=20: 00730 - 0073F */
 {230, 220, 230, 230, 220, 230, 230, 220, 220, 220, 230, 220, 220, 230, 220, 230 },
 /* idx=21: 00740 - 0074F */
 {230, 230, 220, 230, 220, 230, 220, 230, 220, 230, 230, 0, 0, 0, 0, 0 },
 /* idx=22: 007E0 - 007EF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 230 },
 /* idx=23: 007F0 - 007FF */
 {230, 230, 220, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=24: 00810 - 0081F */
 {0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 0, 230, 230, 230, 230, 230 },
 /* idx=25: 00820 - 0082F */
 {230, 230, 230, 230, 0, 230, 230, 230, 0, 230, 230, 230, 230, 230, 0, 0 },
 /* idx=26: 00850 - 0085F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 220, 0, 0, 0, 0 },
 /* idx=27: 00930 - 0093F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=28: 00940 - 0094F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=29: 00950 - 0095F */
 {0, 230, 220, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=30: 009B0 - 009BF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=31: 009C0 - 009CF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=32: 00A30 - 00A3F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=33: 00A40 - 00A4F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=34: 00AB0 - 00ABF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=35: 00AC0 - 00ACF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=36: 00B30 - 00B3F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=37: 00B40 - 00B4F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=38: 00BC0 - 00BCF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=39: 00C40 - 00C4F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=40: 00C50 - 00C5F */
 {0, 0, 0, 0, 0, 84, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=41: 00CB0 - 00CBF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0 },
 /* idx=42: 00CC0 - 00CCF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=43: 00D40 - 00D4F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=44: 00DC0 - 00DCF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0 },
 /* idx=45: 00E30 - 00E3F */
 {0, 0, 0, 0, 0, 0, 0, 0, 103, 103, 9, 0, 0, 0, 0, 0 },
 /* idx=46: 00E40 - 00E4F */
 {0, 0, 0, 0, 0, 0, 0, 0, 107, 107, 107, 107, 0, 0, 0, 0 },
 /* idx=47: 00EB0 - 00EBF */
 {0, 0, 0, 0, 0, 0, 0, 0, 118, 118, 0, 0, 0, 0, 0, 0 },
 /* idx=48: 00EC0 - 00ECF */
 {0, 0, 0, 0, 0, 0, 0, 0, 122, 122, 122, 122, 0, 0, 0, 0 },
 /* idx=49: 00F10 - 00F1F */
 {0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 0, 0, 0, 0, 0, 0 },
 /* idx=50: 00F30 - 00F3F */
 {0, 0, 0, 0, 0, 220, 0, 220, 0, 216, 0, 0, 0, 0, 0, 0 },
 /* idx=51: 00F70 - 00F7F */
 {0, 129, 130, 0, 132, 0, 0, 0, 0, 0, 130, 130, 130, 130, 0, 0 },
 /* idx=52: 00F80 - 00F8F */
 {130, 0, 230, 230, 9, 0, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=53: 00FC0 - 00FCF */
 {0, 0, 0, 0, 0, 0, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=54: 01030 - 0103F */
 {0, 0, 0, 0, 0, 0, 0, 7, 0, 9, 9, 0, 0, 0, 0, 0 },
 /* idx=55: 01080 - 0108F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 0 },
 /* idx=56: 01350 - 0135F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230 },
 /* idx=57: 01710 - 0171F */
 {0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=58: 01730 - 0173F */
 {0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=59: 017D0 - 017DF */
 {0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 0, 0 },
 /* idx=60: 018A0 - 018AF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 0, 0, 0, 0, 0, 0 },
 /* idx=61: 01930 - 0193F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 230, 220, 0, 0, 0, 0 },
 /* idx=62: 01A10 - 01A1F */
 {0, 0, 0, 0, 0, 0, 0, 230, 220, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=63: 01A60 - 01A6F */
 {9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=64: 01A70 - 01A7F */
 {0, 0, 0, 0, 0, 230, 230, 230, 230, 230, 230, 230, 230, 0, 0, 220 },
 /* idx=65: 01B30 - 01B3F */
 {0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=66: 01B40 - 01B4F */
 {0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=67: 01B60 - 01B6F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 220, 230, 230, 230 },
 /* idx=68: 01B70 - 01B7F */
 {230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=69: 01BA0 - 01BAF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0 },
 /* idx=70: 01BE0 - 01BEF */
 {0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=71: 01BF0 - 01BFF */
 {0, 0, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=72: 01C30 - 01C3F */
 {0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=73: 01CD0 - 01CDF */
 {230, 230, 230, 0, 1, 220, 220, 220, 220, 220, 230, 230, 220, 220, 220, 220 },
 /* idx=74: 01CE0 - 01CEF */
 {230, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 220, 0, 0 },
 /* idx=75: 01DC0 - 01DCF */
 {230, 230, 220, 230, 230, 230, 230, 230, 230, 230, 220, 230, 230, 234, 214, 220 },
 /* idx=76: 01DD0 - 01DDF */
 {202, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=77: 01DE0 - 01DEF */
 {230, 230, 230, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=78: 01DF0 - 01DFF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 220, 230, 220 },
 /* idx=79: 020D0 - 020DF */
 {230, 230, 1, 1, 230, 230, 230, 230, 1, 1, 1, 230, 230, 0, 0, 0 },
 /* idx=80: 020E0 - 020EF */
 {0, 230, 0, 0, 0, 1, 1, 230, 220, 230, 1, 1, 220, 220, 220, 220 },
 /* idx=81: 020F0 - 020FF */
 {230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=82: 02CE0 - 02CEF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230 },
 /* idx=83: 02CF0 - 02CFF */
 {230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=84: 02D70 - 02D7F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9 },
 /* idx=85: 02DE0 - 02DEF */
 {230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=86: 02DF0 - 02DFF */
 {230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=87: 03020 - 0302F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 228, 232, 222, 224, 224 },
 /* idx=88: 03090 - 0309F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0 },
 /* idx=89: 0A660 - 0A66F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230 },
 /* idx=90: 0A670 - 0A67F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 0, 0 },
 /* idx=91: 0A6F0 - 0A6FF */
 {230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=92: 0A800 - 0A80F */
 {0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=93: 0A8C0 - 0A8CF */
 {0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=94: 0A8E0 - 0A8EF */
 {230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230, 230 },
 /* idx=95: 0A8F0 - 0A8FF */
 {230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=96: 0A920 - 0A92F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 220, 0, 0 },
 /* idx=97: 0A950 - 0A95F */
 {0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=98: 0A9B0 - 0A9BF */
 {0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=99: 0A9C0 - 0A9CF */
 {9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=100: 0AAB0 - 0AABF */
 {230, 0, 230, 230, 220, 0, 0, 230, 230, 0, 0, 0, 0, 0, 230, 230 },
 /* idx=101: 0AAC0 - 0AACF */
 {0, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=102: 0ABE0 - 0ABEF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0 },
 /* idx=103: 0FB10 - 0FB1F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0 },
 /* idx=104: 0FE20 - 0FE2F */
 {230, 230, 230, 230, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=105: 101F0 - 101FF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 0 },
 /* idx=106: 10A00 - 10A0F */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 230 },
 /* idx=107: 10A30 - 10A3F */
 {0, 0, 0, 0, 0, 0, 0, 0, 230, 1, 220, 0, 0, 0, 0, 9 },
 /* idx=108: 11040 - 1104F */
 {0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=109: 110B0 - 110BF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 7, 0, 0, 0, 0, 0 },
 /* idx=110: 1D160 - 1D16F */
 {0, 0, 0, 0, 0, 216, 216, 1, 1, 1, 0, 0, 0, 226, 216, 216 },
 /* idx=111: 1D170 - 1D17F */
 {216, 216, 216, 0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 220, 220, 220 },
 /* idx=112: 1D180 - 1D18F */
 {220, 220, 220, 0, 0, 230, 230, 230, 230, 230, 220, 220, 0, 0, 0, 0 },
 /* idx=113: 1D1A0 - 1D1AF */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 230, 230, 230, 0, 0 },
 /* idx=114: 1D240 - 1D24F */
 {0, 0, 230, 230, 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
};

/* The index table to ccc_val[*][16] */
static const unsigned char ccc_val_index[][16] = {
 /* idx=0: XXX00 - XXXFF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=1: 00300 - 003FF */
 { 1, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=2: 00400 - 004FF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=3: 00500 - 005FF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 9,10,11,12, 0, 0, 0 },
 /* idx=4: 00600 - 006FF */
 { 0,13, 0, 0,14,15, 0,16, 0, 0, 0, 0, 0,17,18, 0 },
 /* idx=5: 00700 - 007FF */
 { 0,19, 0,20,21, 0, 0, 0, 0, 0, 0, 0, 0, 0,22,23 },
 /* idx=6: 00800 - 008FF */
 { 0,24,25, 0, 0,26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=7: 00900 - 009FF */
 { 0, 0, 0,27,28,29, 0, 0, 0, 0, 0,30,31, 0, 0, 0 },
 /* idx=8: 00A00 - 00AFF */
 { 0, 0, 0,32,33, 0, 0, 0, 0, 0, 0,34,35, 0, 0, 0 },
 /* idx=9: 00B00 - 00BFF */
 { 0, 0, 0,36,37, 0, 0, 0, 0, 0, 0, 0,38, 0, 0, 0 },
 /* idx=10: 00C00 - 00CFF */
 { 0, 0, 0, 0,39,40, 0, 0, 0, 0, 0,41,42, 0, 0, 0 },
 /* idx=11: 00D00 - 00DFF */
 { 0, 0, 0, 0,43, 0, 0, 0, 0, 0, 0, 0,44, 0, 0, 0 },
 /* idx=12: 00E00 - 00EFF */
 { 0, 0, 0,45,46, 0, 0, 0, 0, 0, 0,47,48, 0, 0, 0 },
 /* idx=13: 00F00 - 00FFF */
 { 0,49, 0,50, 0, 0, 0,51,52, 0, 0, 0,53, 0, 0, 0 },
 /* idx=14: 01000 - 010FF */
 { 0, 0, 0,54, 0, 0, 0, 0,55, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=15: 01300 - 013FF */
 { 0, 0, 0, 0, 0,56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=16: 01700 - 017FF */
 { 0,57, 0,58, 0, 0, 0, 0, 0, 0, 0, 0, 0,59, 0, 0 },
 /* idx=17: 01800 - 018FF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,60, 0, 0, 0, 0, 0 },
 /* idx=18: 01900 - 019FF */
 { 0, 0, 0,61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=19: 01A00 - 01AFF */
 { 0,62, 0, 0, 0, 0,63,64, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=20: 01B00 - 01BFF */
 { 0, 0, 0,65,66, 0,67,68, 0, 0,69, 0, 0, 0,70,71 },
 /* idx=21: 01C00 - 01CFF */
 { 0, 0, 0,72, 0, 0, 0, 0, 0, 0, 0, 0, 0,73,74, 0 },
 /* idx=22: 01D00 - 01DFF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,75,76,77,78 },
 /* idx=23: 02000 - 020FF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,79,80,81 },
 /* idx=24: 02C00 - 02CFF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,82,83 },
 /* idx=25: 02D00 - 02DFF */
 { 0, 0, 0, 0, 0, 0, 0,84, 0, 0, 0, 0, 0, 0,85,86 },
 /* idx=26: 03000 - 030FF */
 { 0, 0,87, 0, 0, 0, 0, 0, 0,88, 0, 0, 0, 0, 0, 0 },
 /* idx=27: 0A600 - 0A6FF */
 { 0, 0, 0, 0, 0, 0,89,90, 0, 0, 0, 0, 0, 0, 0,91 },
 /* idx=28: 0A800 - 0A8FF */
 {92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,93, 0,94,95 },
 /* idx=29: 0A900 - 0A9FF */
 { 0, 0,96, 0, 0,97, 0, 0, 0, 0, 0,98,99, 0, 0, 0 },
 /* idx=30: 0AA00 - 0AAFF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,100,101, 0, 0, 0 },
 /* idx=31: 0AB00 - 0ABFF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,102, 0 },
 /* idx=32: 0FB00 - 0FBFF */
 { 0,103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=33: 0FE00 - 0FEFF */
 { 0, 0,104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=34: 10100 - 101FF */
 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,105 },
 /* idx=35: 10A00 - 10AFF */
 {106, 0, 0,107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 /* idx=36: 11000 - 110FF */
 { 0, 0, 0, 0,108, 0, 0, 0, 0, 0, 0,109, 0, 0, 0, 0 },
 /* idx=37: 1D100 - 1D1FF */
 { 0, 0, 0, 0, 0, 0,110,111,112, 0,113, 0, 0, 0, 0, 0 },
 /* idx=38: 1D200 - 1D2FF */
 { 0, 0, 0, 0,114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
};

/* The index table to ccc_val_index[*][16] */
static const unsigned char ccc_index[] = {
  0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14, 0, 0,15, 0, 0, 0,16,
 17,18,19,20,21,22, 0, 0,23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,24,25, 0, 0,
 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,27, 0,
 28,29,30,31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,32, 0, 0,33, 0, 0,34, 0, 0, 0, 0, 0, 0,
  0, 0,35, 0, 0, 0, 0, 0,36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0,37,38,};

struct unicode_decomposition_table {
	uint32_t nfc;
	uint32_t cp1;
	uint32_t cp2;
};

static const struct unicode_decomposition_table u_decomposition_table[] = {
	{ 0x000C0 , 0x00041 , 0x00300 },
	{ 0x000C1 , 0x00041 , 0x00301 },
	{ 0x000C2 , 0x00041 , 0x00302 },
	{ 0x000C3 , 0x00041 , 0x00303 },
	{ 0x000C4 , 0x00041 , 0x00308 },
	{ 0x000C5 , 0x00041 , 0x0030A },
	{ 0x000C7 , 0x00043 , 0x00327 },
	{ 0x000C8 , 0x00045 , 0x00300 },
	{ 0x000C9 , 0x00045 , 0x00301 },
	{ 0x000CA , 0x00045 , 0x00302 },
	{ 0x000CB , 0x00045 , 0x00308 },
	{ 0x000CC , 0x00049 , 0x00300 },
	{ 0x000CD , 0x00049 , 0x00301 },
	{ 0x000CE , 0x00049 , 0x00302 },
	{ 0x000CF , 0x00049 , 0x00308 },
	{ 0x000D1 , 0x0004E , 0x00303 },
	{ 0x000D2 , 0x0004F , 0x00300 },
	{ 0x000D3 , 0x0004F , 0x00301 },
	{ 0x000D4 , 0x0004F , 0x00302 },
	{ 0x000D5 , 0x0004F , 0x00303 },
	{ 0x000D6 , 0x0004F , 0x00308 },
	{ 0x000D9 , 0x00055 , 0x00300 },
	{ 0x000DA , 0x00055 , 0x00301 },
	{ 0x000DB , 0x00055 , 0x00302 },
	{ 0x000DC , 0x00055 , 0x00308 },
	{ 0x000DD , 0x00059 , 0x00301 },
	{ 0x000E0 , 0x00061 , 0x00300 },
	{ 0x000E1 , 0x00061 , 0x00301 },
	{ 0x000E2 , 0x00061 , 0x00302 },
	{ 0x000E3 , 0x00061 , 0x00303 },
	{ 0x000E4 , 0x00061 , 0x00308 },
	{ 0x000E5 , 0x00061 , 0x0030A },
	{ 0x000E7 , 0x00063 , 0x00327 },
	{ 0x000E8 , 0x00065 , 0x00300 },
	{ 0x000E9 , 0x00065 , 0x00301 },
	{ 0x000EA , 0x00065 , 0x00302 },
	{ 0x000EB , 0x00065 , 0x00308 },
	{ 0x000EC , 0x00069 , 0x00300 },
	{ 0x000ED , 0x00069 , 0x00301 },
	{ 0x000EE , 0x00069 , 0x00302 },
	{ 0x000EF , 0x00069 , 0x00308 },
	{ 0x000F1 , 0x0006E , 0x00303 },
	{ 0x000F2 , 0x0006F , 0x00300 },
	{ 0x000F3 , 0x0006F , 0x00301 },
	{ 0x000F4 , 0x0006F , 0x00302 },
	{ 0x000F5 , 0x0006F , 0x00303 },
	{ 0x000F6 , 0x0006F , 0x00308 },
	{ 0x000F9 , 0x00075 , 0x00300 },
	{ 0x000FA , 0x00075 , 0x00301 },
	{ 0x000FB , 0x00075 , 0x00302 },
	{ 0x000FC , 0x00075 , 0x00308 },
	{ 0x000FD , 0x00079 , 0x00301 },
	{ 0x000FF , 0x00079 , 0x00308 },
	{ 0x00100 , 0x00041 , 0x00304 },
	{ 0x00101 , 0x00061 , 0x00304 },
	{ 0x00102 , 0x00041 , 0x00306 },
	{ 0x00103 , 0x00061 , 0x00306 },
	{ 0x00104 , 0x00041 , 0x00328 },
	{ 0x00105 , 0x00061 , 0x00328 },
	{ 0x00106 , 0x00043 , 0x00301 },
	{ 0x00107 , 0x00063 , 0x00301 },
	{ 0x00108 , 0x00043 , 0x00302 },
	{ 0x00109 , 0x00063 , 0x00302 },
	{ 0x0010A , 0x00043 , 0x00307 },
	{ 0x0010B , 0x00063 , 0x00307 },
	{ 0x0010C , 0x00043 , 0x0030C },
	{ 0x0010D , 0x00063 , 0x0030C },
	{ 0x0010E , 0x00044 , 0x0030C },
	{ 0x0010F , 0x00064 , 0x0030C },
	{ 0x00112 , 0x00045 , 0x00304 },
	{ 0x00113 , 0x00065 , 0x00304 },
	{ 0x00114 , 0x00045 , 0x00306 },
	{ 0x00115 , 0x00065 , 0x00306 },
	{ 0x00116 , 0x00045 , 0x00307 },
	{ 0x00117 , 0x00065 , 0x00307 },
	{ 0x00118 , 0x00045 , 0x00328 },
	{ 0x00119 , 0x00065 , 0x00328 },
	{ 0x0011A , 0x00045 , 0x0030C },
	{ 0x0011B , 0x00065 , 0x0030C },
	{ 0x0011C , 0x00047 , 0x00302 },
	{ 0x0011D , 0x00067 , 0x00302 },
	{ 0x0011E , 0x00047 , 0x00306 },
	{ 0x0011F , 0x00067 , 0x00306 },
	{ 0x00120 , 0x00047 , 0x00307 },
	{ 0x00121 , 0x00067 , 0x00307 },
	{ 0x00122 , 0x00047 , 0x00327 },
	{ 0x00123 , 0x00067 , 0x00327 },
	{ 0x00124 , 0x00048 , 0x00302 },
	{ 0x00125 , 0x00068 , 0x00302 },
	{ 0x00128 , 0x00049 , 0x00303 },
	{ 0x00129 , 0x00069 , 0x00303 },
	{ 0x0012A , 0x00049 , 0x00304 },
	{ 0x0012B , 0x00069 , 0x00304 },
	{ 0x0012C , 0x00049 , 0x00306 },
	{ 0x0012D , 0x00069 , 0x00306 },
	{ 0x0012E , 0x00049 , 0x00328 },
	{ 0x0012F , 0x00069 , 0x00328 },
	{ 0x00130 , 0x00049 , 0x00307 },
	{ 0x00134 , 0x0004A , 0x00302 },
	{ 0x00135 , 0x0006A , 0x00302 },
	{ 0x00136 , 0x0004B , 0x00327 },
	{ 0x00137 , 0x0006B , 0x00327 },
	{ 0x00139 , 0x0004C , 0x00301 },
	{ 0x0013A , 0x0006C , 0x00301 },
	{ 0x0013B , 0x0004C , 0x00327 },
	{ 0x0013C , 0x0006C , 0x00327 },
	{ 0x0013D , 0x0004C , 0x0030C },
	{ 0x0013E , 0x0006C , 0x0030C },
	{ 0x00143 , 0x0004E , 0x00301 },
	{ 0x00144 , 0x0006E , 0x00301 },
	{ 0x00145 , 0x0004E , 0x00327 },
	{ 0x00146 , 0x0006E , 0x00327 },
	{ 0x00147 , 0x0004E , 0x0030C },
	{ 0x00148 , 0x0006E , 0x0030C },
	{ 0x0014C , 0x0004F , 0x00304 },
	{ 0x0014D , 0x0006F , 0x00304 },
	{ 0x0014E , 0x0004F , 0x00306 },
	{ 0x0014F , 0x0006F , 0x00306 },
	{ 0x00150 , 0x0004F , 0x0030B },
	{ 0x00151 , 0x0006F , 0x0030B },
	{ 0x00154 , 0x00052 , 0x00301 },
	{ 0x00155 , 0x00072 , 0x00301 },
	{ 0x00156 , 0x00052 , 0x00327 },
	{ 0x00157 , 0x00072 , 0x00327 },
	{ 0x00158 , 0x00052 , 0x0030C },
	{ 0x00159 , 0x00072 , 0x0030C },
	{ 0x0015A , 0x00053 , 0x00301 },
	{ 0x0015B , 0x00073 , 0x00301 },
	{ 0x0015C , 0x00053 , 0x00302 },
	{ 0x0015D , 0x00073 , 0x00302 },
	{ 0x0015E , 0x00053 , 0x00327 },
	{ 0x0015F , 0x00073 , 0x00327 },
	{ 0x00160 , 0x00053 , 0x0030C },
	{ 0x00161 , 0x00073 , 0x0030C },
	{ 0x00162 , 0x00054 , 0x00327 },
	{ 0x00163 , 0x00074 , 0x00327 },
	{ 0x00164 , 0x00054 , 0x0030C },
	{ 0x00165 , 0x00074 , 0x0030C },
	{ 0x00168 , 0x00055 , 0x00303 },
	{ 0x00169 , 0x00075 , 0x00303 },
	{ 0x0016A , 0x00055 , 0x00304 },
	{ 0x0016B , 0x00075 , 0x00304 },
	{ 0x0016C , 0x00055 , 0x00306 },
	{ 0x0016D , 0x00075 , 0x00306 },
	{ 0x0016E , 0x00055 , 0x0030A },
	{ 0x0016F , 0x00075 , 0x0030A },
	{ 0x00170 , 0x00055 , 0x0030B },
	{ 0x00171 , 0x00075 , 0x0030B },
	{ 0x00172 , 0x00055 , 0x00328 },
	{ 0x00173 , 0x00075 , 0x00328 },
	{ 0x00174 , 0x00057 , 0x00302 },
	{ 0x00175 , 0x00077 , 0x00302 },
	{ 0x00176 , 0x00059 , 0x00302 },
	{ 0x00177 , 0x00079 , 0x00302 },
	{ 0x00178 , 0x00059 , 0x00308 },
	{ 0x00179 , 0x0005A , 0x00301 },
	{ 0x0017A , 0x0007A , 0x00301 },
	{ 0x0017B , 0x0005A , 0x00307 },
	{ 0x0017C , 0x0007A , 0x00307 },
	{ 0x0017D , 0x0005A , 0x0030C },
	{ 0x0017E , 0x0007A , 0x0030C },
	{ 0x001A0 , 0x0004F , 0x0031B },
	{ 0x001A1 , 0x0006F , 0x0031B },
	{ 0x001AF , 0x00055 , 0x0031B },
	{ 0x001B0 , 0x00075 , 0x0031B },
	{ 0x001CD , 0x00041 , 0x0030C },
	{ 0x001CE , 0x00061 , 0x0030C },
	{ 0x001CF , 0x00049 , 0x0030C },
	{ 0x001D0 , 0x00069 , 0x0030C },
	{ 0x001D1 , 0x0004F , 0x0030C },
	{ 0x001D2 , 0x0006F , 0x0030C },
	{ 0x001D3 , 0x00055 , 0x0030C },
	{ 0x001D4 , 0x00075 , 0x0030C },
	{ 0x001D5 , 0x000DC , 0x00304 },
	{ 0x001D6 , 0x000FC , 0x00304 },
	{ 0x001D7 , 0x000DC , 0x00301 },
	{ 0x001D8 , 0x000FC , 0x00301 },
	{ 0x001D9 , 0x000DC , 0x0030C },
	{ 0x001DA , 0x000FC , 0x0030C },
	{ 0x001DB , 0x000DC , 0x00300 },
	{ 0x001DC , 0x000FC , 0x00300 },
	{ 0x001DE , 0x000C4 , 0x00304 },
	{ 0x001DF , 0x000E4 , 0x00304 },
	{ 0x001E0 , 0x00226 , 0x00304 },
	{ 0x001E1 , 0x00227 , 0x00304 },
	{ 0x001E2 , 0x000C6 , 0x00304 },
	{ 0x001E3 , 0x000E6 , 0x00304 },
	{ 0x001E6 , 0x00047 , 0x0030C },
	{ 0x001E7 , 0x00067 , 0x0030C },
	{ 0x001E8 , 0x0004B , 0x0030C },
	{ 0x001E9 , 0x0006B , 0x0030C },
	{ 0x001EA , 0x0004F , 0x00328 },
	{ 0x001EB , 0x0006F , 0x00328 },
	{ 0x001EC , 0x001EA , 0x00304 },
	{ 0x001ED , 0x001EB , 0x00304 },
	{ 0x001EE , 0x001B7 , 0x0030C },
	{ 0x001EF , 0x00292 , 0x0030C },
	{ 0x001F0 , 0x0006A , 0x0030C },
	{ 0x001F4 , 0x00047 , 0x00301 },
	{ 0x001F5 , 0x00067 , 0x00301 },
	{ 0x001F8 , 0x0004E , 0x00300 },
	{ 0x001F9 , 0x0006E , 0x00300 },
	{ 0x001FA , 0x000C5 , 0x00301 },
	{ 0x001FB , 0x000E5 , 0x00301 },
	{ 0x001FC , 0x000C6 , 0x00301 },
	{ 0x001FD , 0x000E6 , 0x00301 },
	{ 0x001FE , 0x000D8 , 0x00301 },
	{ 0x001FF , 0x000F8 , 0x00301 },
	{ 0x00200 , 0x00041 , 0x0030F },
	{ 0x00201 , 0x00061 , 0x0030F },
	{ 0x00202 , 0x00041 , 0x00311 },
	{ 0x00203 , 0x00061 , 0x00311 },
	{ 0x00204 , 0x00045 , 0x0030F },
	{ 0x00205 , 0x00065 , 0x0030F },
	{ 0x00206 , 0x00045 , 0x00311 },
	{ 0x00207 , 0x00065 , 0x00311 },
	{ 0x00208 , 0x00049 , 0x0030F },
	{ 0x00209 , 0x00069 , 0x0030F },
	{ 0x0020A , 0x00049 , 0x00311 },
	{ 0x0020B , 0x00069 , 0x00311 },
	{ 0x0020C , 0x0004F , 0x0030F },
	{ 0x0020D , 0x0006F , 0x0030F },
	{ 0x0020E , 0x0004F , 0x00311 },
	{ 0x0020F , 0x0006F , 0x00311 },
	{ 0x00210 , 0x00052 , 0x0030F },
	{ 0x00211 , 0x00072 , 0x0030F },
	{ 0x00212 , 0x00052 , 0x00311 },
	{ 0x00213 , 0x00072 , 0x00311 },
	{ 0x00214 , 0x00055 , 0x0030F },
	{ 0x00215 , 0x00075 , 0x0030F },
	{ 0x00216 , 0x00055 , 0x00311 },
	{ 0x00217 , 0x00075 , 0x00311 },
	{ 0x00218 , 0x00053 , 0x00326 },
	{ 0x00219 , 0x00073 , 0x00326 },
	{ 0x0021A , 0x00054 , 0x00326 },
	{ 0x0021B , 0x00074 , 0x00326 },
	{ 0x0021E , 0x00048 , 0x0030C },
	{ 0x0021F , 0x00068 , 0x0030C },
	{ 0x00226 , 0x00041 , 0x00307 },
	{ 0x00227 , 0x00061 , 0x00307 },
	{ 0x00228 , 0x00045 , 0x00327 },
	{ 0x00229 , 0x00065 , 0x00327 },
	{ 0x0022A , 0x000D6 , 0x00304 },
	{ 0x0022B , 0x000F6 , 0x00304 },
	{ 0x0022C , 0x000D5 , 0x00304 },
	{ 0x0022D , 0x000F5 , 0x00304 },
	{ 0x0022E , 0x0004F , 0x00307 },
	{ 0x0022F , 0x0006F , 0x00307 },
	{ 0x00230 , 0x0022E , 0x00304 },
	{ 0x00231 , 0x0022F , 0x00304 },
	{ 0x00232 , 0x00059 , 0x00304 },
	{ 0x00233 , 0x00079 , 0x00304 },
	{ 0x00385 , 0x000A8 , 0x00301 },
	{ 0x00386 , 0x00391 , 0x00301 },
	{ 0x00388 , 0x00395 , 0x00301 },
	{ 0x00389 , 0x00397 , 0x00301 },
	{ 0x0038A , 0x00399 , 0x00301 },
	{ 0x0038C , 0x0039F , 0x00301 },
	{ 0x0038E , 0x003A5 , 0x00301 },
	{ 0x0038F , 0x003A9 , 0x00301 },
	{ 0x00390 , 0x003CA , 0x00301 },
	{ 0x003AA , 0x00399 , 0x00308 },
	{ 0x003AB , 0x003A5 , 0x00308 },
	{ 0x003AC , 0x003B1 , 0x00301 },
	{ 0x003AD , 0x003B5 , 0x00301 },
	{ 0x003AE , 0x003B7 , 0x00301 },
	{ 0x003AF , 0x003B9 , 0x00301 },
	{ 0x003B0 , 0x003CB , 0x00301 },
	{ 0x003CA , 0x003B9 , 0x00308 },
	{ 0x003CB , 0x003C5 , 0x00308 },
	{ 0x003CC , 0x003BF , 0x00301 },
	{ 0x003CD , 0x003C5 , 0x00301 },
	{ 0x003CE , 0x003C9 , 0x00301 },
	{ 0x003D3 , 0x003D2 , 0x00301 },
	{ 0x003D4 , 0x003D2 , 0x00308 },
	{ 0x00400 , 0x00415 , 0x00300 },
	{ 0x00401 , 0x00415 , 0x00308 },
	{ 0x00403 , 0x00413 , 0x00301 },
	{ 0x00407 , 0x00406 , 0x00308 },
	{ 0x0040C , 0x0041A , 0x00301 },
	{ 0x0040D , 0x00418 , 0x00300 },
	{ 0x0040E , 0x00423 , 0x00306 },
	{ 0x00419 , 0x00418 , 0x00306 },
	{ 0x00439 , 0x00438 , 0x00306 },
	{ 0x00450 , 0x00435 , 0x00300 },
	{ 0x00451 , 0x00435 , 0x00308 },
	{ 0x00453 , 0x00433 , 0x00301 },
	{ 0x00457 , 0x00456 , 0x00308 },
	{ 0x0045C , 0x0043A , 0x00301 },
	{ 0x0045D , 0x00438 , 0x00300 },
	{ 0x0045E , 0x00443 , 0x00306 },
	{ 0x00476 , 0x00474 , 0x0030F },
	{ 0x00477 , 0x00475 , 0x0030F },
	{ 0x004C1 , 0x00416 , 0x00306 },
	{ 0x004C2 , 0x00436 , 0x00306 },
	{ 0x004D0 , 0x00410 , 0x00306 },
	{ 0x004D1 , 0x00430 , 0x00306 },
	{ 0x004D2 , 0x00410 , 0x00308 },
	{ 0x004D3 , 0x00430 , 0x00308 },
	{ 0x004D6 , 0x00415 , 0x00306 },
	{ 0x004D7 , 0x00435 , 0x00306 },
	{ 0x004DA , 0x004D8 , 0x00308 },
	{ 0x004DB , 0x004D9 , 0x00308 },
	{ 0x004DC , 0x00416 , 0x00308 },
	{ 0x004DD , 0x00436 , 0x00308 },
	{ 0x004DE , 0x00417 , 0x00308 },
	{ 0x004DF , 0x00437 , 0x00308 },
	{ 0x004E2 , 0x00418 , 0x00304 },
	{ 0x004E3 , 0x00438 , 0x00304 },
	{ 0x004E4 , 0x00418 , 0x00308 },
	{ 0x004E5 , 0x00438 , 0x00308 },
	{ 0x004E6 , 0x0041E , 0x00308 },
	{ 0x004E7 , 0x0043E , 0x00308 },
	{ 0x004EA , 0x004E8 , 0x00308 },
	{ 0x004EB , 0x004E9 , 0x00308 },
	{ 0x004EC , 0x0042D , 0x00308 },
	{ 0x004ED , 0x0044D , 0x00308 },
	{ 0x004EE , 0x00423 , 0x00304 },
	{ 0x004EF , 0x00443 , 0x00304 },
	{ 0x004F0 , 0x00423 , 0x00308 },
	{ 0x004F1 , 0x00443 , 0x00308 },
	{ 0x004F2 , 0x00423 , 0x0030B },
	{ 0x004F3 , 0x00443 , 0x0030B },
	{ 0x004F4 , 0x00427 , 0x00308 },
	{ 0x004F5 , 0x00447 , 0x00308 },
	{ 0x004F8 , 0x0042B , 0x00308 },
	{ 0x004F9 , 0x0044B , 0x00308 },
	{ 0x00622 , 0x00627 , 0x00653 },
	{ 0x00623 , 0x00627 , 0x00654 },
	{ 0x00624 , 0x00648 , 0x00654 },
	{ 0x00625 , 0x00627 , 0x00655 },
	{ 0x00626 , 0x0064A , 0x00654 },
	{ 0x006C0 , 0x006D5 , 0x00654 },
	{ 0x006C2 , 0x006C1 , 0x00654 },
	{ 0x006D3 , 0x006D2 , 0x00654 },
	{ 0x00929 , 0x00928 , 0x0093C },
	{ 0x00931 , 0x00930 , 0x0093C },
	{ 0x00934 , 0x00933 , 0x0093C },
	{ 0x009CB , 0x009C7 , 0x009BE },
	{ 0x009CC , 0x009C7 , 0x009D7 },
	{ 0x00B48 , 0x00B47 , 0x00B56 },
	{ 0x00B4B , 0x00B47 , 0x00B3E },
	{ 0x00B4C , 0x00B47 , 0x00B57 },
	{ 0x00B94 , 0x00B92 , 0x00BD7 },
	{ 0x00BCA , 0x00BC6 , 0x00BBE },
	{ 0x00BCB , 0x00BC7 , 0x00BBE },
	{ 0x00BCC , 0x00BC6 , 0x00BD7 },
	{ 0x00C48 , 0x00C46 , 0x00C56 },
	{ 0x00CC0 , 0x00CBF , 0x00CD5 },
	{ 0x00CC7 , 0x00CC6 , 0x00CD5 },
	{ 0x00CC8 , 0x00CC6 , 0x00CD6 },
	{ 0x00CCA , 0x00CC6 , 0x00CC2 },
	{ 0x00CCB , 0x00CCA , 0x00CD5 },
	{ 0x00D4A , 0x00D46 , 0x00D3E },
	{ 0x00D4B , 0x00D47 , 0x00D3E },
	{ 0x00D4C , 0x00D46 , 0x00D57 },
	{ 0x00DDA , 0x00DD9 , 0x00DCA },
	{ 0x00DDC , 0x00DD9 , 0x00DCF },
	{ 0x00DDD , 0x00DDC , 0x00DCA },
	{ 0x00DDE , 0x00DD9 , 0x00DDF },
	{ 0x01026 , 0x01025 , 0x0102E },
	{ 0x01B06 , 0x01B05 , 0x01B35 },
	{ 0x01B08 , 0x01B07 , 0x01B35 },
	{ 0x01B0A , 0x01B09 , 0x01B35 },
	{ 0x01B0C , 0x01B0B , 0x01B35 },
	{ 0x01B0E , 0x01B0D , 0x01B35 },
	{ 0x01B12 , 0x01B11 , 0x01B35 },
	{ 0x01B3B , 0x01B3A , 0x01B35 },
	{ 0x01B3D , 0x01B3C , 0x01B35 },
	{ 0x01B40 , 0x01B3E , 0x01B35 },
	{ 0x01B41 , 0x01B3F , 0x01B35 },
	{ 0x01B43 , 0x01B42 , 0x01B35 },
	{ 0x01E00 , 0x00041 , 0x00325 },
	{ 0x01E01 , 0x00061 , 0x00325 },
	{ 0x01E02 , 0x00042 , 0x00307 },
	{ 0x01E03 , 0x00062 , 0x00307 },
	{ 0x01E04 , 0x00042 , 0x00323 },
	{ 0x01E05 , 0x00062 , 0x00323 },
	{ 0x01E06 , 0x00042 , 0x00331 },
	{ 0x01E07 , 0x00062 , 0x00331 },
	{ 0x01E08 , 0x000C7 , 0x00301 },
	{ 0x01E09 , 0x000E7 , 0x00301 },
	{ 0x01E0A , 0x00044 , 0x00307 },
	{ 0x01E0B , 0x00064 , 0x00307 },
	{ 0x01E0C , 0x00044 , 0x00323 },
	{ 0x01E0D , 0x00064 , 0x00323 },
	{ 0x01E0E , 0x00044 , 0x00331 },
	{ 0x01E0F , 0x00064 , 0x00331 },
	{ 0x01E10 , 0x00044 , 0x00327 },
	{ 0x01E11 , 0x00064 , 0x00327 },
	{ 0x01E12 , 0x00044 , 0x0032D },
	{ 0x01E13 , 0x00064 , 0x0032D },
	{ 0x01E14 , 0x00112 , 0x00300 },
	{ 0x01E15 , 0x00113 , 0x00300 },
	{ 0x01E16 , 0x00112 , 0x00301 },
	{ 0x01E17 , 0x00113 , 0x00301 },
	{ 0x01E18 , 0x00045 , 0x0032D },
	{ 0x01E19 , 0x00065 , 0x0032D },
	{ 0x01E1A , 0x00045 , 0x00330 },
	{ 0x01E1B , 0x00065 , 0x00330 },
	{ 0x01E1C , 0x00228 , 0x00306 },
	{ 0x01E1D , 0x00229 , 0x00306 },
	{ 0x01E1E , 0x00046 , 0x00307 },
	{ 0x01E1F , 0x00066 , 0x00307 },
	{ 0x01E20 , 0x00047 , 0x00304 },
	{ 0x01E21 , 0x00067 , 0x00304 },
	{ 0x01E22 , 0x00048 , 0x00307 },
	{ 0x01E23 , 0x00068 , 0x00307 },
	{ 0x01E24 , 0x00048 , 0x00323 },
	{ 0x01E25 , 0x00068 , 0x00323 },
	{ 0x01E26 , 0x00048 , 0x00308 },
	{ 0x01E27 , 0x00068 , 0x00308 },
	{ 0x01E28 , 0x00048 , 0x00327 },
	{ 0x01E29 , 0x00068 , 0x00327 },
	{ 0x01E2A , 0x00048 , 0x0032E },
	{ 0x01E2B , 0x00068 , 0x0032E },
	{ 0x01E2C , 0x00049 , 0x00330 },
	{ 0x01E2D , 0x00069 , 0x00330 },
	{ 0x01E2E , 0x000CF , 0x00301 },
	{ 0x01E2F , 0x000EF , 0x00301 },
	{ 0x01E30 , 0x0004B , 0x00301 },
	{ 0x01E31 , 0x0006B , 0x00301 },
	{ 0x01E32 , 0x0004B , 0x00323 },
	{ 0x01E33 , 0x0006B , 0x00323 },
	{ 0x01E34 , 0x0004B , 0x00331 },
	{ 0x01E35 , 0x0006B , 0x00331 },
	{ 0x01E36 , 0x0004C , 0x00323 },
	{ 0x01E37 , 0x0006C , 0x00323 },
	{ 0x01E38 , 0x01E36 , 0x00304 },
	{ 0x01E39 , 0x01E37 , 0x00304 },
	{ 0x01E3A , 0x0004C , 0x00331 },
	{ 0x01E3B , 0x0006C , 0x00331 },
	{ 0x01E3C , 0x0004C , 0x0032D },
	{ 0x01E3D , 0x0006C , 0x0032D },
	{ 0x01E3E , 0x0004D , 0x00301 },
	{ 0x01E3F , 0x0006D , 0x00301 },
	{ 0x01E40 , 0x0004D , 0x00307 },
	{ 0x01E41 , 0x0006D , 0x00307 },
	{ 0x01E42 , 0x0004D , 0x00323 },
	{ 0x01E43 , 0x0006D , 0x00323 },
	{ 0x01E44 , 0x0004E , 0x00307 },
	{ 0x01E45 , 0x0006E , 0x00307 },
	{ 0x01E46 , 0x0004E , 0x00323 },
	{ 0x01E47 , 0x0006E , 0x00323 },
	{ 0x01E48 , 0x0004E , 0x00331 },
	{ 0x01E49 , 0x0006E , 0x00331 },
	{ 0x01E4A , 0x0004E , 0x0032D },
	{ 0x01E4B , 0x0006E , 0x0032D },
	{ 0x01E4C , 0x000D5 , 0x00301 },
	{ 0x01E4D , 0x000F5 , 0x00301 },
	{ 0x01E4E , 0x000D5 , 0x00308 },
	{ 0x01E4F , 0x000F5 , 0x00308 },
	{ 0x01E50 , 0x0014C , 0x00300 },
	{ 0x01E51 , 0x0014D , 0x00300 },
	{ 0x01E52 , 0x0014C , 0x00301 },
	{ 0x01E53 , 0x0014D , 0x00301 },
	{ 0x01E54 , 0x00050 , 0x00301 },
	{ 0x01E55 , 0x00070 , 0x00301 },
	{ 0x01E56 , 0x00050 , 0x00307 },
	{ 0x01E57 , 0x00070 , 0x00307 },
	{ 0x01E58 , 0x00052 , 0x00307 },
	{ 0x01E59 , 0x00072 , 0x00307 },
	{ 0x01E5A , 0x00052 , 0x00323 },
	{ 0x01E5B , 0x00072 , 0x00323 },
	{ 0x01E5C , 0x01E5A , 0x00304 },
	{ 0x01E5D , 0x01E5B , 0x00304 },
	{ 0x01E5E , 0x00052 , 0x00331 },
	{ 0x01E5F , 0x00072 , 0x00331 },
	{ 0x01E60 , 0x00053 , 0x00307 },
	{ 0x01E61 , 0x00073 , 0x00307 },
	{ 0x01E62 , 0x00053 , 0x00323 },
	{ 0x01E63 , 0x00073 , 0x00323 },
	{ 0x01E64 , 0x0015A , 0x00307 },
	{ 0x01E65 , 0x0015B , 0x00307 },
	{ 0x01E66 , 0x00160 , 0x00307 },
	{ 0x01E67 , 0x00161 , 0x00307 },
	{ 0x01E68 , 0x01E62 , 0x00307 },
	{ 0x01E69 , 0x01E63 , 0x00307 },
	{ 0x01E6A , 0x00054 , 0x00307 },
	{ 0x01E6B , 0x00074 , 0x00307 },
	{ 0x01E6C , 0x00054 , 0x00323 },
	{ 0x01E6D , 0x00074 , 0x00323 },
	{ 0x01E6E , 0x00054 , 0x00331 },
	{ 0x01E6F , 0x00074 , 0x00331 },
	{ 0x01E70 , 0x00054 , 0x0032D },
	{ 0x01E71 , 0x00074 , 0x0032D },
	{ 0x01E72 , 0x00055 , 0x00324 },
	{ 0x01E73 , 0x00075 , 0x00324 },
	{ 0x01E74 , 0x00055 , 0x00330 },
	{ 0x01E75 , 0x00075 , 0x00330 },
	{ 0x01E76 , 0x00055 , 0x0032D },
	{ 0x01E77 , 0x00075 , 0x0032D },
	{ 0x01E78 , 0x00168 , 0x00301 },
	{ 0x01E79 , 0x00169 , 0x00301 },
	{ 0x01E7A , 0x0016A , 0x00308 },
	{ 0x01E7B , 0x0016B , 0x00308 },
	{ 0x01E7C , 0x00056 , 0x00303 },
	{ 0x01E7D , 0x00076 , 0x00303 },
	{ 0x01E7E , 0x00056 , 0x00323 },
	{ 0x01E7F , 0x00076 , 0x00323 },
	{ 0x01E80 , 0x00057 , 0x00300 },
	{ 0x01E81 , 0x00077 , 0x00300 },
	{ 0x01E82 , 0x00057 , 0x00301 },
	{ 0x01E83 , 0x00077 , 0x00301 },
	{ 0x01E84 , 0x00057 , 0x00308 },
	{ 0x01E85 , 0x00077 , 0x00308 },
	{ 0x01E86 , 0x00057 , 0x00307 },
	{ 0x01E87 , 0x00077 , 0x00307 },
	{ 0x01E88 , 0x00057 , 0x00323 },
	{ 0x01E89 , 0x00077 , 0x00323 },
	{ 0x01E8A , 0x00058 , 0x00307 },
	{ 0x01E8B , 0x00078 , 0x00307 },
	{ 0x01E8C , 0x00058 , 0x00308 },
	{ 0x01E8D , 0x00078 , 0x00308 },
	{ 0x01E8E , 0x00059 , 0x00307 },
	{ 0x01E8F , 0x00079 , 0x00307 },
	{ 0x01E90 , 0x0005A , 0x00302 },
	{ 0x01E91 , 0x0007A , 0x00302 },
	{ 0x01E92 , 0x0005A , 0x00323 },
	{ 0x01E93 , 0x0007A , 0x00323 },
	{ 0x01E94 , 0x0005A , 0x00331 },
	{ 0x01E95 , 0x0007A , 0x00331 },
	{ 0x01E96 , 0x00068 , 0x00331 },
	{ 0x01E97 , 0x00074 , 0x00308 },
	{ 0x01E98 , 0x00077 , 0x0030A },
	{ 0x01E99 , 0x00079 , 0x0030A },
	{ 0x01E9B , 0x0017F , 0x00307 },
	{ 0x01EA0 , 0x00041 , 0x00323 },
	{ 0x01EA1 , 0x00061 , 0x00323 },
	{ 0x01EA2 , 0x00041 , 0x00309 },
	{ 0x01EA3 , 0x00061 , 0x00309 },
	{ 0x01EA4 , 0x000C2 , 0x00301 },
	{ 0x01EA5 , 0x000E2 , 0x00301 },
	{ 0x01EA6 , 0x000C2 , 0x00300 },
	{ 0x01EA7 , 0x000E2 , 0x00300 },
	{ 0x01EA8 , 0x000C2 , 0x00309 },
	{ 0x01EA9 , 0x000E2 , 0x00309 },
	{ 0x01EAA , 0x000C2 , 0x00303 },
	{ 0x01EAB , 0x000E2 , 0x00303 },
	{ 0x01EAC , 0x01EA0 , 0x00302 },
	{ 0x01EAD , 0x01EA1 , 0x00302 },
	{ 0x01EAE , 0x00102 , 0x00301 },
	{ 0x01EAF , 0x00103 , 0x00301 },
	{ 0x01EB0 , 0x00102 , 0x00300 },
	{ 0x01EB1 , 0x00103 , 0x00300 },
	{ 0x01EB2 , 0x00102 , 0x00309 },
	{ 0x01EB3 , 0x00103 , 0x00309 },
	{ 0x01EB4 , 0x00102 , 0x00303 },
	{ 0x01EB5 , 0x00103 , 0x00303 },
	{ 0x01EB6 , 0x01EA0 , 0x00306 },
	{ 0x01EB7 , 0x01EA1 , 0x00306 },
	{ 0x01EB8 , 0x00045 , 0x00323 },
	{ 0x01EB9 , 0x00065 , 0x00323 },
	{ 0x01EBA , 0x00045 , 0x00309 },
	{ 0x01EBB , 0x00065 , 0x00309 },
	{ 0x01EBC , 0x00045 , 0x00303 },
	{ 0x01EBD , 0x00065 , 0x00303 },
	{ 0x01EBE , 0x000CA , 0x00301 },
	{ 0x01EBF , 0x000EA , 0x00301 },
	{ 0x01EC0 , 0x000CA , 0x00300 },
	{ 0x01EC1 , 0x000EA , 0x00300 },
	{ 0x01EC2 , 0x000CA , 0x00309 },
	{ 0x01EC3 , 0x000EA , 0x00309 },
	{ 0x01EC4 , 0x000CA , 0x00303 },
	{ 0x01EC5 , 0x000EA , 0x00303 },
	{ 0x01EC6 , 0x01EB8 , 0x00302 },
	{ 0x01EC7 , 0x01EB9 , 0x00302 },
	{ 0x01EC8 , 0x00049 , 0x00309 },
	{ 0x01EC9 , 0x00069 , 0x00309 },
	{ 0x01ECA , 0x00049 , 0x00323 },
	{ 0x01ECB , 0x00069 , 0x00323 },
	{ 0x01ECC , 0x0004F , 0x00323 },
	{ 0x01ECD , 0x0006F , 0x00323 },
	{ 0x01ECE , 0x0004F , 0x00309 },
	{ 0x01ECF , 0x0006F , 0x00309 },
	{ 0x01ED0 , 0x000D4 , 0x00301 },
	{ 0x01ED1 , 0x000F4 , 0x00301 },
	{ 0x01ED2 , 0x000D4 , 0x00300 },
	{ 0x01ED3 , 0x000F4 , 0x00300 },
	{ 0x01ED4 , 0x000D4 , 0x00309 },
	{ 0x01ED5 , 0x000F4 , 0x00309 },
	{ 0x01ED6 , 0x000D4 , 0x00303 },
	{ 0x01ED7 , 0x000F4 , 0x00303 },
	{ 0x01ED8 , 0x01ECC , 0x00302 },
	{ 0x01ED9 , 0x01ECD , 0x00302 },
	{ 0x01EDA , 0x001A0 , 0x00301 },
	{ 0x01EDB , 0x001A1 , 0x00301 },
	{ 0x01EDC , 0x001A0 , 0x00300 },
	{ 0x01EDD , 0x001A1 , 0x00300 },
	{ 0x01EDE , 0x001A0 , 0x00309 },
	{ 0x01EDF , 0x001A1 , 0x00309 },
	{ 0x01EE0 , 0x001A0 , 0x00303 },
	{ 0x01EE1 , 0x001A1 , 0x00303 },
	{ 0x01EE2 , 0x001A0 , 0x00323 },
	{ 0x01EE3 , 0x001A1 , 0x00323 },
	{ 0x01EE4 , 0x00055 , 0x00323 },
	{ 0x01EE5 , 0x00075 , 0x00323 },
	{ 0x01EE6 , 0x00055 , 0x00309 },
	{ 0x01EE7 , 0x00075 , 0x00309 },
	{ 0x01EE8 , 0x001AF , 0x00301 },
	{ 0x01EE9 , 0x001B0 , 0x00301 },
	{ 0x01EEA , 0x001AF , 0x00300 },
	{ 0x01EEB , 0x001B0 , 0x00300 },
	{ 0x01EEC , 0x001AF , 0x00309 },
	{ 0x01EED , 0x001B0 , 0x00309 },
	{ 0x01EEE , 0x001AF , 0x00303 },
	{ 0x01EEF , 0x001B0 , 0x00303 },
	{ 0x01EF0 , 0x001AF , 0x00323 },
	{ 0x01EF1 , 0x001B0 , 0x00323 },
	{ 0x01EF2 , 0x00059 , 0x00300 },
	{ 0x01EF3 , 0x00079 , 0x00300 },
	{ 0x01EF4 , 0x00059 , 0x00323 },
	{ 0x01EF5 , 0x00079 , 0x00323 },
	{ 0x01EF6 , 0x00059 , 0x00309 },
	{ 0x01EF7 , 0x00079 , 0x00309 },
	{ 0x01EF8 , 0x00059 , 0x00303 },
	{ 0x01EF9 , 0x00079 , 0x00303 },
	{ 0x01F00 , 0x003B1 , 0x00313 },
	{ 0x01F01 , 0x003B1 , 0x00314 },
	{ 0x01F02 , 0x01F00 , 0x00300 },
	{ 0x01F03 , 0x01F01 , 0x00300 },
	{ 0x01F04 , 0x01F00 , 0x00301 },
	{ 0x01F05 , 0x01F01 , 0x00301 },
	{ 0x01F06 , 0x01F00 , 0x00342 },
	{ 0x01F07 , 0x01F01 , 0x00342 },
	{ 0x01F08 , 0x00391 , 0x00313 },
	{ 0x01F09 , 0x00391 , 0x00314 },
	{ 0x01F0A , 0x01F08 , 0x00300 },
	{ 0x01F0B , 0x01F09 , 0x00300 },
	{ 0x01F0C , 0x01F08 , 0x00301 },
	{ 0x01F0D , 0x01F09 , 0x00301 },
	{ 0x01F0E , 0x01F08 , 0x00342 },
	{ 0x01F0F , 0x01F09 , 0x00342 },
	{ 0x01F10 , 0x003B5 , 0x00313 },
	{ 0x01F11 , 0x003B5 , 0x00314 },
	{ 0x01F12 , 0x01F10 , 0x00300 },
	{ 0x01F13 , 0x01F11 , 0x00300 },
	{ 0x01F14 , 0x01F10 , 0x00301 },
	{ 0x01F15 , 0x01F11 , 0x00301 },
	{ 0x01F18 , 0x00395 , 0x00313 },
	{ 0x01F19 , 0x00395 , 0x00314 },
	{ 0x01F1A , 0x01F18 , 0x00300 },
	{ 0x01F1B , 0x01F19 , 0x00300 },
	{ 0x01F1C , 0x01F18 , 0x00301 },
	{ 0x01F1D , 0x01F19 , 0x00301 },
	{ 0x01F20 , 0x003B7 , 0x00313 },
	{ 0x01F21 , 0x003B7 , 0x00314 },
	{ 0x01F22 , 0x01F20 , 0x00300 },
	{ 0x01F23 , 0x01F21 , 0x00300 },
	{ 0x01F24 , 0x01F20 , 0x00301 },
	{ 0x01F25 , 0x01F21 , 0x00301 },
	{ 0x01F26 , 0x01F20 , 0x00342 },
	{ 0x01F27 , 0x01F21 , 0x00342 },
	{ 0x01F28 , 0x00397 , 0x00313 },
	{ 0x01F29 , 0x00397 , 0x00314 },
	{ 0x01F2A , 0x01F28 , 0x00300 },
	{ 0x01F2B , 0x01F29 , 0x00300 },
	{ 0x01F2C , 0x01F28 , 0x00301 },
	{ 0x01F2D , 0x01F29 , 0x00301 },
	{ 0x01F2E , 0x01F28 , 0x00342 },
	{ 0x01F2F , 0x01F29 , 0x00342 },
	{ 0x01F30 , 0x003B9 , 0x00313 },
	{ 0x01F31 , 0x003B9 , 0x00314 },
	{ 0x01F32 , 0x01F30 , 0x00300 },
	{ 0x01F33 , 0x01F31 , 0x00300 },
	{ 0x01F34 , 0x01F30 , 0x00301 },
	{ 0x01F35 , 0x01F31 , 0x00301 },
	{ 0x01F36 , 0x01F30 , 0x00342 },
	{ 0x01F37 , 0x01F31 , 0x00342 },
	{ 0x01F38 , 0x00399 , 0x00313 },
	{ 0x01F39 , 0x00399 , 0x00314 },
	{ 0x01F3A , 0x01F38 , 0x00300 },
	{ 0x01F3B , 0x01F39 , 0x00300 },
	{ 0x01F3C , 0x01F38 , 0x00301 },
	{ 0x01F3D , 0x01F39 , 0x00301 },
	{ 0x01F3E , 0x01F38 , 0x00342 },
	{ 0x01F3F , 0x01F39 , 0x00342 },
	{ 0x01F40 , 0x003BF , 0x00313 },
	{ 0x01F41 , 0x003BF , 0x00314 },
	{ 0x01F42 , 0x01F40 , 0x00300 },
	{ 0x01F43 , 0x01F41 , 0x00300 },
	{ 0x01F44 , 0x01F40 , 0x00301 },
	{ 0x01F45 , 0x01F41 , 0x00301 },
	{ 0x01F48 , 0x0039F , 0x00313 },
	{ 0x01F49 , 0x0039F , 0x00314 },
	{ 0x01F4A , 0x01F48 , 0x00300 },
	{ 0x01F4B , 0x01F49 , 0x00300 },
	{ 0x01F4C , 0x01F48 , 0x00301 },
	{ 0x01F4D , 0x01F49 , 0x00301 },
	{ 0x01F50 , 0x003C5 , 0x00313 },
	{ 0x01F51 , 0x003C5 , 0x00314 },
	{ 0x01F52 , 0x01F50 , 0x00300 },
	{ 0x01F53 , 0x01F51 , 0x00300 },
	{ 0x01F54 , 0x01F50 , 0x00301 },
	{ 0x01F55 , 0x01F51 , 0x00301 },
	{ 0x01F56 , 0x01F50 , 0x00342 },
	{ 0x01F57 , 0x01F51 , 0x00342 },
	{ 0x01F59 , 0x003A5 , 0x00314 },
	{ 0x01F5B , 0x01F59 , 0x00300 },
	{ 0x01F5D , 0x01F59 , 0x00301 },
	{ 0x01F5F , 0x01F59 , 0x00342 },
	{ 0x01F60 , 0x003C9 , 0x00313 },
	{ 0x01F61 , 0x003C9 , 0x00314 },
	{ 0x01F62 , 0x01F60 , 0x00300 },
	{ 0x01F63 , 0x01F61 , 0x00300 },
	{ 0x01F64 , 0x01F60 , 0x00301 },
	{ 0x01F65 , 0x01F61 , 0x00301 },
	{ 0x01F66 , 0x01F60 , 0x00342 },
	{ 0x01F67 , 0x01F61 , 0x00342 },
	{ 0x01F68 , 0x003A9 , 0x00313 },
	{ 0x01F69 , 0x003A9 , 0x00314 },
	{ 0x01F6A , 0x01F68 , 0x00300 },
	{ 0x01F6B , 0x01F69 , 0x00300 },
	{ 0x01F6C , 0x01F68 , 0x00301 },
	{ 0x01F6D , 0x01F69 , 0x00301 },
	{ 0x01F6E , 0x01F68 , 0x00342 },
	{ 0x01F6F , 0x01F69 , 0x00342 },
	{ 0x01F70 , 0x003B1 , 0x00300 },
	{ 0x01F72 , 0x003B5 , 0x00300 },
	{ 0x01F74 , 0x003B7 , 0x00300 },
	{ 0x01F76 , 0x003B9 , 0x00300 },
	{ 0x01F78 , 0x003BF , 0x00300 },
	{ 0x01F7A , 0x003C5 , 0x00300 },
	{ 0x01F7C , 0x003C9 , 0x00300 },
	{ 0x01F80 , 0x01F00 , 0x00345 },
	{ 0x01F81 , 0x01F01 , 0x00345 },
	{ 0x01F82 , 0x01F02 , 0x00345 },
	{ 0x01F83 , 0x01F03 , 0x00345 },
	{ 0x01F84 , 0x01F04 , 0x00345 },
	{ 0x01F85 , 0x01F05 , 0x00345 },
	{ 0x01F86 , 0x01F06 , 0x00345 },
	{ 0x01F87 , 0x01F07 , 0x00345 },
	{ 0x01F88 , 0x01F08 , 0x00345 },
	{ 0x01F89 , 0x01F09 , 0x00345 },
	{ 0x01F8A , 0x01F0A , 0x00345 },
	{ 0x01F8B , 0x01F0B , 0x00345 },
	{ 0x01F8C , 0x01F0C , 0x00345 },
	{ 0x01F8D , 0x01F0D , 0x00345 },
	{ 0x01F8E , 0x01F0E , 0x00345 },
	{ 0x01F8F , 0x01F0F , 0x00345 },
	{ 0x01F90 , 0x01F20 , 0x00345 },
	{ 0x01F91 , 0x01F21 , 0x00345 },
	{ 0x01F92 , 0x01F22 , 0x00345 },
	{ 0x01F93 , 0x01F23 , 0x00345 },
	{ 0x01F94 , 0x01F24 , 0x00345 },
	{ 0x01F95 , 0x01F25 , 0x00345 },
	{ 0x01F96 , 0x01F26 , 0x00345 },
	{ 0x01F97 , 0x01F27 , 0x00345 },
	{ 0x01F98 , 0x01F28 , 0x00345 },
	{ 0x01F99 , 0x01F29 , 0x00345 },
	{ 0x01F9A , 0x01F2A , 0x00345 },
	{ 0x01F9B , 0x01F2B , 0x00345 },
	{ 0x01F9C , 0x01F2C , 0x00345 },
	{ 0x01F9D , 0x01F2D , 0x00345 },
	{ 0x01F9E , 0x01F2E , 0x00345 },
	{ 0x01F9F , 0x01F2F , 0x00345 },
	{ 0x01FA0 , 0x01F60 , 0x00345 },
	{ 0x01FA1 , 0x01F61 , 0x00345 },
	{ 0x01FA2 , 0x01F62 , 0x00345 },
	{ 0x01FA3 , 0x01F63 , 0x00345 },
	{ 0x01FA4 , 0x01F64 , 0x00345 },
	{ 0x01FA5 , 0x01F65 , 0x00345 },
	{ 0x01FA6 , 0x01F66 , 0x00345 },
	{ 0x01FA7 , 0x01F67 , 0x00345 },
	{ 0x01FA8 , 0x01F68 , 0x00345 },
	{ 0x01FA9 , 0x01F69 , 0x00345 },
	{ 0x01FAA , 0x01F6A , 0x00345 },
	{ 0x01FAB , 0x01F6B , 0x00345 },
	{ 0x01FAC , 0x01F6C , 0x00345 },
	{ 0x01FAD , 0x01F6D , 0x00345 },
	{ 0x01FAE , 0x01F6E , 0x00345 },
	{ 0x01FAF , 0x01F6F , 0x00345 },
	{ 0x01FB0 , 0x003B1 , 0x00306 },
	{ 0x01FB1 , 0x003B1 , 0x00304 },
	{ 0x01FB2 , 0x01F70 , 0x00345 },
	{ 0x01FB3 , 0x003B1 , 0x00345 },
	{ 0x01FB4 , 0x003AC , 0x00345 },
	{ 0x01FB6 , 0x003B1 , 0x00342 },
	{ 0x01FB7 , 0x01FB6 , 0x00345 },
	{ 0x01FB8 , 0x00391 , 0x00306 },
	{ 0x01FB9 , 0x00391 , 0x00304 },
	{ 0x01FBA , 0x00391 , 0x00300 },
	{ 0x01FBC , 0x00391 , 0x00345 },
	{ 0x01FC1 , 0x000A8 , 0x00342 },
	{ 0x01FC2 , 0x01F74 , 0x00345 },
	{ 0x01FC3 , 0x003B7 , 0x00345 },
	{ 0x01FC4 , 0x003AE , 0x00345 },
	{ 0x01FC6 , 0x003B7 , 0x00342 },
	{ 0x01FC7 , 0x01FC6 , 0x00345 },
	{ 0x01FC8 , 0x00395 , 0x00300 },
	{ 0x01FCA , 0x00397 , 0x00300 },
	{ 0x01FCC , 0x00397 , 0x00345 },
	{ 0x01FCD , 0x01FBF , 0x00300 },
	{ 0x01FCE , 0x01FBF , 0x00301 },
	{ 0x01FCF , 0x01FBF , 0x00342 },
	{ 0x01FD0 , 0x003B9 , 0x00306 },
	{ 0x01FD1 , 0x003B9 , 0x00304 },
	{ 0x01FD2 , 0x003CA , 0x00300 },
	{ 0x01FD6 , 0x003B9 , 0x00342 },
	{ 0x01FD7 , 0x003CA , 0x00342 },
	{ 0x01FD8 , 0x00399 , 0x00306 },
	{ 0x01FD9 , 0x00399 , 0x00304 },
	{ 0x01FDA , 0x00399 , 0x00300 },
	{ 0x01FDD , 0x01FFE , 0x00300 },
	{ 0x01FDE , 0x01FFE , 0x00301 },
	{ 0x01FDF , 0x01FFE , 0x00342 },
	{ 0x01FE0 , 0x003C5 , 0x00306 },
	{ 0x01FE1 , 0x003C5 , 0x00304 },
	{ 0x01FE2 , 0x003CB , 0x00300 },
	{ 0x01FE4 , 0x003C1 , 0x00313 },
	{ 0x01FE5 , 0x003C1 , 0x00314 },
	{ 0x01FE6 , 0x003C5 , 0x00342 },
	{ 0x01FE7 , 0x003CB , 0x00342 },
	{ 0x01FE8 , 0x003A5 , 0x00306 },
	{ 0x01FE9 , 0x003A5 , 0x00304 },
	{ 0x01FEA , 0x003A5 , 0x00300 },
	{ 0x01FEC , 0x003A1 , 0x00314 },
	{ 0x01FED , 0x000A8 , 0x00300 },
	{ 0x01FF2 , 0x01F7C , 0x00345 },
	{ 0x01FF3 , 0x003C9 , 0x00345 },
	{ 0x01FF4 , 0x003CE , 0x00345 },
	{ 0x01FF6 , 0x003C9 , 0x00342 },
	{ 0x01FF7 , 0x01FF6 , 0x00345 },
	{ 0x01FF8 , 0x0039F , 0x00300 },
	{ 0x01FFA , 0x003A9 , 0x00300 },
	{ 0x01FFC , 0x003A9 , 0x00345 },
	{ 0x0219A , 0x02190 , 0x00338 },
	{ 0x0219B , 0x02192 , 0x00338 },
	{ 0x021AE , 0x02194 , 0x00338 },
	{ 0x021CD , 0x021D0 , 0x00338 },
	{ 0x021CE , 0x021D4 , 0x00338 },
	{ 0x021CF , 0x021D2 , 0x00338 },
	{ 0x02204 , 0x02203 , 0x00338 },
	{ 0x02209 , 0x02208 , 0x00338 },
	{ 0x0220C , 0x0220B , 0x00338 },
	{ 0x02224 , 0x02223 , 0x00338 },
	{ 0x02226 , 0x02225 , 0x00338 },
	{ 0x02241 , 0x0223C , 0x00338 },
	{ 0x02244 , 0x02243 , 0x00338 },
	{ 0x02247 , 0x02245 , 0x00338 },
	{ 0x02249 , 0x02248 , 0x00338 },
	{ 0x02260 , 0x0003D , 0x00338 },
	{ 0x02262 , 0x02261 , 0x00338 },
	{ 0x0226D , 0x0224D , 0x00338 },
	{ 0x0226E , 0x0003C , 0x00338 },
	{ 0x0226F , 0x0003E , 0x00338 },
	{ 0x02270 , 0x02264 , 0x00338 },
	{ 0x02271 , 0x02265 , 0x00338 },
	{ 0x02274 , 0x02272 , 0x00338 },
	{ 0x02275 , 0x02273 , 0x00338 },
	{ 0x02278 , 0x02276 , 0x00338 },
	{ 0x02279 , 0x02277 , 0x00338 },
	{ 0x02280 , 0x0227A , 0x00338 },
	{ 0x02281 , 0x0227B , 0x00338 },
	{ 0x02284 , 0x02282 , 0x00338 },
	{ 0x02285 , 0x02283 , 0x00338 },
	{ 0x02288 , 0x02286 , 0x00338 },
	{ 0x02289 , 0x02287 , 0x00338 },
	{ 0x022AC , 0x022A2 , 0x00338 },
	{ 0x022AD , 0x022A8 , 0x00338 },
	{ 0x022AE , 0x022A9 , 0x00338 },
	{ 0x022AF , 0x022AB , 0x00338 },
	{ 0x022E0 , 0x0227C , 0x00338 },
	{ 0x022E1 , 0x0227D , 0x00338 },
	{ 0x022E2 , 0x02291 , 0x00338 },
	{ 0x022E3 , 0x02292 , 0x00338 },
	{ 0x022EA , 0x022B2 , 0x00338 },
	{ 0x022EB , 0x022B3 , 0x00338 },
	{ 0x022EC , 0x022B4 , 0x00338 },
	{ 0x022ED , 0x022B5 , 0x00338 },
	{ 0x0304C , 0x0304B , 0x03099 },
	{ 0x0304E , 0x0304D , 0x03099 },
	{ 0x03050 , 0x0304F , 0x03099 },
	{ 0x03052 , 0x03051 , 0x03099 },
	{ 0x03054 , 0x03053 , 0x03099 },
	{ 0x03056 , 0x03055 , 0x03099 },
	{ 0x03058 , 0x03057 , 0x03099 },
	{ 0x0305A , 0x03059 , 0x03099 },
	{ 0x0305C , 0x0305B , 0x03099 },
	{ 0x0305E , 0x0305D , 0x03099 },
	{ 0x03060 , 0x0305F , 0x03099 },
	{ 0x03062 , 0x03061 , 0x03099 },
	{ 0x03065 , 0x03064 , 0x03099 },
	{ 0x03067 , 0x03066 , 0x03099 },
	{ 0x03069 , 0x03068 , 0x03099 },
	{ 0x03070 , 0x0306F , 0x03099 },
	{ 0x03071 , 0x0306F , 0x0309A },
	{ 0x03073 , 0x03072 , 0x03099 },
	{ 0x03074 , 0x03072 , 0x0309A },
	{ 0x03076 , 0x03075 , 0x03099 },
	{ 0x03077 , 0x03075 , 0x0309A },
	{ 0x03079 , 0x03078 , 0x03099 },
	{ 0x0307A , 0x03078 , 0x0309A },
	{ 0x0307C , 0x0307B , 0x03099 },
	{ 0x0307D , 0x0307B , 0x0309A },
	{ 0x03094 , 0x03046 , 0x03099 },
	{ 0x0309E , 0x0309D , 0x03099 },
	{ 0x030AC , 0x030AB , 0x03099 },
	{ 0x030AE , 0x030AD , 0x03099 },
	{ 0x030B0 , 0x030AF , 0x03099 },
	{ 0x030B2 , 0x030B1 , 0x03099 },
	{ 0x030B4 , 0x030B3 , 0x03099 },
	{ 0x030B6 , 0x030B5 , 0x03099 },
	{ 0x030B8 , 0x030B7 , 0x03099 },
	{ 0x030BA , 0x030B9 , 0x03099 },
	{ 0x030BC , 0x030BB , 0x03099 },
	{ 0x030BE , 0x030BD , 0x03099 },
	{ 0x030C0 , 0x030BF , 0x03099 },
	{ 0x030C2 , 0x030C1 , 0x03099 },
	{ 0x030C5 , 0x030C4 , 0x03099 },
	{ 0x030C7 , 0x030C6 , 0x03099 },
	{ 0x030C9 , 0x030C8 , 0x03099 },
	{ 0x030D0 , 0x030CF , 0x03099 },
	{ 0x030D1 , 0x030CF , 0x0309A },
	{ 0x030D3 , 0x030D2 , 0x03099 },
	{ 0x030D4 , 0x030D2 , 0x0309A },
	{ 0x030D6 , 0x030D5 , 0x03099 },
	{ 0x030D7 , 0x030D5 , 0x0309A },
	{ 0x030D9 , 0x030D8 , 0x03099 },
	{ 0x030DA , 0x030D8 , 0x0309A },
	{ 0x030DC , 0x030DB , 0x03099 },
	{ 0x030DD , 0x030DB , 0x0309A },
	{ 0x030F4 , 0x030A6 , 0x03099 },
	{ 0x030F7 , 0x030EF , 0x03099 },
	{ 0x030F8 , 0x030F0 , 0x03099 },
	{ 0x030F9 , 0x030F1 , 0x03099 },
	{ 0x030FA , 0x030F2 , 0x03099 },
	{ 0x030FE , 0x030FD , 0x03099 },
	{ 0x1109A , 0x11099 , 0x110BA },
	{ 0x1109C , 0x1109B , 0x110BA },
	{ 0x110AB , 0x110A5 , 0x110BA },
};

#endif /* !ARCHIVE_STRING_COMPOSITION_H_INCLUDED */
