--- build/env.cmake.orig	2023-07-10 16:23:35 UTC
+++ build/env.cmake
@@ -69,11 +69,21 @@ if ( ${CMAKE_HOST_SYSTEM_NAME} STREQUAL  "Darwin" )
     set(LIBPFX "lib")
     set(SHLX "dylib")
     set(STLX "a")
+elseif ( ${CMAKE_HOST_SYSTEM_NAME} STREQUAL  "FreeBSD" )
+    set(OS "bsd")
+    set(LIBPFX "lib")
+    set(SHLX "so")
+    set(STLX "a")
 elseif ( ${CMAKE_HOST_SYSTEM_NAME} STREQUAL  "Linux" )
     set(OS "linux")
     set(LIBPFX "lib")
     set(SHLX "so")
     set(STLX "a")
+elseif ( ${CMAKE_HOST_SYSTEM_NAME} STREQUAL  "NetBSD" )
+    set(OS "bsd")
+    set(LIBPFX "lib")
+    set(SHLX "so")
+    set(STLX "a")
 elseif ( ${CMAKE_HOST_SYSTEM_NAME} STREQUAL  "Windows" )
     set(OS "windows")
     set(LIBPFX "")
@@ -91,6 +101,8 @@ elseif ( ${CMAKE_HOST_SYSTEM_PROCESSOR} STREQUAL "aarc
     set(ARCH "arm64")
 elseif ( ${CMAKE_HOST_SYSTEM_PROCESSOR} STREQUAL "x86_64")
     set(ARCH "x86_64")
+elseif ( ${CMAKE_HOST_SYSTEM_PROCESSOR} STREQUAL "amd64")
+    set(ARCH "x86_64")
 elseif ( ${CMAKE_HOST_SYSTEM_PROCESSOR} STREQUAL "AMD64")
     set(ARCH "x86_64")
 else()
@@ -98,7 +110,11 @@ else()
 endif ()
 
 # create variables based entirely upon OS
-if ( "mac" STREQUAL ${OS} )
+if ( "bsd" STREQUAL ${OS} )
+    add_compile_definitions( BSD UNIX )
+    set( LMCHECK "" )
+    set( EXE "" )
+elseif ( "mac" STREQUAL ${OS} )
     add_compile_definitions( MAC BSD UNIX )
     set( LMCHECK "" )
     set( EXE "" )
@@ -380,6 +396,9 @@ endif()
 
 if ( "mac" STREQUAL ${OS} )
     include_directories(${VDB_INTERFACES_DIR}/os/mac)
+    include_directories(${VDB_INTERFACES_DIR}/os/unix)
+elseif( "bsd" STREQUAL ${OS} )
+    include_directories(${VDB_INTERFACES_DIR}/os/bsd)
     include_directories(${VDB_INTERFACES_DIR}/os/unix)
 elseif( "linux" STREQUAL ${OS} )
     include_directories(${VDB_INTERFACES_DIR}/os/linux)
