Propposed patch from comment #3
https://bugzilla.xfce.org/show_bug.cgi?id=13997

From 58e4bb4d3b982876dec33d55003d591559439598 Mon Sep 17 00:00:00 2001
From: Stefan Seyfried <seife+dev@b1-systems.com>
Date: Sat, 3 Mar 2018 20:25:24 +0100
Subject: [PATCH] fix build with libical version 3

---
 src/ical-code.c | 12 ++++++++++++
 1 file changed, 12 insertions(+)

diff --git a/src/ical-code.c b/src/ical-code.c
index d5831404..c40042c3 100644
--- src/ical-code.c
+++ src/ical-code.c
@@ -2579,7 +2579,9 @@ static struct icaltimetype count_first_alarm_time(xfical_period per
  * when counting alarm time. */
         if (rel == ICAL_RELATED_START) {
             per.stime.is_date       = 0;
+#if ICAL_MAJOR_VERSION < 3
             per.stime.is_utc        = 1;
+#endif
             per.stime.is_daylight   = 0;
             per.stime.zone          = utc_icaltimezone;
             per.stime.hour          = 0;
@@ -2588,7 +2590,9 @@ static struct icaltimetype count_first_alarm_time(xfical_period per
         }
         else {
             per.etime.is_date       = 0;
+#if ICAL_MAJOR_VERSION < 3
             per.etime.is_utc        = 1;
+#endif
             per.etime.is_daylight   = 0;
             per.etime.zone          = utc_icaltimezone;
             per.etime.hour          = 0;
@@ -2613,7 +2617,9 @@ static struct icaltimetype count_next_alarm_time(struct icaltimetype start_time
 /* HACK: convert to UTC time so that we can use time arithmetic
  * when counting alarm time. */
         start_time.is_date       = 0;
+#if ICAL_MAJOR_VERSION < 3
         start_time.is_utc        = 1;
+#endif
         start_time.is_daylight   = 0;
         start_time.zone          = utc_icaltimezone;
         start_time.hour          = 0;
@@ -2768,7 +2774,9 @@ static alarm_struct *process_alarm_trigger(icalcomponent *c
      */
     if (icaltime_is_date(per.stime)) {
         if (local_icaltimezone != utc_icaltimezone) {
+#if ICAL_MAJOR_VERSION < 3
             next_alarm_time.is_utc        = 0;
+#endif
             next_alarm_time.is_daylight   = 0;
             next_alarm_time.zone          = local_icaltimezone;
         }
@@ -2850,7 +2858,9 @@ orage_message(120, P_N "Alarm rec loop next_start:%s next_alarm:%s per.stime:%s"
          */
         if (icaltime_is_date(per.stime)) {
             if (local_icaltimezone != utc_icaltimezone) {
+#if ICAL_MAJOR_VERSION < 3
                 next_alarm_time.is_utc        = 0;
+#endif
                 next_alarm_time.is_daylight   = 0;
                 next_alarm_time.zone          = local_icaltimezone;
             }
@@ -2944,7 +2954,9 @@ orage_message(120, P_N "*****After loop Alarm %s %s", icaltime_as_ical_string(ne
          */
         if (icaltime_is_date(per.stime)) {
             if (local_icaltimezone != utc_icaltimezone) {
+#if ICAL_MAJOR_VERSION < 3
                 next_alarm_time.is_utc        = 0;
+#endif
                 next_alarm_time.is_daylight   = 0;
                 next_alarm_time.zone          = local_icaltimezone;
             }
-- 
2.16.2

