#
# Code to build Tcl package library. Defines the proc `buildpackageindex'.
#
proc TCHSH:PutLibLine {outfp package libfile where endwhere autoprocs} {
    puts $outfp [format "TCLSH:defpkg %s %s %s %s %s" $package $libfile \
                        $where [expr {$endwhere - $where - 1}] $autoprocs]
}


proc TCLSH:CreateLibIndex {libName} {

    if {[file extension $libName] != ".tlib"} {
        error "Package library `$libName' does not have the extension `.tlib'"}
    set idxName "[file root $libName].tndx"
    if {(![file writable [file dirname $idxName]]) ||
            ([file exists $idxName] && (![file writable $idxName]))} {
        error "No write access to build package index: `$idxName'"}
    set libFH [open $libName r]
    set idxFH [open $idxName w]

    set contectHdl [scancontext create]

    scanmatch $contectHdl "^#@package: " {
        set size [llength $matchInfo(line)]
        if {$size < 2} {
            error [format "invalid package header \"%s\"" $matchInfo(line)]
        }
        if {[info exists pkgDefName]} {
            TCHSH:PutLibLine $idxFH $pkgDefName $libName $pkgDefWhere \
                             $matchInfo(offset) $pkgDefProcs
        }
        set pkgDefName   [lindex $matchInfo(line) 1]
        set pkgDefWhere  [tell $matchInfo(handle)]
        set pkgDefProcs  [lrange $matchInfo(line) 2 end]
    }

    scanfile $contectHdl $libFH

    TCHSH:PutLibLine $idxFH $pkgDefName $libName $pkgDefWhere [tell $libFH] \
                     $pkgDefProcs
    close $libFH
    close $idxFH
    
    scancontext delete $contectHdl

    # Set mode and ownership of the index to be the same as the library.

    file stat $libName statInfo
    chmod -i $statInfo(mode) $idxName
    chown [list $statInfo(uid) $statInfo(gid)] $idxName

}

proc buildpackageindex {libfile} {

    set status [catch {TCLSH:CreateLibIndex $libfile} errmsg]
    if {$status != 0} {
        global errorInfo errorCode
        error "building package index for `$libfile': $errmsg" $errorInfo \
              $errorCode
    }
}

