

#include <sys/types.h>
#include <sys/security.h>
#include <sys/audit.h>
#include <prot.h>

#include "tclExtdInt.h"
#include "tcl.h"

static int
Tcl_AuthGetUserCmd (clientData, interp, argc, argv)
    char        *clientData;
    Tcl_Interp  *interp;
    int          argc;
    char       **argv;
{
    if (argc != 2) {
	Tcl_AppendResult (interp, "bad # arg: ", argv[0],
	   " user", (char *)NULL);
	return TCL_ERROR;
    }
    agetuser(argv[1]);
    Tcl_Return (interp, agetuser(argv[1]), TCL_VOLATILE);
}

void
Tcl_InitAuthCmds (interp)
    Tcl_Interp *interp;
{
    Tcl_CreateCommand (interp, "auth_getuser", Tcl_AuthGetUserCmd, (ClientData)NULL,
                      (void (*)())NULL);


}

