
class ManualPage
{
public:
  const char * const pagename;
  const char * const filename;
  ManualPage (const char *apagename, const char *afilename);
};

class ManualSection
{
  int allocation;
  int npages;
  ManualPage **pages;
  void read_dir(const char *dirname);
public:
  const char * const section_name;
  ManualSection (const char *asection_name);
  int count () const { return npages; }
  const ManualPage *man_page (int nth) const { return pages [nth]; }
  void addmanpage (const char *pagename, const char *dir,
		   const char *filename);
};

class Manual
{
  int allocation;
  int nsections;
  ManualSection **sections;
public:
  int count_of_sections() const { return nsections; }
  const char *get_section_name(int nth) const 
    { return sections[nth]->section_name; }
  const ManualSection *get_manual_section(int nth) const
    { return sections[nth]; }
  void addmanpage(const char *pagename, const char *section,
		  const char *dir, const char *filename);
  Manual();
  void read_dir(const char *dir);
};

extern Manual manual;
