{$R+,S+,I+,D+,T-,F-,V-,B-,N-,L+ }
{$M 16384,16384,16384 }

PROGRAM KTOOLSDEMO;

USES
    DOS,
    CRT,
    KTOOLS;

VAR
    Regs  : Registers;
    Str255: String;
    Str2  : String[2];
    Str80 : String[80];
    FAttr : Byte;
    Ch    : Char;
    Lines : array[1..6] OF Byte;
    L,Z   : Integer;
    YesNo : Boolean;
    Fore,Back : Integer;
    MyScreen : SaveScrType; {defined in ktools.tpu as array[1..4004] of byte }
    MyMenu : Array[1..9] of MenuItemType; {menuitemtype defined in ktools.tpu}
                                          {as string[30]                     }
    MyDesc : Array[1..9] of MenuDescType; {menudesctype defined in ktools.tpu}
                                          {as string[80]                     }

BEGIN

   ClrScr;

   CursorOff;

   Randomize;

   KWrite(2,1,15,'This line is passed as actual param. to KWrite');

   Str80:='Hello world, I''m Drue Kennon! was passed as a variable.';

   KWriteV(5,1,12,Str80);

   KWrite(8,1,15,'Next line is actual & centered');

   KWriteC(9,11,'Hello world, I''m Drue Kennon!');

   Str80:='Hello World, I''m a centered variable.';

   KWrite(11,1,15,'Next line is varriable & centered');

   KWriteCV(12,6,Str80);

   Str80:='          I have 10 leading blanks and 10 trailing ones          ';

   KWriteV(14,1,4,Str80);

   KTrim(Str80);

   KWrite(16,1,15, KUCase('now I have none on either side of me!') );

   Kwrite(18,1,3,Str80);

   KWrite(20,1,15,'Now to change the attributes of these lines!');

   KWrite(22,1,15,'Press any key to fill the screen via (KFill)');
   NEW(MyScreen);
   KSaveScr(1,1,25,80,MyScreen);

   Delay(5000);

   Lines[1]:=2;
   Lines[2]:=5;
   Lines[3]:=9;
   Lines[4]:=12;
   Lines[5]:=14;
   Lines[6]:=16;

   REPEAT
      FOR Z := 0 TO 15 DO
      FOR L := 1 To 6 DO KAttr(Lines[l],1,1,80,Z);
   UNTIL KeyPressed;

   Ch := ReadKey; {swallow keypressed character}

   CRT.TextAttr := Random(127) OR 128;   {CRT. before TextAttr isn't necessary}
   KFill(5,10,15,60,'*',TextAttr);       {I used it only for clarity}
   Delay(3000);
   CRT.TextAttr := CRT.TextAttr MOD 128;
   KFill(5,10,15,60,'*',TextAttr);
   TextAttr := 7; {We'll put it back to it's normal attr after we play}

   CursorOn;

   KWrite(22,1,color(15,0),'                                                                      ');
   KWrite(23,1,15,'Enter a foreground color i.e. 10, 13 etc...: ');
   Read(Fore);

   KWrite(23,1,color(15,0),'                                                                      ');
   Str80 := '';
   Str80 := 'Enter a background color i.e. 0, 5 etc...: ';
   KTrim(Str80);
   KWriteV(23,1,15,Str80);
   Read(Back);

   FAttr := Color(Fore,Back);
   KFill(5,10,15,60,'*',FAttr);

   MyMenu[1]:=' Turbo Pascal    ';
   MyMenu[2]:=' Turbo Basic     ';
   MyMenu[3]:=' Turbo "C"       ';
   MyMenu[4]:=' Turbo Lightning ';
   MyMenu[5]:=' Turbo Prolog    ';
   MyMenu[6]:=' Pascal ';
   MyMenu[7]:=' Basic  ';
   MyMenu[8]:='  "C"   ';
   MyMenu[9]:=' ProLog ';
   MyDesc[1]:='This is BORLAND''s Turbo Pascal Language';
   MyDesc[2]:='This is BORLAND''s Turbo Basic Language';
   MyDesc[3]:='This is BORLAND''s Turbo "C" Language';
   MyDesc[4]:='This is BORLAND''s Turbo Lightning a word processor utility';
   MyDesc[5]:='This is BORLAND''s Turbo Prolog Language';
   MyDesc[6]:='This is description number # 6 and the first item on menu page 2.';
   MyDesc[7]:='This is description number # 7 and the second item on menu page 2';
   MyDesc[8]:='This is description number # 8 and the third item on menu page 2';
   MyDesc[9]:='This is description number # 9 and the last menuitem; menuitemtotal=9';
   CursorOff;

   KBox(7,29,11,19,Color(Yellow,Blue),15,Border2,True);
   L := KVertMenu(2,MyMenu,9,30,8,30,17,15,Color(White,Red));

   KWrite(20,1,15,'                                                                             ');
   KWrite(20,23,15,'Your Menu Selection Choice was ');
   Str(L,Str80);
   Kwrite(20,54,12,Str80);

   KWrite(22,1,15,'                                                                             ');
   KWrite(23,1,15,'                                                                             ');
   For L := 1 TO 9 DO KTrim (MyMenu[L]);
   KBox(21,4,4,72,45,15,border5,false);
   L := KHorizMenu(1,mymenu,mydesc,9,70,5,22,14,Color(White,Red),12);

{  Just to be cute, let's use BIOS to scroll the screen up one row and make
   room for our statement on line 24 without messing up our menu border.     }
   Regs.AH:=$06;  { scroll function }
   Regs.AL:=1;    { rows to scroll  }
   Regs.CH:=3;    { top row number  }
   Regs.CL:=0;    { top col number  }
   Regs.DH:=24;   { bottom row number }
   Regs.DL:=79;   { bottom col number }
   Regs.BH:=15;   { attribute for cleared lines }
   Intr($10,Regs);{ call the interrupt }

   KWrite(24,1,15,'                                                                             ');
   KWrite(24,23,15,'Your Menu Selection Choice was ');
   Str(L,Str80);
   Kwrite(24,54,12,Str80);

   KBox(1,1,25,80,55,15,border4,false);

   delay(3000);

   KRestoreScr(MyScreen);
   DISPOSE(MyScreen);

   Delay(5000);

   {  Lets see that scroll feature one more time  }
   Regs.AH:=$06;  { scroll function }
   Regs.AL:=25;   { rows to scroll  }
   Regs.CH:=0;    { top row number  }
   Regs.CL:=0;    { top col number  }
   Regs.DH:=24;   { bottom row number }
   Regs.DL:=79;   { bottom col number }
   Regs.BH:=15;   { attribute for cleared lines }
   Intr($10,Regs); { call the interrupt }

   (*
      actually it will happen so fast it will simply look like you called a
      clear screen statement, which is why I used it.  Just to show another
      way you can use BIOS and what it can do.

      If you think this would be useful in your programming then you should
      set the code in a procedure like the one below and simply pass the
      information to it.
   *)


   KWrite(5,1,15,'Press any key to continue...');
   Ch := ReadKey;

   Str2 := KUCase(ParamStr(1));
   Ch := Str2[1];
   IF Ch IN['A'..'F'] THEN
   BEGIN
      YesNo := KUCase(ParamStr(2))='TRUE';

      Str255 := PikDir(ParamStr(1)+'\*.*',YesNo);

      KTrim(Str255);
      Str255:=KLCase(Str255);
      Str255 := 'You chose <<  '+Str255+'  >>';
      KTrim(Str255);
      KWrite(10,1,13,Str255);
   END;

   TextAttr:=15;
   KWrite(15,34,14+128,'<< THE END >>');
   CursorOn;
   Halt;

End.

(*

PROCEDURE Scroll(AL,CH,CL,DH,DL,BH:Byte);
BEGIN
   Regs.AH:=$06; { scroll function }
   Regs.AL:=AL; { rows to scroll  }
   Regs.CH:=CH; { top row number  }
   Regs.CL:=CL; { top col number  }
   Regs.DH:=DH; { bottom row number }
   Regs.DL:=DL; { bottom col number }
   Regs.BH:=BH; { attribute for cleared lines }
   Intr($10,Regs); { call the interrupt }
END;

*)