VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{85155D8C-9F30-46FD-BD68-045EFC85CE9A}#1.0#0"; "ThumbEx.ocx"
Begin VB.Form Form1 
   Caption         =   "Thumbnailer ActiveX control sample project by Inspired Creations"
   ClientHeight    =   7020
   ClientLeft      =   120
   ClientTop       =   405
   ClientWidth     =   11580
   ForeColor       =   &H8000000F&
   Icon            =   "Form1.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   7020
   ScaleWidth      =   11580
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin MSComDlg.CommonDialog Dlg 
      Left            =   -30
      Top             =   6540
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.Frame Frame9 
      Caption         =   "Item info"
      Height          =   1290
      Left            =   60
      TabIndex        =   60
      Top             =   4425
      Width           =   2400
      Begin VB.CommandButton cmdItemInfo 
         Caption         =   "Show Item info"
         Height          =   390
         Left            =   150
         TabIndex        =   39
         ToolTipText     =   "Shows information for the specified item above"
         Top             =   780
         Width           =   2145
      End
      Begin VB.TextBox txtItemInfo 
         Height          =   300
         Left            =   750
         TabIndex        =   38
         ToolTipText     =   "Name of the Item that we wish to retrieve info"
         Top             =   270
         Width           =   1530
      End
      Begin VB.Label lblCaption 
         AutoSize        =   -1  'True
         Caption         =   "Name :"
         Height          =   195
         Index           =   7
         Left            =   150
         TabIndex        =   61
         Top             =   315
         Width           =   510
      End
   End
   Begin VB.Frame Frame6 
      Caption         =   "Selected Item"
      Height          =   1320
      Left            =   60
      TabIndex        =   59
      Top             =   3000
      Width           =   2400
      Begin VB.CommandButton cmdExport 
         Caption         =   "Export"
         Height          =   330
         Left            =   1590
         TabIndex        =   37
         ToolTipText     =   "Export the Selected item as BMP file"
         Top             =   870
         Width           =   690
      End
      Begin VB.CommandButton cmdSetSelected 
         Caption         =   "Set it"
         Height          =   330
         Left            =   1590
         TabIndex        =   34
         ToolTipText     =   "Set the Selected item to the specified index or name"
         Top             =   270
         Width           =   690
      End
      Begin VB.OptionButton optExport 
         Caption         =   "Clear"
         Height          =   225
         Index           =   0
         Left            =   135
         TabIndex        =   35
         ToolTipText     =   "Export the clear thumbnail graphic"
         Top             =   930
         Value           =   -1  'True
         Width           =   720
      End
      Begin VB.OptionButton optExport 
         Caption         =   "Full"
         Height          =   225
         Index           =   1
         Left            =   885
         TabIndex        =   36
         ToolTipText     =   "Export the full thumbnail (included Offset)"
         Top             =   930
         Width           =   720
      End
      Begin VB.TextBox txtSelected 
         Height          =   300
         Left            =   135
         TabIndex        =   33
         ToolTipText     =   "Index or Name of the Selected item"
         Top             =   285
         Width           =   1365
      End
      Begin VB.Line Line2 
         BorderColor     =   &H80000014&
         X1              =   150
         X2              =   2250
         Y1              =   720
         Y2              =   720
      End
   End
   Begin VB.Frame Frame10 
      Caption         =   "Events"
      Height          =   2910
      Left            =   8115
      TabIndex        =   57
      Top             =   60
      Width           =   3390
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   270
         Left            =   2550
         TabIndex        =   32
         Top             =   2370
         Width           =   795
      End
      Begin VB.CheckBox chkEventsAll 
         Caption         =   "Show ""MouseMove"" and ""HitTest"""
         Height          =   195
         Left            =   120
         TabIndex        =   31
         Top             =   2655
         Width           =   2925
      End
      Begin VB.CheckBox chkEvents 
         Caption         =   "Show events"
         Height          =   195
         Left            =   120
         TabIndex        =   30
         Top             =   2385
         Value           =   1  'Checked
         Width           =   1320
      End
      Begin VB.TextBox txtEvents 
         Height          =   2085
         Left            =   90
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   29
         Top             =   240
         Width           =   3225
      End
   End
   Begin VB.Frame Frame8 
      Caption         =   "Info"
      Height          =   1095
      Left            =   60
      TabIndex        =   52
      Top             =   5850
      Width           =   2400
      Begin VB.Label lblCaption 
         AutoSize        =   -1  'True
         Caption         =   "Last drawn index :"
         Height          =   195
         Index           =   9
         Left            =   225
         TabIndex        =   56
         Top             =   690
         Width           =   1290
      End
      Begin VB.Label lblLastDrawn 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   1590
         TabIndex        =   55
         ToolTipText     =   "Last drawn item's index"
         Top             =   675
         Width           =   690
      End
      Begin VB.Label lblItems 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   1590
         TabIndex        =   54
         ToolTipText     =   "Number of Thumbnails"
         Top             =   270
         Width           =   690
      End
      Begin VB.Label lblCaption 
         AutoSize        =   -1  'True
         Caption         =   "Thumbnails :"
         Height          =   195
         Index           =   8
         Left            =   615
         TabIndex        =   53
         Top             =   285
         Width           =   900
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Properties"
      Height          =   2895
      Left            =   60
      TabIndex        =   44
      Top             =   75
      Width           =   8010
      Begin VB.CommandButton cmdBkItemColor 
         Caption         =   "Item BackColor"
         Height          =   270
         Left            =   4275
         TabIndex        =   19
         ToolTipText     =   "Sets the Back color of the thumbnails"
         Top             =   2550
         Width           =   1935
      End
      Begin VB.CommandButton cmdBkColor 
         Caption         =   "BackColor"
         Height          =   270
         Left            =   4275
         TabIndex        =   18
         ToolTipText     =   "Sets the Back color of the control"
         Top             =   2265
         Width           =   1935
      End
      Begin VB.Frame Frame7 
         Height          =   2685
         Left            =   6270
         TabIndex        =   51
         Top             =   120
         Width           =   1650
         Begin VB.CheckBox chkPropFSO 
            Caption         =   "FSOEnable"
            Height          =   225
            Left            =   135
            TabIndex        =   27
            ToolTipText     =   "Synchronizes actions on items and files"
            Top             =   2100
            Width           =   1110
         End
         Begin VB.CheckBox chkPropDelete 
            Caption         =   "CanDelete"
            Height          =   225
            Left            =   135
            TabIndex        =   26
            ToolTipText     =   "Enable/disable items removal"
            Top             =   1839
            Width           =   1110
         End
         Begin VB.CheckBox chkPropReadOnly 
            Caption         =   "Show ReadOnly"
            Height          =   225
            Left            =   135
            TabIndex        =   23
            ToolTipText     =   "Include files marked with the specified attribute"
            Top             =   987
            Value           =   1  'Checked
            Width           =   1470
         End
         Begin VB.CheckBox chkPropDragDrop 
            Caption         =   "DragDrop"
            Height          =   255
            Left            =   135
            TabIndex        =   24
            ToolTipText     =   "Enable/disable Drag and Drop operations"
            Top             =   1251
            Width           =   1065
         End
         Begin VB.CheckBox chkPropLabelEdit 
            Caption         =   "LabelEdit"
            Height          =   255
            Left            =   135
            TabIndex        =   25
            ToolTipText     =   "Enable/disable label editing and item's renaming"
            Top             =   1545
            Width           =   1065
         End
         Begin VB.CheckBox chkPropHidden 
            Caption         =   "Show Hidden"
            Height          =   225
            Left            =   135
            TabIndex        =   21
            ToolTipText     =   "Include files marked with the specified attribute"
            Top             =   459
            Value           =   1  'Checked
            Width           =   1305
         End
         Begin VB.CheckBox chkPropSystem 
            Caption         =   "Show System"
            Height          =   225
            Left            =   135
            TabIndex        =   22
            ToolTipText     =   "Include files marked with the specified attribute"
            Top             =   723
            Value           =   1  'Checked
            Width           =   1305
         End
         Begin VB.CheckBox chkPropTooltips 
            Caption         =   "Tooltips"
            Height          =   225
            Left            =   135
            TabIndex        =   28
            ToolTipText     =   "Show Tooltips for items"
            Top             =   2385
            Value           =   1  'Checked
            Width           =   1110
         End
         Begin VB.CheckBox chkPropHasLabel 
            Caption         =   "Has Label"
            Height          =   255
            Left            =   135
            TabIndex        =   20
            ToolTipText     =   "Show/hide labels"
            Top             =   165
            Value           =   1  'Checked
            Width           =   1065
         End
      End
      Begin VB.Frame Frame5 
         Height          =   2115
         Left            =   4275
         TabIndex        =   48
         Top             =   120
         Width           =   1920
         Begin VB.ComboBox cboLabelBorderStyle 
            Height          =   315
            Left            =   90
            Style           =   2  'Dropdown List
            TabIndex        =   17
            ToolTipText     =   "Label borders style"
            Top             =   1725
            Width           =   1755
         End
         Begin VB.ComboBox cboThumbBorderInStyle 
            Height          =   315
            Left            =   90
            Style           =   2  'Dropdown List
            TabIndex        =   16
            ToolTipText     =   "Internal borders style. Hit Refresh"
            Top             =   1065
            Width           =   1755
         End
         Begin VB.ComboBox cboThumbBorderStyle 
            Height          =   315
            Left            =   90
            Style           =   2  'Dropdown List
            TabIndex        =   15
            ToolTipText     =   "External borders style. Hit Refresh"
            Top             =   420
            Width           =   1755
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "LabelBorderStyle"
            Height          =   195
            Index           =   6
            Left            =   300
            TabIndex        =   58
            Top             =   1485
            Width           =   1200
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbBorderStyle"
            Height          =   195
            Index           =   4
            Left            =   255
            TabIndex        =   50
            Top             =   180
            Width           =   1305
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbBorderInStyle"
            Height          =   195
            Index           =   5
            Left            =   180
            TabIndex        =   49
            Top             =   825
            Width           =   1440
         End
      End
      Begin VB.CommandButton cmdRefresh 
         Caption         =   "Refresh"
         Height          =   390
         Left            =   120
         TabIndex        =   2
         ToolTipText     =   "Rescans the Path and refreshes the control's contents"
         Top             =   2415
         Width           =   2100
      End
      Begin VB.Frame Frame4 
         Height          =   1410
         Left            =   2295
         TabIndex        =   42
         Top             =   120
         Width           =   1905
         Begin VB.TextBox txtThumbWidth 
            Height          =   285
            Left            =   1245
            MaxLength       =   3
            TabIndex        =   3
            ToolTipText     =   "Range: 20 - 200. Click Enter to apply"
            Top             =   165
            Width           =   585
         End
         Begin VB.TextBox txtThumbHeight 
            Height          =   285
            Left            =   1245
            MaxLength       =   3
            TabIndex        =   4
            ToolTipText     =   "Range: 20 - 200. Click Enter to apply"
            Top             =   465
            Width           =   585
         End
         Begin VB.TextBox txtThumbOffset 
            Height          =   285
            Left            =   1245
            MaxLength       =   2
            TabIndex        =   5
            ToolTipText     =   "Range: 1 - 10. Click Enter to apply"
            Top             =   765
            Width           =   585
         End
         Begin VB.TextBox txtThumbSpace 
            Height          =   285
            Left            =   1245
            MaxLength       =   2
            TabIndex        =   6
            ToolTipText     =   "Range: 1 - 20. Click Enter to apply"
            Top             =   1065
            Width           =   585
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbWidth"
            Height          =   195
            Index           =   0
            Left            =   195
            TabIndex        =   40
            Top             =   210
            Width           =   915
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbSpace"
            Height          =   195
            Index           =   3
            Left            =   150
            TabIndex        =   47
            ToolTipText     =   "Range: 1 - 200. Click Enter to apply."
            Top             =   1110
            Width           =   960
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbOffset"
            Height          =   195
            Index           =   2
            Left            =   195
            TabIndex        =   46
            Top             =   810
            Width           =   915
         End
         Begin VB.Label lblCaption 
            AutoSize        =   -1  'True
            Caption         =   "ThumbHeight"
            Height          =   195
            Index           =   1
            Left            =   150
            TabIndex        =   41
            Top             =   510
            Width           =   960
         End
      End
      Begin VB.DirListBox Dir1 
         Height          =   1665
         Left            =   120
         TabIndex        =   1
         ToolTipText     =   "DblClick to select the Path"
         Top             =   645
         Width           =   2100
      End
      Begin VB.DriveListBox Drive1 
         Height          =   315
         Left            =   120
         TabIndex        =   0
         Top             =   240
         Width           =   2100
      End
      Begin VB.Frame Frame3 
         Caption         =   "Pattern"
         Height          =   1230
         Left            =   2295
         TabIndex        =   45
         Top             =   1575
         Width           =   1920
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.ico"
            Height          =   225
            Index           =   7
            Left            =   165
            TabIndex        =   10
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   960
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.cur"
            Height          =   225
            Index           =   6
            Left            =   1080
            TabIndex        =   14
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   960
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.emf"
            Height          =   225
            Index           =   4
            Left            =   1080
            TabIndex        =   12
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   480
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.jpg"
            Height          =   225
            Index           =   1
            Left            =   165
            TabIndex        =   8
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   480
            Value           =   1  'Checked
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.wmf"
            Height          =   225
            Index           =   5
            Left            =   1080
            TabIndex        =   13
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   720
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.dib"
            Height          =   225
            Index           =   3
            Left            =   1080
            TabIndex        =   11
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   240
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.gif"
            Height          =   225
            Index           =   2
            Left            =   165
            TabIndex        =   9
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   720
            Value           =   1  'Checked
            Width           =   705
         End
         Begin VB.CheckBox chkPtn 
            Caption         =   "*.bmp"
            Height          =   225
            Index           =   0
            Left            =   165
            TabIndex        =   7
            ToolTipText     =   "Include files with the specified extension, if checked"
            Top             =   240
            Value           =   1  'Checked
            Width           =   705
         End
      End
   End
   Begin VB.Frame Frame1 
      Height          =   3975
      Left            =   2550
      TabIndex        =   43
      Top             =   2970
      Width           =   8955
      Begin ICThumbnailer.Thumbnailer Thumbnailer 
         Height          =   3375
         Left            =   90
         TabIndex        =   63
         Top             =   525
         Width           =   8790
         _ExtentX        =   15505
         _ExtentY        =   5953
         ThumbOffset     =   5
         Pattern         =   "*.bmp;*.jpg;*.jpeg;*.gif"
      End
      Begin MSComctlLib.ProgressBar PBar 
         Height          =   300
         Left            =   105
         TabIndex        =   62
         Top             =   165
         Width           =   8775
         _ExtentX        =   15478
         _ExtentY        =   529
         _Version        =   393216
         Appearance      =   1
         Scrolling       =   1
      End
   End
   Begin VB.Menu mnuRight 
      Caption         =   ""
      Visible         =   0   'False
      Begin VB.Menu mnuSort 
         Caption         =   "By Name"
         Index           =   0
      End
      Begin VB.Menu mnuSort 
         Caption         =   "By Type"
         Enabled         =   0   'False
         Index           =   1
      End
      Begin VB.Menu mnuSort 
         Caption         =   "By Size"
         Enabled         =   0   'False
         Index           =   2
      End
      Begin VB.Menu mnuSort 
         Caption         =   "By Date"
         Enabled         =   0   'False
         Index           =   3
      End
      Begin VB.Menu mnuSort 
         Caption         =   "By Dims"
         Enabled         =   0   'False
         Index           =   4
      End
      Begin VB.Menu mnuSort 
         Caption         =   "By Ext"
         Enabled         =   0   'False
         Index           =   5
      End
      Begin VB.Menu mnuSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSortOrder 
         Caption         =   "Ascending"
         Index           =   0
      End
      Begin VB.Menu mnuSortOrder 
         Caption         =   "Descending"
         Index           =   1
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit


Const PTN_SEPARATOR = ";"       ' Pattern string separator

Dim bShowAlert As Boolean

Private Sub Form_Load()

  On Error Resume Next

  Dim i As Integer
  Dim sTmp As String

    ' Most controls in the Form are initialized to the values
    ' of the Thumbnailer properties instead of reading them
    ' in real time. If you change any properties in design time,
    ' these controls may show incorrect values.
    
    ' Fill the Thumbnail Borderstyle combobox
    cboThumbBorderStyle.AddItem "thoThinRaisedLight"
    cboThumbBorderStyle.AddItem "thoThinRaisedDark"
    cboThumbBorderStyle.AddItem "thoThinSunkenLight"
    cboThumbBorderStyle.AddItem "thoThinSunkenDark"
    cboThumbBorderStyle.AddItem "thoRaised"
    cboThumbBorderStyle.AddItem "thoSunken"
    cboThumbBorderStyle.AddItem "thoEtched"
    cboThumbBorderStyle.AddItem "thoBump"
    cboThumbBorderStyle.ListIndex = Thumbnailer.ThumbBorderStyle

    ' Fill the Thumbnail internal Borderstyle combobox
    cboThumbBorderInStyle.AddItem "thiNone"
    cboThumbBorderInStyle.AddItem "thiThinRaisedLight"
    cboThumbBorderInStyle.AddItem "thiThinRaisedDark"
    cboThumbBorderInStyle.AddItem "thiThinSunkenLight"
    cboThumbBorderInStyle.AddItem "thiThinSunkenDark"
    cboThumbBorderInStyle.AddItem "thiRaised"
    cboThumbBorderInStyle.AddItem "thiSunken"
    cboThumbBorderInStyle.AddItem "thiEtched"
    cboThumbBorderInStyle.AddItem "thiBump"
    cboThumbBorderInStyle.ListIndex = Thumbnailer.ThumbBorderInStyle
    
    ' Fill the Label Borderstyle combobox
    cboLabelBorderStyle.AddItem "thoThinRaisedLight"
    cboLabelBorderStyle.AddItem "thoThinRaisedDark"
    cboLabelBorderStyle.AddItem "thoThinSunkenLight"
    cboLabelBorderStyle.AddItem "thoThinSunkenDark"
    cboLabelBorderStyle.AddItem "thoRaised"
    cboLabelBorderStyle.AddItem "thoSunken"
    cboLabelBorderStyle.AddItem "thoEtched"
    cboLabelBorderStyle.AddItem "thoBump"
    cboLabelBorderStyle.ListIndex = Thumbnailer.LabelBorderStyle
    
    ' Fill the Textboxes with the predefined values
    txtThumbWidth = Thumbnailer.ThumbWidth
    txtThumbHeight = Thumbnailer.ThumbHeight
    txtThumbOffset = Thumbnailer.ThumbOffset
    txtThumbSpace = Thumbnailer.ThumbSpace
    
    ' Set the flag (set it to False to not get any Refresh messages)
    bShowAlert = False
  
    ' Create the Thumbnailer.Pattern string
    ' from the checked option buttons
    ' --------------------------------------
    For i = 0 To 7
        If chkPtn(i).Value = vbChecked Then
            sTmp = sTmp & chkPtn(i).Caption & PTN_SEPARATOR
            ' Add (*.jpeg) filetypes if (*.jpg) filetype is checked
            If i = 1 Then
                sTmp = sTmp & "*.jpeg" & PTN_SEPARATOR
            End If
        End If
    Next
    ' Thumbnailer will automatically remove any ending PTN_SEPARATOR
    ' char from the Pattern string when processing it.
    ' --------------------------------------

    ' Set the Pattern
    Thumbnailer.Pattern = sTmp
    
    ' Initialize info labels
    InitInfo

    ' This will cause any thumbnails to be drawn.
    Dir1.Path = App.Path
    
    ' Clear any printed events (PatternChange etc.)
    txtEvents = vbNullString

End Sub

' Although Thumbnailer handles any Escape key press and stops
' processing, it need to have the focus to do so.
' Escape key can be globaly handled by the app, if
' setting Form1.KeyPreview = True
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

    ' If Escape is pressed then stop any process in progress
    If KeyCode = vbKeyEscape Then
        Thumbnailer.StopDraw
    End If

End Sub

Private Sub Form_Resize()

  On Error Resume Next
    
    ' Resize controls
    Frame1.Width = (Me.Width - Frame1.Left - 250)
    Frame1.Height = (Me.Height - Frame1.Top - 530)
    Thumbnailer.Width = (Frame1.Width - 250)
    Thumbnailer.Height = (Frame1.Height - 630)
    PBar.Width = (Frame1.Width - 250)

End Sub

Private Sub Form_Unload(Cancel As Integer)

  Dim i As Long

    ' Unload any loaded forms
    For i = 0 To Forms.Count - 1
        Unload Forms(i)
    Next

End Sub

Private Sub Drive1_Change()

  On Error Resume Next  ' To avoid "Drive not available" errors
    
    Dir1 = Drive1

End Sub

Private Sub Dir1_Change()
    
    ' Initialize info labels
    InitInfo
       
    ' The Thumbnailer control does the Error handling
    ' in the case of an invalid path.
    Thumbnailer.Path = Dir1
    
    ' Show information
    ShowInfo

End Sub

' ThumbWidth (20 - 200 pixels)
' We set the property when the Enter key is pressed
Private Sub txtThumbWidth_KeyDown(KeyCode As Integer, Shift As Integer)

  On Error Resume Next ' To avoid Overflow Errors in CInt()

    If KeyCode = vbKeyReturn Then
        ' Error handle
        ' -------------------------
        If Not IsNumeric(txtThumbWidth) Then
            txtThumbWidth = "60"
            Else
            If CInt(txtThumbWidth) < 20 Then txtThumbWidth = 20
            If CInt(txtThumbWidth) > 200 Then txtThumbWidth = 200
        End If
        ' -------------------------
        Thumbnailer.ThumbWidth = CInt(txtThumbWidth)
        ' Refresh the ThumbOffset label as it may be altered
        ' when setting the Thumbnailer.ThumbWidth
        txtThumbOffset = Thumbnailer.ThumbOffset
    End If

End Sub

' ThumbWidth (20 - 200 pixels)
' If the textbox loses the focus we reset its value
Private Sub txtThumbWidth_LostFocus()
    
    ' Refresh the label
    txtThumbWidth = Thumbnailer.ThumbWidth

End Sub

' ThumbHeight (20 - 200 pixels)
' We set the property when the Enter key is pressed
Private Sub txtThumbHeight_KeyDown(KeyCode As Integer, Shift As Integer)

  On Error Resume Next ' To avoid Overflow Errors in CInt()

    If KeyCode = vbKeyReturn Then
        ' Error handle
        ' -------------------------
        If Not IsNumeric(txtThumbHeight) Then
            txtThumbHeight = "60"
            Else
            If CInt(txtThumbHeight) < 20 Then txtThumbHeight = 20
            If CInt(txtThumbHeight) > 200 Then txtThumbHeight = 200
        End If
        ' -------------------------
        Thumbnailer.ThumbHeight = CInt(txtThumbHeight)
        ' Refresh the ThumbOffset label as it may be altered
        ' by setting the Thumbnailer.ThumbWidth
        txtThumbOffset = Thumbnailer.ThumbOffset
    End If

End Sub

' ThumbHeight (20 - 200 pixels)
' If the textbox loses the focus we reset its value
Private Sub txtThumbHeight_LostFocus()
    
    ' Refresh the label
    txtThumbHeight = Thumbnailer.ThumbHeight

End Sub

' ThumbOffset (1 - 10 pixels)
' We set the property when the Enter key is pressed
Private Sub txtThumbOffset_KeyDown(KeyCode As Integer, Shift As Integer)

  On Error Resume Next ' To avoid Overflow Errors in CInt()

    If KeyCode = vbKeyReturn Then
        ' Error handle
        ' -------------------------
        If Not IsNumeric(txtThumbOffset) Then
            txtThumbOffset = "1"
            Else
            If CInt(txtThumbOffset) < 1 Then txtThumbOffset = 1
            If CInt(txtThumbOffset) > 10 Then txtThumbOffset = 10
        End If
        ' -------------------------
        Thumbnailer.ThumbOffset = CInt(txtThumbOffset)
        ' Refresh the ThumbOffset label as it may be adjusted
        txtThumbOffset = Thumbnailer.ThumbOffset
    End If

End Sub

' ThumbOffset (1 - 10 pixels)
' If the textbox loses the focus we reset its value
Private Sub txtThumbOffset_LostFocus()
    
    ' Refresh the label
    txtThumbOffset = Thumbnailer.ThumbOffset

End Sub

' ThumbSpace (1 - 20 pixels)
' We set the property when the Enter key is pressed
Private Sub txtThumbSpace_KeyDown(KeyCode As Integer, Shift As Integer)

  On Error Resume Next ' To avoid Overflow Errors in CInt()

    If KeyCode = vbKeyReturn Then
        ' Error handle
        ' -------------------------
        If Not IsNumeric(txtThumbSpace) Then
            txtThumbSpace = "1"
            Else
            If CInt(txtThumbSpace) < 1 Then txtThumbSpace = 1
            If CInt(txtThumbSpace) > 20 Then txtThumbSpace = 20
        End If
        ' -------------------------
        Thumbnailer.ThumbSpace = CInt(txtThumbSpace)
    End If

End Sub

' ThumbSpace (1 - 20 pixels)
' If the textbox loses the focus we set the property
Private Sub txtThumbSpace_LostFocus()

  On Error Resume Next ' To avoid Overflow Errors in CInt()

    If Not IsNumeric(txtThumbSpace) Then
        txtThumbSpace = "1"
        Else
        If CInt(txtThumbSpace) < 1 Then txtThumbSpace = 1
        If CInt(txtThumbSpace) > 20 Then txtThumbSpace = 20
    End If
        
    Thumbnailer.ThumbSpace = CInt(txtThumbSpace)

End Sub

' Events logging
Private Sub txtEvents_Change()

  On Error Resume Next
  
  Dim iLength As Long

    iLength = Len(txtEvents)
    
    ' Clear the Textbox if its contents reaches 10000
    ' characters to avoid "Out of memory" errors
    If iLength > 10000 Then txtEvents = vbNullString
    
    ' Force the txtEvents to show the last added line
    txtEvents.SelStart = iLength

End Sub

' ThumbBorderStyle
Private Sub cboThumbBorderStyle_Click()

    Thumbnailer.ThumbBorderStyle = cboThumbBorderStyle.ListIndex
    
    ' Refresh the ThumbOffset label as it may be altered
    ' by setting the Thumbnailer.ThumbBorderStyle
    txtThumbOffset = Thumbnailer.ThumbOffset
    
    ' The ThumbOffset property may be altered by the Thumbnailer
    ' control internally when the ThumbWidth, ThumbHeight,
    ' ThumbBorderStyle or the ThumbBorderInStyle are changed.
    ' If the ThumbOffset is altered, then the Thumbnails must
    ' be re-created and then re-drawn so the items are shown
    ' correctly. As in most cases the ThumbOffset is not changed
    ' we cheat here and just re-draw the items to have an instant
    ' view of the effect. But remember, to see the final effect you
    ' have to hit the Refresh button or to call the control's Redarw
    ' method for a full refresh of the control.
    
    If bShowAlert Then
        MsgBox "Although you may get an idea about the effect, you have to hit Refresh to see the correct result." & vbCrLf & vbCrLf _
                 & "If you wish to no more receive this alert set the 'bShowAlert' to False in Form_Load."
    End If
    
    ' Re-draw
    Thumbnailer.DrawItems

End Sub

' ThumbBorderInStyle
Private Sub cboThumbBorderInStyle_Click()

    Thumbnailer.ThumbBorderInStyle = cboThumbBorderInStyle.ListIndex
    
    ' Refresh the ThumbOffset label as it may be altered
    ' by setting the Thumbnailer.ThumbBorderInStyle
    txtThumbOffset = Thumbnailer.ThumbOffset
    
    ' The ThumbOffset property may be altered by the Thumbnailer
    ' control internally when the ThumbWidth, ThumbHeight,
    ' ThumbBorderStyle or the ThumbBorderInStyle are changed.
    ' If the ThumbOffset is altered, then the Thumbnails must
    ' be re-created and then re-drawn so the items are shown
    ' correctly. As in most cases the ThumbOffset is not changed
    ' we cheat here and just re-draw the items to have an instant
    ' view of the effect. But remember, to see the final effect you
    ' have to hit the Refresh button or to call the control's Redarw
    ' method for a full refresh of the control.
    
    If bShowAlert Then
        MsgBox "Although you may get an idea about the effect, you have to hit Refresh to see the correct result." & vbCrLf & vbCrLf _
                 & "If you wish to no more receive this alert set the 'bShowAlert' to False in Form_Load."
    End If
    
    ' Re-draw
    Thumbnailer.DrawItems

End Sub

' LabelBorderStyle
Private Sub cboLabelBorderStyle_Click()

    Thumbnailer.LabelBorderStyle = cboLabelBorderStyle.ListIndex

End Sub

' HasLabel
Private Sub chkPropHasLabel_Click()

    Thumbnailer.HasLabel = CBool(chkPropHasLabel)

End Sub

' DragDrop
Private Sub chkPropDragDrop_Click()

    Thumbnailer.DragDrop = CBool(chkPropDragDrop)
    
    If Thumbnailer.DragDrop Then
        MsgBox "True drag and drop functionality has been enabled", vbInformation, "Notice"
    End If

End Sub

' LabelEdit
Private Sub chkPropLabelEdit_Click()

    If chkPropLabelEdit Then
        Thumbnailer.LabelEdit = thlAutomatic
        Else
        Thumbnailer.LabelEdit = thlManual
    End If

End Sub

Private Sub chkPropDelete_Click()

    Thumbnailer.CanDelete = CBool(chkPropDelete)

End Sub

Private Sub chkPropFSO_Click()

    Thumbnailer.FSOEnable = CBool(chkPropFSO)
    
    If Thumbnailer.FSOEnable Then
        MsgBox "When renaming or removing an item from Thumbnailer, the same action will take place on the corresponding file.", vbInformation, "Notice"
    End If

End Sub

' Pattern
Private Sub chkPtn_Click(Index As Integer)

  Dim i As Integer
  Dim sTmp As String
    
    ' Create the Thumbnailer.Pattern string
    ' from the checked option buttons
    ' --------------------------------------
    For i = 0 To 7
        ' Enable any previously disabled checkboxes
        chkPtn(i).Enabled = True
        ' Add the extension to the Pattern string
        If chkPtn(i).Value = vbChecked Then
            sTmp = sTmp & chkPtn(i).Caption & PTN_SEPARATOR
            ' Add (*.jpeg) filetypes if (*.jpg) filetype is checked
            If i = 1 Then
                sTmp = sTmp & "*.jpeg" & PTN_SEPARATOR
            End If
        End If
    Next
    ' Thumbnailer will automatically remove any ending PTN_SEPARATOR
    ' char from the Pattern string when processing it.
    ' --------------------------------------
    
    ' An empty Pattern string, although it is allowed, it is ignored
    ' by the control and does not change the existing Thumbnailer.Pattern
    ' --------------------------------------
    ' If only one Checkbox is left checked
    If (chkPtn(0) + chkPtn(1) + chkPtn(2) + chkPtn(3) + chkPtn(4) + chkPtn(5) + chkPtn(6) + chkPtn(7)) = 1 Then
        ' Loop all the checkboxes
        For i = 0 To 7
            ' Find the checked one
            If chkPtn(i) = vbChecked Then
                ' Do not allow it to be unchecked, as the current Pattern
                ' for the Thumbnailer will not actually change, if the string is empty.
                chkPtn(i).Enabled = False
            End If
        Next
    End If
    ' --------------------------------------

    ' Set the Pattern
    Thumbnailer.Pattern = sTmp

    ' Refresh Thumbnailer and show updated info
    RefreshAll
    
End Sub

' ShowHidden files
Private Sub chkPropHidden_Click()

    Thumbnailer.ShowHidden = CBool(chkPropHidden)
    
    ' Refresh Thumbnailer and show updated info
    RefreshAll

End Sub

' ShowSystem files
Private Sub chkPropSystem_Click()

    Thumbnailer.ShowSystem = CBool(chkPropSystem)
    
    ' Refresh Thumbnailer and show updated info
    RefreshAll

End Sub

' ReadOnly files
Private Sub chkPropReadOnly_Click()

    Thumbnailer.ShowReadOnly = CBool(chkPropReadOnly)
    
    ' Refresh Thumbnailer and show updated info
    RefreshAll

End Sub

' Tooltips (filenames)
Private Sub chkPropTooltips_Click()

    Thumbnailer.Tooltips = CBool(chkPropTooltips)

End Sub

' Log events
Private Sub chkEvents_Click()

    chkEventsAll.Enabled = CBool(chkEvents)

End Sub

' Back color
Private Sub cmdBkColor_Click()

  On Error GoTo Out ' To handle "Cancel pressed"

    Dlg.Flags = &H3
    Dlg.Color = Thumbnailer.BackColor
    Dlg.ShowColor
    
    ' Set the color of the control's background
    Thumbnailer.BackColor = Dlg.Color
    
' Cancel was pressed
Out:

End Sub

' Items' Back color
Private Sub cmdBkItemColor_Click()

  On Error GoTo Out ' To handle "Cancel pressed"

    Dlg.Flags = &H3
    Dlg.Color = Thumbnailer.BackColor
    Dlg.ShowColor
    
    ' Set the background color of the items
    Thumbnailer.BackClrItem = Dlg.Color
    
    ' Re-create the Thumbnails
    Thumbnailer.Redraw
    
' Cancel was pressed
Out:

End Sub

' Set Selected item (Thumbnailer does the Error handling and on Error
' will set Thumbnailer.SelectedItem = Nothing)
Private Sub cmdSetSelected_Click()
  
  On Error Resume Next ' To avoid Overflow Errors in CInt()

    ' If we set the SelectedItem by index (as sorted)
    If IsNumeric(txtSelected) Then
        ' Set the selected item. Index must be < 32767 (Integer)
        Set Thumbnailer.SelectedItem = Thumbnailer.Thumbs(CInt(txtSelected))
        ' If we set the SelectedItem by Name
        Else
        ' Set the selected item
        Set Thumbnailer.SelectedItem = Thumbnailer.Thumbs(txtSelected)
    End If

    ' Verify the current Selected Item's name, in txtSelected
    If Thumbnailer.SelectedItem Is Nothing Then
        txtSelected = "<Nothing>"
        Else
        txtSelected = Thumbnailer.SelectedItem
    End If

End Sub

' Exports the SelectedItem as a BMP file in the application's Path
Private Sub cmdExport_Click()
    
  Dim eExport As ethExportStyles
    
    ' Set the export style
    If optExport(0) Then
        eExport = theClear
        Else
        eExport = theFull
    End If
    
    ' If there is any SelectedItem
    If Not (Thumbnailer.SelectedItem Is Nothing) Then
        If Thumbnailer.ExportThumb(Thumbnailer.SelectedItem, App.Path & "\thumbnail.bmp", eExport) Then
            MsgBox "Successfully exported in """ & App.Path & """ as ""thumbnail.bmp"".", vbCritical, "Export item"
            Else
            MsgBox "Failed", vbCritical, "Export item"
        End If
    End If
    
End Sub

' Re-scans the Path, re-creates the Thumbnails and re-draws them
Private Sub cmdRefresh_Click()
    
    ' Refresh Thumbnailer and show updated info
    RefreshAll

End Sub

' Clear the txtEvents
Private Sub cmdClear_Click()

    txtEvents = vbNullString

End Sub

' Shows information for the item specified in txtItemInfo
Private Sub cmdItemInfo_Click()

  Dim oThumb As Thumb

    ' If the specified item does not exist, exit
    If Thumbnailer.Thumbs(txtItemInfo) Is Nothing Then Exit Sub
    
    ' Get a reference of the item
    Set oThumb = Thumbnailer.Thumbs(txtItemInfo)
    
    ' Show the dialog with the SelectedItem's info
    With oThumb
        ' Always retrieved
        frmItemInfo.imgPreview = LoadPicture(.Path & .Name)
        frmItemInfo.lblInfo(0) = .Name
        frmItemInfo.lblInfo(1) = .Path
        frmItemInfo.lblInfo(8) = .Selected
        ' To be retrieved, the appropriate property
        ' must be set to True
        If Thumbnailer.GetType Then
            frmItemInfo.lblInfo(2) = .FileType
            Else
            frmItemInfo.lblInfo(2) = "Not retrieved"
        End If
        If Thumbnailer.GetSize Then
            frmItemInfo.lblInfo(3) = .Size
            Else
            frmItemInfo.lblInfo(3) = "Not retrieved"
        End If
        If Thumbnailer.GetDate Then
            frmItemInfo.lblInfo(4) = .DateMdf
            Else
            frmItemInfo.lblInfo(4) = "Not retrieved"
        End If
        If Thumbnailer.GetDims Then
            frmItemInfo.lblInfo(5) = .Width
            frmItemInfo.lblInfo(6) = .Height
            Else
            frmItemInfo.lblInfo(5) = "Not retrieved"
            frmItemInfo.lblInfo(6) = "Not retrieved"
        End If
        If Thumbnailer.GetExt Then
            frmItemInfo.lblInfo(7) = .Extension
            Else
            frmItemInfo.lblInfo(7) = "Not retrieved"
        End If
    End With
    
    ' Show the dialog
    frmItemInfo.Show

End Sub

' Sort menu
Private Sub mnuSort_Click(Index As Integer)

  Dim i As Long

    ' Initialize
    For i = 0 To 5
        mnuSort(i).Checked = False
    Next
        
    ' Check the clicked one
    mnuSort(Index).Checked = True
    
    ' Set the property
    Thumbnailer.Sorted = Index

End Sub

Private Sub mnuSortOrder_Click(Index As Integer)

  Dim i As Long

    ' Initialize
    For i = 0 To 1
        mnuSortOrder(i).Checked = False
    Next
        
    ' Check the clicked one
    mnuSortOrder(Index).Checked = True
    
    ' Set the property
    Thumbnailer.SortOrder = Index

End Sub




























' ################## PROCEDURES ###################

' Initializes info controls
Private Sub InitInfo()

    ' Initialize
    lblItems = vbNullString
    lblLastDrawn = vbNullString
    txtSelected = vbNullString
    txtItemInfo = vbNullString

End Sub

' Shows information
Private Sub ShowInfo()
    
  On Error Resume Next
    
    ' Show information
    ' --------------------------------------
    With Thumbnailer
        ' Show the amount of items in the path
        lblItems = .Items
        ' Show the current Selected Item's name in txtSelected
        If .SelectedItem Is Nothing Then
            txtSelected = "<Nothing>"
            Else
            txtSelected = .SelectedItem
            ' Optionally set it also, as the item to retrieve info for
            txtItemInfo = txtSelected
        End If
    End With
    ' --------------------------------------

End Sub

' Refreshes Thumbnailer and shows updated info
Private Sub RefreshAll()
    
    ' Initialize info labels
    InitInfo

    ' Re-create the Thumbnails
    Thumbnailer.Redraw
    
    ' Show information
    ShowInfo

End Sub




























' ################## THUMBNAILER EVENTS ###################

Private Sub Thumbnailer_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single)

    ' Uncomment below to test the HitTest function
    ' Results are printed in the Immediate window
    
' --------------------------------------------------
' Dim sTemp As String
' Dim THHI As THHITTESTINFO
' Dim oThumb As Thumb
'
'    ' Get the item the mouse moves over
'    Set oThumb = Thumbnailer.HitTest(X, Y, THHI)
'
'    If oThumb Is Nothing Then
'        Debug.Print "None"
'        Else
'        Select Case THHI
'            Case THT_ONICON
'                sTemp = "On icon"
'            Case THT_ONLABEL
'                sTemp = "On label"
'            Case THT_ONSPACE
'                sTemp = "Between icon and label"
'        End Select
'        Debug.Print oThumb.Name, sTemp
'    End If
' --------------------------------------------------

    ' Log the event
    If chkEvents And chkEventsAll Then
        txtEvents = txtEvents & "MouseMove " & Button & " , " & Shift & " , " & X & " , " & Y & vbCrLf
    End If

End Sub

Private Sub Thumbnailer_MouseDown(Thumb As Thumb, ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single)

    ' Log the event
    If chkEvents Then
        ' If the Thumb has been set
        If Not Thumb Is Nothing Then
            txtEvents = txtEvents & "MouseDown " & Thumb.Name & ", " & Button & ", " & Shift & ", " & X & ", " & Y & vbCrLf
            ' If the Thumb has not been set
            Else
            txtEvents = txtEvents & "MouseDown on empty area" & ", " & Button & ", " & Shift & ", " & X & ", " & Y & vbCrLf
        End If
    End If

End Sub

Private Sub Thumbnailer_MouseUp(Thumb As Thumb, ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single)

    ' Log the event
    If chkEvents Then
        ' If the Thumb is set
        If Not Thumb Is Nothing Then
            txtEvents = txtEvents & "MouseUp " & Thumb.Name & ", " & Button & ", " & Shift & ", " & X & ", " & Y & vbCrLf
            ' If the Thumb is not set
            Else
            txtEvents = txtEvents & "MouseUp on empty area" & ", " & Button & ", " & Shift & ", " & X & ", " & Y & vbCrLf
        End If
        ' If the Right button is clicked
        If Button And vbRightButton Then
            ' Enable the Sort menus that we have the needed info
            If Thumbnailer.GetType Then mnuSort(1).Enabled = True
            If Thumbnailer.GetSize Then mnuSort(2).Enabled = True
            If Thumbnailer.GetDate Then mnuSort(3).Enabled = True
            If Thumbnailer.GetDims Then mnuSort(4).Enabled = True
            If Thumbnailer.GetExt Then mnuSort(5).Enabled = True
            ' Check the active Sort menu
            mnuSort(Thumbnailer.Sorted).Checked = True
            ' Check the active SortOrder menu
            mnuSortOrder(Thumbnailer.SortOrder).Checked = True
            ' Show the Sort menu
            PopupMenu mnuRight
        End If
    End If

End Sub

Private Sub Thumbnailer_Click(Thumb As Thumb)

    ' Log the event
    If chkEvents Then
        ' If the Thumb has been set
        If Not Thumb Is Nothing Then
            txtEvents = txtEvents & "Click " & Thumb.Name & vbCrLf
            ' If the Thumb has not been set
            Else
            txtEvents = txtEvents & "Click on empty area" & vbCrLf
        End If
    End If

End Sub

Private Sub Thumbnailer_DblClick(Thumb As Thumb)

    ' Log the event
    If chkEvents Then
        ' If the Thumb has been set
        If Not Thumb Is Nothing Then
            txtEvents = txtEvents & "DblClick " & Thumb.Name & vbCrLf
            ' If the Thumb has not been set
            Else
            txtEvents = txtEvents & "DblClick on empty area" & vbCrLf
        End If
    End If

End Sub

' Raised before the Path changes and the image files been validated, allowing
' the user to prevent the Path from changing, by setting Cancel = True.
Private Sub Thumbnailer_BeforePathChange(ByVal sPath As String, Cancel As Boolean)

    ' Cancel = True

End Sub

' Raised after the image files have been validated and the
' final Items property has been set.
Private Sub Thumbnailer_AfterPathChange(ByVal ItemsCount As Long)
    
    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "PathChange" & vbCrLf
    End If

End Sub

Private Sub Thumbnailer_AfterListChange(ByVal ItemsCount As Long)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ListChange" & vbCrLf
    End If

End Sub

Private Sub Thumbnailer_AfterPatternChange()

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "AfterPatternChange" & vbCrLf
    End If

End Sub

' Raised when the Items property of the control is changed due to
' detection of invalid items.
Private Sub Thumbnailer_ItemsCountChange(ByVal ItemsCount As Long)

    ' Set the Progress Bar's Max property
    If ItemsCount > 0 Then
        PBar.Max = ItemsCount
        Else
        PBar.Value = 0
    End If

End Sub

' Raised each time a Thumb for a valid file
' has been added to the collection.
Private Sub Thumbnailer_AfterThumbAdd(ByVal Index As Long, ByVal Name As String)

    ' Log the event
'    If chkEvents Then
'        txtEvents = txtEvents & "AfterThumbAdd (Index = " & Index & ")" & vbCrLf
'    End If
    
    ' Show the current drawn thumbnail's index
    lblLastDrawn = Index
    
    ' Increase the Progress Bar as soon as a new thumbnail is added
    PBar.Value = Index
    
    ' PBar.Max has been set in ItemsCountChange event
    
    ' We may reset the ProgBar when finished
    ' here or in ThumbsAdded event
'    If Index = PBar.Max Then PBar.Value = 0

End Sub

' Thumbnails creation has been finished
Private Sub Thumbnailer_ThumbsAdded(ByVal Items As Long)

    ' Reset the ProgBar
    PBar.Value = 0

End Sub

' The event is raised only if the mouse moves over an item.
' Thumb can not be Nothing
Private Sub Thumbnailer_HitTest(Thumb As Thumb)

    ' Log the event
    If chkEventsAll Then
        txtEvents = txtEvents & "HitTest (" & Thumb.Name & ")" & vbCrLf
    End If

End Sub

' SelectedItem has been changed
Private Sub Thumbnailer_SelChanged(Thumb As Thumb)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "SelChanged (" & Thumb.Name & ")" & vbCrLf
    End If

    ' Show the info for the item
    txtSelected = Thumb.Name
    ' Optionally, set it as the item to retrieve info for
    txtItemInfo = txtSelected

End Sub

' An item has been added
Private Sub Thumbnailer_ItemAdd(Thumb As Thumb)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemAdd (" & Thumb.Name & ")" & vbCrLf
    End If
            
    ' Initialize info labels
    InitInfo
    
    ' Refresh info
    ShowInfo

End Sub

' An item has been renamed
Private Sub Thumbnailer_ItemRename(Thumb As Thumb, ByVal sOldName As String)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemRename (" & sOldName & ", " & Thumb.Name & ")" & vbCrLf
    End If
            
    ' Initialize info labels
    InitInfo
    
    ' Refresh info
    ShowInfo

End Sub

Private Sub Thumbnailer_ItemDelete(ByVal sPath As String, ByVal sName As String)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemDelete (" & sName & ")" & vbCrLf
    End If
            
    ' Initialize info labels
    InitInfo
    
    ' Refresh info
    ShowInfo

End Sub

Private Sub Thumbnailer_ItemsDeleted(ByVal ItemsCount As Long)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemsDeleted (" & ItemsCount & ")" & vbCrLf
    End If

End Sub

' Thumb can not be = Nothing
Private Sub Thumbnailer_BeforeLabelEdit(Thumb As Thumb)

    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "BeforeLabelEdit (" & Thumb.Name & ")" & vbCrLf
    End If

End Sub

' Thumb can not be = Nothing
Private Sub Thumbnailer_AfterLabelEdit(Thumb As Thumb, ByVal NewText As String, bCancel As Boolean)
    
  Dim sText As String
    
    ' Set bCancel = True to cancel the event and
    ' prevent text from being changed.
    
    ' Log the event
    If chkEvents Then
        ' If the NewText is empty, then either the Label editing has been
        ' canceled by pressing the ESC key or the label is not changed.
        ' If empty text is applied, the label resets to its original text.
        If Len(NewText) = 0 Then ' or bCancel
            sText = "NULL"
            Else
            sText = NewText
        End If
        txtEvents = txtEvents & "AfterLabelEdit (" & Thumb.Name & "), " & sText & vbCrLf
    End If

End Sub

' Operation has been interrupted
Private Sub Thumbnailer_Interrupted()
    
    ' Reset the Progress Bar
    PBar.Value = 0
    
    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "Interrupted" & vbCrLf
    End If

End Sub

' DropEffect determines the allowed action
Private Sub Thumbnailer_ItemsStartDrag(Data As DataObject, DropEffect As Long)

  On Error Resume Next
  
  Dim iItems As Long    ' Number of items in the collection
    
    ' Get the number of items in the Data.Files collection
    iItems = Data.Files.Count
    
    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemsStartDrag (" & iItems & "), " & DropEffect & vbCrLf
    End If

End Sub

' DropEffect determines the allowed action
Private Sub Thumbnailer_ItemsDragOver(Data As DataObject, DropEffect As Long, Button As Integer, Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal State As Integer)

  On Error Resume Next
  
  Dim iItems As Long    ' Number of items in the collection
    
    ' Get the number of items in the Data.Files collection
    iItems = Data.Files.Count
    
    ' Log the event
'    If chkEvents Then
'        txtEvents = txtEvents & "ItemsDragOver (" & iItems & "), " & DropEffect & ", " & Button & ", " & Shift & ", " & X & ", " & Y & ", " & State & vbCrLf
'    End If

End Sub

' External item(s) have been dropped onto the control
Private Sub Thumbnailer_ItemsDragDrop(Data As DataObject, DropEffect As Long, Cancel As Boolean)
  
  Dim iItems As Long    ' Number of items in the collection
    
    ' Get the number of items in the Data.Files collection
    iItems = Data.Files.Count
    
    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemsDragDrop (" & iItems & "), " & DropEffect & vbCrLf
    End If
    
    ' Although the control handles Copy or Move operations, it
    ' does not refresh automatically as new items are added to
    ' the current Path after a drop operation (Copy or Move).
    ' So we have to manually Refresh.
        
    ' As the system needs time to finish any Copy or Move
    ' operation, we can not just call Redraw here because the
    ' operation may not be completed.

End Sub

' Internal item(s) have been dropped outside the control
Private Sub Thumbnailer_ItemsCompleteDrag(ByVal DropEffect As Long)
    
    ' Log the event
    If chkEvents Then
        txtEvents = txtEvents & "ItemsCompleteDrag (" & DropEffect & ")" & vbCrLf
    End If
    
    ' Although the control handles Copy or Move operations, it does
    ' not refresh automatically when new items are removed from the
    ' current Path after a drag and drop operation (Move).
    ' So we have to manually Refresh.
        
    ' As the system needs time to finish any Copy or Move
    ' operation, we can not just call Redraw here because the
    ' operation may not be completed.

End Sub

