<?php

echo "<html><body bgcolor=#96cde4><span style=\"color:#000000; font-size:10pt; font-weight: normal; text-decoration:none; font-family:Verdana, Arial, Sans-serif\">";

if (!SaveTestFile("./"))
{
  echo "
  <p align=center><table width=500><td><tr>
  <b>LinkMachine Installation</b><br>
  <br>
  Before running this installation script, please turn on all of the write permissions for your site's <i>linkmachine</i> directory.<br>
  <br>
  If you do not know how to set the permissions of a file or directory, please consult your FTP software's documentation. One common method used by many FTP programs is to select the directory, choose <i>Change Permissions</i> from a right-click or pop-down menu, and turn on all write permissions. In other FTP programs you would select <i>chmod</i> instead, and set the permissions number to 777.
  </td></tr></table></p></body></html>
  ";
  exit();
}

$install_list = LoadPage("http://www.linkmachine.net/install/install_list.php", true);

if ($install_list == "")
{
  if (LoadPage("http://www.google.com/", true) == "")
  {
    echo "Php scripts running on your web site cannot access outside web sites. Because of this, LinkMachine cannot install on your site. Please contact your web hosting company to have them fix this problem.";
  }
  else
  {
    echo "Cannot access the site www.linkmachine.net. Please try again in a few minutes.";
  }

  exit();
}

echo "<b>Installing LinkMachine. Please wait, this will take a few moments.</b><br><br>\n";
flush();

parse_str($install_list);

while(list($key, $val)=each($dirs)) 
{
  $val = str_replace("linkmachine/", "./", $val);
  if (!file_exists($val))
  {
    mkdir($val);
  }
  
  chmod($val, 0777);
}

$file_count = count($files);
$files_copied = 0;
$perdec = -1;

while(list($key, $val)=each($files)) 
{
  $src_file = "http://www.linkmachine.net/install/".$val;
  $dst_file = str_replace(".php_", ".php", $val);
  $dst_file = str_replace("linkmachine/", "./", $dst_file);

  $file_contents = LoadPage($src_file, false);

  // Save the file to disk
  $fd = @fopen($dst_file, "w");

  if ($fd == false)
  {
    echo "Error saving file $dst_file<br><br>";
    GenerateErrorData();
    exit();
  }
  else
  {
    fwrite($fd, $file_contents);
    fclose($fd);
    chmod($dst_file, 0777);
  }

  $files_copied++;
  $new_perdec = floor($files_copied * 10 / $file_count);
  if ($new_perdec != $perdec)
  {
    $perdec = $new_perdec;
    echo ($perdec * 10)."%<br>\n";
    flush();
  }
}

echo"
<script language=\"JavaScript\">
var lm_url = document.location.href;
lm_url = lm_url.substring(0, lm_url.length - 11);
document.location.href = lm_url + 'linkmachine.php?ua=fresh_install&base_url=' + escape(lm_url);
</script>
</span></body></html>
";

function LoadPage($_url, $_ping=true)
{
  if ($_ping)
  {
    $host = str_replace("https://", "", $_url);
    $host = str_replace("http://", "", $host);
    if (is_integer(strpos($host, "/")))
    {
      $host = substr($host, 0, strpos($host, "/"));
    }
    if ($fp = @fsockopen($host, 80, $errno, $errstr, 5))
    {
      fclose($fp);
    }
    else
    {
      return "";
    }
  }

  $fp = @fopen($_url, 'r');

  if ($fp == false) {
    return "";
  }

  $page = "";

  while (feof($fp) == false)
  {
    $page .= fread($fp, 10000);
  }

  fclose($fp);

  return $page;
}

function SaveTestFile($_directory)
{
  // Save a test file to disk
  $fd = @fopen($_directory."lm_test.txt", "w");
  
  if ($fd) 
  {
    // Test was successful
    fclose($fd);
    unlink($_directory."lm_test.txt");
    return true;
  }

  return false;
}

function GenerateErrorData()
{
  $php_version = phpversion();

  echo "
<br>
<h3>LinkMachine Installer Error Information</h3><br>\n
An error has occurred while installing LinkMachine. Please do the following:<br>\n
1) Press Ctrl+A to select all of the contents of this checkup page<br>\n
2) Press Ctrl+C to copy it<br>\n
3) <a href=\"mailto:contact@linkmachine.net\">Open a new e-mail</a> and paste the contents of this page into it by pressing Ctrl-V<br>\n
4) Send the e-mail to contact@linkmachine.net<br>\n
<br>\n
Thank you!<br>\n
<br>\n";

  phpinfo(INFO_GENERAL | INFO_CONFIGURATION | INFO_ENVIRONMENT | INFO_VARIABLES);
  
  echo "<br><br>LinkMachine Directory Information<br><br>\n";

  $handle=opendir("./");

  while ($file = readdir($handle)) 
  {
     if(is_dir($file) && $file != ".") {
       echo "<b>$file (dir)</b><br>\n";
     } else if ($file != ".") {
       echo "<b>$file</b> size: ".filesize($file)." perms: ".fileperms($file)." modified: ".date("r", filemtime($file))."<br>\n";
     }
  }

  // Save a test file to disk
  $fd = @fopen("lm_test.txt", "w");

  echo "<br><br>Test file write: ".($fd ? "Success" : "Fail")."<br><br>\n";
  
  // Delete the test file if it was written
  if ($fd) 
  {
    fclose($fd);
    unlink("lm_test.txt");
  }

  // Attempt to load page from LinkMachine site
  $page = LoadPage("http://linkmachine.net/", true);

  echo "<br><br>LinkMachine site available: ".(($page == "") ? "No" : "Yes")."<br><br>\n";

  echo "<br><br></span></body></html>\n";
}

?>