/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/* Author: Don Gillies */

/* A very useful test program for TCP.  This finger program starts a server,
 * fingers 2 foreign hosts at once, then continually fingers the
 * foreign host, alternately closing first; then second; then first, etc.
 * When this host closes first, it goes into TIMEWAIT and there is a
 * long delay; see <ntcpblk.h>.
 *
 * NOTE: some hosts will abort the user listing when this TCP closes
 * first; BE WARNED THAT SOMETIMES THE FOREIGN HOST WILL CLOSE BEFORE
 * SENDING A LISTING.  CSR's TCP will xmit data after sending a FIN, a
 * csr protocol bug, causing this TCP to sometimes miss the first character
 * of the listing; again, this is not my bug.
 *
 * F10 stops the program; 2,3,4,5 sets the debug level; 3 and 2 are most
 * useful; AT ANY TIME DURING THE PROGRAM'S EXECUTION.
 *
 * At this writing, THIS TEST PROGRAM ALSO GENERATES A PROFILE:
 * profile.pro, in case you want to use it for efficiency computations.
 */

#include	<notice.h>

typedef	long	time_t;			/* ugly! */

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include	<ntcp.h>
#include	<ntcpblk.h>
#include	<em.h>

#define	FINGERSOCK	79
#define	WINDOW		1000
#define	TWOCON		2
#ifdef	TCPSTUB			/* hand test the TCP */
#define	MAXTIME		32000
#else				/* automatic TCP test */
#define	MAXTIME		240
#endif
int	us_opna(), us_cls(), us_tmo(), us_space(), us_yld(), us_null();
int	displa(), quit(), us_rsd(),us_8rs(), clsnotify();
int	sv_opna(), sv_cls(),sv_chk(),cli_cls(), don_tmo(), keybd();
int	tcp_demon();
int	opened,shot;
task	*mainproc;

int	(*myprocs[])() = {us_opna,us_8rs,displa,us_space,clsnotify,us_cls};
int	(*svprocs[])() = {sv_opna,us_8rs,sv_chk,us_space,cli_cls,sv_cls};

TcpCon con,con2,pcon;	/* have passive connection */
extern	NET	nets[];
int etwpp;		
int etdrop;
timer *tm,*tm2;

in_name	fhost;
main(argc, argv)
int	argc;
char	**argv;
{
	char	name[40];
	char	*p, *q;
	long int	tries;

	if (!tcp_init(800)) printf("Couldn't init TCP\n");

	if(argc < 2) {
		printf("usage: whois [user]@host\n");
		exit(0);
	}

	for(p = argv[1], q = name; *p != NULL && *p != '@';)
		*q++ = *p++;

	if(*p == NULL) {
		printf("usage: %s [user]@host\n", argv[0]);
		exit(1);
	}

	*q++ = '\n';
	*q = NULL;

	p++;				/* skip over '@' */
#ifndef	TCPSTUB
	(int *) tk_fork(tk_cur, keybd, 500,"keybd",0);
#endif
	if(NDEBUG)
		printf("Attempting to resolve host name %s\n",p);

	if((fhost = resolve_name(p)) == 0L) {
		printf("Host not known\n");
		exit(0);
	}
	else printf("foreign host is at %a", fhost); 
	putchar('\n');
	if(fhost == 1L) {
		printf("Name servers not responding.\n");
		exit(0);
	}

	printf("IBM PC %s Experimental TCP/Finger - bugs to bug-pc@mit-csr\n",
	nets[0].n_name);

	tm = tm_alloc();
	tm2= tm_alloc();
	if(tm ==0 | tm2 == 0) {
		printf("Couldn't allocate timer.\n");
		exit(0);	
	}
	mainproc = tk_cur;

	printf("attempt to listen #1\n");
	pcon = tcp_listen(FINGERSOCK,WINDOW,WINDOW/2,svprocs);
	printf("attempting open # 3\n"); 
	con2 = tcp_open(fhost, FINGERSOCK, 0, WINDOW, WINDOW/2,myprocs);
	printf("attempting open #2\n"); 
	con = tcp_open(fhost, FINGERSOCK, 0, WINDOW, WINDOW/2,myprocs);
	con->ack_dally = con2->ack_dally = 0;	    
	/*space_display();*/
	tm_clear(tm2);
	tm_set(MAXTIME, us_tmo, 0, tm2);

	tk_block(); 
	tk_block(); 
	printf("\nBOTH CONNECTIONS OPEN NOW\n");
	tputs(con,name);
	tputs(con2,name);
	tk_yield();		
	tcp_close(con);
	tcp_close(con2);
	printf("Now waiting for a close...\n");
	tk_block(); 
	tk_block(); 

	printf("End of test, part 1\n");
	shot = 0;

	for (tries = 1 ; ; tries ++) {
		tm_clear(tm);
		tm_set(2, don_tmo, 0,tm);
		tk_block();
		printf("-----------------------------------------\n");
		printf("IF THIS IS STILL RUNNING LEAVE A NOTE FOR\n");
		printf(" DON GILLIES BEFORE USING IT FOR SELFISH \n");
		printf("	     PERSONAL REASONS		 \n");
		printf("-----------------------------------------\n");
		opened = 1;
		printf("Trying to open\n");
		con2 = tcp_open(fhost,FINGERSOCK,0,WINDOW,WINDOW/2,myprocs);
		tcp_setu(con2,mainproc);
		if (TCDBG) printf("Open loc = %d\n",con2);
		tk_block();	/* wait for open to occur */
		opened ++;	/* set it to 3 */
		tputs(con2,name);
		if (shot) {
			printf("I'LL DO THE CLOSING\n");
			tcp_close(con2);
		}
		tk_block();	/* fclose will close us -- wait for it */
		shot = 1-shot;
		printf("End of cycle number %d\n\n",tries);
	}
}

keybd()
{   
	int c;
	while (1) {
		switch(c = h19key()) {
		case '5': 
			{
				TDEBUG= TRUE;
				NDEBUG |= TPTRACE;
				break;
			}
		case '4': 
			{

				TDEBUG = TRUE;
				NDEBUG = NETERR|PROTERR|NETRACE|INFOMSG|BUGHALT|TPTRACE;
				printf("debug is DEFINED\n");
				break;
			}

		case '3': 
			{
				NDEBUG |= TPTRACE;
				break;
			}
		case '2': 
			{
				TDEBUG = FALSE;
				NDEBUG = NETERR | PROTERR | BUGHALT;
				break;
			}
		case F10:
			exit(0);
		case NONE:
			{
		    	tk_yield();
			continue;
			}
		}
		printf("\nDBG %c\n",c);
		tk_yield();
	}
}

displa(con, buf, len)
register TcpCon con;
register char	*buf;
int	len;
{
	fwrite(buf, 1, len, stdout);
	return(WINDOW);
}

us_tmo() {
	printf("Host not responding\n");
	quit();
}


quit() {
	printf("Whois: quit %d bad wakes %d dropped p's\n",etwpp,etdrop);
	tk_yield();
	exit(1);
}

us_opna() {
	printf("Open %d\n",++opened);
	tk_wake(mainproc); 
}


us_cls(lcon,norst) int norst; 
TcpCon lcon;
{
	if (norst) printf("Closed %d\n",--opened); 
	else {
		printf("Open resulted in a reset %d\n",lcon);
		if (con==lcon) con = 0; 
		else con2=0;
	}
	tk_wake(mainproc);
}


us_space(con)
TcpCon con; 
{
/*	printf("SPACE AVAIL\n"); */
	/* assume only the finger process will need space */
	tk_wake((task *) tcp_getu(con));
}

us_8rs(){
	printf("Timeout! no connection.\n");
}

sv_opna(con)
TcpCon con;
{	
	int satisfy();
	TcpCon tcon;
	printf("DWG: Task ETDEMUX now running.\n");
	tcon = tcp_listen(FINGERSOCK,WINDOW,WINDOW/2,svprocs);
	printf("FINGER REQUEST %u COMING THROUGH\n",tcon);
	/* fork process to satisfy finger request */
	tcp_setu(con,tk_fork(tk_cur, satisfy, 600,"SATISFY", (unsigned) con));
}

satisfy(mycon) TcpCon mycon;
{	
	register int i;
	for( i = 0; i<2000; i++) {
		tputs(mycon,"Donald gillies logged into zud.  time = XYZ\n");
	}
	tcp_close(mycon);		/* server must close connection */
	/*	printf("FINGER REQUEST SATISFIED\n"); */
	tk_exit();
}

sv_chk(con, buf, len)
register TcpCon con;
register char	*buf;
int	len;
{	
	printf("FINGER-SERVER:Host says:"); 
	if (len ==0) printf("Nothing?");
	fwrite(buf, 1, len, stdout); 
	putchar('\n');
}

sv_cls()
{
	printf("FINGER-SERVER:  Remote host has closed.  Dying.\n");
}

clsnotify(mycon)	/* client wishes to close */
TcpCon mycon;
{	/* can do anything from here */
	printf("$$$$$$$$$$$$ CLIENT %d CLOSED $$$$$$$$$$$$\n",mycon);
	if (opened == 2) 	/* haven't put data in pkt yet? */
		shot = 1 - shot;	/* close it later */
	if (shot ==0)  {
		printf("closing my side...\n");
		tcp_close(mycon);	/* I'll close as well */
	}
}

cli_cls(mycon)
TcpCon mycon;
{
	 	printf("$$$$$$$$$$$$ PASSIVE CLIENT %d CLOSED $$$$$$$$$$$$\n",mycon);
	printf("Pks sent = %d, Pks rcvd = %d", tcppsnt,tcpprcv);
	printf("Old = %d Not for my sock = %d bd_chk = %d",tcprercv,tcpsock,bd_chk);
	printf("Resends=%d",tcpresend);
}


don_tmo()
{
	tk_wake(mainproc);
}
#ifdef	NEVER
tputz(con,str)			/* puts a string onto network */
char	*str;
register TcpCon con; 
{	
	register char c;
	/* specify there's new data before buffer it -- in case we block */
	if (!(c = *str)) return;
	do {	
		tputc(con,c);
	} 
	while (c = *++str);
	/* specify new data if we haven't already (in Tfixit) */
	if (con->SendReason < NEWDATA) tcp_newdata(con);
}
#endif
