  //
  // Xactor.t, an actor, layered clothing, and bodyparts library for TADS3
  // based on the TADS2 xactor.t and requiring excitementobject.t
  //
  // version dated March 24, 2003.
  //
  // only include this file once
#pragma once
  // This code copyrighted (C) 2003 by Choices, and contributors.
  // This code is licensed under the IF Library License.
  //
  // Permission is hereby granted to use, copy, modify and/or 
  // distribute this package, provided that: 
  // * copyright terms are retained unchanged, whether the package 
  //   is modified or not.
  // * any distribution of this package, whether modified or not, 
  //   includes this notice.
  // * Aggregation of a binary version of this package with a 
  //   binary distribution is always permitted provided that 
  //   the use of this package is embedded; that is, when no 
  //   overt attempt is made to make this package's code 
  //   interfaces visible to the end user of the binary 
  //   distribution. Such use shall not be construed as a 
  //   distribution of this package.
  //
#include "excitementobject.h"
#include "xactor.h"
  //
  //   Contributions, ideas used, derivative works, and fair use 
  //   of code:
  //
  //  This code is explicitly based on the TADS2 xactor, which in
  //  turn is based on MMX, by d. TADS2 xactor contained code
  //  copyrighted by Scarlet Herring, specifically his iVerb
  //  implementation. Scarlet Herring's iVerb is not a part of
  //  this code. mmx_d's clever class breakdown is a part of this
  //  code. One of the really spectacular things he did was make
  //  functional bodypart classes which then are inherited by
  //  structural bodyparts. A large part of the ideas of the 
  //  original structure-function breakdown are retained in this
  //  code, and in some ways expanded, by separating XXXXed classes
  //  from XXXXing classes.
  //   
  //  We have borrowed ideas liberally from other sources (ideas 
  //  are not copyrightable, though implementations are). I
  //  noted in ArKane's layered library that he inverted the 
  //  layering convention, and I do so here. Sir Gareth had
  //  the clever idea of liftable clothing. We use a version of
  //  that idea here. From the game "Prom Night", we've taken
  //  the ideas of a public location, and implemented a version
  //  of autodressing and autostripping code. From NewKid, we 
  //  use the idea of a default clothing drop location. Ideas 
  //  don't arise in a vacuum and we have used other people's 
  //  good ideas when possible.
  //
  //  Unlike some librarians, we have enough guts to tell people
  //  when we have used the ideas of others. Uncredited use of
  //  other people's code implementations is a copyright violation
  //  and a kind of code theft. The distribution of code that 
  //  takes implementations from coyrighted code without credit 
  //  is software piracy. There are examples of both in AIF these 
  //  days.
  //
  //  Derivative works of this library must retain the license terms
  //  of this library. There are no exceptions. Don't think I'll take
  //  pity on you if you make a thinly disguised rewrite of this code
  //  and put a different license on it. I'll take that derived work
  //  and incorporate all the good ideas back into this code, and throw
  //  your illegal license away. If however you retain the license terms
  //  of this code you have my blessings. The point behind an open source
  //  license is to encourage interesting forks that everyone can use.
  //
  //  If you use this library in your binary game, you do not have to
  //  credit the librarian, but he strongly encourages it. 
  //
  //
  //
modify Person
  //
  // Actor Xclothing routines.
  //
  // created     ca 6/99.
  // translated to TADS3: 01/13/2003.
  //
  //
  // Coverage code for bodyparts; unusable unless actor has bodyparts.
  //
  // method: coveredBy
  // usage : return true if bodyPart covered, nil otherwise.
  //         Set overpart in bodyPart to the covering clothing object.
  //         This algorithm also calculates total touch percentage for
  //         a bodypart.
  //
  coverLevel = -1
  coveredBy ( bodyPart ) 
  {
    local l, c, touchpct;
    c = nil;
    touchpct = 100;
    coverLevel = -1;
    l = self.contents.length;
    if ( l < 1)
      { return(nil); }
      //
      // What happens here:
      //   We scan the contents list of the Actor for Xclothing.
      //   If we find any, does it cover the bodyPart?
      //   If yes, and it's the outermost clothing layer, we record
      //   what it is. Also, in the meantime, we calculate the
      //   touch percent product associated with the garment.
      //
    foreach(local cur in contents)
      {
        if (cur.ofKind(Xclothing))      
          {
            if (cur.checkCover(bodyPart))
              {
                  //
                  // material properties take priority over touchPercent.
                  //
                if ( cur.material.touchThru != transparent )
                  touchpct = touchpct*cur.touchPercent/100;
                if (cur.coverLevel > coverLevel )
                  {
                    c = cur;
                    coverLevel = cur.coverLevel;
                  }
              }
          }
      }
    if ( coverLevel > -1 )
      { 
        bodyPart.overpart = c;
        bodyPart.totalTouchPercent = touchpct;
        return(true); 
      }
    else { return(nil); }
  }
  //
  // Coverage code for clothes.
  //
  // method: canBeTaken
  // usage : returns a list of garments that possibly can prevent wearing
  //         or removal of clothing. Helper method for verDoWear and 
  //         verDoUnwear in Xclothing.
  //
  //         If no clothing prevents action, the list returned is empty.
  //
  //
 
  canBeTaken ( garmentList ) 
  {
    local l, lst;
    l = garmentList.length;      
    lst = [];
    if ( l < 1 )
      return( lst );
    foreach (local cur in contents) {
      foreach( local g in garmentList)
      {
        if (cur.ofKind(g)) {
          if (coveredBy(cur)) {
            lst += cur.overpart;
          }
        }
      }
    }
    return( lst ); 
  }
  //
  // Visualization check for clothes. 
  //
  // method:   canBeSeen
  // usage :   return true if garment can be seen, nil otherwise.
  //
  //           If garment cannot be seen, highest covering item returned in
  //           Xclothing property xCovers. 
  //
  //           If garment is seen through transparent layer(s) of clothes, the
  //           highest transparent layer returned in the Xclothing 
  //           property xThrough
  // modified: 02/04/2003
  //
  // bugs:     12/15/2002 - The old partial coverage bug has been squashed. This algorithm
  //           requires 'garment' to have a nonempty locationList. xUnderneath
  //           eventually needs to become a list...
  //
  //           02/04/2003 - the cumulative coverage bug has been squashed. An item totally
  //           covered by two or more garments would return a false canBeSeen. In the 
  //           cumulative case, what covers is not determined (xCovers = nil ).
  //
  canBeSeen ( garment ) 
  {
    local l, m, tmp, myLevel, transLevel, underLevel;
    local checkList, oneList, twoList, cumeList;
    myLevel = garment.coverLevel;
    underLevel = -1;
    transLevel = garment.coverLevel;
    garment.xThrough = nil;
    garment.xCovers = nil;
    garment.xUnderneath = nil;
    tmp = true;
    l = garment.locationList.length();
    checkList = garment.locationList;
    cumeList=[];
    m = contents.length();
      //
      // If either l or m is 0 we have a biiig problem. The code is busted.
      // So we bail and return true.
      // Would be nice to be able to throw an exception here.
      //
    if ( ( l < 1) || (m < 1 ) )
      return( true );
    foreach(local cur in contents) {
      foreach( local bodytype in checkList )
      {
          //
          // Is this element of the contents list an anatomy subclass in 
          // garment.coverList? In other words, is this one of the bodyparts 
          // that my garment covers? If so, we now have to search the Actor 
          // for all Xclothes that cover this part. Once we find them we need
          // to test the clothing to see if they cover our garment.
          //
        if (cur.ofKind(bodytype)) {
            //
            // We now scan the contents list for clothes that cover our selected 
            // bodypart.
            //
          foreach (local cur2 in contents ) {
          if (cur2.checkCover(cur))
            {
                //
                // found something that covers the bodypart.
                // Is it a higher layer than my garment?
                //
              if (cur2.coverLevel > myLevel )
                {
                    //
                    // get coverlists that are sorted and have only unique 
                    // components.
                    //
                  oneList = checkList.getUnique();
                  twoList = cur2.coverList.getUnique();
                  cumeList = cumeList + twoList;
                    //
                    // is garment's list contained in the list of the new item?
                    //
                  if ( twoList == twoList.appendUnique(oneList) ) 
                  {
                    //
                    // If you get here in this code, the garment being passed is 
                    // covered by something. So is it transparent or not? If it's
                    // transparent, the clothes aren't covered, but for special
                    // effects, we might want to know what is covering us 
                    // (hence xThrough). Otherwise, something opaque covers us
                    // and we want to return nil (we set tmp to nil) and set
                    // the xCovers property.
                    //
                  if ( ! ( cur2.material.seeThru == transparent ) ) 
                    {
                      tmp = nil;
                      garment.xCovers = cur2;
                      myLevel = cur2.coverLevel;
                    }
                  else 
                    {
                      if (cur2 > transLevel) {
                        transLevel =  cur2.coverLevel;
                        garment.xThrough = cur2;
                      }
                    }
                  }
                }
                //
                // is clothing item just underneath our garment?
                //
              else if (cur2.coverLevel > underLevel )
                {
                  underLevel = cur2.coverLevel;
                  xUnderneath = cur2;
                }
            }
          }
        }
      }
    }
    l = cumeList.length();
    if ( l < 1)
      return( tmp ); 
    else {
      if ( tmp ) {
        //
        // At this point it is possible that two or more garments cumulatively cover
        // our current garment. cumeList allows us to check for that possibility.
        //
        oneList = checkList.getUnique();
        twoList = cumeList.getUnique();
        //
        // is garment's list contained in the list of all cumulative items?
        //
        if ( twoList == twoList.appendUnique(oneList) ) {
          tmp = nil;
          //
          // need a fix for this next result too.
          //
          garment.xCovers = nil;
        }
      }
      return ( tmp );
    }
  }
;
/************************************************************************/
// Room modification for Sex-is-Public flag
//
modify Room
  xaSexIsPublic = true
;
/************************************************************************/
// Thing modification for the uberLoc function
//
// uberLoc: returns either the Actor or the Room that contains 'Thing'.
// If 'Thing' is a room, return self.
// Inspired by a similar function by Stephen Granade in TADS2.
//
modify Thing
  uberLoc
  {
    local obj = self;
    if ( obj.ofKind(Room) )
      return obj;
    for (local i = 0; i < 12; i++ ) {
      obj = obj.location;
      if ( obj.ofKind(Actor) || obj.ofKind(Room) || obj == nil )
        break;
    }
    if (obj.ofKind(Actor) || obj.ofKind(Room))
      return obj;
    else return nil;
  }
//
// uberRoom: returns the Room that contains 'Thing'. If 'Thing' is a Room, return self.
// Inspired by a similar function by Stephen Granade in TADS2.
//
  uberRoom
  {
    local obj = self;
    if ( obj.ofKind(Room) )
      return obj;
    for (local i = 0; i < 12; i++ ) {
      obj = obj.location;
      if ( obj.ofKind(Room) || obj == nil )
        break;
    }
    if ( obj.ofKind(Room))
      return obj;
    else return nil;
  }
;
/************************************************************************/
// Xclothing : clothing that identifies what it covers.
// Needed to make sense of wearing clothes in this game.
/************************************************************************/
class Xclothing: Wearable
{
//
// most clothes are singular
//
isPlural = nil
//
// Clothes are made of a material (see Material in sense.t )
//
material = adventium
//
// most clothes are not seen through other clothes
//
xThrough = nil
//
// xCovers = what covers you, if anything. Not used at present, though set.
//
xCovers = nil
//
// xUnderneath = what is directly under this item of clothing
//
xUnderneath = nil
//
// coverList, a list of classes that can/will be covered. 
//
coverList = [ titsPart, assPart, pussyPart, mouthPart, penisPart ]
//
// locationList, where a piece of clothing is (whether covers or not)
//
locationList = coverList
//
// openList, if clothing is open, what is covered?
//
openList = coverList
//
// Is the clothing open or not? Default clothing is never open.
//
initiallyOpen = nil
//
// defaultDropLocation.. will drop here if 'dDL' and actor share a uberRoom.
//
defaultDropLocation = nil
//
// coverLevel: set by convention (though feel free to change)
//
// allows you to determine what could cover what.
//
coverLevel = xcCoverOuter
//
// percentage of touch transmitted through clothes. Should be between 0 and 100.
//
touchPercent = 0
//
// default desc for people who wish the canBeSeen code to manifest.
// override if needed.
//
bulk=3
desc 
  {
    if (isWorn) {
      if (location.canBeSeen(self))
        clothingDesc;
      else " You can\'t see the <<name>>. ";
    }
    else clothingDesc;
  }
clothingDesc  
{
    "<<itIs>> <<name>>. ";
} 
thedesc
{
  "<<location.itPossAdj>> <<name>>";
}
hideFromAll(actor)
{
  if (isWorn) 
    if (location.canBeSeen(self))
      return nil;
    else return true;
  return nil;
}

  //
  // method: checkCover
  // usage : return true if part (a bodypart) is covered by the Xclothing
  //         return nil otherwise.
  // changes: 3/5/2003 fixed an issue with openable clothing and subclasses of openables.
  //
checkCover ( part ) 
  {  
    local l, c;
    if ( isOpen ) {
      l = openList.length();
      c = openList;
    }
    else {
      l = coverList.length();
      c = coverList;
    }
    if (l < 1 )
    { return(nil) ; }
    else 
    {
      if (isWorn) {
          foreach( local cov in c ) {
              if ( part.ofKind(cov))
                { return(true); }
          }
      }
      return(nil); 
    }
  }

  textWear = "{You/he} put{s} on the <<name>>. "
  textRemove =  "\^<<gActor.name>> slowly take<<gActor.verbEndingS>> off the <<name>>\, 
        and let<<gActor.verbEndingS>> <<itObj>> fall. "

  dobjFor( Wear )    
  {  
    verify() 
    { 
      if (( isWorn ) && ( gActor != location ))
        illogicalNow(' {You/he} can\'t wear someone else\'s clothes. ');
      if ( isWorn )
        illogicalNow(' The ' + name + ' ' + verbToBe + ' already being worn. ');
      if ( location == gActor )
        logicalRank(150, 'isheld');
    }

    check()
    {
      local top, c, i, l, lst;
      top = coverLevel;
      c = -1;
      lst = gActor.canBeTaken( self.coverList );
      l = lst.length;
      if ( l < 1 )
        { }
      else {
        for (i = 1; i <= l; i++ ) {
          if ( lst[i].coverLevel >= top ) {
            c = i;
            top = lst[i].coverLevel;
          }
        }
      if (c > -1 ) {
        " \^<<gActor.itIs>> wearing <<lst[c].aName>>. \^{You/He} can\'t put on 
          the <<name>> unless {you/he} want{s} to look really silly. ";
        exit;
        }
      }
    }
    action() 
    { 
      textWear;
      if ( ofKind(Openable) )
        makeOpen(nil);
      makeWornBy(location);
      moveInto(gActor);
      if ( gActor.ofKind(Xactor) )
        if ( gActor.clothed() )
         gActor.setWear();
    }
  }
    // later we should work this so clothes can be held but not worn.


  dobjFor(UnWear)
  {
    verify()
    {
      if ( ! isWorn ) 
        illogical('\^' + theName + ' ' + verbToBe + 'n\'t being worn. ');
      if ( isWorn && isWornBy(gActor) )
        logicalRank(150, 'wornbywhom');
      if ( isWorn && ( ! isWornBy(gActor)) && location.location == gActor.location )
        logicalRank(100,'wornbywhom');
      if ( isWorn && ( ! isWornBy(gActor)) && location.location != gActor.location )
        logicalRank(80,'wornbywhom');
      if ( isWorn && location.canBeSeen( self ) )
        logicalRank(100,'isvisible');
      else if ( isWorn && ( ! location.canBeSeen( self ) ) )
        logicalRank(80,'isvisible');
    }

    check()
    {

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( gActor != location && ( ! gActor.ofKind(Xactor) ) ) {
          //
          // assuming non-Xactors are animals and not humans..
          //
        "\^<<gActor.name>> can\'t do this. ";
        exit;
      }
      if ( ( gActor != location ) && gActor.ofKind(Xactor) &&
              gActor.xaWillingness < wlVeryInvolved ) {
        "\^<<gActor.name>> is not willing to do this. ";
        exit;
      }
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to remove <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to remove <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to remove <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to remove <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to remove 
         <<thedesc>> in a public location. "; 
         exit;
        }          
    }



    action()
    {
      
      textRemove;      
      makeWornBy(nil); 
        //
        // drop items unless 'nil' bug happens. 
        //
      if ( ( defaultDropLocation != nil ) && ( defaultDropLocation.uberRoom() == uberRoom() ) )
        moveInto(defaultDropLocation);
      else if (location.location <> nil )
        moveInto(location.location);
      if ( gActor.ofKind(Xactor) )
        if ( gActor.clothed() )
         gActor.setWear();
    }
  }
  dobjFor(GiveTo)
  {
    verify()
    {
      if ( isWorn && ( ! isWornBy(gActor) ) )
        illogicalNow(' That\'s someone else\'s garment. ');
      if ( location == gActor )
        logicalRank(150, 'isheld');
      if ( uberLoc() == gActor )
        logicalRank(140, 'iskept');
      if ( location == gActor.uberRoom )
        logicalRank(100,'onGround');
    }
  }
  dobjFor(ShowTo)
  {
    verify()
    {
      if ( isWorn && ( ! isWornBy(gActor) ) )
        illogicalNow(' That\'s someone else\'s garment. ');
      if ( location == gActor )
        logicalRank(150, 'isheld');
      if ( uberLoc() == gActor )
        logicalRank(140, 'iskept');
      if ( location == gActor.uberRoom )
        logicalRank(100,'onGround');
      if ( location.ofKind(Actor) && location != gActor )
        logicalRank(70,'someone else');
    }
  }
  dobjFor(Doff) remapTo(UnWear, self)
  //
  // convenience methods - so it can be overridden.
  //
  xcRemove
  {
    if ( location.ofKind(Actor) && isWorn ) {
      makeWornBy(nil);
      if (( defaultDropLocation != nil ) && ( defaultDropLocation.uberRoom() == uberRoom() ) )
        moveInto(defaultDropLocation);
      else if (location.location <> nil )
        moveInto(location.location);      
    }     
  }
} /* Xclothing class */

/*******************************************************************/
/* sample Xclothing classes */
class wigtype : Xclothing
coverList = [ hairPart ]
coverlevel = xcCoverOuter
;
class hattype : Xclothing
coverList = [ hairPart ]
coverlevel = xcCoverOuter
;
class glassestype : Xclothing
coverList = [ eyesPart ]
coverlevel = xcCoverOuter
;
class jackettype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart ]
coverLevel = xcCoverOuter
;
class coattype : Xclothing
bulk=5
coverList = [ titsPart, nipplesPart, chestPart, bellyPart, pussyPart, clitPart, assPart, 
              penisPart, groinPart ]
coverLevel = xcCoverOuter
;
class sweatertype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart ]
coverLevel = xcCoverSweater
;
class vesttype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart ]
coverLevel = xcCoverVest
;
class dresstype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart, assPart, pussyPart, clitPart, 
               penisPart, groinPart ]
coverLevel = xcCoverShirt
touchPercent = 50
;
class overallstype : Xclothing
bulk=5
coverList = [ titsPart, nipplesPart, chestPart, bellyPart, pussyPart, clitPart, assPart, 
              penisPart, groinPart ]
coverLevel = xcCoverSweater
;
class blousetype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart ]
coverLevel = xcCoverShirt
touchPercent = 50
;
class shirttype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart, bellyPart ]
coverLevel = xcCoverShirt
touchPercent = 50
;
class skirttype : Xclothing
coverList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
coverLevel = xcCoverShirt
touchPercent = 40
;
class pantstype : Xclothing
coverList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
coverLevel = xcCoverShirt
isPlural = true
touchPercent = 40
;
class sliptype : Xclothing
coverList = [ titsPart, chestPart, nipplesPart, bellyPart, pussyPart, clitPart, assPart,
              penisPart, groinPart ]
coverLevel = xcCoverSlip
touchPercent = 90
;
class halfsliptype : Xclothing
coverList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
coverLevel = xcCoverSlip
touchPercent = 90
;
class bratype : Xclothing
coverList = [ titsPart, nipplesPart, chestPart ]
coverLevel = xcCoverUndies
touchPercent = 70
  //
  // size bras to the woman
  //
cupSize = xaLargeTits
  dobjFor(Wear)
  {
    verify() { inherited; }
    check() 
    {
      inherited;

      local tits = nil;
      local z = gActor.contents;
      foreach( local part in z)
        if ( part.ofKind(titsPart) )
          tits = part;
       if ( tits != nil ) {
         if ( cupSize < tits.titSize ) {
           "\^<<theName>> is too small for <<gActor.itObj>> to be able to wear. ";
           exit;
         }
         if ( cupSize > tits.titSize ) {
           "\^<<theName>> is too large for <<gActor.itObj>> to be able to wear. ";
           exit;          
         }   
       }  
    }
    action() { inherited; }
  }
;
class pantytype : Xclothing
bulk=1
coverList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
coverLevel = xcCoverUndies
touchPercent = 90
;
class bellychaintype : Xclothing
bulk=1
coverList = []
locationList = [ bellyPart ]
coverLevel = xcCoverUndies
touchPercent = 100
;
class onepiecetype : Xclothing
coverList = [ titsPart, chestPart, nipplesPart, bellyPart, pussyPart, clitPart, assPart, 
              penisPart, groinPart ]
coverLevel = xcCoverUndies
touchPercent = 80
;
class veiltype : Xclothing
bulk=1
coverList = [ mouthPart ]
coverLevel = xcCoverSweater
;
class openableXclothing : Openable, Xclothing
  okayOpen = " {You/he} open{s} << theName>>. "
  okayClose = " {You/he} close{s} <<theName>>. "
  descContentsLister = thingDescContentsLister
  openList = []
  coverList
  {
    if ( isOpen )
      return openList;
    else return locationList;
  }
  dobjFor( Open )
  {
   verify() { inherited; }
   check()
    {

      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if (isWorn) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to open <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to open <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to open <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to open <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to open 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }

    action () 
    { 
      makeOpen(true);
      okayOpen;      
     }
  }
  dobjFor(Close) {
    verify() { inherited; }
    check()
    {

      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to close <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to close <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to close <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to close <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to close 
         <<thedesc>> in a public location. "; 
         exit;
        }
      }          
    }
    action() 
    {
      makeOpen(nil);
      okayClose;      
    }
  }
;
class zippableXclothing : openableXclothing
  alreadyZipped = theName + ' ' + verbToBe + ' already zipped. '
  okayZip = " {You/he} zip{s} << theName>>. "
  alreadyUnzipped = theName + ' ' + verbToBe + ' already unzipped. '
  okayUnzip = " {You/he} unzip{s} <<theName>>. "
  zipDesc
  {
    if ( isOpen )
      "It\'s unzipped. ";
    else "It\'s zipped. ";
  }
  dobjFor(Open) remapTo(UnZip, self)
  dobjFor(Close) remapTo(Zip, self)
  dobjFor(Zip)
  {
    verify() 
    { if ( ! isOpen )
        illogicalNow( alreadyZipped );
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to zip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to zip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to zip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to zip <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to zip 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(nil);
      okayZip;      
    }
  }
  dobjFor(UnZip)
  {
    verify() 
    { if ( isOpen )
        illogicalNow( alreadyUnzipped );
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unzip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unzip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unzip <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unzip <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to unzip 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(true);
      okayUnzip;
    }
  }

;
class buttonableXclothing : openableXclothing
  alreadyButtoned = theName + ' ' + verbToBe + ' already buttoned. '
  okayButton = " {You/he} button{s} <<theName>>. "
  alreadyUnbuttoned = theName + ' ' + verbToBe + ' already unbuttoned. '
  okayUnbutton = " {You/he} unbutton{s} <<theName>>. "
  buttonDesc
  {
    if ( isOpen )
      "It\'s unbuttoned. ";
    else "It\'s buttoned. ";
  }
  dobjFor(Open) remapTo(UnButton, self)
  dobjFor(Close) remapTo(Button, self)  
  dobjFor(Button)
  {
    verify() 
    { 
      if ( ! isOpen ) { illogicalNow(alreadyButtoned); }
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to button <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to button <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to button <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to button <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to button 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(nil);
      okayButton;
    }
  }
  dobjFor(UnButton)
  {
    verify() 
    { 
      if ( isOpen ) { illogicalNow( alreadyUnbuttoned );  }
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unbutton <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unbutton <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unbutton <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to unbutton <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to unbutton 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(true);
      okayUnbutton;
    }
  }

;

class liftableXclothing : openableXclothing
  alreadyLifted = theName + ' ' + verbToBe + ' already lifted up. '
  okayLiftup = " {You/he} lift{s} up <<theName>>. "
  alreadyStraightened = theName + ' ' + verbToBe + ' already straightened. '
  okayStraighten = " {You/he} straighten{s} out <<theName>>. "
  liftDesc
  {
    if ( ! isOpen )
      "It is normal. ";
    else "It is lifted. ";
  }
  dobjFor(Open) remapTo(LiftUp, self)
  dobjFor(Close) remapTo(Straighten, self)  

  dobjFor(LiftUp)
  {
    verify() 
    { 
      if ( isOpen ) { illogicalNow(alreadyLifted); }
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to lift up <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to lift up <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to lift up <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to lift up <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to lift up 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(true);
      okayLiftup;
    }
  }
  dobjFor(Straighten)
  {
    verify() 
    { 
      if ( ! isOpen ) { illogicalNow( alreadyStraightened );  }
    } 
    check()
    {
      inherited;

      local top, c, item, l, lst;
      top = coverLevel;
      c = -1;
      item = nil;
      
      if ( ! location.ofKind(Person))
        { }
      else {
        lst = location.canBeTaken( coverList );
        l = lst.length;
        if ( l < 1 )
          { }
        else {
          foreach (local cur in lst ) {
            if ( cur.coverLevel > top ) {
              item = cur;
              c = cur.coverLevel;
              top = cur.coverLevel;
            }
          }
          if (c > -1) {
            " \^<<item.name>> <<item.verbToBe>> being worn over <<thedesc>>. 
            \^<<gActor.name>> will have to 
            remove <<item.thedesc>> first. ";
            exit;
          }
        }
      } /* else */
      if ( isWorn ) {
      if (location.xaWillingness < wlVeryFlirty )
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to straighten out <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlInvolved ) && ( coverLevel <= xcCoverShirt ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to straighten out <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlVeryInvolved ) && ( coverLevel <= xcCoverUndies ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to straighten out <<thedesc>>. "; 
         exit;
        }
      if ((location.xaWillingness < wlWillingNoTouch ) && ( self.ofKind(pantytype) ||
         self.ofKind(onepiecetype) ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this. ";
          exit;
        }
        else {
         "\^<<location.name>> doesn\'t seem willing to straighten out <<thedesc>>. "; 
         exit;
        }
      if ((location.location.xaSexIsPublic) && (location.xaWillingness < wlWild ))
        if ( gActor.isPlayerChar ) {
          "\^<<location.name>> doesn\'t seem willing to allow you to do this 
            in a public location. ";
          exit;
        }
        else {
         "\^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to straighten out 
         <<thedesc>> in a public location. "; 
         exit;
        }          
      }
    }
    action()
    {
      makeOpen(nil);
      okayStraighten;
    }
  }
;

/*******************************************************************/
/* sample Xclothing classes */
  //
  // alterable clothing types
  //
class zipjackettype : zippableXclothing, jackettype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class buttonjackettype : buttonableXclothing, jackettype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class zipcoattype : zippableXclothing, coattype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart, pussyPart, clitPart, assPart, 
              penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class buttoncoattype : buttonableXclothing, coattype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart, pussyPart, clitPart, assPart, 
              penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class buttonsweatertype : buttonableXclothing, sweatertype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class buttonvesttype : buttonableXclothing, vesttype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class topbuttondresstype : buttonableXclothing, dresstype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart, assPart, pussyPart, clitPart, 
               penisPart, groinPart ]
openList = [ assPart, pussyPart, clitPart, penisPart, groinPart ]
initiallyOpen = nil
;
class buttonblousetype : buttonableXclothing, blousetype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class buttonshirttype : buttonableXclothing, shirttype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class zippantstype : zippableXclothing, pantstype
locationList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class buttonpantstype : buttonableXclothing, pantstype
locationList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class asszippantstype : zippableXclothing, pantstype
locationList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = [ pussyPart, clitPart, penisPart, groinPart ]
initiallyOpen = nil
;
class zippvctype : zippableXclothing, sliptype
locationList = [ titsPart, chestPart, nipplesPart, bellyPart, pussyPart, clitPart, assPart,
              penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class openbratype : openableXclothing, bratype
locationList = [ titsPart, nipplesPart, chestPart ]
openList = []
initiallyOpen = nil
;
class zippantytype : zippableXclothing, pantytype
locationList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = [ assPart ]
initiallyOpen = nil
;
class liftblousetype : liftableXclothing, blousetype
locationList = [ titsPart, nipplesPart, chestPart, bellyPart ]
openList = []
initiallyOpen = nil
;
class liftskirttype : liftableXclothing, skirttype
coverList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = []
initiallyOpen = nil
;
class liftbratype : liftableXclothing, bratype
locationList = [ titsPart, nipplesPart, chestPart ]
openList = []
initiallyOpen = nil
;
class liftpantytype : liftableXclothing, pantytype
locationList = [ pussyPart, clitPart, assPart, penisPart, groinPart ]
openList = []
initiallyOpen = nil
;
  // basic bodypart class
  //
class actorAnatomy : Fixture, Topic
{
  overpart = nil
  totalTouchPercent = 0
  //
  // attribute below is part of Mister Spatula's superior clothed() method.
  //
  isNormallyClothed = nil
  topicDesc = "That\'s not a subject I\'d discuss right now."
  thedesc 
  { if ( location.isPlayerChar )
      "your <<name>>";
    else "\^<<location.name>>\'s <<name>>";
  }
  thedescsq
  {
     if ( location.isPlayerChar )
      return( 'your ' + name );
    else return( '\^' + location.name + '\'s ' + name );
  }
  clothed { return location.coveredBy(self); }
  textNoFun { " \^<<location.name>> do<<location.verbEndingEs>>n\'t seem to be enjoying what 
                      <<gActor.itIs>> doing. "; }
  hideFromAll(action)  { return true; }
  underClothesPc = "\^<<thedesc>> <<verbToBe>> clothed. ";
  underClothesNpc = "\^<<thedesc>> seem<<verbEndingS>> awfully inviting underneath 
  <<location.itPossAdj>> <<overpart.name>>. ";
  eoClassType = nil
  desc 
  { if (clothed) 
    {
          if ( location.isPlayerChar ) {
            underClothesPc;
          }
          else {
            underClothesNpc;
          }
    }
    else { nakedDesc; }
  }
  nakedDesc
  {
    "\^<<thedesc>> <<verbToBe>> there for all to see.";
  }
  sexSmell="\^<<thedesc>> smells clean and fresh. "
  smellDesc
  {
    if ( clothed() )
      " {You/he} can\'t smell <<thedesc>> through <<location.itPossAdj>> <<overpart.name>>. ";
    else sexSmell;
  }
  dobjFor(Examine)
  {
      preCond = [objVisible]
      verify()
      {
          //
          // examine other objects first
          //
        if ( location == gActor )
          nonObvious;
          //
          // examine nude parts preferentially.
          //
        else if ( clothed() )
          logicalRank(80,'clothed');
        else inherited;
      }
      check() { inherited; }
      action() { inherited; }
  }
}
  //
  // abstract anatomical classes
  //
  // ******
  //
  // fucked
  //
class fuckedClass : actorAnatomy
{
  lastFucked = -1
  lastFuckedWith = -1
  textFuck { "{You/he} fuck{s} <<thedesc>>. "; }
  textFuckAgain { "{You/he} fuck{s} <<thedesc>> again. "; }
  fuckCount = 0
  fuckAgainCount = 0
  textFuckWith  { "{You/he} fuck{s} <<thedesc>> with <<gIobj.theName>>. "; }
  textFuckWithAgain  { "{You/he} fuck{s} <<thedesc>> with <<gIobj.theName>> again. "; }
  fuckWithCount = 0
  fuckWithAgainCount = 0
  textClimax { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  sexSmell
  {
    if ( fuckCount < 1 )
     "\^<<thedesc>> <<verbToHave>> a rich musky aroma. ";
    else
     "\^<<thedesc>> <<verbToHave>> a rich musky aroma mixed with the smell of sex juices. ";
  }
  dobjFor(Fuck)
  {
    verify() 
    {
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t fuck. ');
      if ( gActor == location )
        illogical(' {You/he} can\'t fuck ' + gActor.itPossAdj + ' own ' + name + '. '); 
       if ( clothed() ) 
         illogicalNow('{You/he} can\'t fuck ' + thedescsq + ' while \^' + location.name + 
         ' ' + location.verbToBe + ' clothed. ');
       if ( gActor.fuckPart != nil )
         if (gActor.fuckPart.clothed)
             illogicalNow(' \^' + gActor.name + ' can\'t fuck ' + thedescsq + ' while ' + 
             gActor.itIs + ' clothed. '); 
    }
    check()
    {
       if (( ! location.isPlayerChar ) && ( location.xaWillingness < wlWillingNoTouch ) ) 
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if (( ! gActor.isPlayerChar ) && gActor.xaWillingness < wlWillingNoTouch )
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
           "\^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
           exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
           "\^<<gActor.name>> do<<gActor.verbEndingEs>>n\'t seem willing to do this in a public location. "; 
            exit;
         }
       }
       if ( location.emotionalState is in (eomsgAnger, eomsgFear )) 
       {
         reportFailure(' \^' + location.itIs + ' too upset to allow this. ');
         exit;        
       } 
       if ( gActor.hasPenis && ofKind(dildoClass) && hasDildo )
       {
         "{You/he} can\'t fuck <<thedesc>> because it is already full.";
         exit;
       }
    }
    action()
    {
      local l, i;
      if ( lastFucked + 1 < libGlobal.totalTurns ) { 
        textFuck();
        fuckAgainCount = 0;
      }
      else {
        textFuckAgain();
        fuckAgainCount++;
      }
      fuckCount++;
      l = location.myEo.fucked( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax();
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax();
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun();
      gActor.fucking( self, l, nil );
      lastFucked = libGlobal.totalTurns;
    }
  }
  dobjFor(FuckWith)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t fuck. ');
       if ( clothed() ) 
         illogicalNow('{You/he} can\'t fuck ' + thedescsq + ' while \^' + location.name + 
         ' ' + location.verbToBe + ' clothed. ');
    }
    check()
    {
       if (( ! location.isPlayerChar ) && ( location.xaWillingness < wlWillingNoTouch ) ) 
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if (( ! gActor.isPlayerChar ) && gActor.xaWillingness < wlWillingNoTouch )
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
           "\^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
           exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
           "\^<<gActor.name>> do<<gActor.verbEndingEs>>n\'t seem willing to do this in a public location. "; 
            exit;
         }
       }
       if ( location.emotionalState is in (eomsgAnger, eomsgFear )) 
       {
         reportFailure( ' \^' + location.itIs + ' too upset to allow this. ');
         exit;        
       } 
       if ((gIobj == gActor.fuckPart ) && gActor.fuckPart.clothed )
       {
           " \^<<gActor.name>> can\'t fuck <<thedesc>> while <<gActor.itIs>> clothed. "; 
           exit;
       }
       if ( gActor == location && gIobj == gActor.fuckPart )
       {
         reportFailure('{You/he} can\'t fuck ' + gActor.itPossAdj + ' own ' + name);
         exit;
       }
       if ( (gIobj.ofKind(pussyPart) || gIobj.ofKind(penisPart)) && gIobj.location != gActor ) {
         reportFailure('That isn\'t something {you/he} can fuck someone else with. ');
       }
       if ( gActor.hasPenis && ofKind(dildoClass) && hasDildo )
       {
         "{You/he} can\'t fuck <<thedesc>> because it is already full.";
         exit;
       }
    }
    action()
    {
      local l, i;
      if ( lastFuckedWith + 1 < libGlobal.totalTurns ) { 
        if ( gIobj == gActor.fuckPart ) {
          textFuck();
          fuckAgainCount = 0;
        }
        else {
          textFuckWith();
          fuckWithAgainCount = 0;
        }
      }
      else {
        if ( gIobj == gActor.fuckPart ) {
          textFuckAgain();
          fuckAgainCount++;
        }
        else {
          textFuckWithAgain();
          fuckWithAgainCount++;
        }
      }
      fuckWithCount++;
      if ( gIobj == gActor.fuckPart )
        l = location.myEo.fucked( eoClassType , nil, nil );
      else l = location.myEo.fucked( eoClassType , eoWithDildo, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax();
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax();
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun();
      if ( gActor.fuckPart == gIobj )
        gActor.fucking( self, l, nil );
      lastFuckedWith = libGlobal.totalTurns;
      if ( gActor == location )
        gActor.respondToSexAct();
    }
  } 
}

//
// licked
//
class lickedClass : actorAnatomy
{
  lastLicked = -100
  textLick { "{You/he} lick{s} <<thedesc>>. "; }
  lickCount = 0
  lickAgainCount = 0
  textLickAgain { " {You/he} lick{s} <<thedesc>> again. "; }
  textLickedClimax { "\^<<location.name>> shivers\, and <<location.itPossAdj>> juices pour
                     into <<gActor.itPossAdj>> hot wet mouth. "; }
  dobjFor(Lick)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t lick sexually. ');
       if ( gActor == location && (! (ofKind(titsPart) && titSize == xaHugeTits ) ) )
         illogical('\^' + gActor.name + ' can\'t lick ' + gActor.itPossAdj + ' own ' +
         name + '. ');
       if ( clothed() ) 
         illogicalNow('{You/he} can\'t lick ' + thedescsq + ' while ' + location.itIs + 
         ' clothed. ');
    }
    check()
    {
       if ((! location.isPlayerChar ) && (location.xaWillingness < wlVeryInvolved ))  
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if ( (! gActor.isPlayerChar ) && (gActor.xaWillingness < wlWilling ))
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this 
                in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             "{You/he} do<<gActor.verbEndingEs>>n\'t seem willing to do this in a public location. ";
             exit;
         }
       }
       if ( location.emotionalState is in (eomsgAnger, eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
    }
    action()
    {
      local l, i;
      if ( lastLicked + 1 < libGlobal.totalTurns ) { 
        textLick();
        lickAgainCount = 0;
      }
      else {
        textLickAgain();
        lickAgainCount++;
      }
      lickCount++;
      l = location.myEo.licked( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textLickedClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax;
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax;
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun;
      gActor.licking( self, l, nil );
      lastLicked = libGlobal.totalTurns;
      if ( gActor == location )
        gActor.respondToSexAct();
    }
  } 
  dobjFor(Taste) remapTo(Lick, self)
}
//
// kissed
//
class kissedClass : actorAnatomy
{
  lastKissed = -100
  textKiss { "{You/he} kiss{es} <<thedesc>>. "; }
  kissCount = 0
  kissAgainCount = 0
  textKissAgain { " {You/he} kiss{es} <<thedesc>> again. "; }
  textKissedClimax { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  dobjFor(Kiss)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t kiss sexually. ');
       if ( gActor == location )
         illogical('\^' + location.name + ' can\'t kiss \^' + location.name + '. ');
       if ( clothed() ) 
         illogicalNow('{You/he} can\'t kiss ' + thedescsq + ' while ' + thedescsq + 
         ' ' + verbToBe + ' clothed. ');
    }
    check()
    {
       if ((! location.isPlayerChar ) && (location.xaWillingness < wlVeryInvolved ))  
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if ( (! gActor.isPlayerChar ) && (gActor.xaWillingness < wlWilling ))
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             " \^<<gActor.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
             exit;
          }
       }
       if (location.emotionalState is in (eomsgAnger, eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
    }
    action()
    {
      local l, i;
      if ( lastKissed + 1 < libGlobal.totalTurns ) { 
        textKiss();
        kissAgainCount = 0;
      }
      else {
        textKissAgain();
        kissAgainCount++;
      }
      kissCount++;
      l = location.myEo.kissed( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax;
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax;
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun;
      gActor.kissing( self, l, nil );
      lastKissed = libGlobal.totalTurns;
    }
  } 
}
//
// touched
//
class touchedClass : actorAnatomy
{
  touchThreshhold = 51
  lastTouched = -100
  textTouch { "{You/he} touch{es} <<thedesc>>. "; }
  touchCount = 0
  touchAgainCount = 0
  textTouchAgain { " {You/he} touch{es} <<thedesc>> again. "; }
  textTouchClothed { "{You/he} touch{es} <<thedesc>> through clothing."; }
  textTouchAgainClothed { " {You/he} touch{es} <<thedesc>> again through clothing. "; }
  textTouchedClimax { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  textTouchedClimaxClothed { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  dobjFor(Touch)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t touch sexually. ');
      if ( gActor == location )
        nonObvious;
      if ( clothed() )
        logicalRank( 80, 'clothed' );
      else logicalRank(100, 'naked' );
    }
    check()
    {
       if (clothed && totalTouchPercent < touchThreshhold )
       {
          " Not through <<overpart.thedesc>>. ";
          exit;
       }
       else if (clothed && (! location.isPlayerChar) && location.xaWillingness < wlInvolved )
       {
         "{You/he} would not do this right now.";
         exit;
       } 
       else if ((! location.isPlayerChar ) && (location.xaWillingness < wlVeryInvolved ))  
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       else if ( (! gActor.isPlayerChar ) && (gActor.xaWillingness < wlWilling ))
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             " \^<<gActor.itNom>> do<<location.verbEndingEs>>n\'t seem willing to do this in a public location. ";
             exit;
         }
       }
       if ( location.emotionalState is in ( eomsgAnger, eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
   }
    action()
    {
      local l, i;
      if ( lastTouched + 1 < libGlobal.totalTurns ) { 
        if (clothed)
          textTouchClothed();
        else textTouch();
        touchAgainCount = 0;
      }
      else 
      {
        if (clothed) 
          textTouchAgainClothed();
        else textTouchAgain();
        touchAgainCount++;
      }
      touchCount++;
      if (clothed)
        l = location.myEo.touched( eoClassType , eoThroughClothes, totalTouchPercent );
      else l = location.myEo.touched( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
      {
        if (clothed)
          textTouchedClimaxClothed(); 
        else textTouchedClimax();      
      }
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax;
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax;
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun;
      if (clothed)
        gActor.touching( self, l, totalTouchPercent);
      else gActor.touching( self, l, nil );
      lastTouched = libGlobal.totalTurns;
      if ( gActor == location )
        gActor.respondToSexAct();
    }
  } 
  dobjFor(Feel) remapTo(Touch, self)
}

class spankedClass : actorAnatomy
{
  lastSpanked = -100
  textSpank { "{You/he} spank{s} <<thedesc>> "; }
  textSpankAgain { " {You/he} spank{s} <<thedesc>> again. "; }
  spankCount = 0
  spankAgainCount = 0
  textSpankedClimax { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  dobjFor(Spank)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t spank sexually. ');
      if ( gActor == location )
        nonObvious;
      if ( clothed() )
        logicalRank( 80, 'clothed' );
      else logicalRank(100, 'naked' );
    }
    check()
    {
       if ((! location.isPlayerChar ) && (location.xaWillingness < wlVeryInvolved ))  
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if ( (! gActor.isPlayerChar ) && (gActor.xaWillingness < wlWilling ))
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to do this 
             in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             " \^<<gActor.name>> <<gActor.verbEndingEs>>n\'t seem willing to do this 
             in a public location. ";
             exit;
         }
       }
       if ( location.emotionalState is in ( eomsgAnger , eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
       if (clothed) 
       {
         "{You/he} can't spank <<location.name>> while <<thedesc>> <<verbToBe>> clothed. ";
         exit;
       }
       if ( gActor == self.location )
       {
         "\^<<location.name>> can\'t spank <<location.name>>.";
         exit;
       }
    }
    action()
    {
      local l, i;
      if ( lastSpanked + 1 < libGlobal.totalTurns ) { 
        textSpank();
        spankAgainCount = 0;
      }
      else {
        textSpankAgain();
        spankAgainCount++;
      }
      spankCount++;
      l = location.myEo.spanked( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textSpankedClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax;
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax;
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun;
      gActor.spanking( self, l, nil );
      lastSpanked = libGlobal.totalTurns;
    }
  } 
}
  //
  // rubbing dobj classes
  //
class BasicLotion : Thing
  dobjFor(RubOnto)
  {
    preCond=[objHeld]
    verify() {}
  }
  iobjFor(TouchWith)
  {
    preCond=[objHeld]
    verify() {}
  }
;
class Lotion : BasicLotion
;
class Oil : BasicLotion
;
class Soap : BasicLotion
;
class rubbedClass : actorAnatomy
{
  lastRubbed = -100
  textRub { "{You/he} rub{s} <<gDobj.theName>> all over <<thedesc>> "; }
  textRubAgain { " {You/he} continue{s} to rub <<gDobj.theName>> all over <<thedesc>>. "; }
  textRubUnderClothes { "{You/he} slip{s} a hand under <<overpart.theName>> and 
                          rub{s} <<gDobj.theName>> all over <<thedesc>> "; }
  textRubAgainUnderClothes { "{You/he} slip{s} a hand under <<overpart.theName>> and 
                              continue{s} to rub <<gDobj.theName>> all over <<thedesc>>. "; }
  rubCount = 0
  rubAgainCount = 0
  textRubbedClimax { "<BR> <<location.name>> came! <<location.name>> came! <BR>"; }
  iobjFor(RubOnto)
  {
    verify() 
    { 
      if ( ! gActor.ofKind(Xactor) )
        illogical(' \^' + gActor.name + ' can\'t rub sexually. ');
      if ( gActor == location )
        nonObvious;
      if ( clothed() )
        logicalRank( 80, 'clothed' );
      else logicalRank(100, 'naked' );
    }
    check()
    {
       if ((! location.isPlayerChar ) && (location.xaWillingness < wlVeryInvolved ))  
       {
         "\^<<location.name>> is not willing to do this. ";
         exit;
       }
       if ( (! gActor.isPlayerChar ) && (gActor.xaWillingness < wlWilling ))
       {
         "\^<<gActor.name>> is not willing to do this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.name>> do<<location.verbEndingEs>>n\'t seem willing to do this 
             in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             " \^<<gActor.name>> <<gActor.verbEndingEs>>n\'t seem willing to do this 
             in a public location. ";
             exit;
         }
       }
       if ( location.emotionalState is in ( eomsgAnger , eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
       //
       // there is an inherent assumption here that clothes with touch percent 80 or more
       // are stretchable. Its up to the author to make sure that is the case.
       //
       if (clothed && totalTouchPercent < 80 ) 
       {
         "{You/he} can't rub <<location.name>> while <<thedesc>> <<verbToBe>> clothed. ";
         exit;
       }
    }
    action()
    {
      local l, i;
      if ( lastRubbed + 1 < libGlobal.totalTurns ) { 
        if ( clothed )
          textRubUnderClothes();
        else textRub();
        rubAgainCount = 0;
      }
      else {
        if ( clothed )
          textRubAgainUnderClothes();
        else textRubAgain();
        rubAgainCount++;
      }
      rubCount++;
      l = location.myEo.rubbed( eoClassType , nil, nil );
      location.emotionalState = l[1];
      i = l[2];
      if ( location.emotionalState == eomsgClimax ) 
        textRubbedClimax();      
      else if ( location.emotionalState == eomsgNearClimax )
        location.textNearClimax;
      else if ( location.emotionalState == eomsgOverClimax )
        location.textOverClimax;
      if ( i == eomsgLevel || i == eomsgDown )
        textNoFun;
      gActor.rubbing( self, l, nil );
      lastRubbed = libGlobal.totalTurns;
      if ( gActor == location )
        gActor.respondToSexAct();
    }
  }
}
  //
  // dildo class
  //
class dildoClass : actorAnatomy, Container
{
  bulkCapacity = 2
  maxSingleBulk = 2
  isOpen = true
  hasDildo 
  {
    if ( contents.length() > 0 )
      return true;
    else return nil;
  }
  iobjFor(PutIn)
  {
    verify() { inherited; }
    check()
    {
      if (! gDobj.ofKind(Dildo) ) {
        "\^<<gDobj.theName>> won\'t go in. ";
        exit;
      }
      if (clothed) {
       "{You/he} can\'t put <<gDobj.theName>> in <<thedesc>> if <<thedesc>> is clothed. ";
       exit;
      }
      if ( contents.length() > 0 ) {
        "\^<<thedesc>> is full. ";
        exit;
      }
      inherited;
    }
    action()
    {
      inherited;
    }
  }
  iobjFor(TakeFrom)
  {
    verify() { inherited; }
    check()
    {
      if (clothed)
      {
        "{You/he} can't get <<gDobj.theName>>. \^<<overpart.thedesc>> is in the way. ";
        exit;
      }
    }
    action()     { inherited; }
  }
  heartBeatOn { return true; }
  localHeartBeat
  {
    if ( hasDildo )
    {
      if  ( contents[1].ofKind(Vibrator) && contents[1].isOn )
        location.myEo.sextoy( eoClassType , eoSexToyVibrator, nil );
      else location.myEo.sextoy( eoClassType , eoSexToyDildo, nil );
    }
  }
}
class Dildo : Thing
{
  bulk = 2;
  dobjFor(Take)
  {
    verify() { inherited; }
    check()
    {
      if (location.ofKind(dildoClass) && location.clothed )
      {
        "{You/he} can't get <<theName>>. \^<<location.overpart.thedesc>> is in the way. ";
        exit;        
      }
      inherited;
    }
    action() { inherited; }
  }
  iobjFor(FuckWith)
  {
    preCond = [objHeld]
    verify() { }
  }
  dobjFor(Doff) remapTo(Take , self );
}

class Vibrator: Dildo, OnOffControl
;
  //
  // XXXXing classes
  //
class fuckingClass : actorAnatomy
{
  localPart = nil
  fuckingCount = 0
  fuckingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>\, 
                    and juices pour out\, all over <<localPart.thedesc>>. ";
  fucking( part, msg, val )
  {
    fuckingCount++;
    localPart = part;
    local m;
    if ( val != nil )
      m = location.myEo.fucking( part.eoClassType , eoThroughClothes , val );
    else m = location.myEo.fucking( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      fuckingClimax;
  }
  iobjFor(FuckWith)
  {
    verify() { }
  }
}

class lickingClass : actorAnatomy
{
  localPart = nil
  lickingCount = 0
  lickingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>! ";
  licking( part, msg, val )
  {
    lickingCount++;
    localPart = part;
    local m;
    if ( val != nil )
      m = location.myEo.licking( part.eoClassType , eoThroughClothes , val );
    else m = location.myEo.licking( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      lickingClimax;
  }
}

class kissingClass : actorAnatomy
{
  localPart = nil
  kissingCount = 0
  kissingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>! ";  
  kissing( part, msg, val )
  {
    kissingCount++;
    localPart = part;
    local m;
    if ( val != nil )
      m = location.myEo.kissing( part.eoClassType , eoThroughClothes , val );
    else m = location.myEo.kissing( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      kissingClimax;
  }
}
class touchingClass : actorAnatomy
{
  localPart = nil
  touchingCount = 0
  touchingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>! ";  
  touching( part, msg, val )
  {
    touchingCount++;
    localPart = part;
    local m;
    if ( val != nil )
      m = location.myEo.touching( part.eoClassType , eoThroughClothes , val );
    else m = location.myEo.touching( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      touchingClimax;
  }
}
class rubbingClass : actorAnatomy
{
  localPart = nil
  rubbingCount = 0
  rubbingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>! ";  
  noRubClothing = theName + ' is covered in clothes. '
  rubbing( part, msg, val )
  {
    rubbingCount++;
    localPart = part;
    local m;
    m = location.myEo.rubbing( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      rubbingClimax;
  }
  dobjFor(RubOnto)
  {
    verify() 
    {
      if ( clothed )
        illogicalNow( noRubClothing );
    }
  }
  iobjFor(TouchWith)
  {
    verify() 
    {
      if ( clothed )
        illogicalNow( noRubClothing );
    }
  }
}
class spankingClass : actorAnatomy
{
  localPart = nil
  spankingCount = 0
  spankingClimax = " <BR>\^<<location.name>> groan<<location.verbEndingS>>! ";  
  spanking( part, msg, val )
  {
    localPart = part;
    spankingCount++;
    local m;
    if ( val != nil )
      m = location.myEo.spanking( part.eoClassType , eoThroughClothes , val );
    else m = location.myEo.spanking( part.eoClassType , eoClassType, msg );
    location.emotionalState = m[1];
    if ( location.emotionalState == eomsgClimax )
      spankingClimax;
  }
}
  //
  // convenience class, to shorten class declarations.
  //
class mostlyClass : fuckedClass, lickedClass, kissedClass, touchedClass
;
  //
  // concrete body classes
  //
class pussyPart: mostlyClass, fuckingClass  'vagina/swell/slit/pussy/twat/cunt' 'pussy'
{
  isNormallyClothed = true
  nakedDesc { "A soft, slightly swollen and slitted mound, covered with fine hair."; }
  eoClassType = eoPussy
  dobjFor(FuckWith)
  {
    verify() { inherited; }
    check()
    {
      if ( gIobj.ofKind(self) ) {
        " This is impossible. ";
        exit;
      }
      inherited;
    }
    action() { inherited; }
  }
  dobjFor(Kiss) remapTo(Lick, self)
  dobjFor(Eat) remapTo(Lick, self)
}
class penisPart : mostlyClass, fuckingClass 'penis/prick/dick/cock/phallus/shaft' 'penis'
{
  isNormallyClothed = true
  nakedDesc { "Full and thick, an imposing shaft."; }
  eoClassType = eoPenis
  dobjFor(Fuck)
  {
    verify() 
    { 
     inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t fuck {your/his} own ' + name);
    }
    check()
    {
      if (! gActor.fuckPart.ofKind( pussyPart ) )
      {
        "{You/he} can't perform this act, lacking the necessary equipment. ";
        exit;
      }

      inherited;
    }
    action() { inherited; }
  }
  dobjFor(FuckWith)
  {
    verify() 
   { 
     inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t fuck {your/his} own ' + name);
   }
    check()
    {
      if ( gIobj.ofKind(Dildo) || gIobj.ofKind(penisPart) ) {
        " This is impossible. ";
        exit;
      }
      inherited;
    }
    action() { inherited; }
  }
  dobjFor(Lick)
  {
    verify() 
    { 
      inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t lick {your/his} own ' + name);
    }
    check() { inherited; }
    action() { inherited; }
  }
  dobjFor(Kiss) remapTo(Lick, self)
}
class titsPart : mostlyClass 'bosom/tits/breasts/boobs/hooters' 'tits'
{
  isNormallyClothed = true
  nakedDesc { "A full, firm pair of tits."; }
  isPlural = true
  eoClassType = eoTits
  titSize = xaLargeTits
  sexSmell
  {
    if ( fuckCount < 1 )
     "\^<<thedesc>> <<verbToHave>> a delicate scent\, perhaps touched with perfume. ";
    else
     "\^<<thedesc>> <<verbToHave>> a delicate scent mixed with the smell of sex juices. ";
  }
  dobjFor(Fuck)
  {
    verify() { inherited; }
    check()
    {
      if (! gActor.hasPenis )
      {
        "{You/he} can't perform this act, lacking the necessary equipment. ";
        exit;
      }

      inherited;
      if ( titSize == xaSmallTits )
      {
        "\^<<thedesc>> are too small to do this. ";
        exit;
      }
    }
    action() { inherited; }
  }
  dobjFor(FuckWith)
  {
    verify() { illogical(' This doesn\'t make much sense. There isn\'t any pleasure in it for her. '); }
  }
  dobjFor(Kiss) remapTo(Lick, self)
}
class chestPart : lickedClass, kissedClass, touchedClass 'chest' 'chest'
{
  //
  // if your char is a male lifeguard, you'll want to change the flag below.
  //
  isNormallyClothed = true
  nakedDesc { " A nice, broad chest. "; }
  eoClassType = eoTits
  dobjFor(Kiss) remapTo(Lick, self)
}
class mouthPart : fuckedClass, kissedClass, kissingClass, lickingClass 'mouth/lips' 'mouth'
{
  nakedDesc { "A soft wet pair of lips that cover white pearly teeth."; }
  eoClassType = eoMouth
  textChasteKiss=" \^<<gActor.name>> give<<gActor.verbEndingS>> \^<<location.name>> a 
                  chaste peck on the cheek."
  sexSmell
  {
    if ( fuckCount < 1 )
     "\^<<thedesc>> has a fresh scent. \^<<location.itNom>> <<location.verbToHave>> recently brushed.";
    else
     "\^<<thedesc>> has a fresh scent mixed with the smell of sex juices. ";
  }
  dobjFor(Kiss) 
  {
    verify() 
    { 
      inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t kiss {your/his} own ' + name);
    }
    check() 
    {
       if ((! location.isPlayerChar ) && ( location.xaWillingness < wlFriend ))  
       {
         "\^<<location.name>> is not willing to doing this. ";
         exit;
       }
       if ( ( ! gActor.isPlayerChar ) && (gActor.xaWillingness < wlFriend ))
       {
         "\^<<gActor.name>> is not willing to doing this. ";
         exit;
       }
       else if ( location.emotionalState is in (eomsgAnger, eomsgFear )) 
       {
         "\^<<location.name>> is too upset to allow <<gActor.itObj>> to do this. ";
         exit;
       } 
       else if (clothed) 
       {
         "{You/he} can't kiss <<location.name>> while <<thedesc>> <<verbToBe>> clothed. ";
         exit;
       }
    }
    action() 
    {
      if (( gActor.xaWillingness < wlVeryFlirty ) || (location.xaWillingness < wlVeryFlirty )) {
        textChasteKiss; 
        lastKissed = libGlobal.totalTurns;
        exit;
      }
      else inherited; 
    }
  }
  dobjFor(Fuck)
  {
    verify() 
    { 
      inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t fuck {your/his} own ' + name);
    }
    check()
    {
      if (! gActor.hasPenis )
      {
        "{You/he} can't perform this act, lacking the necessary equipment. ";
        exit;
      }

      inherited;
    }
    action() { inherited; }
  }
  dobjFor(FuckWith)
  {
    verify() { illogical(' There isn\'t any way ' + location.itNom + ' would get any pleasure out of this. '); }
  }
}
class assPart : mostlyClass, spankedClass 'ass/rear/rump/butt/behind' 'ass'
{
  isNormallyClothed = true
  nakedDesc { "Round, firm, and tight."; }
  eoClassType = eoAss
  dobjFor(Fuck)
  {
    verify() 
    { 
      inherited; 
      if ( gActor == location )
        illogical('{You/he} can\'t fuck {your/his} own ' + name);
    }
    check()
    {
       if (! gActor.hasPenis )
       {
         "{You/he} can't perform this act, lacking the necessary equipment. ";
         exit;
       }
       if (( ! location.isPlayerChar ) && ( location.xaWillingness < wlVeryWilling ) ) 
       {
         "\^<<location.name>> is not willing to doing this. ";
         exit;
       }
       if (( ! gActor.isPlayerChar ) && gActor.xaWillingness < wlVeryWilling )
       {
         "\^<<gActor.name>> is not willing to doing this. ";
         exit;
       }
       if (location.location.xaSexIsPublic) 
       {
         if (location.xaWillingness < wlWild ) {
             " \^<<location.itNom>> do<<location.verbEndingEs>>n\'t seem willing 
             to do this in a public location. ";
             exit;
         }
         else if (gActor.xaWillingness < wlWild ) {
             " <<gActor.itNom>> do<<gActor.verbEndingEs>>n\'t seem willing 
             to do this in a public location. ";
             exit;
         }
       }
       if ( location.emotionalState is in ( eomsgAnger, eomsgFear )) 
       {
         reportFailure(' \^' + location.itIs + ' too upset to allow this. ');
         exit;        
       } 
       if (clothed) 
       {
         reportFailure('{You/he} can\'t fuck while clothed. ');
         exit;
       }
    }
    action() { inherited; }
  }
  dobjFor(Lick) 
  {
    verify()
    {
      inherited;
      if ( gActor == location )
        illogical('{You/he} can\'t lick {your/his} own ' + name);

    }
    check() { inherited; }
    action() { inherited; }
  }
  dobjFor(Touch)
  {
    verify()
    {
      if ( gActor == location )
        nonObvious;
    }
    check() { inherited; }
    action() { inherited; }
  }
  dobjFor(Kiss) remapTo(Lick, self)
}
class groinPart : lickedClass, kissedClass, touchedClass 'balls/sac/groin/nads/gonads' 'groin'
{
  isNormallyClothed = true
  nakedDesc { "A full hairy sac covering a pair of testicles."; }
  eoClassType = eoGroin
  dobjFor(Kiss) remapTo(Lick, self)
}
class nipplesPart : lickedClass, kissedClass, touchedClass 'nipples/aureoles/areola/areolae' 'nipples'
{
  isNormallyClothed = true
  nakedDesc { "Full, swollen, and pink, graced with pink circles as large as your thumb."; }
  eoClassType = eoNipples
  isPlural = true
  dobjFor(Kiss) remapTo(Lick, self)
}
class clitPart: lickedClass, kissedClass, touchedClass 'clit/clitoris' 'clit'
{
  isNormallyClothed = true
  nakedDesc { "Hidden in swollen lips, a little pink nub can barely be seen."; }
  eoClassType = eoClit
  dobjFor(Kiss) remapTo(Lick, self)
}
class legsPart : touchedClass
{
  noun = 'legs' 
  isPlural = true
  nakedDesc { "A pair of legs."; }
  eoClassType = eoLegs
  dobjFor(Feel) remapTo(Touch, self)
}
class feetPart : actorAnatomy
{
  isNormallyClothed = true
  noun = 'feet'
  isPlural = true
  nakedDesc  { "A pair of feet."; }
}
class hairPart : actorAnatomy
{
  noun = 'hair'
  nakedDesc { "A head of hair."; }
}
class armsPart : actorAnatomy
{
  noun = 'arms'
  isPlural = true
  nakedDesc { "A pair of arms"; }
}
class wristsPart : actorAnatomy
{
  noun = 'wrists'
  isPlural = true
  nakedDesc { "A pair of wrists."; }
}
class handsPart : touchingClass, spankingClass
{
  noun = 'hands'
  isPlural = true
  nakedDesc { "A pair of hands."; }
  eoClassType = eoHands
}
class throatPart : actorAnatomy
{
  noun = 'neck' 'throat'
  nakedDesc  { "A slender throat. "; }
}
class eyesPart : actorAnatomy
{
  noun = 'eyes'
  isPlural = true
  nakedDesc { "A pair of eyes. "; }
}
class earsPart : actorAnatomy
{
  noun = 'ears'
  isPlural = true
  nakedDesc  { " A pair of ears."; }
}
class nosePart : actorAnatomy
{
  noun = 'nose'
  nakedDesc  { " A nose."; }
}
class bellyPart : actorAnatomy
{
  noun = 'belly' 'waist'
  nakedDesc  { " A soft round belly."; }
}

//
// Xactor code
//
class Xactor : Person
{
  // willingness level. See beginning of this file.
  xaWillingness = wlWild
  // set this to your excitement object
  myEo = nil
  // set this to actor's penis or pussy, as necessary
  fuckPart = nil
  // text messages
  textNearClimax = " \^<<name>> <<verbToBe>> getting pretty turned on now. ";
  textOverClimax = " \^<<name>> <<verbToBe>> visibly and exceptionally aroused now. ";
  hasPenis { return nil; }
  isErect { return nil; }
    //
    // Mister Spatula's improvement on clothed() from code dated 3/8/2003.
    //
  clothed()
  {
    local lst=contents.subset( {z: z.isNormallyClothed && ( ! z.clothed() ) });
      if( lst.length() > 0 )
        return nil; 
      else return true;
    }
  naked()
  {
    local lst=contents.subset( {z: z.isNormallyClothed && ( z.clothed() ) });
      if( lst.length() > 0 )
        return nil; 
      else return true;
  }
  emotionalState = eomsgLow
    //
    // used to implement a 'dress' verb.
    //
  defaultClothingList = []
    //
    // to determine if someone can be successfully dressed in advance.
    //
  clothesAreHere
  {
    local l=defaultClothingList.length();
    if ( l < 1 )
      return nil;
    foreach( local item in defaultClothingList )
      if ( item.uberRoom() != uberRoom() )
        return nil;
    return true;
  }
    //
    // used to implement replies to the 'strip' and 'dress' command
    //
  stripReplyList = []
  stripReply( actor )
  {
   if ( xaWillingness < wlInvolved )
    " \^<<name>> says\, <Q>I wish you wouldn\'t do that.</Q> ";
   else if ( uberRoom().xaSexIsPublic == true && xaWillingness < wlWild )
    " \^<<name>> says\, <Q>I wish you wouldn\'t do that in public.</Q> ";
   else
    " As {you/he} remove{s} {your/his} clothes, \^<<name>> smile<<verbEndingS>> 
      broadly at <<gActor.isPlayerChar ? "you" : "\^<<name>>" >>. "; 
  }
  //
  // implememnt this for chars that automatically strip when you do.
  //
  autoStrip( actor ) { }
  dressReplyList = []
  dressReply( actor )
  {
   if ( xaWillingness < wlInvolved )
    " \^<<name>> says\, <Q>Thank you. That\'s much better.</Q> ";
   else if ( uberRoom().xaSexIsPublic == true && xaWillingness < wlWild )
    " \^<<name>> says\, <Q>At least you have a shred of decency in you.</Q> ";
   else
    " \^<<name>> asks\, <Q>Are you leaving?</Q> "; 
  }
  //
  // implement this for characters that automatically dress when you do...
  //
  autoDress( actor ) { }
  //
  // sexResponse and sexResponseList. To implement reactions to masturbation.
  //
  sexResponse( actor ) { }
  sexResponseList=[]
  respondToSexAct
  {
    local l=sexResponseList.length();
    if ( l < 1 ) {
      // do nothing
    }
    else  {
      foreach(local npc in sexResponseList )
        if ( npc.uberRoom == uberRoom )
          npc.sexResponse( self );
    }
  }
  //
  // take Dildo class code. Also controls 'get' and 'take' from actor in general
  //
  canRemoveDildo = true
  checkTakeFromInventory(actor, obj)
  {
    if ( obj.ofKind(Dildo) && canRemoveDildo ) {
      // do nothing
    }
    else inherited(actor, obj);
  }
  //
  // undress
  //
  undress
  {
    local l = contents;
    foreach( local cur in l) 
      if ( cur.ofKind(Xclothing) )
        cur.xcRemove();
  }
  undressWithCheck
  {
    if ( isPlayerChar || ( xaWillingness >= wlWillingNoTouch )) {
      undress();
      " \^<<itNom>> remove<<verbEndingS>> all <<itPossAdj>> clothes. ";
    }
    else "\^<<itNom>> seem<<verbEndingS>> unwilling to do that. ";
  }

  dress
  {
    if (defaultClothingList.length() > 0 )
      foreach( local cur in defaultClothingList)
        if ( cur.uberRoom() == uberRoom() ) {
          cur.moveInto(self);
          cur.makeWornBy(self);
          if ( cur.isOpen && cur.ofKind(Openable) )
            cur.makeOpen(nil);
        }
  }

  dressWithCheck
  {
    local l = defaultClothingList.length();
    if ( l < 1 ) {
      "{You/he} need{s} to put on clothing one item at a time. ";
      exit;
    }
    if ( isPlayerChar || ( xaWillingness >= wlWillingNoTouch )) {
      dress();
      if ( clothed() )
        " \^<<itNom>> put<<verbEndingS>> on all <<itPossAdj>> clothes. ";
      else "\^<<itNom>> need<<verbEndingS>> to check <<itPossAdj>> clothes. They don\'t all
      appear to be present. ";
    }
    else "\^<<itNom>> seem<<verbEndingS>> unwilling to do that. ";
  }
  //
  // this should be used with a nakedBarrier or some other
  // generic room exit routine, if the Xactor is a PC.
  //
  dressAndRun
  {
     if ( ! clothed() ) {
       dress();
      //
      // only issue message if dressing succeeds.
      //
      if ( clothed() )
        " \^<<itNom>> put<<verbEndingS>> on all <<itPossAdj>> clothes. ";
      else "\^<<itNom>> need<<verbEndingS>> to check <<itPossAdj>> clothes. They don\'t all
      appear to be present. ";
       local l = dressReplyList.length();
       if ( l > 0 )
         foreach(local cur in dressReplyList)
           if ( cur.uberRoom() == uberRoom() ) {
             cur.dressReply( self );
             cur.autoDress( self );
           }
     }
  }
  setWear
  {
    if ( isPlayerChar ) {
      defaultClothingList = [];
      foreach( local cur in contents) 
        if ( cur.ofKind(Xclothing) && cur.isWorn )
          defaultClothingList = defaultClothingList + [ cur ];
    }
  }
  //
  // command control for this actor.
  //
  willGiveItems
  {
    if ( xaWillingness < wlWilling )
      return nil;
    else return true;
  }
  willMoveLocally
  {
    if ( xaWillingness < wlWilling )
      return nil;
    else return true;
  }
  willFollow = nil
  willUseSenses = nil
  willSearch = nil
  willUseKeys = nil
  willTravel = nil
  willInOut = nil
  willFight = nil
  willMisc = nil
  actorAction()
  {
     if (gActor != gIssuingActor) // if someone else is telling us to
                                  // do this action:
     {
       if ( ! willFollow ) {
         if ( gAction.ofKind(FollowAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willMisc ) {
         if ( gAction.ofKind(YellAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       
         if ( gAction.ofKind(JumpAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(AskForAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(SleepAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(AskAboutAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ConsultAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willUseSenses ) {
         if ( gAction.ofKind(ListenToAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(SmellAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(TasteAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(EatAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(DrinkAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willSearch ) {
         if ( gAction.ofKind(ReadAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(LookAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(LookUnderAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(LookBehindAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(SearchAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ExamineAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willUseKeys ) {
         if ( gAction.ofKind(LockAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(UnlockAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(UnlockWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willFight ) {
         if ( gAction.ofKind(AttackAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(AttackWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(CutAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(CutWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(BreakAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(BurnAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(BurnWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willMoveLocally ) {
         if ( gAction.ofKind(StandAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(DigAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(DigWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(PushAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(PullAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(MoveAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(MoveWithAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ClimbAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ClimbUpAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ClimbDownAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(OpenAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(CloseAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(SitOnAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(LieOnAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(StandOnAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(StandAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(BoardAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(GetOutOfAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(GetOffOfAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(GetOutAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if ( ! willGiveItems ) {
          if ( gAction.ofKind(TakeFromAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(TakeAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(DropAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(GiveToAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ShowToAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(PutInAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(PutOnAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(PutUnderAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ThrowAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ThrowToAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
         if ( gAction.ofKind(ThrowAtAction) ) {
           "\^<<name>> won\'t do that. ";
           exit;
         }
       }
       if (gAction.ofKind(TravelAction) && ( ! willTravel ) )
       {
         if ( willInOut && ( gAction.ofKind(InAction) || gAction.ofKind(OutAction) ) ) {
           // do nothing if willInOut flag is true.
         }
         else {
         "\^<<name>> seem<<verbEndingS>> content to stay here. ";
         exit;
         }
       }
     }
  }

  //
  // This is a modification of the Actor inventory code so 
  // that npc Xactors will not display hidden Xclothing.
  //
  showInventoryWith(tall, inventoryLister, wearingLister)
  {
      local infoTab;

      /* get the table of objects sensible for inventory */
      infoTab = inventorySenseInfoTable();

      /* list in the appropriate mode ("wide" or "tall") */
      if (tall)
      {
        local Xcontents;

        if ( isPlayerChar )
          Xcontents = contents;
        else {
          Xcontents = [];
          foreach(local cur in contents )
            if  ( ! cur.ofKind(Xclothing) )
              Xcontents.append(cur);
            else {
              if ( ! cur.isWorn )
                Xcontents.append(cur);
              else if ( canBeSeen(cur) )
                Xcontents.append(cur);
            }
        }
          /* 
           *   show the list of items being carried, recursively
           *   displaying the contents; show items being worn in-line
           *   with the regular listing 
           */
          inventoryLister.showList(self, self, Xcontents,
                                   ListTall | ListRecurse,
                                   0, infoTab, nil);
      }
      else
      {
        local carrying;
        local wearing;

        /* 
         *   paragraph style ("wide") inventory - go through the
         *   direct contents, and separate the list into what's being
         *   carried and what's being worn 
         */
        carrying = new Vector(32);
        wearing = new Vector(32);
        foreach (local cur in contents)
        {
            if (cur.isWornBy(self)) {
               if ( isPlayerChar )
                 wearing.append(cur);
               else {
                 if ( canBeSeen(cur) )
                   wearing.append(cur);
               }
            }
            else
                carrying.append(cur);
        }

        /* convert the carrying and wearing vectors to lists */
        carrying = carrying.toList();
        wearing = wearing.toList();
            
        /* show the list of items being carried */
        inventoryLister.showList(self, self, carrying, ListRecurse,
                                 0, infoTab, nil);

        /* show the list of items being worn */
        if (wearing.length() != 0)
        {
            /* show the items being worn */
            wearingLister.showList(self, self, wearing, ListRecurse, 0,
                                   infoTab, nil);
        }
      }
  }
  dobjFor(ShowTo) 
  {
    verify()
    { inherited; }
    check()
    {
      if ( gActor == self )
        illogical(' Doing that makes no sense. ');
      if ( gDobj.ofKind(actorAnatomy) ) {
        if ( uberRoom().xaSexIsPublic ) {
          "Flashing in public isn\'t a good idea. ";
          exit;
        }
      }
    }
  }
  //
  // remapping functions.. these should be redirected as appropriate, or implemented locally
  //
  fucking( part, msg , val ) {}
  licking( part, msg , val ) {}
  kissing( part, msg , val ) {}
  touching( part, msg , val ) {}
  spanking( part, msg , val ) {}
  rubbing( part, msg , val ) {}
}
  //
  // Verbs
  //
DefineTAction(Fuck);
VerbRule(Fuck)
    ('fuck' | 'hump' | 'boink') singleDobj
    : FuckAction
    verbPhrase = 'fuck/fucking (what)'
;
DefineTIAction(FuckWith)
;
VerbRule(FuckWith)
    ('fuck' | 'hump' | 'boink') singleDobj 'with' singleIobj
    : FuckWithAction
    verbPhrase = 'fuck/fucking (what) with (what)'
;
DefineTIAction(RubOnto)
;
VerbRule(RubOnto)
    ( 'rub' | 'spread' ) singleDobj ( 'onto' | 'on' | 'over' ) singleIobj
    : RubOntoAction
    verbPhrase = 'rub/rubbing (what) onto (what)'
;
DefineTAction(Lick);
VerbRule(Lick)
    ('lick' | 'suck') singleDobj
    : LickAction
    verbPhrase = 'lick/licking (what)'
;

DefineTAction(Touch);
VerbRule(Touch)
    ('touch' | 'rub' | 'stroke' ) singleDobj
    : TouchAction
    verbPhrase = 'touch/touching (what)'
;
DefineTIAction(TouchWith)
;
VerbRule(TouchWith)
    ('touch' | 'rub' | 'stroke' ) singleDobj ( 'with' | 'using' ) singleIobj
    : TouchWithAction
    verbPhrase = 'touch/touching (what) with (what)'
;

DefineTAction(Spank);
VerbRule(Spank)
    'spank'  singleDobj
    : SpankAction
    verbPhrase = 'lick/licking (what)'
;
DefineTAction(UnWear);
VerbRule(UnWear)
    'unwear'  singleDobj
    : UnWearAction
    verbphrase = 'unwear/unwearing (what)'
;
DefineTAction(LiftUp)
;
VerbRule(LiftUp)
 ( 'lift' 'up' | 'lift' |  'raise' | 'raise' 'up' | 'pull' 'up' ) singleDobj |
 ( 'lift' | 'pull' | 'push' ) singleDobj ( 'up' | 'off' | 'aside' )
  : LiftUpAction
  verbPhrase = 'lift/lifting up (what)'
;
DefineTAction(Straighten)
;
VerbRule(Straighten)
 ( 'straighten' | 'straighten' 'up' | 'fix' 'up' ) singleDobj
  : StraightenAction
  verbPhrase = 'straighten/straightening (what)'
;
DefineTAction(Zip);
VerbRule(Zip)
    'zip'  singleDobj
    : ZipAction
    verbphrase = 'zip/zipping (what)'
;
DefineTAction(UnZip);
VerbRule(UnZip)
    'unzip'  singleDobj
    : UnZipAction
    verbphrase = 'zip/unzipping (what)'
;
DefineTAction(Button);
VerbRule(Button)
    'button'  singleDobj
    : ButtonAction
    verbphrase = 'button/buttoning (what)'
;
DefineTAction(UnButton);
VerbRule(UnButton)
    'unbutton'  singleDobj
    : UnButtonAction
    verbphrase = 'unbutton/unbuttoning (what)'
;
DefineIAction(Strip)
    execAction()
    {
        /* let the actor handle it */
        gActor.undressWithCheck();
        local l = gActor.stripReplyList.length();
        if ( l > 0 )
          foreach(local cur in gActor.stripReplyList)
            if ( cur.uberRoom() == gActor.uberRoom() ) {
              cur.stripReply( gActor );
              cur.autoStrip( gActor );
             }
    }
;
VerbRule(Strip)
    'strip' | 'undress' 
    : StripAction
    verbPhrase = 'strip/stripping'
;
DefineIAction(Dress)
    execAction()
    {
        /* let the actor handle it */
        gActor.dressWithCheck();
        local l = gActor.dressReplyList.length();
        if ( l > 0 )
          foreach(local cur in gActor.dressReplyList)
            if ( cur.uberRoom() == gActor.uberRoom() ) {
              cur.dressReply( gActor );
              cur.autoDress( gActor );
            }
    }
;
VerbRule(Dress)
    'dress' | 'wear' 'clothes' 
    : DressAction
    verbPhrase = 'dress/dressing'
;
  //
  // With recent changes to wear and remove, the verb 'setwear' is now obsolete.
  //

modify Thing
  dobjFor(Fuck)
  {
    verify() { illogical(' {You/he} can\'t fuck that. '); }
  }
  dobjFor(FuckWith)
  {
    verify() { illogical(' {You/he} can\'t fuck that. '); }
  }
  iobjFor(FuckWith)
  {
    verify() { illogical(' {You/he} can\'t fuck with that. '); }
  }
  dobjFor(RubOnto)
  {
    verify() { illogical(' {You/he} can\'t rub that onto anything. '); }
  }
  iobjFor(RubOnto)
  {
    verify() { illogical(' {You/he} can\'t rub that. '); }
  }
  dobjFor(Lick)
  {
    verify() { illogical(' {You/he} can\'t lick that. '); }
  }
  dobjFor(Touch)
  {
    verify() { illogical(' {You/he} can\'t touch that. '); }
  }
  dobjFor(TouchWith)
  {
    verify() { illogical(' {You/he} can\'t touch that with something else. '); }
  }
  iobjFor(TouchWith)
  {
    verify() { illogical(' {You/he} can\'t touch something with that. '); }
  }
  dobjFor(Spank)
  {
    verify() { illogical(' {You/he} can\'t spank that. '); }
  }
  dobjFor(LiftUp)
  {
    verify() { illogical(' {You/he} can\'t lift that up. '); }
  }
  dobjFor(Straighten)
  {
    verify() { illogical(' {You/he} can\'t straighten that. '); }
  }
  dobjFor(Zip)
  {
    verify() { illogical(' {You/he} can\'t zip that. '); }
  }
  dobjFor(UnZip)
  {
    verify() { illogical(' {You/he} can\'t unzip that. '); }
  }
  dobjFor(Button)
  {
    verify() { illogical(' {You/he} can\'t button that. '); }
  }
  dobjFor(UnButton)
  {
    verify() { illogical(' {You/he} can\'t unbutton that. '); }
  }
;

ModuleID
    name = 'Xactor.t'
    byline = 'by Choices'
    htmlByline = 'by <a href="choices1243@hotmail.com">Choices</a>'
    version = '1.05'
;
