! This file is for the storage of objects prefixed with the word 'CONTAINER'
! i.e. objects which can contain other objects.
! Most (but not all) containers have the attribute 'container'.

Class AGTObject	! To define AGT objects.
 with
  after
  [;
   Take: print_ret "You are now carrying ", (the)self, ".";
   Drop: print_ret "You drop ", (the)self, ".";
  ],
  before
  [;
   Kiss: print_ret "Eat ", (the)self, "? You must be kidding!";
   Attack: "It really would make more sense to specify a living creature. Hostility really requires a target of some sort.";
  ],
  key_to ROOM_Limbo,
  TimesSeen 0
;

! A huge fish.
AGTObject CONTAINER_Fish "huge fish" ROOM_Theatre
 with
  after
  [;
   Close:
    if (self hasnt ForNeil)	! Haven't seen this comment yet.
    {
     Quip (-1, 1, Crow, "How did you close the fish? With a needle and thread?", 1);
     give self ForNeil;		! Now, you have seen this comment.
     rtrue;
    }
   Eat:
    print "You eat ", (the)self, ". Not bad.^";
    move self to ROOM_Limbo;
    if (OBJECT_Key in self)	! Comment on the bulge.
    {
     Quip (-1, 1, Tom, "Do you think that this'll affect the chances of completing this game?", 1);
     Quip (-1, 0, Crow, "No, but who cares?", 1);
    }
    rtrue;
   Open:
    print (The)self, " opens easily in your hands. Inside the fish there is a silver key.^";
    Quip (0, 1, Tom, "It's a hinged fish!", 1);
    Quip (0, 0, Joel, "It's a hinged, openable fish at that, Tom.", 1);
    rtrue;
  ],
  description
  [;
   print "The huge fish shines in the light. It gazes mournfully at your with its lidless eye. You notice a bulge in the fish's belly.^";
   Quip (0, 1, Tom, "Hey Joel, I just noticed something! A bulge in the fish's...", 1);
   Quip (0, 0, Joel, "Yeah, I know.", 1);
   if (OBJECT_Key notin self)	! Comment about bulge.
   {
    Quip (0, 1, Crow, "So, what's causing the bulge? A malignant tumour?", 1);
   }
   rtrue;
  ],
  initial "A huge fish lies at your feet.",
  name "huge" "fish"
 has
  container
  edible	! So you can be stupid and eat the key too!
  openable
;

! The small book
AGTObject CONTAINER_Book "small book" ROOM_Study
 with
  before
  [;
   Lock:
    if (second.key_to==self && self hasnt locked && self hasnt open)
    {
     print "You lock the book with the key.^";
     give self locked;
     rtrue;
    }
   Read:
    <Examine self>;		! Show us the text.
    ! OK, Crow, give it the works.
    Quip (0, 1, Crow, "Is it a book on good game design?", 1);
    Quip (0, 0, Tom, "I wish.", 1);
    Quip (0, 0, Joel, "It's a book on nothing. There's NOTHING to read in the book!", 1);
    Quip (0, 0, Crow, "What?", 1);
    Quip (0, 0, Tom, "What he means is that you can see what the book looks like, but you can't read the text IN the book, because there isn't any.", 1);
    Quip (0, 0, Crow, "But... isn't that just a little stupid?", 1);
    Quip (0, 0, Joel, "Yes.", 1);
    rtrue;			! To avoid problems.
   Unlock:
    if (second.key_to==self && self has locked)
    {
     print "You unlock the book with the key.^";
     Quip (0, 1, Tom, "Just like I said you would.", 1);
     give self ~locked;
     rtrue;
    }
  ],
  description
  [;
   print "The small book has an old leather cover with faded Hebrew letters on the cover. The single word, when translated, means ~understanding,~ or ~recognition.~ The book is held closed by a small silver lock.^";
   Quip (0, 1, Tom, "I get it. We unlock the book with the fish!", 1);
   if (self hasnt locked)	! Only it isn't locked!
   {
    Quip (0, 1, Crow, "Except that it isn't.", 1);
   }
   rtrue;
  ],
  name "small" "book"
 has
  Legible
  lockable
  locked
  openable
  scored
;