#charset "us-ascii"

/*
 *   MegaTADS. General header file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#pragma once

/* ---------------------------------------------------------------------- */
/*
 *   Determine which components to include and which to exclude. By default,
 *   some are on and some are off -- most of them on -- but this can be
 *   changed by using a number different global defines. The following
 *   syntax:
 *
 *   MEGA_NAME_ON
 *   MEGA_NAME_OFF
 *
 *   turns the component with the given name on or off. We can also turn all
 *   components off using the following define:
 *
 *   MEGA_ALL_OFF
 *
 *   There is no corresponding define to turn all components on, since most
 *   of them are already on by default. MEGA_ALL_OFF overrides the defaults,
 *   and an explicit MEGA_NAME_ON overrides MEGA_ALL_OFF.
 *
 *   Besides all this, some components require other components, and so will
 *   turn these on by themselves. This overrides even an explicit
 *   MEGA_NAME_OFF.
 *
 *   Implementation: For the components which are off by default, no
 *   additional work is necessary from here. The only way to turn them on is
 *   by using MEGA_NAME_ON defines, and these are what we check for in our
 *   source files. For the components that are on by default, we have to
 *   check for either a MEGA_NAME_OFF or a MEGA_ALL_OFF. Finally, we'll turn
 *   on all components that are required by other components that are on.
 */

/*
 *   Check the components that are on by default. Don't turn anything on if
 *   MEGA_ALL_OFF is defined.
 */
#ifndef MEGA_ALL_OFF

/*
 *   Turn on everything that hasn't been explicitly turned off, in
 *   alphabetical order.
 */

/* miscellaneous grammar additions */
#ifndef MEGA_GRAMMAR_OFF
#define MEGA_GRAMMAR_ON
#endif

/* interjection handling */
#ifndef MEGA_INTERJECT_OFF
#define MEGA_INTERJECT_ON
#endif

/* locational phrases */
#ifndef MEGA_LOCATIONAL_OFF
#define MEGA_LOCATIONAL_ON
#endif

/* patch for the Passages class when both sides are in scope */
#ifndef MEGA_PASSAGE_OFF
#define MEGA_PASSAGE_ON
#endif

/* extended punctuation */
#ifndef MEGA_PUNCT_OFF
#define MEGA_PUNCT_ON
#endif

/* SayTopics */
#ifndef MEGA_SAYTOPIC_OFF
#define MEGA_SAYTOPIC_ON
#endif

/* The SpareWords class */
#ifndef MEGA_SPARE_OFF
#define MEGA_SPARE_ON
#endif

/* patch for TIActions with one empty noun phrase */
#ifndef MEGA_TIACTION_OFF
#define MEGA_TIACTION_ON
#endif

/* Unactors */
#ifndef MEGA_UNACTOR_OFF
#define MEGA_UNACTOR_ON
#endif

/* the USE command */
#ifndef MEGA_USE_OFF
#define MEGA_USE_ON
#endif

#endif /* ifndef MEGA_ALL_OFF */

