#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Data-structures Library Extension
 *
 *  Stack.t
 *
 *  Defining the Stack class.
 */

#include <tads.h>
#include <t3.h>

class Stack: Queue
{
    /*
     *  Returns the data value at the top of a non-empty stack.
     */
    top() { return front(); }

    /*
     *  Push value onto the stack. 
     */
    push(val)
    {
        local node;

        /*
         *  Create a new stack node.
         */
        node    = new Stack(val...);

        /*
         *  Set the new stack node's next pointer
         *  to the 1st node of the stack.
         */
        node.setNextThis(nodeFirst());

        /*
         *  Set the 1st node of the stack's next pointer
         *  to the new stack node.
         */
        nodeFirst().setPrevThis(node);

        return node;
    }
}