#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Data-structures Library Extension
 *
 *  Node.t
 *
 *  Defining the Node class.
 */

#include <tads.h>
#include <t3.h>

class Node: object
{
    data    = nil
    type    = nil

    next        = nil
    prev        = nil

    /*
     *  Returns the next pointer for this node.
     */
    nextThis()
    {
        return next;
    }

    /*
     *  Returns this node.
     */
    nodeThis()
    {
        return self;
    }

    /*
     *  Returns the prev pointer for this node.
     */
    prevThis()
    {
        return prev;
    }

    /*
     *  Set this node's next pointer to point to node.
     */
    setNextThis(node)
    {
        next    = node;
    }

    /*
     *  Set this node's prev pointer to point to node.
     */
    setPrevThis(node)
    {
        prev    = node;
    }

    /*
     *  Set the data value of this node.
     */
    setValThis([value])
    {
        if (value.length())
        {
            data   = value.car();
            setTypeThis(dataType(data));
        }
        else
        {
            data    = nil;
            setTypeThis(nil);
        }
    }

    /*
     *  Set the type value of this node.
     */
    setTypeThis(type)
    {
        self.type   = type;
    }

    /*
     *  Returns the type value of this node
     */
    typeThis()
    {
        return type;
    }

    /*
     *  Returns the data value of this node
     */
    valThis()
    {
        return data;
    }
}