#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

/* Space_en_us.t
 * by Eric Eve, 2004
 *
 * This file handles all of the (English) language specific parts of
 * the ECC/ConSpace extension.
 */

//-----------------------------------------------
// Language-specific VerbRules and modifications
//-----------------------------------------------


// replacements:


replace VerbRule(GetOutOf)
    ('out' 'of' | 'get' 'out' 'of' | 'climb' 'out' 'of' | 'leave' | 'exit')
    singleDobj
    : GetOutOfAction
    verbPhrase = ('move/moving ' + gActor.location.actorOutOfPrep + ' (what)')
    askDobjResponseProd = singleNoun
;

replace VerbRule(GetOffOf)
    'get' ('off' | 'off' 'of' | 'down' 'from') singleDobj
    : GetOffOfAction
    verbPhrase = ('move/moving ' + gActor.location.actorOutOfPrep + ' (what)')
    askDobjResponseProd = singleNoun
;


// modifications:


modify VerbRule(StandOn)
/* The library defines the grammer thus:
 *
 *  ('stand' | 'climb') ('on' | 'in') singleDobj
 *
 * Because we are treating "standing *in*" and "standing *on*" as two
 * different actions, we remove 'in' from the above.
 */
    ('stand' | 'climb') ('on') singleDobj
    :
;

modify VerbRule(SitOn)
/* The library defines the grammer thus:
 *
 *  'sit' ( | 'on' | 'down' | 'in' | 'down' 'on' | 'down' 'in') singleDobj
 *
 * Because we're treating "sitting *in*" and "sitting *on*" as two
 * different actions, we remove 'in' from the above.
 *
 * However, SitOnAction takes precedence over SitInAction, when the
 * command is simply "sit" or "sit down".
 */
    'sit' ( | (( | 'down') ( | 'on')) ) singleDobj
    :
;

modify VerbRule(LieOn)
/* The library defines the grammer thus:
 *
 *  'lie' ( | 'on' | 'down' | 'in' | 'down' 'on' | 'down' 'in') singleDobj
 *
 * Because we're treating "lying *in*" and "lying *on*" as two
 * different actions, we remove 'in' from the above.
 *
 * However, LieOnAction takes precedence over LieInAction, when the
 * command is simply "lie" or "lie down".
 */
    'lie' ( | (( | 'down') ( | 'on')) ) singleDobj
    :
;

modify VerbRule(MoveTo)
/* The library defines the grammar thus:
 *
 *  ('push' | 'move') dobjList ('to' | 'under') singleIobj
 *
 * We're treating 'under' specially and separately, so we remove
 * 'under' from the above.
 */
    ('push' | 'move') dobjList ('to') singleIobj
    :
;

modify VerbRule(PutUnder)
/* The library defines the grammar thus:
 *
 *  ('put' | 'place') dobjList 'under' singleIobj
 *
 * We sophisticate the grammar a bit:
 */
  ('put' | 'place' | 'move') dobjList
  ('under' | 'below' | 'beneath' | 'underneath') singleIobj
   :
;

modify VerbRule(LookUnder)
/* The library defines the grammar thus:
 *
 *  ('look' | 'l') 'under' dobjList
 *
 * We sophisticate the grammar a bit:
 */
   ('look' | 'l') ('under' | 'below' | 'beneath' | 'underneath')
   dobjList
   :
;

modify VerbRule(PutUnder)
  ('put' | 'place') dobjList ('under' | 'below' | 'beneath' | 'underneath') singleIobj
   :
;

modify VerbRule(LookUnder)
   ('look' | 'l') ('under' | 'below' | 'beneath' | 'underneath') dobjList
   :
;

// new verb rules:


VerbRule(SitIn)
    'sit' ( ( | 'down') 'in' ) singleDobj
    : SitInAction
    verbPhrase = 'sit/sitting (in what)'
    askDobjResponseProd = singleNoun
;

VerbRule(LieIn)
    'lie' ( ( | 'down') 'in' ) singleDobj
    : LieInAction
    verbPhrase = 'lie/lying (in what)'
    askDobjResponseProd = singleNoun
;

VerbRule(SitUnder)
    ('sit' ( | 'down') 'under' ) singleDobj
    : SitUnderAction
    verbPhrase = 'sit/sitting (under what)'
    askDobjResponseProd = singleNoun
;

VerbRule(LieUnder)
    ('lie' | 'climb' | 'crawl') ( | 'down') 'under' singleDobj
    : LieUnderAction
    verbPhrase = 'lie/lying (under what)'
    askDobjResponseProd = singleNoun
;

VerbRule(SitBehind)
    ('sit' 'behind') singleDobj
    : SitBehindAction
    verbPhrase = 'sit/sitting (behind what)'
    askDobjResponseProd = singleNoun
;

VerbRule(LieBehind)
    ('lie' 'behind') singleDobj
    : LieBehindAction
    verbPhrase = 'lie/lying (behind what)'
    askDobjResponseProd = singleNoun
;

VerbRule(PutNear)
  ('put' | 'move' | 'push') dobjList ('near' | 'beside' | 'next' 'to' | 'by') singleIobj
  : PutNearAction
  verbPhrase = 'put/putting (what) (near what)'
;

VerbRule(StandNear)
  ('stand' | 'go' | 'move' | 'walk' | 'get' )
  ('near' | 'nearby' | 'beside' | 'by' | (('next' | 'close' | 'over' | 'closer' | ) 'to'))
  singleDobj
  : StandNearAction
  verbPhrase = 'stand/standing (near what)'
;

VerbRule(SitNear)
  'sit' ( | 'down') ('near' | 'by') singleDobj
  : SitNearAction
  verbPhrase = 'sit/sitting (near what)'
;

VerbRule(LieNear)
  'lie' ( | 'down') ('near' | 'by') singleDobj
  : LieNearAction
  verbPhrase = 'lie/lying (near what)'
;

/* "Stand Under" implies room to stand, which there may or may not be room to do
 * "Get Under" is vaguer, and may imply getting under in the default posture.
 *  So perhaps these need to be separate verbs.
 */

VerbRule(StandUnder)
 ('stand' |  'walk' )
 ('under' | 'below' | 'beneath' | 'underneath') singleDobj
  : StandUnderAction
  verbPhrase = 'stand/standing (under what)'
;

VerbRule(GetUnder)
 ('go' | 'move' | 'get')
 ('under' | 'below' | 'beneath' | 'underneath') singleDobj
  : GetUnderAction
  verbPhrase = 'get/getting (under what)'
;

VerbRule(StandBehind)
   ('stand' | 'go' | 'move' | 'walk' | 'get') ('behind') singleDobj
   : StandBehindAction
    verbPhrase = 'stand/standing (behind what)'
;

VerbRule(StandIn)
  ('stand') ('in' | 'inside') singleDobj
  : StandInAction
  verbPhrase = 'stand/standing (in what)'
;

VerbRule(WalkOverTo)
 ( 'approach' | ('walk' | 'stroll' | 'amble') ('near' | ('over' | 'across') 'to')) singleDobj
 : WalkOverToAction
 verbPhrase = 'go/going (over to what)'
;

VerbRule(PutInFront)
 ('put' | 'place' | 'move' | 'drop') dobjList (('in' 'front' 'of') | 'before') singleIobj
 : PutInFrontAction
 verbPhrase = 'put/putting (what) (in front of what)'
;

VerbRule(StandInFront)
 ('stand' | 'move' | 'go' | 'walk') (('in' 'front' 'of') | 'before') singleDobj
 : StandInFrontAction
 verbPhrase = 'stand/standing (in front of what)'
;

VerbRule(GoFromUnder)
  ('go' | 'get' | 'move') ('out' | 'out' 'from')
  ('under' | 'underneath' | 'below') singleDobj
  : GetOutOfAction
  verbPhrase = ('get/getting out from under (what)')
  askDobjResponseProd = singleNoun
;

VerbRule(GoFromBehind)
  ('go' | 'get' | 'move') ('out' | 'out' 'from') 'behind' singleDobj
  : GetOutOfAction
  verbPhrase = ('get/getting out from behind (what)')
  askDobjResponseProd = singleNoun
;

VerbRule(GoAwayFrom)
  ('go' | 'get' | 'walk' | 'move' | 'get') 'away' 'from' singleDobj
  : GoAwayFromAction
  verbPhrase = ('move/moving ('+ (gDobj==nil ? 'away from' : gDobj.actorOutOfPrep) + ' what)')
  askDobjResponseProd = singleNoun
;





//--!! Note: We may also want a TIAction: "move X away from Y".
//--!!       It's vague the best default behavior, so we don't
//--!!       support this at present.

/* ================================================================*\
|*         Additional action messages, for command reports.        *|
\* =============================================================== */

modify playerActionMessages
    notNearMsg = '{You/he} {is} not particularly near {the dobj/him}. '
    okayMoveAwayFromMsg(loc)
    {
        return ('{You/he} move{s/d} ' + loc.actorOutOfName + '. ');
    }
    okayMoveNearMsg(loc)
    {
        return ('{You/he} put{s|} {the dobj/him} near ' + loc.theName
                + '. ');
    }
    cannotPutNearMsg = cannotStandBesideMsg
    moveAwayToNoEffectMsg = 'That would {| have }accomplish{|ed} nothing. '
    cannotStandBesideMsg = '{You} {are} already near enough. '
    cannotStandInMsg = '{That dobj/he} {is} not something {you/he} can
                         stand in. '
    cannotGetNearerMsg = '{The dobj/he} {is} out of reach from here;
                          perhaps {you/he} {can} find some other way of
                          getting nearer. '
    alreadyPutNearMsg = ('{The dobj/he} {is} already '
                         + gIobj.actorInName + '. ')
    alreadyStandingNearMsg = ('{You/he} {is} already standing '
                              + gDobj.actorInName + '. ')

    walkIntoMsg(dest)
    { return '{You/he} walk{s/ed} ' + dest.actorIntoName + '. '; }

    posPrep(pos)
    {
        switch(pos)
        {
            case posNear: return 'near';
            case posBehind : return 'behind';
            case posUnder: return 'under';
            case posFront: return 'in front of';
            case posIn: return 'in';
            case posOn: return 'on';
            default: return 'by';
        }
    }
    actorAlreadyThereMsg = '{You/he} {is} already there. '
     
    actorPostureThereMsg(obj, pos)
    {
      return '{You/he} {is} ' + gActor.posture.participle + ' '
       + posPrep(pos) + ' ' + obj.theName + '. ';
    }  
    

    alreadyCloseMsg(pos)
    {
        return '{The dobj/he} {is} already ' + posPrep(pos) + ' {the iobj/him}. ';
    }

    cannotPutCloseMsg(pos)
    {
        return '{You/he} {can\'t} put anything ' + posPrep(pos) + ' {that iobj/him}. ';
    }

    okayPutCloseMsg(pos)
    {
        return '{You/he} put{s|} {the dobj/him} down ' + posPrep(pos) + ' {the iobj/him}. ';
    }

    cannotStandCloseMsg(pos)
    {
        return '{You/he} {can\'t} stand ' + posPrep(pos) + ' {that dobj/him}. ';
    }

    cannotSitCloseMsg(pos)
    {
        return '{You/he} {can\'t} sit ' + posPrep(pos) + ' {that dobj/him}. ';
    }

    cannotLieCloseMsg(pos)
    {
        return '{You/he} {can\'t} lie ' + posPrep(pos) + ' {that dobj/him}. ';
    }

    cannotStandNearMsg = 'There{\'s| was} nowhere near {that dobj/him} to stand. '

// should the following use gDobj.actorIntoName?

    okayGoOverToMsg = '{You/he} {goes} over to {the dobj/him}. '

    okayStandCloseMsg(pos, post)
    {
        return '<.p>Okay, {you/he} {is} now ' + post.participle + ' ' 
           + posPrep(pos) + ' {the dobj/him}. ';
    }
    
    okayNewPostureMsg = ( 'Okay, {you/he} {is} now ' + gActor.posture.participle + ' '
     + gActor.roomLocation.actorInName + '. ')
    
    

//  cannotStandUnderMsg = '{You/he} can\'t stand under {that dobj/him}. '

  noRoomUnderMsg = 'There{\'s| was} not enough room under {the dobj/him} to get under (it dobj/him}. '
   
  noRoomToStandHereMsg = ('There{\'s| was} not enough room under ' + gActor.roomLocation.theName
   + ' to stand. ' )

  okayGoUnderMsg = 'Okay, {you/he} {is} now standing under {the dobj/him}. '
  alreadyUnderMsg = '{The dobj/he} {is} already under {the iobj/him}. '
  okayGoBehindMsg = 'Okay, {you/he} {is} now standing behind {the dobj/him}. '
  alreadyBehindMsg = '{The dobj/he} {is} already behind {the iobj/him}. '

  alreadyAwayFromMsg = '{You/he} {is}n\'t that close to {the dobj/him}. '
  goWhereMsg = 'Which way {would|did} {you/he} {like|want} to go? '
;

 /* Additional messages for use with tryImplicitActionMsg on NestedSpace */

modify libMessages
    enterNestedSpaceMsg(action, ctx)
    {
        local msg, obj = action.getDobj();
        msg = (ctx.useInfPhrase ? 'trying to get': 'getting ')
               + obj.actorIntoName;
        return ctx.buildImplicitAnnouncement(msg);
    }

    leaveNestedSpaceMsg(action, ctx)
    {
        local msg, obj = action.getDobj();
        msg = (ctx.useInfPhrase ? 'trying to move': 'moving ')
               + obj.actorOutOfName;
        return ctx.buildImplicitAnnouncement(msg);
    }
;

//-----------------------------------------------------------
//  English Language Mods to Specific Classes
//-----------------------------------------------------------

modify NestedSpace
    objInPrep = 'near' 
    actorInPrep = (objInPrep)   
    actorOutOfPrep = 'away from'
;

modify ESubSurface
    objInPrep = 'on'
    actorOutOfPrep = 'off'
;

modify ESubContainer
    objInPrep = 'in'
    actorOutOfPrep = 'out of'
;

modify ESubUnderside
    objInPrep = 'under'    
    actorOutOfPrep = 'out from under'
;

modify ESubRear
    objInPrep = 'behind'  
    actorOutOfPrep = 'out from behind' 
;

//modify ESubRearSurface
//  actorInPrep = 'behind'
//  actorOutOfPrep = 'out from behind'
//;

 /* Also define the following for convenience */

class NestedSpaceUnder : NestedSpace
   objInPrep = 'under'   
;

class NestedSpaceBehind : NestedSpace
   objInPrep = 'behind'   
;

class NestedSpaceFront: NestedSpace
   objInPrep = 'in front of'
;



//----------------------------------------------------------
//  Additional Listers
//-----------------------------------------------------------


  /* 
   * The generalContentsLister is a lister that employs the objInPrep of the
   * container whose contents is being listed. This allows an author to change
   * the objInPrep (or the actorInPrep, which objInPrep follows by default) 
   * of a NestedSpace object and have the lister use the correct preposition.
   */

class BaseGeneralContentsLister: Lister
     showListPrefixWide(itemCount, pov, parent)
         { "\^<<parent.objInPrep>> <<parent.theNameObj>> <<itemCount == 1 ? '{is|was}' : '{are|were}'>> "; }
     showListSuffixWide(itemCount, pov, parent)
         { ". "; }
     showListPrefixTall(itemCount, pov, parent)
         { "\^<<parent.objInPrep>> <<parent.theNameObj>> <<itemCount == 1 ? '{is|was}' : '{are|were}'>>:"; }
     showListContentsPrefixTall(itemCount, pov, parent)
         { "<<parent.aName>>, <<parent.objInPrep>> which <<itemCount == 1 ? '{is|was}' : '{are|were}'>>:"; }
     
     showCustomList(lst, options, indent, parent)
     {
         local infoTab;
     
         /* create a sense information table with each item in full view */
         infoTab = new LookupTable(16, 32);
         foreach (local cur in lst)
         {
             /* add a plain view sensory description to the info list */
             infoTab[cur] = new SenseInfo(cur, transparent, nil, 3);
         }
         
         /* show the list from the current global point of view */
         showList(getPOV(), parent, lst, options, indent, infoTab, nil);
     }
    showListEmpty(pov, parent)
     {
         /* show a default message indicating the space is empty */
         gMessageParams(parent);
         defaultDescReport('{You/he} {sees} nothing ' + parent.objInPrep +
             ' {the parent/him}. ');
     }

         
;

generalContentsLister : ContentsLister, BaseGeneralContentsLister
;

class BaseDiscoverContentsLister : BaseGeneralContentsLister
     showListPrefixWide(itemCount, pov, parent)
         { "\^<<parent.objInPrep>> <<parent.theNameObj>> {you/he} discover{s/ed} "; }
     showListSuffixWide(itemCount, pov, parent)
         { ". "; }
     showListPrefixTall(itemCount, pov, parent)
         { "\^<<parent.objInPrep>> <<parent.theNameObj>> {you/he} discover{s/ed} "; }
     showListContentsPrefixTall(itemCount, pov, parent)
         { "<<parent.aName>>, <<parent.objInPrep>> in which {you/he} discover{s/ed} "; }     
     
;

discoverContentsLister : ContentsLister, BaseDiscoverContentsLister
;


//------------------------------------------------------------------
//   Modify announcement of default direct object to use the
//   correct preposition on a NestedSpace
//-----------------------------------------------------------------


modify TAction
    announceDefaultObject(obj, whichObj, resolvedAllObjects)
    {
        local prep;
        local nm = obj.theNameObj;
        
        
        if(obj.ofKind(NestedSpace))
          prep = obj.actorInPrep + ' '; 
          
          
        else
        /* 
         *   get any direct object preposition - this is the part inside
         *   the "(what)" specifier parens, excluding the last word 
         */
        
        {
          rexSearch('<lparen>(.*<space>+)?<alpha>+<rparen>', verbPhrase);
          prep = (rexGroup(1) == nil ? '' : rexGroup(1)[3]);
        }

        /* show the preposition (if any) and the object */
        return (prep == '' ? nm : prep + nm);
    }

;
