//
//  XTBannerTextView.m
//  XTads
//
//  Created by Rune Berg on 25/12/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import "XTBannerTextView.h"
#import "XTLogger.h"
#import "XTPrefs.h"
#import "XTNotifications.h"
#import "XTAllocDeallocCounter.h"


@interface XTBannerTextView ()

@property BOOL hasDoneCustomInit;
@property XTPrefs *prefs;

@end


//TODO refactor wrt XTOutputTextView
@implementation XTBannerTextView

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTBannerTextView class]];
}

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

- (id)initWithFrame:(NSRect)frame
{
	//XT_DEF_SELNAME;
	//XT_TRACE_0(@"");

	self = [super initWithFrame:frame];
	if (self) {
		[self customInit];
	}
	return self;
}

- (void)customInit
{
	if (_hasDoneCustomInit) {
		return;
	}
	
	[super customInit];

	_prefs = [XTPrefs prefs];
	
	[self setEditable:NO];
	
	//_showCursor = YES;
	
	_hasBorder = NO;
	
	// don't propagate our font to NSFontPanel
	[self setUsesFontPanel:NO];
	
	[self setAutomaticSpellingCorrectionEnabled:NO];
	
	[self syncWithPrefs];
	
	[_prefs startObservingChangesToAll:self];
	
	_hasDoneCustomInit = YES;
}

// For banners only: recalc tab stops wrt. live window/view resize
- (void)resizeWithOldSuperviewSize:(NSSize)oldSize
{
	//XT_WARN_ENTRY;
	
	[super resizeWithOldSuperviewSize:oldSize];
	
	[self.outputFormatter recalcAllTabStops];
}

- (void)teardown
{
	[_prefs stopObservingChangesToAll:self];
	
	NSAttributedString *noText = [NSAttributedString new];
	[self.textStorage setAttributedString:noText];
	
	self.delegate = nil;
}

//TODO do in handler?
- (void)observeValueForKeyPath:(NSString *)keyPath
					  ofObject:(id)object
						change:(NSDictionary *)change
					   context:(void *)context
{
	XT_DEF_SELNAME;
	XT_TRACE_1(@"keyPath=\"%@\"", keyPath);
	
	if (object == self.prefs) {
		[self syncWithPrefs];
	} else {
		XT_TRACE_0(@"%@ OTHER");
	}
}

- (void)syncWithPrefs
{
	BOOL spellCheck = self.prefs.spellCheckGameText.boolValue;
	[self setContinuousSpellCheckingEnabled:spellCheck];
	
	BOOL gramCheck = self.prefs.grammarCheckGameText.boolValue;
	[self setGrammarCheckingEnabled:gramCheck];

	//TODO unless set by game:
	self.backgroundColor = self.prefs.statusLineBackgroundColor;

	//TODO unless set by game:
	//TODO text color
}

- (BOOL)displaysLinkToolTips
{
	return self.prefs.linksShowToolTips.boolValue;
}

- (void)changeFont:(id)sender
{
	// Nothing - we don't want NSFontPanel to directly change our font
}

- (void)keyDown:(NSEvent *)theEvent
{
	// Nothing - we don't want arrow keys etc. to scroll banner
	// (but allow cmd-a and cmd-c, so user can copy text)
	
	//TODO support/test self.allowUserScrolling
	
	[XTNotifications notifySetFocusToMainOutputView:self];
}

- (void)unselectText
{
	[self setSelectedRange:NSMakeRange(0, 0)];
}

// https://developer.apple.com/library/mac/documentation/Cocoa/Conceptual/TextLayout/Tasks/CountLines.html
- (NSUInteger)countRenderedTextLines
{
	NSLayoutManager *layoutManager = [self layoutManager];
	
	NSUInteger numberOfGlyphs =	[layoutManager numberOfGlyphs];
	NSUInteger numberOfLines;
	NSUInteger index;
	NSRange lineRange;
	
	for (numberOfLines = 0, index = 0; index < numberOfGlyphs; numberOfLines++) {
		
		(void) [layoutManager lineFragmentRectForGlyphAtIndex:index
											   effectiveRange:&lineRange];
		index = NSMaxRange(lineRange);
	}
	
	return numberOfLines;
}

- (NSUInteger)countCharsInText
{
	NSUInteger res = [self.textStorage length];
	return res;
}


@end
