//
//  XTStringUrlValueTransformer.m
//  TadsTerp
//
//  Created by Rune Berg on 18/10/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTFileUrlStringValueTransformer.h"


@implementation XTFileUrlStringValueTransformer

+ (Class)transformedValueClass
{
	return [NSString class];
}

+ (BOOL)allowsReverseTransformation
{
	return YES;
}

- (id)transformedValue:(id)value
{
	NSString *res = nil;
	
	if (value != nil && [value isKindOfClass:[NSURL class]]) {
		NSURL *urlVal = (NSURL *)value;
		res = urlVal.path;
	}
	
	return res;
}

- (id)reverseTransformedValue:(id)value
{
	NSURL *res = nil;
	
	if (value != nil && [value isKindOfClass:[NSString class]]) {
		res = [NSURL fileURLWithPath:(NSString *)value];
	}
	
	return res;
}

@end
