//
//  XTGameCommand.m
//  XTads
//
//  Created by Rune Berg on 07/03/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTGameCommand.h"


@implementation XTGameCommand

@synthesize result = _result;
@synthesize command = _command;

- (instancetype)initWithResult:(XTGameCommandResult)result
					   command:(NSString *)command
{
	self = [super init];
	if (self) {
		_result = result;
		_command = command;
	}
	return self;
}

+ (instancetype)withCommand:(NSString *)command
{
	XTGameCommand *res = [[XTGameCommand alloc] initWithResult:XT_GAME_CMD_OK_COMMAND command:command];
	return res;
}

+ (instancetype)withTimeout
{
	XTGameCommand *res = [[XTGameCommand alloc] initWithResult:XT_GAME_CMD_TIMEOUT command:nil];
	return res;
}

+ (instancetype)withGameQuit
{
	XTGameCommand *res = [[XTGameCommand alloc] initWithResult:XT_GAME_CMD_GAME_QUIT command:nil];
	return res;
}

@end
