//
//  XTPrefsItemFloat.m
//  XTads
//
//  Created by Rune Berg on 12/04/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTPrefsItemFloat.h"
#import "XTPrefsItem_private.h"


@implementation XTPrefsItemFloat

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;
{
	return [XTPrefsItemFloat itemWithDefaultValue:defaultValue userDefaultsKey:userDefaultsKey valueTransformer:nil];
}

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer
{
	XTPrefsItemFloat *item = [XTPrefsItemFloat new];
	item.defaultValue = defaultValue;
	item.userDefaultsKey = userDefaultsKey;
	item.valueTransformer = valueTransformer;
	item.value = [item copyOfDefaultValue];
	item.skipResetToDefault = NO;
	return item;
}

- (void)internalPersist:(id)persistedValue
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	[userDefaults setFloat:self.value.floatValue forKey:self.userDefaultsKey];
}

- (id)internalRestoreFromPersisted
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	CGFloat floatVal = [userDefaults floatForKey:self.userDefaultsKey];
	NSNumber *res = [NSNumber numberWithFloat:floatVal];
	return res;
}

@end
