//
//  XTHtmlTagT2TradStatusLine.m
//  XTads
//
//  Created by Rune Berg on 11/11/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import "XTHtmlTagT2TradStatusLine.h"
#import "XTFormattedOutputElement.h"
#import "XTBaseTextHandler.h"
#import "XTBannerTextHandler.h"
#import "XTLogger.h"
#import "osxtads.h"


@implementation XTHtmlTagT2TradStatusLine

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTHtmlTag class]];
}

+ (NSString *)name
{
	return @"xtads-tads2tradstatusline";
}

+ (BOOL)standalone
{
	return NO;
}

+ (instancetype)withMode:(NSUInteger)statusLineMode
{
	//XT_DEF_SELNAME;
	
	XTHtmlTagT2TradStatusLine *tag = [XTHtmlTagT2TradStatusLine new];
	NSString *modeStr = [NSString stringWithFormat:@"%lu", statusLineMode];
	[tag addAttribute:@"mode" value:modeStr];
		//TODO !!! adapt: make a distinct member field?
	return tag;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSUInteger statusLineMode = [self attributeAsUInt:@"mode"];
	XTFormattedOutputElement *outputElement = nil;
	if (statusLineMode == STATUS_LINE_MODE_STATUS) {
		outputElement = [XTFormattedOutputElement statusLineModeStart];
		outputElement.htmlTag = self;
	} else if (statusLineMode == STATUS_LINE_MODE_MAIN) {
		outputElement = [XTFormattedOutputElement statusLineModeEnd];
		outputElement.htmlTag = self;
		if ([textHandler isKindOfClass:[XTBannerTextHandler class]]) {
			[textHandler setAbortProcessingTags];
		}
	} else if (statusLineMode == STATUS_LINE_MODE_SUPPRESS) {
		outputElement = [XTFormattedOutputElement statusLineModeSuppress];
	} else {
		XT_DEF_SELNAME;
		XT_ERROR_1(@"unknown statusLineMode %lu", statusLineMode);
	}
	if (outputElement != nil) {
		NSArray *res = [NSArray arrayWithObject:outputElement];
		[textHandler receiveFormattedElements:res];
	}
}

@end
