
/* Sample TADS game demonstrating how to use the 'go to' verb. */

#include <adv.t>
#include <std.t>
#include <GOTO.T>

// The function initGoTo should normally be called, but it doesn't *have*
// to.  To make this sample program I've chosen to use the standard std.t
// file with its definition of the preinit function, so initGoTo is not
// called.


startroom: room
    sdesc = "Clearing"
    noun = 'clearing'       // Rooms must have vocabular words defined
    adjective = 'forest'    // for the 'go to' command to work.
    ldesc = "You're standing in a clearing in the forest.  A path leads
             south, and to the east lies a small building.  To the north
             is a treacherous swamp. "
    north = {
        /* This swamp really is dangerous.  But only kill the player if
         * s/he is actually walking into it, not just because the 'go to'
         * command is trying if this is a usable direction.
         */
        if ( global.justTesting )
            return (nil);   // Just say "no exit in that direction"
        else {
            "You cautiously take a step onto a tussock that looks sturdy.
             That wasn't so hard at all.  You take another step.  This is
             going fine!  Encouraged by your success you take a third step,
             and a fourth and...\ suddenly you sink deep into the mud!
             The bank is too far away for you to reach it, and the mud
             sucks you down, slowly but surely. ";
            die();
        }
    }
    south = outsideCave
    east = outerFrontDoor
    isseen = true   // Old versions of std.t does not set startroom.isseen
                    // to true after the initial lookAround.  This is normally
                    // not very important, but here it matters because the
                    // player can only 'go to' already seen locations.
;

swamp: decoration
    sdesc = "swamp"
    noun = 'swamp'
    adjective = 'treacherous'
    ldesc = "I wouldn't wander around there if I were you.  A swamp can
             be very dangerous if you don't know it extremely well.  (Don't
             ask me how anybody is supposed to come to know a swamp in the first
             place if they can't go there until they know it extremely well.) "
    location = startroom
;

building: decoration
    sdesc = "building"
    noun = 'building' 'house'
    adjective = 'small' 'thatched'
    ldesc = "It's a small thatched house.  From the outside it looks a
             bit dilapidated, as if it has not been inhabited for a long
             time.  Especially the door lock is in a bad shape, so I guess
             you could take a look inside. "
    location = startroom
;

outerFrontDoor: doorway
    sdesc = "door"
    noun = 'door'
    adjective = 'front'
    location = startroom
    otherside = innerFrontDoor
    doordest = m2room
;

innerFrontDoor: doorway
    sdesc = "front door"
    noun = 'door'
    adjective = 'front'
    location = m2room
    otherside = outerFrontDoor
    doordest = startroom;
;

wirthBust: fixeditem
    sdesc = "Niklaus Wirth bust"
    noun = 'bust' 'pedestal'
    adjective = 'niklaus' 'wirth'
    heredesc = "In the corner stands a pedestal with a bust. "
    ldesc = "According to a small sign on the pedestal the bust 
             represents Niklaus Wirth, the father of the programming
             languages Pascal, Modula-2, and Oberon.  The bust is very
             well done, so well that it almost looks alive. "
    location = m2room
;

m2room: room
    sdesc = "Modula-2 Room"
    noun = 'room'
    adjective = 'modula' '2' 'modula-2' 'niklaus' 'wirth'
    ldesc = {
        if (not self.isseen)
            "Entering the building is big surprise.  The outside ";
        else
            "The outside of the building ";
        "seemed to suggest that this might be the idyllic home of a
         forest guard, but from the inside it looks more like the home
         of a full-time programmer.  All around the room is computing
         equipment and manuals.  The front door is in the western wall,
         and in the eastern wall is a back door. ";
    }
    roomCheck(v) = {
        /* If the player uses the 'go to' command from this room Wirth
         * protests.  But he doesn't stop the player from walking THROUGH
         * the room (stopping the actor from that should have been done
         * by defining the method gtRoomCheck(actor) to return nil).
         */
        if (v = goToVerb) {
            /* This only catches the player using 'go to' from here,
             * because the individual moves are simulated as normal moves.
             * Thus during movement the verb would be (say) v = wVerb.
             */
            "Suddenly Niklaus Wirth's bust comes to life!  \"Thou shalt
             not use GOTO; That giveth no good structure!\" it exclaims.
             You are so startled by this that you obediently stay where
             you are, and the bust falls back to lifelessnes. ";
            return( nil );
        }
        else
            pass roomCheck;
    }
    west = innerFrontDoor
    east = innerBackDoor
;

lamp: lightsource
    sdesc = "lamp"
    noun = 'lamp'
    islit = true
    location = m2room
;

equipment: decoration
    sdesc = "computer equipment"
    noun = 'equipment'
    adjective = 'computer'
    ldesc = "A look at the computers tells you that the person that live
             here must be a very enthuisiastic.  He (or she) has been so
             quick to buy the newest equipment that he (I'm becoming
             more and more convinced that it must be a 'he') forgot that
             electricity is not installed in the house. "
    location = m2room
;

manuals: readable
    sdesc = "manuals"
    adesc = "some manuals"
    noun = 'manual' 'manuals'
    adjective = 'computer'
    ldesc = "They are all manuals to various implementations of Modula-2. "
    readdesc = "\"IF ...\ THEN ...\ ELSIF ...\ ELSIF ...\ ELSE ...\ END;\"
                and so on. "
    location = m2room
;

innerBackDoor: doorway
    sdesc = "back door"
    noun = 'door'
    adjective = 'back'
    location = m2room
    otherside = outerBackDoor
    doordest = backyard
;

outerBackDoor: doorway
    sdesc = "back door"
    noun = 'door'
    adjective = 'back'
    location = backyard
    otherside = innerBackDoor
    doordest = m2room
;

backyard: room
    sdesc = "Backyard"
    noun = 'backyard'
    ldesc = "You're standing in a backyard.  The floor is tiled and a brick
             wall surrounds you.  The only exit is back west. "
    west = outerBackDoor
;
/* The purpose of this backyard to make it possible to walk through the
 * m2room, so the comment in m2room.roomCheck(v) can be verified.  As a
 * bonus, this also allows the player to close the doors and 'go to'
 * (say) the clearing.  This will demonstrate how doors are automatically
 * opened on a walk.
 */

brickwall: decoration
    sdesc = "brick wall"
    noun = 'wall'
    adjective = 'brick'
    ldesc = "There is nothing special about the brick wall.  It's too
             high to climb, if that's what you're hinting at. "
    location = backyard
;

outsideCave: room
    sdesc = "Outside Cave"
    noun = 'cave'
    adjective = 'outside' 'entrance'
    ldesc = {
        "The path ends at the opening of a cave that lies to the south.
         This looks exactly like one of those caves where other people
         are said to have found fortunes in gold and jewels! ";
        if (not Me.isCarrying(lamp))
            "It may be a good idea to bring a lamp, before you start
             exploring, though. ";
    }
    north = startroom
    south = {
        "You boldly enter the cave.  After a few paces the tunnel turns
         and after a few more paces you have to realize that you are
         lost.\b";
        return( maze1 );
    }
;

class mazeroom: lostroom, darkroom  // Note the order - both lostroom and
                                    // darkroom has a gtRoomCheck method,
                                    // and we want the one from lostroom.
    sdesc = "Lost in Tunnels"
    ldesc = "All around you identical-looking tunnels lead to somewhere
             else. "
;

maze1: mazeroom
    // There is no reason to define vocabulary words for these locations.
    // The player is not allowed to go there, anyway.
    north = maze1
    south = maze2
    east = maze2
    west = {
        "After a turn you can see light ahead.  Relieved you emerge to -\b";
        return( outsideCave );
    }
;
maze2: mazeroom
    north = maze1
    south = maze2
    west = maze1
    east = {
        "The tunnel bends sharply and suddenly you find yourself outside
         the cave in the middle of a -\b";
        return( glade );
    }
;
// Yes, that's a very small maze, it's just there to demonstrate how to
// use the class lostroom.

glade: room
    sdesc = "Peaceful Glade"
    noun = 'glade'
    adjective = 'peaceful'
    ldesc = "You're standing in a peaceful glade.  The air is fresh,
             everything is silent, and there is even a stump of a tree
             that looks like it will provide a comfortable seat.  The
             only disturbing thing is that a thick briar scrub surronds you,
             which means you'll have to find your way back through the
             tunnels whose ominously dark entrance lies to the north. "
    north = maze2
;

stump: chairitem
    sdesc = "tree stump"
    noun = 'stump'
    adjective = 'tree'
    ldesc = "The appearance of the stump shows that you're not the first
             person here.  The tree has been felled with a saw, leaving
             a flat stump that constitutes a comfortable seat. "
    location = glade
    statusPrep = "on"
;
// The idea of the seat is to show what happens if player is sitting when
// s/he uses the 'go to' command:  Just what would happen with normal
// movement commands:
// >go to clearing
// You're not going anywhere until you get off that tree stump.

briarscrub: decoration
    sdesc = "briar scrub"
    noun = 'scrub'
    adjective = 'briar'
    ldesc = "Brer Rabbit would love to enter the briar scrub, but you
             certainly would not. "
    location = glade
;
