#include "cyoa_lib.t"

/* Here's the introduction to the game. */
modify intro
	desc = "It wasn't supposed to happen this way. You were simply
		going on a routine scanning mission of the local area, making
		sure the locals weren't up to any of their usual tricks. It'd
		be easy, they said. It'll only take a couple of hours, they
		said.\b

		\tWell, maybe this is Outpost Station 351's initiation rite:
		causing your air speeder to break down in the most remote area.
		You'd only been flying for about 20 minutes before the engine
		started to give out. You tried to ease it down slowly, but the
		controls seemed to be locked up. Fortunately, as you smashed
		through the forest roof, the deflector grid remained
		operational. You didn't feel any remorse as you slammed into
		the huge, ancient tree which stopped your forward motion. You
		were upset, though, that the speeder was damaged beyond your
		ability to repair.\b

		\tFortunately, you were able to salvage a few emergency
		rations, a portable scanner, and a survival blanket which you
		drew around you to keep out the cold. Winters on this backwater
		planet were a lot colder than you were used to. But still, you
		need to find shelter soon, for the sun is well past its zenith,
		and night will be coming soon...\b\b\b"
;

/* And here's the version information */
modify version
	desc = "\(The Hunt for the Bluening\)\n
		Being a Very Short Game to Demonstrate the Use of CYOA_LIB\b
		Serial No 980209, Release 1.\n
		Copyright 1998 by Mark J.\ Musante.\n
		All rights reserved.\b
		Developed with TADS, the Text Adventure Development System\n
		Type 'about' for more information on this game and for
		contacting the author.\n
		Type 'credits' for acknowledgments."
;

/* This is how we add flags & values used through the game */
modify global
	cabin_scanned = nil
	owns_scanner = true
	box_scanned = nil
	walk_away = nil
	obligation = nil
	village_scanned = nil
;

/* here are a couple of extra verbs unique to this game */
aboutVerb: object
	verb = 'about'
	action( actor ) = {
		"\tThis game was written to demonstrate the use of the
		CYOA_LIB.T TADS library. The source to it, and to TADS, can be
		found on the Interactive Fiction
		archive:\ 'ftp://ftp.gmd.de/if-archive/'.\n
		\tThis game is Copyright 1998 by Mark J.\ Musante. All rights
		reserved. Permission is hereby granted to distribute this game
		and its source to any on-line site provided it is not altered
		in any way. If you wish to distribute this on CD-ROM or any
		other physical medium, you must get permission in writing from
		the author.\n
		\tIf you have any questions about the source to this
		game or to CYOA_LIB.T, feel free to email the author
		at:\ 'olorin@world.std.com'";
	}
;

creditsVerb: object
	verb = 'credits'
	action( actor ) = {
		"I would like to thank the following people:\b
		\tIan Finley - For inspiring the creation of CYOA_LIB\n
		\tBrian Uri and James Cone - For betatesting above and beyond
		the call of duty \b
		In addition, I would like to thank the following people for
		their input, suggestions and encouragement:\n
		\tKevin \"Whizzard\" Wilson\n
		\tDan \"inky\" Shovitz\n
		\tDavid \"ddyte\" Dyte\n
		\tRussell Mirabelli
		\bAnd thanks to you, gentle adventurer, for playing my game. I
		hope you do enjoy it.\n";
	}
;

/* Every cyoa_lib game starts at 'startplace' and goes from there */
startplace: Place
	statusLine = "Clearing"
	desc = "You shift the scanner from your left hand to your right as
		you struggle your way through the forest. You consider
		yourself very lucky to have been able to free the homing
		beacon from the speeder. Now you just have to stay alive long
		enough for a search and rescue mission to be sent out from your
		Outpost. Unfortunately, you weren't due to report back for at
		least five hours.\n
		\tAs you continue to depress yourself with those thoughts,
		you're suddenly surprised to find a clearing! The ground is
		covered with ankle-high grass and there is a small cabin in the
		middle, on a slight rise. A brief gust of wind sends a chill
		through your body. "
	choices = "\t1. Scan the cabin with your Ev-R-Site portascanner.\n
		\t2. Enter the cabin.\n
		\t3. Go round the back of the cabin.\n
		\t4. Re-enter the forest."
	choice_1 = {
		global.cabin_scanned := true;
		return scan_cabin;
	}
	choice_2 = force_cabin
	choice_3 = behind_cabin
	choice_4 = {
		"You turn around, re-enter the forest and start hiking off.
		As night falls, you still haven't been able to find a place of
		shelter, so you start trying to build your own. You gather some
		branches and twigs together, pile up some leaves, and try to
		conserve your warmth as you burrow in under your construction.
		You close your eyes and drift off to sleep, but you never wake
		up. ";
		die();
		return nil;
	}
;

scan_cabin: Place
	statusLine = "Clearing"
	desc = "Your frozen fingers fumble with the scanner, but you manage
		to get it open. You point it at the cabin and watch the
		display carefully. It tells you that there's a life-form
		inside (but you're too inexperienced to tell which kind), and
		it appears to be resting. There also appears to be another
		entrance round the back of the cabin. "
	choices = "\t1. Go round the back of the cabin.\n
		\t2. Enter the cabin.\n
		\t3. Knock on the cabin's door.\n
		\t4. Re-enter the forest."
	choice_1 = behind_cabin
	choice_2 = tug_cabin
	choice_3 = knock_cabin
	choice_4 = startplace.choice_4
;

behind_cabin: Place
	statusLine = "Behind Cabin"
	desc = {
		"You stiffly stomp round to the rear of the cabin. ";
		if ( global.cabin_scanned )
			"You can see (on this side) the entrance that the
			scanner found,";
		else
			"You notice an entrance to it on this side of it,";
		" and there seems to be a path leading through the forest
		back here. Next to the rear door is a pile of wood, cut
		and split, ready for building a fire.";
	}
	choices = "\t1. Enter the cabin on this side.\n
		\t2. Follow the path through the forest.\n
		\t3. Build a fire using the wood by the cabin."
	choice_1 = enter_rear_cabin
	choice_2 = follow_path
	choice_3 = {
		"You grab some wood off the pile and start to arrange it to
		make a fire. Suddenly, the rear door of the cabin bursts
		open and a three meter tall T'Hrag rushes out.\n
		\t\"What the hell do you think you're doing?\"\ it growls,
		saliva glistening on its fangs. \"That's MY wood!\"\n
		\tWith the swipe of its massive hand, it sends you reeling
		backwards. You barely have time to notice it bearing down
		on you before the world goes black. ";
		die();
	}
;

enter_rear_cabin: Place
	statusLine = "Back Room of Cabin"
	desc = {
		"You step up to the rear door and pull on it. To your surprise,
		it opens easily, and so you step inside.\n
		\tIt's much warmer in here -- you're no longer in danger of
		freezing to death, but you can't help but wonder ";
		if ( global.cabin_scanned ) {
			"what the owner or, at least, occupant of the cabin 
			might do if he finds you here.";
		} else {
			"if there's anyone in the cabin who might not be
			too friendly towards intruders.";
		}
		"\n\tLooking around, you spot a large, low wooden box, about
		four meters long and about a meter high and deep, along
		the north wall, and a doorway into the rest of the cabin
		westward.";
	}
	choices = "\t1. Open the wooden box\n
		\t2. Scan the box with your Ev-R-Site portascanner\n
		\t3. Enter the main part of the cabin to the west.\n"
	choice_1 = {
		if ( global.cabin_scanned )
			return open_the_box;
		"You throw open the box and have just barely enough time to
		see the foodstuffs inside before a giant T'Hrag bursts out
		from the other room.\n";
		self.thief_death;
	}
	choice_2 = scan_the_box
	choice_3 = enter_main_cabin

	thief_death = {
		"\t\"Thief!\"\ it roars, fangs glistening with saliva. It draws
		back a trunk-like arm and, with its massive hand, swipes you
		so hard you fly up into the air and slam against the wall. As
		you slide down toward the floor, so blackness slides down
		before your eyes. ";
		die();
	}
;

follow_path: Place
	statusLine = "At a Crossroads"
	desc = "You trudge down the path through the forest. After some time,
		you arrive at a crossroads. The path which crosses the one
		you're on is wider but, like your own, is unpaved. You can't
		see anything unusual down any of the paths."
	choices = "\t1. Go straight on.\n
		\t2. Turn left, and walk down the wider path.\n
		\t3. Turn right, and walk down the wider path.\n"
	choice_1 = straight_on
	choice_2 = turn_left
	choice_3 = turn_right
;

knock_cabin: Place
	statusLine = "At the Cabin Door"
	desc = "You step up to the cabin door and knock gently on it. You
		hear a rustling sound come from within and, after a moment,
		you hear a gruff voice, muffled by the door, which says \"What
		do you want?\" "
	choices = "\t1. Request shelter\n
		\t2. Demand entry\n
		\t3. Ignore the voice and open the door\n
		\t4. Ignore the voice and walk back into the forest.\n"
	choice_1 = request_shelter
	choice_2 = demand_shelter
	choice_3 = force_cabin2
	choice_4 = startplace.choice_4
;

force_cabin: Place
	statusLine = "Facing the T'Hrag"
	desc = "You walk up to the cabin door and give it a push. It
		appears to be locked, so you push harder. You hear a rustling
		sound from behind the door, and suddenly it bursts open! A
		three meter tall T'Hrag glares down at you, its fangs
		glistening with saliva.\n
		\t\"What the hell do you want?\"\ it asks. \"Why are you trying
		to enter my home?\" "
	choices = "\t1. Tell it you need shelter.\n
		\t2. Turn around and walk back into the forest.\n
		\t3. Attack the T'Hrag with all your might."
	choice_1 = request_shelter
	choice_2 = {
		global.walk_away := true;
		return request_shelter;
	}
	choice_3 = {
		"You bravely attack the T'Hrag, but a simple swipe with
		the back of its hand flattens you. Permanently. ";
		die();
	}
;

request_shelter: Place
	statusLine = "Facing the T'Hrag"
	desc = {
		if ( global.walk_away ) {
			"You turn around and start to walk away, but the T'Hrag
			catches your arm.\n
			\t\"You're going to freeze out there, you know,\"\ it
			says, gruffly. \"Tell you what:\ in exchange for that
			scanner, I'll let you in to warm up.\" ";
		} else {
			"Briefly, you explain what happened to your ship. \"And
			now,\"\ you conclude, \"I'm freezing to death out here.
			Can you let me stay in your cabin until my outpost
			sends a rescue team for me?\"\n
			\tThe T'Hrag looks you over. \"Tell you what,\"\ it
			says, gruffly. \"I'll let you stay here in exchange for
			that scanner.\" ";
		}
	}
	choices = "\t1. Agree\n
		\t2. Turn down the offer\n
		\t3. Attack the T'Hrag with all your might."
	choice_1 = {
		global.ownes_scanner := nil;
		return swap_scanner;
	}
	choice_2 = {
		"\t\"No deal,\"\ you tell the T'Hrag. \"This scanner is
		staying with me.\"\n
		\t\"Fine,\"\ growls the T'Hrag. \"Then get the hell off my
		land.\"\ It gestures back the way you came.\b
		Glumly, you return to the forest. As night falls, you attempt
		to build yourself a shelter of branches and leaves. You
		try to wrap your coat around you more tightly as you burrow
		in. The temperature drops as you close your eyes and drift off
		to sleep. You never wake up. ";
		die();
	}
	choice_3 = {
		"\tAngrily, futilly, you charge the T'Hrag. With an almost
		offhand gesture, it smacks your head so hard, your neck
		snaps.";
		die();
	}

;

tug_cabin: Place
	statusLine = "At the Cabin Door"
	desc = "You walk up to the cabin door and, mindful of the occupant,
		you gently, quitely push on the door. You meet resistance --
		the door must be locked."
	choices = "\t1. Scan the lock to see if there's a way to release it.\n
		\t2. Go back into the forest.\n
		\t3. Go round the back of the cabin.\n
		\t4. Knock on the cabin's door.\n"
	choice_1 = scan_the_lock
	choice_2 = startplace.choice_4
	choice_3 = behind_cabin
	choice_4 = knock_cabin
;

open_the_box: Place
	statusLine = "Opening the Box"
	desc = {
		"You gently open the box, being careful not to disturb the
		occupant of the building. Peering inside, ";
		if ( global.box_scanned )
			"and much to your surprise, ";
		"you see salted meats, an assortment cheese, and some pickled
		vegetables. ";
		if ( global.box_scanned )
			"No dead body after all. ";
	}
	choices = "\t1. Take the food in exchage for your rations.\n
		\t2. Enter the main part of the cabin.\n
		\t3. Return outside and build a fire with the wood you saw.\n
		\t4. Return outside and take the path through the woods.\n"
	choice_1 = {
		"You reach for the food within the box when, suddenly, a
		three meter tall T'Hrag storms forth from the other room.\n";
		enter_rear_cabin.thief_death;
	}
	choice_2 = enter_main_cabin
	choice_3 = {
		"Walking back ouside, \v";
		behind_cabin.choice_3;
	}
	choice_4 = {
		"Walking back outside, \v";
		return follow_path;
	}
;


scan_the_box: Place
	statusLine = "Scanning the Box"
	desc = {
		"You level your Ev-R-Site portable scanner at the box, and
		study the resulting display carefully. It picks up the
		well-known signature of decaying meat and mold, along with
		some decomposing plant matter. Could there be a dead body
		in there?";
		global.box_scanned := true;
	}
	choices = "\t1. Open the box\n
		\t2. Return outside and build a fire with the wood you saw.\n
		\t3. Enter the main part of the cabin.\n
		\t4. Return outside and take the path through the woods.\n"
	choice_1 = open_the_box
	choice_2 = open_the_box.choice_3
	choice_3 = enter_main_cabin
	choice_4 = open_the_box.choice_4
;

enter_main_cabin: Place
	statusLine = "Main Part of Cabin"
	desc = {
		if ( global.cabin_scanned ) {
			"You tiptoe into the main part of the cabin. The light
			is rather dim, here, but you can make out the shape of
			a three meter tall T'Hrag lying on a couch. The front
			door to the cabin is closed and locked, and there is
			a lightswitch on the wall beside it. Near the T'Hrag,
			on a long, low table in front of the couch, is the
			remains of a dinner. ";
		} else {
			"You walk into the main part of the cabin, and just
			have enough time to realize you've woken up a three
			meter tall T'Hrag. It backhands you with such force
			that you go flying, and, as your head strikes the wall,
			blackness strikes your vision. ";
			die();
		}
	}
	choices = "\t1. Return to the back room.\n
		\t2. Attempt to go out the front door.\n
		\t3. Wake the T'Hrag.\n
		\t4. Take the remains of the T'Hrag's dinner.\n"
	choice_1 = {
		"As you turn to walk out of the room, your foot catches on the
		rug, and you jar the table slightly. The T'Hrag wakes, and
		jumps up!\n";
		enter_rear_cabin.thief_death;
	}
	choice_2 = {
		"You fiddle with the lock on the front door, but it doens't
		seem to open. You hear a noise behind you and spin round to
		see the woken, angry T'Hrag bearing down on you!\n";
		enter_rear_cabin.thief_death;
	}
	choice_3 = {
		"You walk up to the T'Hrag and shake it. Its eyes spring
		open, and its angry glare burns into you.\n";
		enter_rear_cabin.thief_death;
	}
	choice_4 = {
		"You step up to the table and start to take the food, but
		the T'Hrag wakes and jumps up!\n";
		enter_rear_cabin.thief_death;
	}

;

straight_on: Place
	statusLine = "Lost"
	desc = "You continue wandering down the forest path and it slowly
		peters out. You bravely press on for a bit, but after a while
		you realize you've become hopelessly lost. Night is falling,
		and if you don't find shelter soon, you could die from
		exposure."
	choices = "\t1. Try to find the path and return to the crossroads.\n
		\t2. Try to build a shelter to wait out the night.\n"
	choice_1 = {
		"You turn around and try to find the path you were on but,
		in the twilight, you stumble around hopelessly. Eventually
		you pass out from the cold. No one ever finds you.";
		die();
	}
	choice_2 = {
		"You gather together some sticks, branches and leaves to form
		a crude structure. You burrow in, trying to conserve your heat
		as best you can. Concerned about the nocternal animals on this
		backwater planet, you nervously fall alseep. It wasn't the
		animals that should have bothered you, though, since the
		falling temperature assured your endless slumber. ";
		die();
	}

;

turn_left: Place
	statusLine = "On the Road"
	desc = "You turn left onto the wider road start walking briskly. The
		road is much easier to walk upon, and you're able to fend off
		the cold, at least for a little while. Fortunately, the road
		is rather flat -- only slightly rising and dipping as it
		cuts its way through the forest. The sky grows darker as night
		starts to fall when suddenly, rounding round a bend in the
		road, you come across a small T'Hragian village.\n
		\tA few of the villagers notice you and approach. You grow
		concerned as they stand in your way - they're not exactly
		diminutive. The average adult T'Hrag is three meters tall and
		is extremely muscular. One of them steps forward.\n
		\t\"What do you want, human?\"\ it asks in a halting
		approximation of English. \"We doing nothing bad,\"\ it adds,
		spreading its arms wide. Very wide.\n"
	choices = "\t1. Demand shelter, as is your right.\n
		\t2. Request shelter, explaining your plight.\n
		\t3. Turn around, walking back into the night.\n
		\t4. Scan the village with your trusty Ev-R-Site.\n"
	choice_1 = {
		"\b\t\"I require shelter,\"\ you say assertively. \"You will
		provide me with a place to stay and food to eat, or I will be
		very angry and have my friends bring great fire down on your
		village.\"\n
		\tThe T'Hrag's eyes narrow as it looks down at you. Turning
		to its neighbors, it growls and grunts in its native tongue
		for a bit.\n
		\t\"Well?\"\ you ask, impatiently.\n
		\t\"We do having shelter,\"\ it says, turning back to face you.
		\"We can be feeding you. Follow.\"\n
		\tThe villagers wander off and the English-speaking T'Hrag
		leads you to a small hut. Inside it is nice and warm, and you
		see another T'Hrag and three T'Hraglings there. The two
		T'Hrag's growl briefly at one another, gather up the
		T'Hraglings, and leave.\n
		\tYou look around the hut. The floor is covered with warm
		animal skins, and a fire is burning in a stove. A bed of
		furs lies in the far corner, and there is an exit which can
		seal itself shut easily. After a few moments, a T'Hrag enters
		the hut. You look at it warily, but it hands you a sack,
		saying, merely, \"Feeding.\"\n
		\tYou look in the sack and see some cooked meat. It smells
		awful, but at least it's better than the rations you've got.
		You look up, but the T'Hrag is gone.\n
		\tThe next morning, a rescue party picks you up from the
		village, and you feel lucky to be alive.";
		global.death_msg := 'survived';
		die();
	}
	choice_2 = decision_time
	choice_3 = {
		"\b\tYou turn away from the group of T'Hrag and their village
		and walk back into the woods. It gets darker and darker as
		the sun sets, and the temperature drops precipitously. You
		step off the path and crawl under a tree, tightening the
		blanket around you. You shut your eyes and shiver yourself
		to sleep. Unfortunately, you never wake up.";
		die();
	}
	choice_4 = scan_village
;

decision_time: Place
	statusLine = "Hard Choices"
	desc = "\"Please,\"\ you say, \"my ship crashed in the woods back
		there, and I have no means for returning home. Can you help
		me?\"\n
		\tThe T'Hrag narrows its eyes at you, and turns around. You
		shiver once or twice as it growls and grunts at its
		comrades and, after what seems like a long time, it finally
		turns back to you.\n
		\t\"We decide:\ help human.\"\ You breathe a sigh of relief, but
		it goes on:\ \"In exchange, you help G'Ragth.\"\n
		\tYou must have put on a puzzled expression at this last bit,
		because the T'Hrag tries to explain:\ \"Me,\"\ it says, thumping
		its chest. \"I am G'Ragth.\""
	choices = "\t1. Try to find out what G'Ragth is going on about.\n
		\t2. Decline the bargain and, instead, demand shelter.\n
		\t3. Ignore G'Ragth and return to the forest.\n"
	choice_1 = agree_to_help
	choice_2 = {
		"\b\t\"What can I possibly help you with?\"\ you ask, growing
		angry. \"I'm out here, lost, with no way to survive the coming
		night, and I'm requesting shelter. You would dare to put
		conditions on this?\"\n
		\tG'Ragth looks at you askance for a moment, then turns back
		to the others. They grunt and growl at one another for a bit,
		as you shiver partly from the growing cold, and partly from
		your current predicament. Finally, G'Ragth turns back to you.\n
		\t\"Very well, we provide shelter for you. Follow.\"\n
		\tAs G'Ragth leads the way, you mutter to yourself, \"damn
		straight.\"\n
		\tThe two of you arrive at a small hut, and G'Ragth holds the
		door open for you. You step inside and are momentarily startled
		to see another T'Hrag inside with a few T'Hraglings around it.
		G'Ragth grunts a few times at the T'Hrags stand up and walk
		outside. G'Ragth spares you one last glance before closing the
		door, and you're left on your own.\n
		\tYou look around the hut. It is quite spartan, with a small
		fire in one corner, and animal skins lining the floor. A pile
		of furs lies opposite the fire, a serviceable bed. You lie
		down, and break out your rations as you wrap the blanket
		around you more tightly. Sleep comes uneasily since your a bit
		nervous about the villagers, but eventually you succumb to your
		weariness.\n
		\tThe next day, a search party locates you and brings you back
		to your Outpost Station. It's not an adventure you'll soon
		forget.\n";
		global.death_msg := 'survived';
		die();
	}
	choice_3 = turn_left.choice_3
;

turn_right: Place
	statusLine = "Walking on the Road"
	desc = "You turn right and trudge down the road a ways. As the sun
		begins to set, the temperature gets colder and colder. Pretty
		soon, even walking down the road isn't enough to warm you up.\n
		\tAfter some time, you can hear the distinctive sound of a land
		speeder approaching off in the distance ahead of you. You step
		to the side of the road to watch it go by and, to your
		surprise, the T'Hrag driver slows down and stops once it sees
		you.\n
		\t\"Lost?\"\ it asks.\n
		\tYou are lost, but resent the fact that you have to admit it.
		So you decide to say nothing.\n
		\t\"I head up to village,\" it says, nodding in the direction
		it's travelling. \"They have shelter. You need shelter from
		cold. I take you there.\"\n "
	choices = "\t1. Accept the offer\n
		\t2. Decline, and continue walking on\n"
	choice_1 = get_on_speeder
	choice_2 = {
		"\tYou shake your head and move on down the road. The T'Hrag
		watches you go and, after a short pause, it speeds off. You
		hear the sound fade into the distance.\n
		\tAfter the sun sets, you use some branches and leaves in the
		forest to build a small shelter on the side of the road. You
		burrow in and try to warm up. Sleep comes easily.";
		die();
	}
;

get_on_speeder: Place
	statusLine = "Decision Time"
	desc = "You nod, too cold to bother speaking.\n
		\t\"Sit here,\"\ it says, indicating the rear seat of its
		speeder.
		\tYou get on, and the speeder's thermoshield envelops you,
		warming you up. The T'Hrag sets off for the village. After a
		couple of hours, you arrive, and you step off the speeder to
		look around. It's actually more of a collection of huts than a
		village, you think to yourself.\n
		\tThe villagers crowd around you, curious because they haven't
		seen a human before. This is a bit disturbing (the crowding,
		not the ignorance), because T'Hrags are about three meters tall
		and very muscular. The one who gave you a ride grunts and
		growls with the villagers for a bit and then turns to you.
		\t\"This G'Ragth,\" it says, indicating another T'Hrag. \"Says
		you stay here,\"\ it goes on. \"Says you stay until tomorrow.
		In trade, you give favour. Is okay?\"\n
		\tG'Ragth bows slightly, never taking its eyes off of you."
	choices = "\t1. Reject the bargain, demanding to spend the night.\n
		\t2. Ask what the favour is.\n
		\t3. Turn around and walk back down the path.\n
		\t4. Push the T'Hrag off its speeder and drive away."
	choice_1 = decision_time.choice_2
	choice_2 = agree_to_help
	choice_3 = {
		"\tYou shake your head, turn around, and start walking down the
		road. The sun has set now, and the cold is starting to become
		more than you can bear. You step off the road and build a
		shelter with a few branches and leaves, and you burrow in.
		Sleep comes easily. Waking does not.";
		die();
	}
	choice_4 = {
		"You savegely attack the T'Hrag. Rather, you attempt to
		savegely attack the T'Hrag but it, more out of instinct than
		foresight, slaps you with the back of its hand. The blow sends
		you flying and your head strikes a tree in the same way that
		a skydiver, whose parachute had been accidentally left behind on
		the plane, hits the ground.";
		die();
	}
;

force_cabin2: Place
	statusLine = "Facing the T'Hrag"
	desc = "You grab the door's handle and try to open it. You rattle the
		door a bit, and suddenly it is pulled open wide by a three
		meter tall T'Hrag! It looks down and growls at you. \"What the
		hell do you want?\""
	choices = "\t1. Tell it you need shelter\n
		\t2. Turn around and walk back into the forest\n
		\t3. Attack the T'Hrag with all your might"
	choice_1 = force_cabin.choice_1
	choice_2 = force_cabin.choice_2
	choice_3 = force_cabin.choice_3
;

swap_scanner: Place
	statusLine = "Making a Bargain"
	desc = "You look down at your scanner. It's really quite a useful
		little device, and there'd be hell to pay back at the Outpost
		if it went missing. But you really do need the shelter.\n
		\t\"Okay,\"\ you say. \"It's a deal.\"\n
		\tThe T'Hrag steps aside, and you walk in. The interior of the
		cabin is well lit and looks comfortably lived in. Comfortable
		for a T'Hrag, that is. Up against one wall is a couch made of
		animal fur, a handmade table is in front of it, upon which
		is, apparently, the remains of dinner. In the far corner is a
		wood-burning stove (providing heat), and a doorway leads out to
		a rear room in the cabin.\n
		\tBehind you, the T'Hrag closes the door and then comes around
		to gather up the mess on the table. \"Sit,\"\ it says,
		indicating the couch. Gingerly, you sit down, not knowing what
		to expect. Surprisingly, it's quite comfortable. Comfortable,
		that is, until the T'Hrag lowers its massive bulk into the
		couch next to you.\n
		\tIt holds out its hand and you reluctantly place the scanner
		in it. The T'Hrag eyes the scanner warily and manages to turn
		it on. It starts to point it at various things around the room
		and a grin (at least, you hope that's a grin) spreads across
		its face.\n
		\t\"I like this,\"\ it says. Finally it points the scanner
		at you and reads the display. \"Hmm. You seem to be cold and
		hungry. I'll get some food.\"\ It starts to get up, but you
		protest, unsure of what T'Hrag food would do to you. \"No, no,
		that's okay - I've got rations on me.\"
		\t\"Very well,\"\ it says, settling back into the couch.\n
		\tYou sit in silence for a bit. Suddenly, the entire couch
		shifts as the T'Hrag reaches under the table and pulls out a
		small metallic object. You watch as it dangles the object in
		front of its eyes.\n
		\t\"Many years ago,\"\ the T'Hrag starts, \"before Humans came
		to our world, one of the greatest reserch projects was the
		determination of the location of the Fnorgar Ratkin. That means
		'blue stone' in your language.\" "
	choices = "\t1. Feign interest\n
		\t2. Express interest\n
		\t3. Express disinterest"
	choice_1 = {
		"\"Uh-huh,\"\ you say, looking around the cabin. You notice some
		wall coverings that might bring a fair price on the T'Hrag
		curio market.\n
		\t\"Well, I can see you're not interested,\"\ the T'Hrag says.
		\"Perhaps you are in need of some rest. Sleep now - I shall
		leave you alone.\"\ The T'Hrag gets up, shuts the blinds on
		the window, and walks softly into the other room.\b
		\tThe next morning, your Outpost's rescue team locates your
		distress beacon and picks you up. You get some grief from them
		about having 'lost' your scanner and the quartermaster docks
		your pay, but otherwise you've come through in one piece.";
		global.death_msg := 'survived';
		die();
	}
	choice_2 = listen_to_story
	choice_3 = {
		"\t\"Look,\"\ you say. \"I'm not interested in your Frogger
		Ruxpin. I just need a place to keep warm until my Output finds
		my distress beacon.\"\ You point to your belt where you've
		clipped the beacon on.\n
		\tThe T'Hrag spares it a glance and then, letting out a large
		breath, gets up from the couch. \"Okay,\"\ it says. \"I'll let
		you get your rest. It's dark out now, and your comrades
		probably won't be here until morning.\"\ It closes the window
		blinds, turns down the lights, and leaves the room.\n
		\tYou stretch out on the couch and close your eyes. Sleep
		doesn't come easily, but eventually you drift off. The next
		morning, as the T'Hrag predicted, your buddies show up. Your
		pay gets docked by the quatermaster when you get back without
		the scanner, but otherwise you've managed to come through in
		once piece.";
		global.death_msg := 'survived';
		die();
	}
;

scan_the_lock: Place
	statusLine = "Breaking and Entering"
	desc = "You level the scanner at the door and adjust a few sensors.
		The lock doesn't appear to be an overly complex one and, you
		believe, playing with the scanner's output frequency you should
		be able to trip the lock and open the door."
	choices = "\t1. Use the scanner to open the door.\n
		\t2. Knock on the door anyway.\n
		\t3. Go round the back side of the cabin.\n
		\t4. Go back into the forest."
	choice_1 = {
		"\tYou adjust the scanner a bit and hear the satisfying thump
		of the lock releasing itself. You push open the door easily and
		step inside. Your eyes don't even have time to adjust to the
		darkness before you notice a huge lumbering mass barreling
		towards you. It strikes you, slamming you up against the wall.
		The last sound you hear is a <crack!> as your skull snaps
		backward.";
		die();
	}
	choice_2 = knock_cabin
	choice_3 = behind_cabin
	choice_4 = startplace.choice_4
;

apologise: Place
	statusLine = "In or Out"
	desc = "You look up at the T'Hrag, its eyes boring into you, its face
		a mask of terror.\n
		\t\"Um,\"\ you say, not sure of yourself. \"I'm really quite
		cold out here, and...\"\n
		\tThe T'Hrag cuts you off. \"So you want to come in and warm
		up?\"\n
		\tYou nod vigorously.\n
		\t\"Okay,\"\ it says. \"Tell you what:\ I'll let you in in
		exchange for that scanner. Deal?\""
	choices = "\t1. Swap the scanner for warmth\n
		\t2. Turn around and walk away\n
		\t3. Attack the T'Hrag and take over the cabin\n"
	choice_1 = {
		global.owns_scanner := nil;
		return swap_scanner;
	}
	choice_2 = demand_shelter.choice_3
	choice_3 = {
		"You rush the T'Hrag but, more out of instinct than malice, it
		swipes you with the back of its hand, sending you flying.\n
		\t\"And don't come back,\"\ it yells at you, shutting the door
		to the cabin.\n
		\tYou get up and brush off the snow. Wrapping your blanket
		around you more tightly, you trudge back into the forest. As
		the temperature drops and the cold starts to sting, you build a
		makeshift shelter of branches and leaves into which you burrow.
		In the morning, you think as you drift off to sleep, the rescue
		team from the Outpost will find me. It's the last conscious
		thought you have.";
		die();
	}
;

demand_shelter: Place
	statusLine = "Facing Down the T'Hrag"
	desc = "You pound on the door with your fist. \"You must let
		me in at once!\"\ you say. \"I have the right, as a duely
		appointed representative of the law to be given shelter
		as the need arises. Open this door!\"\n
		\tThe door slowly opens and, as your eyes adjust to the
		dimness of the interior, you make out the shape of a three
		meter tall T'Hrag standing at the door. It's voice, colder
		than you are, seems to emanate from all around:\ \"What did
		you say?\"\n
		\tYou tremble, slightly."
	choices = "\t1. Apologise. Profusely.\n
		\t2. Continue to demand entry.\n
		\t3. Turn around and walk back into the forest.\n"
	choice_1 = apologise
	choice_2 = {
		"\"I said let me in,\"\ you repeat. \"Let me in or I shall
		have your property confiscated, and your family thrown in
		prison!\"\ The T'Hrag's mouth opens
		in an evil grin, and you can see saliva glistening on its
		fangs.\b
		\t\"That's what I thought you said\"\ it growls deeply. With
		a casual smack of its hand, it sends you flying across the
		clearing. Just before your body hits the ground, your head
		hits a tree, and your life hits its end.";
		die();
	}
	choice_3 = {
		"You turn around, and the door is slammed shut behind you.
		Night slowly falls and the temperature drops considerably
		as you hike back through the forest. Soon you decide to build
		a shelter, and so you gather together some branches and
		leaves. You burrow in, trying to conserve your body heat, and
		fitfully fall asleep. Unfortunately, the blanket and leaves
		don't offer enough protection against the cold, and you never
		do wake up.";
		die();
	}
;

scan_village: Place
	statusLine = "In Search Of:\ An Anomaly"
	desc = {
		"You pull out your scanner, momentarily startling the villagers.
		They pull back from you a bit as you start to play with the
		scanner's controls and it makes beeping and whistling sounds.
		They watch you carefully and, when it's apparent the scanner
		means them no harm, they crowd around you again, looking at
		it.\n
		\tThe display on the scanner indicates that there are several
		huts scattered around in a wide area, the greatest
		concentration being further along the road you're on. To your
		surprise, you notice an energy signature indicating human
		technology is up ahead, in one of the huts.\n";
		global.village_scanned := true;
	}
	choices = "\t1. Demand shelter from the cold.\n
		\t2. Request shelter of the villagers.\n
		\t3. Turn around and head back to the crossroads.\n
		\t4. Investigate the energy anomaly."
	choice_1 = turn_left.choice_1
	choice_2 = turn_left.choice_2
	choice_3 = turn_left.choice_3
	choice_4 = investigate_energy
;

agree_to_help: Place
	statusLine = "Sacred Search"
	desc = "\"In what way do you think I can help you?\"\ you ask, somewhat
		petulantly. \"I'm not exactly equipped to help anyone right
		now.\"\n
		\tG'Ragth waves his arms. \"Not important what you have,\"\ it
		says. \"Is important what you do. We need locating of special
		item. Very special. Very important. But hidden.\"\n
		\t\"If there's something you need,\"\ you respond, \"simply
		petition us for a requisition...\"\n
		\tG'Ragth stops you. \"No, is not something humans have. Is
		something planet have. Planet have hidden, but humans stop us.
		Humans block us.\"\n
		\tYou're not entirely sure what G'Ragth means, but your
		curiosity gets the better of you. \"The planet is hiding
		something?\"\ you
		ask.\n
		\tG'Ragth nods vigorously. The other T'Hrag start grunting and
		growling at him, but he waves them off. \"Human find sacred
		item? Human help us?\""
	choices = "\t1. Ignore the request and demand shelter instead.\n
		\t2. Ask to hear more about this 'sacred item'.\n
		\t3. Forget the whole thing and return to the forest."
	choice_1 = decision_time.choice_2
	choice_2 = intrigued
	choice_3 = turn_left.choice_3

;

listen_to_story: Place
	statusLine = "Listening to the Story"
	desc = "\"Do go on,\"\ you say.\n
		\tThe T'Hrag seems pleased by your interest. \"We had come
		very close to locating it. Our Gna Jees, our searchers, had
		found the ancient ruin which contained the stone. This, \"the
		T'Hrag holds up the metallic object again, \"this is the key to
		the entrance. Unfortunately, the search was cut short when you
		humans decided to...\"\ it pauses, trying to find the right
		word. \"Visit,\"\ it says, finally, \"our planet.\"\n
		\t\"What's stopping you from the search?\"\ you ask.\n
		\t\"The ruins I spoke of,\"\ it says, ruefully, \"are in one of
		the Restricted Areas. T'Hrag are not allowed there.\""
	choices = "\t1. Offer to help, if you can.\n
		\t2. Express condolances"
	choice_1 = offer_help
	choice_2 = {
		"\"I'm sorry to hear that,\"\ you answer, \"but there's nothing
		I can do.\"\n
		\tThe T'Hrag nods, glumly. \"I thought not,\"\ it says. \"Ah,
		well. You rest here, I'll go into the other room. Your friends
		will probably be by in the morning.\"\n
		\tIt gets up and walks off, turning down the lights. You lie
		down on the couch, and fall comfortably sleep.\n
		\tThe next morning, as the T'Hrag predicted, a search and
		rescue team from the Outpost locates your signal and brings you
		home. ";
		global.death_msg := 'survived';
		die();
	}
;

offer_help: Place
	statusLine = "Offering help"
	desc = "\"I could probably help with that,\"\ you say. \"My clearance
		gives me access to the R.A.'s.\"\n
		\tThe T'Hrag's eyes light up. \"Excellent! We can use my
		'porter to get over there. I know the coordinates by heart.\"\n
		\t\"I can't promise anything,\"\ you hastily add. \"But I'll
		try.\"\n
		\t\"I understand,\"\ the T'Hrag says, excitedly. \"Come, follow
		me.\"\n
		\tThe T'Hrag gets up and leads you outside. You hike a bit of
		the way into the forest northwards when the T'Hrag suddenly
		stops. It growls something in its language and the air shivers
		slightly. You hear the familiar soft thumping sound of a
		chameleofield dropping, and a 'porter booth stands in front of
		you.\n
		\t\"In the middle of the forest?\"\ you ask.\n
		\t\"Most people just scan the cabin when they're searching for
		something,\"\ it says. \"No one bothers to scan the forest.\"\n
		\tThe T'Hrag punches a few buttons on the side of the 'porter,
		and the doors open up. \"Hop in,\"\ it says.\n
		\tYou walk into the 'porter, the T'Hrag right on your heels,
		and step out onto a large circular platform of stones which
		look like they were shaped by hand. It must be about thirty
		meters in diameter, and has been built into the side of a
		moutain. You look around, and spot an Outpost guard blocking
		the entrance to an underground tunnel.\n
		\t\"Over there,\"\ says the T'Hrag, indicating the tunnel. The
		two of you walk up to the guard.\n
		\t\"This is a restricted area,\"\ says the guard, holding up
		his hand. \"No T'Hrags allowed.\" "
	choices = "\t1. Admit defeat\n
		\t2. Bluff your way in\n
		\t3. Knock out the guard."
	choice_1 = {
		"\tYou turn to the T'Hrag. \"Well, that's it. Not much more we
		can do here. This guard won't let us in\"\n
		\tThe T'Hrag gives you an extremely disappointed look. \"Very
		well. I shall return to my cabin.\" It walks back to the
		'porter, enters some codes, steps inside and vanishes.\n
		\t\"Sorry to bother you,\" you say to the guard. He gives you
		a quizzical look, which you decide to ignore. Going up to
		the 'porter, you enter the codes for your Outpost, step inside,
		and return home.";
		global.death_msg := 'survived';
		die();
	}
	choice_2 = {
		"\t\"We're here on security business,\" you say, flashing your
		badge at the guard. \"This T'Hrag is with me.\"\n
		\tThe guard squints his eyes at you, but steps aside. You
		quickly walk into the tunnel, the T'Hrag following closely
		behind.\n
		\t\"Good one,\"\ it says.";
		return inside_tunnel;
	}
	choice_3 = {
		"\tYou raise your fist and take a swing at the guard. He sees
		it coming and blocks it easily. You struggle for a bit, but the
		guard takes you down. You and the T'Hrag are arrested on the
		spot. ";
		global.death_msg := 'been court martialed';
		die();
	}
;

investigate_energy: Place
	statusLine = "Investigations"
	desc = "With your eyes squarely on the scanner's display, you start
		moving forward towards the energy signature, but run into one
		of the T'Hrag.\n
		\t\"Out of my way,\"\ you say, waving your hand. The T'Hrag's
		face melts into a huge grin, and it starts grunting at you.\n
		\tThe English-speaking T'Hrag comes up behind you. \"Where you
		going?\" it asks."
	choices = "\t1. Ignore it and continue looking for the anomaly.\n
		\t2. Explain what you've found.\n
		\t3. Demand shelter.\n
		\t4. Request shelter.\n"
	choice_1 = continue_search
	choice_2 = explain_search
	choice_3 = turn_left.choice_1
	choice_4 = turn_left.choice_2
;

intrigued: Place
	statusLine = "A Helping Hand"
	desc = "\"What is this sacred item?\"\ you ask, your interest piqued.\n
		\tThe T'Hrag smiles. \"Is very sacred to us. Gna Gees find
		cave. They know Fnorgar Ratkin in cave. Humans come. Humans
		block cave.\"\n
		\t\"We're blocking entrace to a cave?\"\ you ask, puzzled.
		You're not aware of any cave that your Outpost would be
		interested in.\n
		\t\"Yes,\"\ replies the T'Hrag. \"Humans blocking cave. You go
		get Fnorgar Ratkin for us?\"\n
		\t\"What's a Forgar Ratkin?\"\ you ask.\n
		\t\"Means...\"\ G'Ragth thinks about it for a moment. \"Means
		'stone of blue',\" he says, finally.\n
		\t\"So you want me to go into a cave which is most likely
		guarded by security, and get a blue stone for you.\"\n
		\tG'Ragth grins. \"Yes. Right. Do that.\"\n
		\t\"But,\"\ you protest, \"there are plenty of stones around
		here. What's wrong with them?\"\n
		\t\"Fnorgar Ratkin is special. Sacred. We need. You find? You
		help?\"\n"
	choices = "\t1. Agree to find the Fnorgar Ratkin.\n
		\t2. Tell G'Ragth to forget it, and demand shelter instead.\n"
	choice_1 = say_yes
	choice_2 = decision_time.choice_2
;

continue_search: Place
	statusLine = "Curiouser and Curiouser"
	desc = "You step around the T'Hrag blocking your way, and follow the
		energy signature. You make your way down the central road of
		the village and come to a stop in front of a hut. The scanner
		shows the source of the energy to be within. You glance around
		the exterior of the hut, but you can't see any power generator
		anywhere. You reach for the door of the hut, but a large T'Hrag
		hand is placed on yours.\n
		\t\"Where human going?\"\n
		\t\"I'm going into the hut,\"\ you say, a bit petulantly.
		\"Stand aside.\"\n
		\tThe T'Hrag doesn't move. \"This is special hut of Gna Gees.
		Is special to us.\"\n
		\tYou're skeptical. \"Oh?\"\ you ask. \"Well, I'd like to speak
		with Gna Gees, then.\"\n
		\t\"Gna Gee not one person. Is many persons. Is group of
		seekers, but gone now. They use hut when visiting village.\""
	choices = "\t1. Ask about the Gna Gees.\n
		\t2. Ignore the Gna Gee story and demand entry to the hut.\n
		\t3. Forget about the hut, and demand shelter instead."
	choice_1 = asking_about_gg
	choice_2 = explain_search.choice_1
	choice_3 = {
		"\t\"This is pointless!\"\ you exclaim. \"The only reason I'm
		here is because my speeder broke down. I'm lucky to have made
		it this far. Now I demand you give me shelter for the night, or
		for as long as it takes for my friends to find me.\"\n
		\tThe T'Hrag looks at you, and then turns to the crowd of
		onlookers who had gathered round. They grunt and growl for a
		bit, and then finally the T'Hrag says, \"We have shelter.
		Follow.\"\n
		\tIt leads you to a small hut on the edge of town, and opens
		the door. You step inside and you're surrounded by pelts of all
		shapes and sizes.\n
		\t\"Is skin hut,\"\ explains the T'Hrag. \"You will be warm
		here.\"\n
		\tIt closes the door, leaving you on your own. You fall asleep
		rather quickly -- you didn't realize how tired you were. The
		next morning, a search and rescue team finds your beacon, and
		takes you back to the Outpost.";
		global.death_msg := 'survived';
		die();
	}
;

explain_search: Place
	statusLine = "Whose Hut?"
	desc = "You show the display of the scanner to the T'Hrag. \"I'm
		looking for the source of this energy anomaly,\"\ you say. \"It
		oughtn't to be in your village.\"\n
		\tThe T'Hrag looks up at its fellow villagers, and they grunt
		for a bit.\n
		\tFinally, turning to you, it says, \"I show you hut.
		Follow.\"\n
		\tIt takes you down the road and, to your consternation, the
		crowd of T'Hrag follow as well. Stopping in front of a hut, it
		says, \"This is hut of Gna Gees. They special people. Sacred
		people. They were seekers. Their hut stays closed.\"\n
		\tYou look at the hut, but it doesn't seem any different from
		any of the others, except it's perhaps a bit smaller."
	choices = "\t1. Demand entry to the hut.\n
		\t2. Ask about the Gna Gees.\n
		\t3. Forget about the whole thing and insist on shelter for the
		night."
	choice_1 = {
		"\t\"You will let me enter the hut,\"\ you say in your most
		assertive voice. \"You will step aside now.\"\n
		\tThe T'Hrag looks at its companions, and they grunt and growl
		back and forth to one another. After a moment, the T'Hrag steps
		aside and bows.\n
		\t\"Very well,\"\ it says.\n
		\tYou enter the hut. You look around and see nothing. Four
		walls, a floor and a ceiling. You glance back down at your
		scanner -- yes, there's an energy signature right there. You
		look into the corner of the hut where the signal's coming from
		but you see nothing. Cautiously, you step closer, arm
		outstretched, feeling. Suddenly, your hand hits something! Of
		course:\ a chameleofield! You look back down at your scanner,
		and make a few adjustments. Yes, there it is. If you hadn't
		been so tired, you would have been able to pick up on it
		straight away.\n
		\tYou fiddle with the scanner's controls a bit and disable the
		chameleofield and are astonished when a 'porter booth shimmers
		into view. Well, what a stroke of good luck.\n
		\tYou set tne 'porter's controls for your Outpost and step
		inside. What a story you have to tell your mates back home! You
		wonder if they'll ever believe it.";
		global.death_msg := 'made it home safely';
		die();
	}

	choice_2 = asking_about_gg
	choice_3 = continue_search.choice_3
;

say_yes: Place
	statusLine = "The Edge of the Abyss"
	desc = "\"Very well,\"\ you say, intrigued by the whole thing. \"How
		can I help you find the Fnorgar Ratkin?\"\n
		\tThe T'Hrag grins. \"Come,\"\ it says. \"Follow.\"\n
		\tYou follow it a bit further down the road. The villagers fall
		in behind you like a curious entourage and, after a little
		while, you stop in front of a hut.\n
		\t\"Here,\"\ says G'Ragth. \"This hut of Gna Gees.\"\ It
		pauses, collecting its thoughts.\n
		\t\"Who is Gna Gees?\"\ you ask.\n
		\t\"Gna Gee not person. Is many persons. Is group of seekers.
		Special to us. Sacred. Greatest search is search for Fnorgar
		Ratkin. Here,\"\ it indicates the hut, \"here is where they
		search from. You go in here and find it. You come back here
		when found.\"\n
		\t\"In the hut?\"\ you ask, starting to doubt the whole
		thing.\n
		\t\"Not in hut,\" replies the T'Hrag. \"Is THROUGH hut.\"\n
		\t\"Through the hut,\"\ you repeat, not comprehending.\n
		\tG'Ragth opens the door. \"Yes. I show you.\""
	choices = "\t1. Enter the hut.\n
		\t2. Forget the whole thing and insist on shelter for the
		night."
	choice_1 = {
		global.obligation := true;
		return enter_hut;
	}
	choice_2 = continue_search.choice_3
;

asking_about_gg: Place
	statusLine = "Choices"
	desc = "\"Can you tell me more about the Gna Gees?\"\ you ask.\n
		\tThe T'Hrag looks pleased. \"Gna Gees,\"\ it says, \"are
		searchers, hunters. Greatest hunt of Gna Gees is to find the
		Fnorgar Ratkin. Is sacred stone. Means...\"\ It thinks about it
		for a bit and then, \"Means 'blue stone'.\"\n
		\t\"Forgar Ratkin?\"\ you ask.\n
		\t\"Yes,\"\ it replies. \"Very special stone to us. Very
		sacred. We need back. You help find?\"\n
		\tThe T'Hrag opens the door of the hut, gesturing for you to
		enter."
	choices = "\t1. No way. You're not getting involved.\n
		\t2. Agree to help."
	choice_1 = continue_search.choice_3
	choice_2 = {
		global.obligation := true;
		"\tAs you step in through the door, the T'Hrag says, \"My name
		G'Ragth.\"\n
		\tYou nod and tell G'Ragth your name. It's the first time
		you've been on first-name terms with any of the first
		intelligent species on this planet. ";
		return enter_hut;
	}
;

enter_hut: Place
	statusLine = "At the Edge of the Abyss"
	desc = {
		"You step through the open door and find yourself inside the
		hut. It's got four bare walls, a floor and a ceiling. That's
		it.\n
		\tJust as you start to think the whole thing is a joke, G'Ragth
		walks over to one of the corners and growls something. A
		shimmering light slowly reveals a 'porter booth! ";
		if ( global.village_scanned ) {
			"Of course - that's what the energy signature was. ";
		}
		"You just have enough time to start to wonder where the T'Hrag
		got a 'porter from, when G'Ragth enters some coordinates, turns
		to you, and says, \"Enter.\"\n";
	}
	choices = "\t1. Reprogram the 'porter to send you back to your
	Outpost.\n
		\t2. Trust G'Ragth to have set the coordinates correctly.\n
		\t3. Check to see where the coordinates have been set."
	choice_1 = {
		"\t\"Let me check those coordinates,\"\ you slyly tell
		G'Ragth.\n
		\tIt obligingly steps aside and you pretend to peer at the
		display panel. You cast a furtive glance back at the T'Hrag and
		then quickly, before it has a chance to do anything about it,
		you type in the coordinates to send you back to your Outpost,
		and step through.\n
		\tYou wonder if any of your fellow Outposters will believe the
		story you have to tell.";
		global.death_msg := 'made it home alive';
		die();
	}
	choice_2 = outside_tunnel
	choice_3 = double_check


;

outside_tunnel: Place
	statusLine = "Platform"
	desc = "Quickly stepping through the 'porter, you find yourself on a
		wide, round plateau cut into the side of a mountain. The air is
		not quite as chilly here, and the sun is higher up in the sky.
		Behind you is the 'porter you stepped out of.\n
		\tWhere the plateau meets the mountainside, you notice a dark
		tunnel. Sitting beside the tunnel is a guard. Human, yes, but
		not a member of your Outpost. You don't recognize him at all."
	choices = "\t1. Enter the tunnel, ignoring the guard.\n
		\t2. Reprogram the 'porter at this end to send you back to your
			Outpost.\n
		\t3. Ask the guard for permission to enter the tunnel."
	choice_1 = entry_attempt
	choice_2 = {
		"You turn around and reprogram the plateau's 'porter for the
		Outpost and step through. You wonder if your mates at the
		Outpost will belive the story you've got to tell.";
		global.death_msg := 'survived';
		die();
	}
	choice_3 = {
		"\tYou walk up to the guard.\n
		\t\"Scuse me,\"\ you say. He just looks at you.\n
		\t\"I'd like to enter the tunnel, if I may.\"\n
		\t\"You got security papers?\"\ he asks, doubt dripping from
		his demeanor.\n
		\t\"Um, no,\"\ you respond.\n
		\tHe scoffs. \"Get out of here before I call the MPs.\"\n
		\tGlumly, you return to the 'porter and set it for your
		Outpost. Well, you think to yourself, that could have gone
		better.\n";
		global.death_msg := 'made it home';
		die();
	}
;

double_check: Place
	statusLine = "Paranoia"
	desc = "\"Let me check those coordinates,\"\ you tell the T'Hrag.\n
		\tIt obligingly steps aside, and you look at the 'porter's
		display carefully. The coordinates seem to be set about a
		quarter of the way around the planet from here. You don't
		remember the geography that well, but you seem to remember a
		mountain range there.\n
		\t\"Look,\"\ says G'Ragth. \"Is okay. I go through.\"\n
		\tIt steps through the 'porter and disappers. After a few
		moments it returns. \"See?\"\ it says. \"Is safe.\""
	choices = "\t1. Step through the 'porter.\n
		\t2. Reprogram it for your Outpost.\n"
	choice_1 = outside_tunnel
	choice_2 = {
		"\tQuickly, before G'Ragth can do anything, you punch in the
		coordinates to your Outpost and step through. You experience
		the familiar momentary disorientation as you travel across
		space far more quickly than matter ever should, and step out at
		the other end in your Outpost.\n
		\tYou wonder if your compadres will ever believe the story you
		have to tell.\n";
		global.death_msg := 'made it home';
		die();
	}
;

entry_attempt: Place
	statusLine = "Stopped at the Gate"
	desc = "You step up to the tunnel, trying to act as if you belong
		there, but the guard stops you.\n
		\t\"Oy!\"\ he says. \"Where do you think you're going?\""
	choices = "\t1. Bluff your way in.\n
		\t2. Go back and use the 'porter to return to your base."
	choice_1 = {
		"\tYou quickly flash your badge. \"I'm here on security
		business,\"\ you say. The guard looks at you oddly, but lets
		you pass.";
		return taking_a_chance;
	}
	choice_2 = {
		"\tYou go back to the 'porter and program it for your Outpost.
		As you step through you wonder if any of your friends will
		believe the story you've got to tell.";
		global.death_msg := 'made it home';
		die();
	}
;

/****************************************************************\
**                                                              **
** This marks the halfway point in the game: we've transitioned **
** from wandering around outside, to actually searching for the **
** "Fnorgar Ratkin".                                            **
**                                                              **
\****************************************************************/

inside_tunnel: Place
	statusLine = "At the Door"
	desc = "You make your way down the tunnel.  It slopes down rather
		steeply and, every so often, you dislodge a small stone which
		goes off skittering ahead of you. As you make your way down,
		small side-tunnels branch off to the left and right, but the
		T'Hrag keeps steering you along the main corridor.\n
		\t\"You seem to know where you're going,\"\ you say.\n
		\t\"I've been part of the way through this before,\"\ it
		answers. \"Soon, though, we'll come to unfamiliar
		territory.\"\n
		\tYou continue, going a bit more slowly, and you notice the
		T'Hrag muttering something each time you pass a side-tunnel.
		You realize, after a bit, that it's counting.\n
		\t\"Are we there yet?\"\ you can't resist asking.\n
		\t\"Three more.\"\n
		\tAt the third side-tunnel, the T'Hrag turns. \"This is where
		we found the door.\"\n
		\tDoor?\ you wonder. You follow it down the side-tunnel. As you
		make your way down, other tunnels split off, still others join
		up. Your guide deftly turns and twists through the maze,
		following a path, a path it obviously knows  very well.\n
		\tYour curiosity gets the better of you. \"How do you know
		where you're going?\"\ you ask.\n
		\tIt points to faint scratches on the walls, and carries on.
		You take a look -- you never would have been able to see those
		scratches on your own.\n
		\tAfter more twists and turns through the tunnel maze, you
		reach a dead end.\n
		\t\"You must have missed a turn,\"\ you say.\n
		\t\"No,\"\ it replies. \"This is the door.\"\n
		\tYou look, but can't make out anything. \"Are you
		sure?\"\ you ask.\n
		\tThe T'Hrag reaches out for the rock face of the tunnel, and
		his hand appears to slide right into it! \"This is why it took
		us so long to find. We had to search every wall very carefully.
		There was much rejoicing when this was found, but the delight
		was short-lived. We found no way to open the door.\"\n
		\t\"Just blast it,\"\ you respond.\n
		\tThe T'Hrag shakes its head. \"If we did that, we could end up
		destroying that for which we search.\"\n
		\tIt closes its eyes and seems to concentrate for a bit. After
		a minute or so, the wall shimmers and disappears.\n
		\t\"A chameleofield,\"\ you say.\n
		\t\"This is not of human technology,\"\ it says. \"This was
		placed here long before you arrived. Long before you left your
		own planet.\"\n
		\tYou look at the revealed door; it seems perfectly
		smooth -- there are no markings, no latches, nothing to
		indicate how it might open.\n"
	choices = "\t1. Scan the door to see what you can find.\n
		\t2. Ask the T'Hrag if there are any legends about this
		place.\n
		\t3. Give up and return to the surface.\n
		\t4. Try to examine the door more closely."
	choice_1 = scan_the_door
	choice_2 = ask_of_legends
	choice_3 = ask_of_legends.choice_2
	choice_4 = examine_door
;

taking_a_chance: Place
	statusLine = "Exploring the Tunnels"
	desc = "You step into the tunnel and start to make your way down.
		A florescent substance on the walls provides enough light for
		you to see by. After about a hundred meters in, you spot a
		tunnel going off to the side."
	choices = "\t1. End this now, while you still can.\n
		\t2. Use your scanner to see if there's anything down here.\n
		\t3. Keep going along the main tunnel.\n
		\t4. Try the side-tunnel."
	choice_1 = {
		"\tShaking your head and asking yourself why you ever got into
		this in the first place, you turn around and head back to the
		surface. You wave curtly to the guard, head over to the
		'porter, and program in the coordinates to your Outpost.\n
		\tAs you step through, you wonder if there was anything to that
		story the villagers told you. You also wonder if your Outpost
		Commander is going to believe the story you're about to tell
		her.";
		global.death_msg := 'survived';
		die();
	}
	choice_2 = scan_tunnels
	choice_3 = go_straight_on
	choice_4 = turn_to_the_side
;

scan_the_door: Place
	statusLine = "At the Door"
	desc = "You reach for your scanner and then remember you had given it
		to the T'Hrag in exchange for shelter.\n
		\t\"Would you mind scanning the door?\"\ you ask.\n
		\t\"Of course!\"\ it says, shaking its head. \"I should have
		thought of that myself.\"\n
		\tIt levels the scanner at the door, pushing a few buttons, and
		its expression changes.\n
		\t\"What?\"\ you ask.\n
		\t\"There seems to be a device within the door, but I can't make
		out what kind.\"\n
		\t\"Let me have a look.\"\n
		\tThe T'Hrag holds the scanner so you can see it. The device
		appears to be some sort of signal processor, and you tell the
		T'Hrag.\n
		\t\"WHAT sort of signal processor?\"\ it asks.\n
		\t\"I can't tell. It could be for processing sounds. This part
		here,\"\ you indicate on the scanner, \"looks like a crude
		codec and, over here, this could be a small microphone.\"\n
		\t\"I see. So the door could be actually keyed to voice
		commands?\"\n
		\t\"Could be.\"\n
		\tThe T'Hrag draws itself up to its full height, throws back
		its head, and starts grunting loudly. Startled, you step back
		from it.\n
		\t\"What are you saying?\"\ you ask, when it pauses to catch
		its breath.\n
		\t\"I'm LAUGHING,\"\ it answers. You wait whilst it calms
		itself down. \"You see, part of our
		religious code was that these tunnels, being sacred, were to be
		silent at all times. No one was permitted to speak within
		them.\"\n
		\t\"So no one would be able to accidentally trip the lock.\"\n
		\t\"Exactly. My mentor always said that there's nothing more
		useless than a lock with a voiceprint. But here's an effective
		way of making one work: have a holy writ against speech!\"\n
		\tThe T'Hrag turns to the door and grunts sharply. Much to your
		surprise, the door slides open!\n
		\t\"What did you say?\"\ you ask.\n
		\t\"Merely our word for 'open'.\""
	choices = "\t1. Step through the door.\n
		\t2. Return to the surface."
	choice_1 = ask_of_legends.choice_1
	choice_2 = ask_of_legends.choice_2
;

ask_of_legends: Place
	statusLine = "Step or Stop?"
	desc = "\"Are there any stories or legends of this place?\"\ you ask.\n
		\t\"Many,\"\ replies the T'Hrag. \"Most of them are used as
		bedtime stories for children. None which tell of getting
		through this door, however.\"\n
		\t\"Most?\"\n
		\t\"Pardon ne?\"\n
		\t\"You said that MOST of the stories are for children.\"\n
		\t\"Yes. The others are part of the religious canon.\" It
		smiles. \"Actually, one of the laws forbids speech in these
		tunnels.\"\n
		\tYou shrug. \"Not much help there.\" You pause, thinking for
		a bit. And then, \"How about WHY this blue stone was hidden in
		here?\"\n
		\t\"That's rather a long story,\"\ it replies. \"But the
		essence of it is that a warrior desired it, and the religious
		leaders didn't want the warrior to have it.\"\n
		\t\"Ah,\"\ you say. \"Politics.\"\n
		\tThe T'Hrag nods. \"Politics and bureaucracy: the twin curses
		of intelligent life forms throughout the universe.\"\n
		\tYou can't resist a smile. \"Pessimist.\"\n
		\t\"But as for the door...\"\n
		\t\"Right,\"\ you say. \"The door.\"\n
		\tThe two of you stare at it for a bit.\n
		\t\"So,\"\ you say, breaking the silence. \"There's nothing in
		the legends which tell of a door; there's no children's stories
		about this door; there is no mention of it in your religious
		works...\"\n
		\t\"The greatest of our thinkers have been stymied by it.
		They've tried pushing on it, pulling it, tapping it, thinking
		at it, throwing rocks at it--\"\n
		\t\"Thinking at it?\"\n
		\tIt shrugs. \"One never knows.\"\n
		\tSuddenly a thought comes to you. \"But none of them have ever
		spoken to it!\"\n
		\tThe T'Hrag's expression changes. \"Of course! Because of the
		law!\"\n
		\tIt turns to the door and barks a quick grunt at it. To your
		surprise, the door slides open!\n
		\t\"What did you say?\"\ you ask, incredulous.\n
		\t\"Merely our word for 'open'.\""
	choices = "\t1. Step through the door.\n
		\t2. Return to the surface."
	choice_1 = {
		"You step through the door and find yourselves in a large,
		well-lit chamber. It looks perfectly round and there are three
		other doors besides the one you entered through, spaced evenly
		around the chamber. Carved into the walls are pictures and
		symbols and, along one part of the wall, a shelf has been
		carved in.\n
		\t\"Where's the light coming from?\"\ you ask, but the T'Hrag
		seems to be distracted.\n
		\t\"Look,\"\ it says, pointing at the carvings. \"This tells
		the story of the warrior who wanted the Fnorgar Ratkin and how
		Hikalt built this place for it to be hidden! This is an
		extraordinary find. Why, we'll be studying this for ages to
		come! Think of the...\" It trails off.\n
		\tYou turn to look at the T'Hrag, and see that it's staring
		straight at the shelf. Your eyes are drawn to the shelf, upon
		which you notice a small, blue oval stone, about the size of
		your fist, and very smooth.\n
		\t\"Is that it?\"\ you ask.\n
		\tThe T'Hrag just nods, speechless. Reverentially, it walks up
		to the stone and picks it up off the shelf. A brief flash of
		thought runs through your mind about possible booby traps but,
		since nothing untoward happened, you shrug the feeling off.
		The T'Hrag turns to you, cradling the stone in its hand.\n
		\t\"You did it,\"\ it says. \"You found the Fnorgar Ratkin.\"\n
		\tYou shrug, not feeling like you did all that much, really.
		\"To tell you the truth,\"\ you say, \"I really should be
		getting back to my base.\"\n
		\t\"Of course, of course,\"\ says the T'Hrag. \"Come, I'll show
		you the way back.\"\n
		\tIt seems to be almost entranced as it walks out the door. You
		follow it through the tunnels and back to the outside. It's
		dark out now, and the guard is asleep.\n
		\t\"You must come to my village so that we may properly thank
		you,\"\ it whispers. \"You will be a great hero in our
		society.\"\n
		\tYou shake your head. \"Maybe some other time,\"\ you say.
		\"I really have to get back or the Outpost Commander will have
		me flayed alive.\"\n
		\tThe T'Hrag smiles gently, which is difficult for someone of
		its species. \"Some other time, then.\"\n
		\tIt enters some coordinates into the 'porter, steps inside and
		vanishes.\n
		\tYou enter the coordinates for your Outpost and look back at
		the entrance to the tunnels. Great hero, you think to yourself.
		You like the sound of that. You shake it off, and step into the
		'porter. You know that no one at your Outpost will ever
		believe it.";
		global.death_msg := 'won';
		die();
	}
	choice_2 = {
		"You turn around and start walking back up the tunnel.\n
		\t\"Where are you going?\"\ asks the T'Hrag.\n
		\t\"I'm tired of this now. I have to get back to my Outpost.
		They're probably wondering where I've got to.\"\n
		\t\"You'll never find your way out,\"\ it says.\n
		\t\"I'm willing to take that chance.\"\n
		\tThe T'Hrag turns back to the door.\n
		\tYou wander back, trying to follow the scratch marks that the
		T'Hrag had showed you earlier. After walking for a few hours,
		you sit down to rest and nod off.\b
		\tMillennia later, explorers find your desiccated body. How a
		human came to be inside the holy place of the T'Hrag was
		a mystery that no scholar was able ever to solve.";
		die();
	}
;

examine_door: Place
	statusLine = "Frustration"
	desc = "You feel the surface of the door carefully. It's very smooth.
		You can't detect any bumps or grooves in it whatsoever. You
		examine the sides, and can't see any gaps between the door and
		the wall. You rub your finger along the top where it meets the
		ceiling. Nothing. You get on your knees to see if there's a gap
		at the floor. Nothing.\n
		\t\"We've tried all that,\"\ the T'Hrag says.\n
		\t\"It helps for me to do it myself.\"\n
		\t\"Certainly.\""
	choices = "\t1. Kick the door.\n
		\t2. Ask the T'Hrag about any legends concerning the door.\n
		\t3. Scan the door to see if there are any clues to be
		gained.\n
		\t4. Forget about the whole thing and return to the surface."
	choice_1 = kick_door
	choice_2 = ask_of_legends
	choice_3 = scan_the_door
	choice_4 = ask_of_legends.choice_2
;

kick_door: Place
	statusLine = "Return to Rationality"
	desc = "You draw your leg back and kick the door hard. An incredible
		burst of pain shoots up your leg, and you hop away from the
		door, your face writhing in agony.\n
		\t\"We hadn't tried that, though,\"\ the T'Hrag says, wryly.\n
		\tYou suppress the urge to hit it."
	choices = "\t1. Give up and leave the tunnels.\n
		\t2. Scan the door with your portascanner.\n
		\t3. Ask the T'Hrag about stories of the tunnels."
	choice_1 = ask_of_legends.choice_2
	choice_2 = scan_the_door
	choice_3 = ask_of_legends
;

scan_tunnels: Place
	statusLine = "Go or Stay?"
	desc = "Powering up the scanner, you set it for maximum range. After a
		moment or two, a complex network of tunnels reveals itself.
		It's very complex -- almost maze like -- in nature. You
		scroll the display back and forth, up and down, through the
		mountain's interior, looking for anything unusual.  Suddenly,
		you spot something. It appears to be a perfectly round room
		with some sort of energy source on the north, south, east and
		west edges of the curve."
	choices = "\t1. Try to make your way to one of the energy sources.\n
		\t2. End this nonsense and return to your Outpost."
	choice_1 = find_an_entrance
	choice_2 = taking_a_chance.choice_1
;

go_straight_on: Place
	statusLine = "Fork in the Tunnel"
	desc = "You continue down the tunnel for a bit, and eventually you come
		to a fork."
	choices = "\t1. Go left.\n
		\t2. Go right.\n
		\t3. Scan the tunnel system to try to map it out."
	choice_1 = four_1
	choice_2 = four_2
	choice_3 = scan_tunnels
;

turn_to_the_side: Place
	statusLine = "A T-intersection"
	desc = "You turn down the side-tunnel and walk for a bit. Eventually
		the tunnel ends at another, wider, tunnel, which intersects it,
		allowing you to either turn left or right."
	choices = "\t1. Turn left.\n
		\t2. Turn right.\n
		\t3. Scan the system of tunnels to try to map it out."
	choice_1 = fork_1
	choice_2 = four_3
	choice_3 = scan_tunnels
;

find_an_entrance: Place
	statusLine = "Moral Choice"
	desc = "Following the map on your scanner, you make your way to the
		closest source of the energy emissions.  When you arrive, you
		look up to see a dead end. What's the source of the
		energy?\ you ask yourself.\n
		\tFocusing the scanner's sensors on the tunnel wall in front of
		you, you realize that there is the equivalent of a
		chameleofield convering the wall. It's making something look
		like the rough-hewn surface of the tunnel. You fiddle with the
		controls of the scanner for a bit manage to deactivate the
		field, and reveal a smooth surface.\n
		\tScanning the surface, you realize that it's actually a door,
		beyond which is the chamber you detected earlier. Again, you
		fiddle with the scanner's controls and determine that the
		locking mechanism for the door is actually based on
		sound. You determine the right sound to make and tell the
		scanner to make it. The scanner makes a grating noise and, to
		your delight, the door slides open.\n
		\tYou step through into the chamber. As your scan had
		indicated, it's perfectly round. Along part of the curve, a
		shelf has been carved in and, all along the interior surface of
		the room, are carvings and pictograms. Images of T'Hrag in some
		historical event.\n
		\tYour attention is drawn to the shelf, though, and on it you
		see a small, oval stone, its blue surface shimmering in the
		florescent light from the walls.\n"
	choices = "\t1. Take the stone and return to the village.\n
		\t2. Take the stone and return to your Outpost.\n
		\t3. Forget about all this nonsense and return to the surface."
	choice_1 = {
		"You grab the stone -- it's quite light -- and walk back up to
		the surface. Night has fallen and the guard appears to be
		asleep. You quietly walk up to the 'porter, set the
		coordinates for the village and step through.\n
		\tThe villagers were all keeping a vigil in the hut by the
		'porter and grow quite excited when you step through.\n
		\t\"Have it?\"\ one of them asks. \"Have Fnorgar Ratkin?\"\n
		\tYou open your hand and a T'Hrag carefully, gently,
		reverentially takes it from you. It holds it up in the air,
		dancing and growling. The other T'Hrag dance around it too, and
		make their way out of the hut.\n
		\tYou follow, and there seems to be a party going on outside.\n
		\tOne T'Hrag takes your arm. \"Come,\"\ it says. \"We give you
		food and shelter for the night.\"\n
		\tNot being all that interested in the celebration, you
		willingly let yourself be led away. The T'Hrag takes you to a 
		hut, the interior of which is, by T'Hrag standards, most
		opulent.\n
		\tYou settle down comfortably on a soft bed, drawing thick
		blankets around you to ward of the cold. You fall asleep
		easily, despite the noise and merrymaking outside.\n
		\tThe next day, a search and rescue team from your Outpost
		locates your distress beacon and, when you get back, you're not
		sure you want to tell your Outpost Commander the whole story.
		You're not sure she'll believe you.";
		global.death_msg := 'won';
		die();
	}
	choice_2 = {
		"You grab the stone -- it's quite light -- and walk back up to
		the surface. Night has fallen an the guard apperas to be
		asleep. You quietly walk up to the 'porter, set the
		coordinates for your Outpost, and step through.\n
		\tThe blue stone ends up in your dresser drawer, your souvenir
		from this planet. Months later, after you've been transferred
		to another assignment on another Outpost, you go to look at it,
		but can't find it anywhere. Oops, you think to yourself. I must
		have left it behind.\n
		\tYou never think about it again.";
		global.death_msg := 'survived';
		die();
	}
	choice_3 = taking_a_chance.choice_1
;

four_1: Place
	statusLine = "Intersection"
	desc = "You make your way to an intersection of two tunnels. The
		intersection isn't at 90 degrees, though, it's more like 45."
	choices = "\t1. Go straight on.\n
		\t2. Turn to the left -- almost a u-turn.\n
		\t3. Fork to the right.\n
		\t4. Scan the tunnel system to try to map it out."
	choice_1 = fork_2
	choice_2 = four_3
	choice_3 = fork_3
	choice_4 = scan_tunnels
;

four_2: Place
	statusLine = "Intersection"
	desc = "The tunnel you're following curves and twists and, after a
		short while, you've become quite disoriented. You reach a point
		where the tunnel you're in intersects another, and are faced
		with a decision."
	choices = "\t1. Go straight on.\n
		\t2. Turn to the left.\n
		\t3. Turn to the right.\n
		\t4. Scan the tunnel system to try to map it out."
	choice_1 = fork_3
	choice_2 = four_1
	choice_3 = fork_2
	choice_4 = scan_tunnels
;

fork_1: Place
	statusLine = "Fork in the Tunnel"
	desc = "You continue to hike down the tunnel. Eventually, you come to
		a fork."
	choices = "\t1. Take the fork to the left.\n
		\t2. Take the right fork.\n
		\t3. Scan the tunnel system to try to map it out."
	choice_1 = four_1
	choice_2 = four_2
	choice_3 = scan_tunnels
;

four_3: Place
	statusLine = "Intersection"
	desc = "After hiking a way down the tunnel, the twists and turns do
		a very good job of disorienting you. You've no idea which way
		the surface is any more. You arrive at an unusual intersection:
		the tunnel to the right is as large as the one you're in, but
		the tunnel to the left is much smaller and narrower."
	choices = "\t1. Go straight on.\n
		\t2. Turn right into the wide tunnel.\n
		\t3. Turn left into the side-tunnel.\n
		\t4. Scan the tunnel system to try to map it out."
	choice_1 = fork_2
	choice_2 = fork_3
	choice_3 = turn_to_the_side
	choice_4 = scan_tunnels
;

fork_2: Place
	statusLine = "Fork in the Tunnel"
	desc = "You walk down the tunnel and it seems to get steeper and
		steeper. Eventually, it levels out and spot a smaller tunnel
		angling off to one side."
	choices = "\t1. Go straight on.\n
		\t2. Take the smaller tunnel.\n
		\t3. Scan the tunnel system to try to map it out."
	choice_1 = fork_1
	choice_2 = fork_3
	choice_3 = scan_tunnels
;

fork_3: Place
	statusLine = "Fork in the Tunnel"
	desc = "After becoming thoroughly disoriented by the turns and angles
		in the tunnel system, you reach a fork. Both tunnels are the
		same size as the one you've come from -- you have no way of
		distinguishing between the two."
	choices = "\t1. Take the left fork.\n
		\t2. Take the right one.\n
		\t3. Scan the tunnel system to try to map it out."
	choice_1 = four_1
	choice_2 = four_2
	choice_3 = scan_tunnels
;
