#include <lib.h>
#include <curses.h>
#include "curspriv.h"
#include <termcap.h>
/************************************************************************
 *									*
 *			 Tiny pseudo "curses" package			*
 *									*
 *		v1.0	870117	DBW - D. Wecker, initial hack		*
 *		v1.1    881003  W. Toomey, hacked to get it to use	*
 *				Termcap, and to not foul input.		*
 *				Borrowed a bit of code from Alistair	*
 *				Crooks' `show.c' posted on 870730.	*
 *		v1.2    900906  D. Cope beefed up to close to full 	*
 *				curses support				*
 *		v1.3	900920	M. Haardt removed some little bugs,	*
 *				added block grafic characters		*
 ************************************************************************/


#include <sgtty.h>
/* #include <stdlib.h> */
#include <stdio.h>
#include <signal.h>

struct sgttyb 	old_tty, new_tty;

extern char *tgetstr();		/* termcap getstring capability */
extern char *tgoto();		/* termcap goto (x, y) */
void scrncolor();		/* forward declarition */

int  lastcolor = 0x700;		/* last color received fst is white on black */
int  lastattr  = 0;		/* last attribute received */
int  curmod = 1;		/* cursor initially set to on */
char termcap[1024];		/* termcap buffer */
char tc[200];			/* area to hold string capabilities */
char *ttytype;			/* terminal type from env */
char *arp;			/* pointer for use in tgetstr */
char *cp;			/* character pointer */

char *cl;			/* clear screen capability */
char *cm;			/* cursor motion capability */
char *so;			/* start standout capability */
char *se;			/* end standout capability */
char *mr;			/* start of reverse */
char *me;			/* revert to normal */
char *mb;			/* start of blink */
char *md;			/* start of bold */
char *us;			/* start of underscore */
char *ue;			/* end of underscore */
char *vi;			/* cursor invisible */
char *ve;			/* cursor normal */
char *as;			/* alternative charset start */
char *ae;			/* alternative charset end */

/*
 *	fatal - report error and die. Never returns
 */
void fatal(s)
char *s;
{
  (void) fprintf(stderr, "curses: %s\n", s);
  exit(1);
}


/*
 *	outc - call putchar, necessary because putchar is a macro.
 */
void outc(c)
int c;
{
  putchar(c);
}


/* get cbreak mode  */
int gcb()
{
	ioctl(0,TIOCGETP,&old_tty);	/* get and return old setting */
	return(old_tty.sg_flags & CBREAK? TRUE : FALSE);
}

/* set cbreak mode  */
void scb(s)
int s;
{
	ioctl(0,TIOCGETP,&old_tty);	/* set or clear cbreak */
	if(s)	
		{old_tty.sg_flags |= CBREAK;
		 old_tty.sg_flags &= ~ECHO;
		}
	else	
		{old_tty.sg_flags &= ~CBREAK;
		 old_tty.sg_flags |= ECHO;
		}
	ioctl(0,TIOCSETP,&old_tty);
}

/* get fixed lines */
int glines()
{
/*	return(25); */
	return(tgetnum("li")); 
}

/* get fixed cols */
int gcols()
{
/*	return(80); */
	return(tgetnum("co")); 
}

/* output char with attribute */
void _cursescattr(a, b, c, d)
int a, b, c, d;
{
	if(lastattr != (c & 0xff))	/* attribute first */
	{
		c = c & 0xff;
		lastattr = c;
		setdef();
		if ((c << 8) & A_ALTCHARSET)
			if (as) tputs(as, 1, outc);
		if ((c << 8) & A_BLINK)
			tputs(mb, 1, outc);
        	if ((c << 8) & A_BOLD)
			tputs(md, 1, outc);
		if ((c << 8) & A_REVERSE)
			tputs(mr, 1, outc);
		if ((c << 8) & A_STANDOUT)
			tputs(so, 1, outc);
		if ((c << 8) & A_UNDERLINE)
			tputs(us, 1, outc);
		c = lastcolor;
		lastcolor = 0;
		scrncolor(c);
	}
	outc(b);		/* then out the character */
}

/* set the screen colors  */
void scrncolor(colors)
int colors;
{
	int e, f;
	if(lastcolor != colors)
	{
		lastcolor = colors;
		e = colors & 0x700;
		e = (e >> 8) + 30;
		f = colors & 7;
		f = f  + 40;
		printf("\033[%d;%dm", e, f);
	}
}

/* How do we do this with the cursor */
int gcmode()
{
	return(curmod);		/* condition of the cursor */
}

void cmode(a)
int a;
{
	if (a && ve !=NULL) tputs(ve,1,outc);
	else if (vi!=NULL) tputs(vi,1,outc);
/*	if(a) tputs("\033Pcursor.on\033\\",1,outc);
	else  tputs("\033Pcursor.off\033\\",1,outc);
*/
	curmod = a;
}

/* move cursor to r,c */
void poscur(d, r, c)
int d, r, c;
{
	tputs(tgoto(cm, c, r),1,outc);

}

/* this is get key */
int getkey()
{

	return(getchar());
}

int getkeytst()
{
	return(kbhit());
}

/*  flush all input away */
void kbflush()
{
	ioctl(0, TIOCFLUSH,0);
}

/*  key board been hit */
int kbhit()
{
	int n = 0;
	return (TRUE);
}


/* clear the screen */
void clrscr()
{
	tputs(cl, 1, outc);
}

/* this are terminal independent characters which can be used in curses */

unsigned char ACS_ULCORNER;
unsigned char ACS_LLCORNER;
unsigned char ACS_URCORNER;
unsigned char ACS_LRCORNER;
unsigned char ACS_RTEE;
unsigned char ACS_LTEE;
unsigned char ACS_BTEE;
unsigned char ACS_TTEE;
unsigned char ACS_HLINE;
unsigned char ACS_VLINE;
unsigned char ACS_PLUS;
unsigned char ACS_S1;
unsigned char ACS_S9;
unsigned char ACS_DIAMOND;
unsigned char ACS_CKBOARD;
unsigned char ACS_DEGREE;
unsigned char ACS_PLMINUS;
unsigned char ACS_BULLET;
unsigned char ACS_LARROW;
unsigned char ACS_RARROW;
unsigned char ACS_DARROW;
unsigned char ACS_UARROW;
unsigned char ACS_BOARD;
unsigned char ACS_LANTERN;
unsigned char ACS_BLOCK;

/* these defines describe the full set of grafic block characters which
   can be defined via termcap. */
 
#define RIGHTARROW  0
#define LEFTARROW   1
#define DOWNARROW   2
#define UPARROW     3
#define FULLSQUARE  4
#define GREYSQUARE  5
#define EMPTYSQUARE 6
#define LATERN      7
#define DIAMOND     8
#define DEGREE      9
#define PLUSMINUS  10
#define DOWNRIGHT  11
#define UPRIGHT    12
#define UPLEFT     13
#define DOWNLEFT   14
#define CROSS      15
#define UPLINE     16
#define UPMIDLINE  17
#define MIDLINE    18
#define DOMIDLINE  19
#define DOWNLINE   20
#define TEELEFT    21
#define TEERIGHT   22
#define TEEHEAD    23
#define TEENORMAL  24
#define VERTLINE   25
#define PARAGRAPH  26

char _cursgraftable[28] = "><v^#+ #+'#+++++- \300 _++++| ";
char _cursident[28]     = "+,.-0ahI`fgjklmnopqrstuvwx~";

_curstcap()
{
  char *ac;
  int i;

 if ((ttytype = getenv("TERM")) == (char *)NULL)
	fatal("No terminal type set in environment");

  if (tgetent(termcap, ttytype) != 1) fatal("No termcap entry for terminal");
  arp = tc;
  cl = tgetstr("cl", &arp);
  so = tgetstr("so", &arp);
  se = tgetstr("se", &arp);
  cm = tgetstr("cm", &arp);
  mr = tgetstr("mr", &arp);
  me = tgetstr("me", &arp);
  mb = tgetstr("mb", &arp);
  md = tgetstr("md", &arp);
  us = tgetstr("us", &arp);
  ue = tgetstr("ue", &arp);
  vi = tgetstr("vi", &arp);
  ve = tgetstr("ve", &arp);
  as = tgetstr("as", &arp);
  ae = tgetstr("ae", &arp);
  ac = tgetstr("ac", &arp);

  if (ac)
    while (*ac)
    {
      i=0;
      while (*ac != _cursident[i]) i++;
      _cursgraftable[i] = *++ac;
      ac++;
    }

  ACS_ULCORNER = _cursgraftable[UPLEFT];
  ACS_LLCORNER = _cursgraftable[DOWNLEFT];
  ACS_URCORNER = _cursgraftable[UPRIGHT];
  ACS_LRCORNER = _cursgraftable[DOWNRIGHT];
  ACS_RTEE = _cursgraftable[TEERIGHT];
  ACS_LTEE = _cursgraftable[TEELEFT];
  ACS_BTEE = _cursgraftable[TEEHEAD];
  ACS_TTEE = _cursgraftable[TEENORMAL];
  ACS_HLINE = _cursgraftable[MIDLINE];
  ACS_VLINE = _cursgraftable[VERTLINE];
  ACS_PLUS = _cursgraftable[PLUSMINUS];
  ACS_S1 = _cursgraftable[UPLINE];
  ACS_S9 = _cursgraftable[DOWNLINE];
  ACS_DIAMOND = _cursgraftable[DIAMOND];
  ACS_CKBOARD = _cursgraftable[GREYSQUARE];
  ACS_DEGREE = _cursgraftable[DEGREE];
  ACS_PLMINUS = _cursgraftable[PLUSMINUS];
  ACS_BULLET = 'o'; /* where the hell is a bullet defined in termcap ??? */
  ACS_LARROW = _cursgraftable[LEFTARROW];
  ACS_RARROW = _cursgraftable[RIGHTARROW];
  ACS_DARROW = _cursgraftable[DOWNARROW];
  ACS_UARROW = _cursgraftable[UPARROW];
  ACS_BOARD = _cursgraftable[EMPTYSQUARE];
  ACS_LANTERN = _cursgraftable[LATERN];
  ACS_BLOCK = _cursgraftable[FULLSQUARE];
  /* wow, I got it! */  
 
  tputs(cl, 1, outc);  
}

void setdef()		/* set screen back to default settings */
{
	tputs(me, 1, outc);
	if (ae) tputs(ae, 1, outc);
}
