/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclInteger
extends InternalRep {
    private int value;

    private TclInteger(int n) {
        this.value = n;
    }

    private TclInteger(Interp interp, String string) throws TclException {
        this.value = Util.getInt(interp, string);
    }

    protected InternalRep duplicate() {
        return new TclInteger(this.value);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static TclObject newInstance(int n) {
        return new TclObject(new TclInteger(n));
    }

    private static void setIntegerFromAny(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.internalRep;
        if (!(internalRep instanceof TclInteger)) {
            if (internalRep instanceof TclBoolean) {
                boolean bl = TclBoolean.get(interp, tclObject);
                if (bl) {
                    tclObject.setInternalRep(new TclInteger(1));
                    return;
                }
                tclObject.setInternalRep(new TclInteger(0));
                return;
            }
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            tclObject.setInternalRep(new TclInteger(interp, tclObject.stringRep));
        }
    }

    public static int get(Interp interp, TclObject tclObject) throws TclException {
        TclInteger.setIntegerFromAny(interp, tclObject);
        TclInteger tclInteger = (TclInteger)tclObject.internalRep;
        return tclInteger.value;
    }

    public static int getForIndex(Interp interp, TclObject tclObject, int n) throws TclException {
        InternalRep internalRep = tclObject.internalRep;
        if (internalRep instanceof TclInteger) {
            TclInteger tclInteger = (TclInteger)tclObject.internalRep;
            return tclInteger.value;
        }
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        if ("end".startsWith(tclObject.stringRep)) {
            return n;
        }
        try {
            TclInteger.setIntegerFromAny(interp, tclObject);
        }
        catch (TclException tclException) {
            StringBuffer stringBuffer = new StringBuffer("bad index \"");
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            throw new TclException(interp, stringBuffer.append(tclObject.stringRep).append("\": must be integer or \"end\"").toString());
        }
        TclInteger tclInteger = (TclInteger)tclObject.internalRep;
        return tclInteger.value;
    }

    public static void set(TclObject tclObject, int n) {
        tclObject.invalidateStringRep();
        InternalRep internalRep = tclObject.internalRep;
        if (internalRep instanceof TclInteger) {
            TclInteger tclInteger = (TclInteger)internalRep;
            tclInteger.value = n;
            return;
        }
        tclObject.setInternalRep(new TclInteger(n));
    }
}

