/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.SearchId;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;

class ArrayCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"anymore", "donesearch", "exists", "get", "names", "nextelement", "set", "size", "startsearch"};
    static final int OPT_ANYMORE = 0;
    static final int OPT_DONESEARCH = 1;
    static final int OPT_EXISTS = 2;
    static final int OPT_GET = 3;
    static final int OPT_NAMES = 4;
    static final int OPT_NEXTELEMENT = 5;
    static final int OPT_SET = 6;
    static final int OPT_SIZE = 7;
    static final int OPT_STARTSEARCH = 8;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arrayName ?arg ...?");
        }
        boolean bl = false;
        Hashtable hashtable = interp.varFrame.varTable;
        Object object = tclObjectArray[2];
        if (((TclObject)object).stringRep == null) {
            ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
        }
        if ((object = (Var)hashtable.get(((TclObject)object).stringRep)) != null && (((Var)object).flags & 4) != 0) {
            object = null;
        }
        if (object != null && (((Var)object).flags & 2) != 0) {
            object = (Var)((Var)object).value;
        }
        if (object == null || (((Var)object).flags & 1) == 0) {
            bl = true;
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                Object object2;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "anymore arrayName searchId");
                }
                if (bl) {
                    object2 = tclObjectArray[2];
                    if (((TclObject)object2).stringRep == null) {
                        ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                    }
                    ArrayCmd.errorNotArray(interp, ((TclObject)object2).stringRep);
                }
                if (((Var)object).sidVec == null) {
                    object2 = tclObjectArray[2];
                    if (((TclObject)object2).stringRep == null) {
                        ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                    }
                    String string = ((TclObject)object2).stringRep;
                    object2 = tclObjectArray[3];
                    if (((TclObject)object2).stringRep == null) {
                        ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                    }
                    ArrayCmd.errorIllegalSearchId(interp, string, ((TclObject)object2).stringRep);
                }
                object2 = tclObjectArray[3];
                if (((TclObject)object2).stringRep == null) {
                    ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                }
                if ((object2 = ((Var)object).getSearch(((TclObject)object2).stringRep)) == null) {
                    TclObject tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    String string = tclObject.stringRep;
                    tclObject = tclObjectArray[3];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    ArrayCmd.errorIllegalSearchId(interp, string, tclObject.stringRep);
                }
                if (object2.hasMoreElements()) {
                    if ("1" == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance("1"));
                    return;
                }
                if ("0" == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance("0"));
                return;
            }
            case 1: {
                TclObject tclObject;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "donesearch arrayName searchId");
                }
                if (bl) {
                    TclObject tclObject2 = tclObjectArray[2];
                    if (tclObject2.stringRep == null) {
                        tclObject2.stringRep = tclObject2.internalRep.toString();
                    }
                    ArrayCmd.errorNotArray(interp, tclObject2.stringRep);
                }
                boolean bl2 = true;
                if (((Var)object).sidVec != null) {
                    tclObject = tclObjectArray[3];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    bl2 = ((Var)object).removeSearch(tclObject.stringRep);
                }
                if (((Var)object).sidVec == null || !bl2) {
                    tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    String string = tclObject.stringRep;
                    tclObject = tclObjectArray[3];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    ArrayCmd.errorIllegalSearchId(interp, string, tclObject.stringRep);
                }
                return;
            }
            case 2: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "exists arrayName");
                }
                boolean bl3 = !bl;
                interp.setResult(TclBoolean.newInstance(bl3));
                return;
            }
            case 3: {
                Object object3;
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "get arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string = null;
                if (tclObjectArray.length == 4) {
                    object3 = tclObjectArray[3];
                    if (((TclObject)object3).stringRep == null) {
                        ((TclObject)object3).stringRep = ((TclObject)object3).internalRep.toString();
                    }
                    string = ((TclObject)object3).stringRep;
                }
                object3 = (Hashtable)((Var)object).value;
                TclObject tclObject = TclList.newInstance();
                Object object4 = tclObjectArray[2];
                if (((TclObject)object4).stringRep == null) {
                    ((TclObject)object4).stringRep = ((TclObject)object4).internalRep.toString();
                }
                object4 = ((TclObject)object4).stringRep;
                Enumeration enumeration = ((Hashtable)((Var)object).value).keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Var var = (Var)((Hashtable)object3).get(string2);
                    if ((var.flags & 4) != 0) continue;
                    TclObject tclObject3 = interp.varFrame.getVar((String)object4, string2, 0);
                    if (tclObject3.stringRep == null) {
                        tclObject3.stringRep = tclObject3.internalRep.toString();
                    }
                    String string3 = tclObject3.stringRep;
                    if (string != null && !Util.stringMatch(string2, string)) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string2));
                    TclList.append(interp, tclObject, TclString.newInstance(string3));
                }
                interp.setResult(tclObject);
                return;
            }
            case 4: {
                Object object5;
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "names arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string = null;
                if (tclObjectArray.length == 4) {
                    object5 = tclObjectArray[3];
                    if (((TclObject)object5).stringRep == null) {
                        ((TclObject)object5).stringRep = ((TclObject)object5).internalRep.toString();
                    }
                    string = ((TclObject)object5).stringRep;
                }
                object5 = (Hashtable)((Var)object).value;
                TclObject tclObject = TclList.newInstance();
                Enumeration enumeration = ((Hashtable)object5).keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    Var var = (Var)((Hashtable)object5).get(string4);
                    if ((var.flags & 4) != 0 || string != null && !Util.stringMatch(string4, string)) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string4));
                }
                interp.setResult(tclObject);
                return;
            }
            case 5: {
                Object object6;
                Object object7;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "nextelement arrayName searchId");
                }
                if (bl) {
                    object7 = tclObjectArray[2];
                    if (((TclObject)object7).stringRep == null) {
                        ((TclObject)object7).stringRep = ((TclObject)object7).internalRep.toString();
                    }
                    ArrayCmd.errorNotArray(interp, ((TclObject)object7).stringRep);
                }
                if (((Var)object).sidVec == null) {
                    object7 = tclObjectArray[2];
                    if (((TclObject)object7).stringRep == null) {
                        ((TclObject)object7).stringRep = ((TclObject)object7).internalRep.toString();
                    }
                    String string = ((TclObject)object7).stringRep;
                    object7 = tclObjectArray[3];
                    if (((TclObject)object7).stringRep == null) {
                        ((TclObject)object7).stringRep = ((TclObject)object7).internalRep.toString();
                    }
                    ArrayCmd.errorIllegalSearchId(interp, string, ((TclObject)object7).stringRep);
                }
                object7 = tclObjectArray[3];
                if (((TclObject)object7).stringRep == null) {
                    ((TclObject)object7).stringRep = ((TclObject)object7).internalRep.toString();
                }
                if ((object7 = ((Var)object).getSearch(((TclObject)object7).stringRep)) == null) {
                    object6 = tclObjectArray[2];
                    if (((TclObject)object6).stringRep == null) {
                        ((TclObject)object6).stringRep = ((TclObject)object6).internalRep.toString();
                    }
                    String string = ((TclObject)object6).stringRep;
                    object6 = tclObjectArray[3];
                    if (((TclObject)object6).stringRep == null) {
                        ((TclObject)object6).stringRep = ((TclObject)object6).internalRep.toString();
                    }
                    ArrayCmd.errorIllegalSearchId(interp, string, ((TclObject)object6).stringRep);
                }
                if (!object7.hasMoreElements()) break;
                object6 = (Hashtable)((Var)object).value;
                String string = (String)object7.nextElement();
                Var var = (Var)((Hashtable)object6).get(string);
                if ((var.flags & 4) == 0) {
                    if (string == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance(string));
                    return;
                }
                if ("" == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(""));
                return;
            }
            case 6: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "set arrayName list");
                }
                int n2 = TclList.getLength(interp, tclObjectArray[3]);
                if (n2 % 2 != 0) {
                    throw new TclException(interp, "list must have an even number of elements");
                }
                Object object8 = tclObjectArray[2];
                if (((TclObject)object8).stringRep == null) {
                    ((TclObject)object8).stringRep = ((TclObject)object8).internalRep.toString();
                }
                object8 = ((TclObject)object8).stringRep;
                int n3 = 0;
                while (n3 < n2) {
                    TclObject tclObject = TclList.index(interp, tclObjectArray[3], n3++);
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    String string = tclObject.stringRep;
                    tclObject = TclList.index(interp, tclObjectArray[3], n3);
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    String string5 = tclObject.stringRep;
                    tclObject = TclString.newInstance(string5);
                    interp.varFrame.setVar((String)object8, string, tclObject, 0);
                    ++n3;
                }
                return;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "size arrayName");
                }
                if (bl) {
                    interp.setResult(TclInteger.newInstance(0));
                    return;
                }
                Hashtable hashtable2 = (Hashtable)((Var)object).value;
                int n4 = 0;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Var var = (Var)hashtable2.get((String)enumeration.nextElement());
                    if ((var.flags & 4) != 0) continue;
                    ++n4;
                }
                interp.setResult(TclInteger.newInstance(n4));
                return;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "startsearch arrayName");
                }
                if (bl) {
                    TclObject tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    ArrayCmd.errorNotArray(interp, tclObject.stringRep);
                }
                if (((Var)object).sidVec == null) {
                    ((Var)object).sidVec = new Vector();
                }
                int n5 = ((Var)object).getNextIndex();
                StringBuffer stringBuffer = new StringBuffer("s-").append(n5).append("-");
                Object object9 = tclObjectArray[2];
                if (((TclObject)object9).stringRep == null) {
                    ((TclObject)object9).stringRep = ((TclObject)object9).internalRep.toString();
                }
                object9 = stringBuffer.append(((TclObject)object9).stringRep).toString();
                Enumeration enumeration = ((Hashtable)((Var)object).value).keys();
                ((Var)object).sidVec.addElement(new SearchId(enumeration, (String)object9, n5));
                if (object9 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)object9));
                return;
            }
        }
    }

    private static void errorNotArray(Interp interp, String string) throws TclException {
        throw new TclException(interp, "\"" + string + "\" isn't an array");
    }

    static void errorIllegalSearchId(Interp interp, String string, String string2) throws TclException {
        int n = ArrayCmd.validSearchId(string2.toCharArray(), string);
        if (n == 1) {
            throw new TclException(interp, "couldn't find search \"" + string2 + "\"");
        }
        if (n == 0) {
            throw new TclException(interp, "illegal search identifier \"" + string2 + "\"");
        }
        throw new TclException(interp, "search identifier \"" + string2 + "\" isn't for variable \"" + string + "\"");
    }

    private static int validSearchId(char[] cArray, String string) {
        if (cArray[0] != 's' || cArray[1] != '-' || cArray[2] < '0' || cArray[2] > '9') {
            return 0;
        }
        int n = 3;
        while (n < cArray.length && cArray[n] != '-') {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return 0;
            }
            ++n;
        }
        if (++n >= cArray.length) {
            return 0;
        }
        if (string.equals(new String(cArray, n, cArray.length - n))) {
            return 1;
        }
        return -1;
    }

    ArrayCmd() {
    }
}

