/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

final class QSort {
    static final int ASCII = 0;
    static final int INTEGER = 1;
    static final int REAL = 2;
    static final int COMMAND = 3;
    static final int DICTIONARY = 4;
    private int sortMode;
    private int sortIndex;
    private boolean sortIncreasing;
    private String sortCommand;
    private Interp sortInterp;

    /*
     * Unable to fully structure code
     */
    private final void quickSort(TclObject[] var1_1, int var2_2, int var3_3) throws TclException {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var1_1[(var2_2 + var3_3) / 2];
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.compare(var1_1[var4_4], var6_6) < 0) continue block0;
                    while (var5_5 > var2_2 && this.compare(var1_1[var5_5], var6_6) > 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    QSort.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private static final void swap(TclObject[] tclObjectArray, int n, int n2) {
        TclObject tclObject = tclObjectArray[n];
        tclObjectArray[n] = tclObjectArray[n2];
        tclObjectArray[n2] = tclObject;
    }

    final void sort(Interp interp, TclObject[] tclObjectArray, int n, int n2, boolean bl, String string) throws TclException {
        this.sortInterp = interp;
        this.sortMode = n;
        this.sortIndex = n2;
        this.sortIncreasing = bl;
        this.sortCommand = string;
        this.quickSort(tclObjectArray, 0, tclObjectArray.length - 1);
    }

    private final int compare(TclObject object, TclObject object2) throws TclException {
        StringBuffer stringBuffer;
        int n = 0;
        if (this.sortIndex != -1) {
            int n2 = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, object) - 1 : this.sortIndex;
            stringBuffer = TclList.index(this.sortInterp, object, n2);
            if (stringBuffer == null) {
                throw new TclException(this.sortInterp, "element " + n2 + " missing from sublist \"" + object + "\"");
            }
            object = stringBuffer;
            n2 = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, object2) - 1 : this.sortIndex;
            stringBuffer = TclList.index(this.sortInterp, object2, n2);
            if (stringBuffer == null) {
                throw new TclException(this.sortInterp, "element " + n2 + " missing from sublist \"" + object2 + "\"");
            }
            object2 = stringBuffer;
        }
        switch (this.sortMode) {
            case 0: {
                n = object.toString().compareTo(object2.toString());
                break;
            }
            case 4: {
                n = this.doDictionary(object.toString(), object2.toString());
                break;
            }
            case 1: {
                try {
                    int n3 = TclInteger.get(this.sortInterp, object);
                    int n4 = TclInteger.get(this.sortInterp, object2);
                    if (n3 > n4) {
                        n = 1;
                        break;
                    }
                    if (n4 <= n3) break;
                    n = -1;
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to integer)");
                    throw tclException;
                }
            }
            case 2: {
                try {
                    double d = TclDouble.get(this.sortInterp, object);
                    double d2 = TclDouble.get(this.sortInterp, object2);
                    if (d > d2) {
                        n = 1;
                        break;
                    }
                    if (!(d2 > d)) break;
                    n = -1;
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to real)");
                    throw tclException;
                }
            }
            case 3: {
                stringBuffer = new StringBuffer(this.sortCommand);
                Util.appendElement(this.sortInterp, stringBuffer, object.toString());
                Util.appendElement(this.sortInterp, stringBuffer, object2.toString());
                try {
                    this.sortInterp.eval(stringBuffer.toString(), 0);
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (user-defined comparison command)");
                    throw tclException;
                }
                try {
                    n = TclInteger.get(this.sortInterp, this.sortInterp.getResult());
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.resetResult();
                    TclException tclException2 = new TclException(this.sortInterp, "comparison command returned non-numeric result");
                    throw tclException2;
                }
            }
            default: {
                throw new TclRuntimeError("Unknown sortMode " + this.sortMode);
            }
        }
        if (this.sortIncreasing) {
            return n;
        }
        return -n;
    }

    private final int doDictionary(String string, String string2) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = string2.length();
        block0: while (bl) {
            if (n3 >= n5 || n4 >= n6) break;
            if (Character.isDigit(string2.charAt(n4)) && Character.isDigit(string.charAt(n3))) {
                int n7 = 0;
                while (n4 < n6 - 1 && string2.charAt(n4) == '0') {
                    ++n4;
                    --n7;
                }
                while (n3 < n5 - 1 && string.charAt(n3) == '0') {
                    ++n3;
                    ++n7;
                }
                if (n2 == 0) {
                    n2 = n7;
                }
                n = 0;
                do {
                    if (n3 >= n5 || n4 >= n6) {
                        bl = false;
                        continue block0;
                    }
                    if (n == 0) {
                        n = string.charAt(n3) - string2.charAt(n4);
                    }
                    if (++n3 >= n5 || ++n4 >= n6) {
                        bl = false;
                        continue block0;
                    }
                    if (Character.isDigit(string2.charAt(n4))) continue;
                    if (Character.isDigit(string.charAt(n3))) {
                        return 1;
                    }
                    if (n == 0) continue block0;
                    return n;
                } while (Character.isDigit(string.charAt(n3)));
                return -1;
            }
            n = string.charAt(n3) - string2.charAt(n4);
            if (n != 0) {
                if (Character.isUpperCase(string.charAt(n3)) && Character.isLowerCase(string2.charAt(n4))) {
                    n = Character.toLowerCase(string.charAt(n3)) - string2.charAt(n4);
                    if (n != 0) {
                        return n;
                    }
                    if (n2 == 0) {
                        n2 = -1;
                    }
                } else if (Character.isUpperCase(string2.charAt(n4)) && Character.isLowerCase(string.charAt(n3))) {
                    n = string.charAt(n3) - Character.toLowerCase(string2.charAt(n4));
                    if (n != 0) {
                        return n;
                    }
                    if (n2 == 0) {
                        n2 = 1;
                    }
                } else {
                    return n;
                }
            }
            ++n3;
            ++n4;
        }
        if (n3 >= n5 && n4 < n6) {
            if (!Character.isDigit(string2.charAt(n4))) {
                return 1;
            }
            return -1;
        }
        if (n4 >= n6 && n3 < n5) {
            if (!Character.isDigit(string.charAt(n3))) {
                return -1;
            }
            return 1;
        }
        if (n == 0) {
            n = n2;
        }
        return n;
    }

    QSort() {
    }
}

