/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.ZonedTransverseMercator;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.TransverseMercator;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class ZonedGridSystem
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -7219325241026170925L;
    private static final double RANGE = 360.0;
    private static final double ZONE_SCALE = 1000000.0;
    final double initialLongitude;
    final double zoneWidth;
    final AbstractMathTransform projection;
    private final MathTransform2D inverse;

    public ZonedGridSystem(OperationMethod operationMethod, Parameters parameters, MathTransformFactory mathTransformFactory) throws FactoryException {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.TransverseMercator.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_NORTHING);
        Initializer initializer = new Initializer(operationMethod, parameters, enumMap, 0);
        this.initialLongitude = initializer.getAndStore(ZonedTransverseMercator.INITIAL_LONGITUDE);
        this.zoneWidth = initializer.getAndStore(ZonedTransverseMercator.ZONE_WIDTH);
        MatrixSIS matrixSIS = initializer.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        matrixSIS.convertBefore(0, null, this.zoneWidth / -2.0);
        this.projection = (AbstractMathTransform)new TransverseMercator(initializer).createMapProjection(mathTransformFactory);
        this.inverse = new Inverse();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.projection.getParameterValues();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n] - this.initialLongitude;
        double d2 = dArray[n + 1];
        d -= 360.0 * Math.floor(d / 360.0);
        double d3 = Math.floor(d / this.zoneWidth);
        dArray2[n2] = d -= d3 * this.zoneWidth;
        dArray2[n2 + 1] = d2;
        Matrix matrix = this.projection.transform(dArray2, n2, dArray2, n2, bl);
        int n3 = n2;
        dArray2[n3] = dArray2[n3] + (d3 + 1.0) * 1000000.0;
        return matrix;
    }

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        long l = Double.doubleToLongBits(this.initialLongitude) + 31L * Double.doubleToLongBits(this.zoneWidth);
        return (super.computeHashCode() ^ Numerics.hashCode(l)) + 37 * this.projection.hashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            ZonedGridSystem zonedGridSystem = (ZonedGridSystem)object;
            return Numerics.equals(this.initialLongitude, zonedGridSystem.initialLongitude) && Numerics.equals(this.zoneWidth, zonedGridSystem.zoneWidth) && this.projection.equals(zonedGridSystem.projection, comparisonMode);
        }
        return false;
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        private static final long serialVersionUID = 1900563285661407519L;
        private final AbstractMathTransform inverseProjection;

        Inverse() throws FactoryException {
            super(ZonedGridSystem.this);
            try {
                this.inverseProjection = (AbstractMathTransform)ZonedGridSystem.this.projection.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new FactoryException(noninvertibleTransformException);
            }
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.floor(d / 1000000.0) - 1.0;
            dArray2[n2] = d -= (d3 + 1.0) * 1000000.0;
            dArray2[n2 + 1] = d2;
            Matrix matrix = this.inverseProjection.transform(dArray2, n2, dArray2, n2, bl);
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + (d3 * ZonedGridSystem.this.zoneWidth + ZonedGridSystem.this.initialLongitude);
            return matrix;
        }
    }
}

