#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine  TekD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term, fid)


******************************************************************
*                                                                *
*   Subroutine Device_Tektronix_4014/4014 (Enhanced)             *
*                                                                *
*      This subroutine is a device dependent routine, used       *
*      to plot the object stored in XC & YC with NC points.      *
*      The XC & YC arrays are stored in normalized device        *
*      coordinates, the points are converted into tektronix      *
*      device, and then the plotting commands for point and      *
*      line mode are used to do the actual graphing.             *
*                                                                *
*      The points stored in the XC & YC array is the clipped     *
*      plot. The object is stored as a series of points, or      *
*      a series of line segments; depending if a point or        *
*      continuous plot is desired.                               *
*                                                                *
******************************************************************


        Integer    cont, point, discrt, bar, marker, fid
        Parameter (cont = 1, point = 2, discrt = 3, bar = 4, marker = 5)

        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Integer        CType(3)
        Common /lntyp/ CType
        Save   /lntyp/
 
        Real     XC(maxC,num), YC(maxC,num), golden
        Integer  NumCrv, NC(NumCrv), CrvTyp(3), NumTic(2), term 

        Character hiX1, lwX1, hiY1, lwY1, extr1
        Character hiX2, lwX2, hiY2, lwY2, extr2
        Character Bars(20)
        Integer   TXmax, TXmin, DXmax, DXmin, DYmax, DYmin, 
     +            Tx, Ty, I, J, legend

        Character  typln(5)
        Character  PntTyp(5)
        Data       PntTyp /'*','+','0','x','o'/
        Data       typln /'`','a','b','c','d'/

*       (* clears the screen. *)
        Call clear(term)

        golden = (sqrt(5.0) + 1.0)/2.0
        DYmax = 2690
        DYmin = 620
        DXmin = 600
        DXmax = (DYmax - DYmin)*golden + DXmin
        legend = 450

*       (* The routine to draw all the graphic peripherals. *)
        Call TekBox(term, NumTic, DXmax, DXmin, DYmax, DYmin, fid)

        DO 100 J = 1, NumCrv

          Write (fid,10) Char(29), Char(27), typln(Ctype(J)), Char(31)
  10      Format(4a1)

*         (* Check to see what type of plot is desired. *)

          IF (CrvTyp(j) .EQ. discrt) THEN

*           (* Then convert, position, and vector the line segments. *)
            DO 200 I = 1, NC(J)
*             (* Position the point to the bottom of the x-axis. *)
              Tx = XC(I,J)*(DXmax - DXmin) +DXmin
              Ty = DYmin
              Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)

*             (* Vector to the top of the 'y' position. *)
              Ty = (DYmax - DYmin)*YC(I,J) +DYmin
              Call tekcrd(Tx, Ty, hiY2, lwY2, hiX2, lwX2, extr2)

              Write (fid,30) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, extr2, lwY2, hiX2, lwX2, Char(31)
   30         Format (12a1)
  200       CONTINUE

          ELSE IF (CrvTyp(j) .EQ. bar) THEN

            TXmax = XC(1,J)
            TXmin = XC(1,J)

*           (* Then convert, position, and vector the line segments. *)
            DO 300 I = 1, NC(J) -1

              IF (TXmax .LT. XC(I,J)) TXmax = XC(I,J)
              IF (TXmin .GT. XC(I,J)) TXmin = XC(I,J)

*             (* Position the point on the x-axis. *)
              Tx = XC(I,J)*(DXmax - DXmin) +DXmin
              Ty = DYmin
              Call tekcrd(Tx, Ty, Bars(1), Bars(3), Bars(4), 
     +                    Bars(5), Bars(2))

*             (* Vector to the top of the 'y' position. *)
              Ty = (DYmax - DYmin)*YC(I,J) +DYmin
              Call tekcrd(Tx, Ty, Bars(6), Bars(8), Bars(9), 
     +                    Bars(10), Bars(7))

              Tx = (DXmax - DXmin)*XC(I+1,J) +DXmin
              Call tekcrd(Tx, Ty, Bars(11), Bars(13), Bars(14), 
     +                    Bars(15), Bars(12))

              Ty = DYmin
              Call tekcrd(Tx, Ty, Bars(16), Bars(18), Bars(19), 
     +                    Bars(20), Bars(17))

              Write (fid,40) Char(29), Bars, Char(31)
   40         Format (a1,20a1,a1)
  300       CONTINUE

*           (* Repeat the process for the last point. *)
              Tx = XC(NC(J),J)*(DXmax - DXmin) +DXmin
              Call tekcrd(Tx, DYmin, Bars(1), Bars(3), Bars(4), 
     +                    Bars(5), Bars(2))
              Ty = (DYmax - DYmin)*YC(NC(J),J) +DYmin
              Call tekcrd(Tx, Ty, Bars(6), Bars(8), Bars(9), 
     +                    Bars(10), Bars(7))

              IF ((Tx +(TXmax - TXmin)/NC(J)) .LT. DXmax) THEN
                Tx = Tx + (TXmax - TXmin)/NC(J)
              ELSE
                Tx = DXmax
              ENDIF

              Call tekcrd(Tx, Ty, Bars(11), Bars(13), Bars(14), 
     +                    Bars(15), Bars(12))
              Call tekcrd(Tx, DYmin, Bars(16), Bars(18), Bars(19),
     +                    Bars(20), Bars(17))
              Write (fid,40) Char(29), Bars, Char(31)

          ELSE
            IF (CrvTyp(j) .EQ. cont .OR. CrvTyp(j) .EQ. marker) THEN

*             (* Then convert, position, and vector the line segments. *)
              DO 400 I = 1, NC(J), 2
*               (* Position the first point. *)
                Tx = XC(I,J)*(DXmax - DXmin) + DXmin
                Ty = YC(I,J)*(DYmax - DYmin) + DYmin
                Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)

*               (* Vector to the second point. *)
                Tx = XC(I+1,J)*(DXmax - DXmin) + DXmin
                Ty = YC(I+1,J)*(DYmax - DYmin) + DYmin
                Call tekcrd(Tx, Ty, hiY2, lwY2, hiX2, lwX2, extr2)

                Write (fid,30) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                      hiY2, extr2, lwY2, hiX2, lwX2, Char(31)
  400         CONTINUE
            ENDIF

            IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN

*             (* Then position the point, and mark it. *)
              DO 500 I = 1, NC(J)
*               (* Position the point. *)
                Tx = XC(I,J)*(DXmax - DXmin) + DXmin
                Ty = YC(I,J)*(DYmax - DYmin) + DYmin
                Call tekcrd(Tx-20, Ty-23, hiY1, lwY1, hiX1, lwX1, extr1)
                Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                        Char(31), PntTyp(J)
   50           Format (7a1,a1)
  500         CONTINUE
            ENDIF

          ENDIF

          IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN
            Call tekcrd(legend, 200, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,60) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                   Char(31), crv(j), (PntTyp(J), I=1,5)
   60       Format (7a1,1x,a7,' ',5(' ',a1))
          ENDIF

          IF (CrvTyp(j) .NE. point) THEN
            Call tekcrd(legend, 200, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,70) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                   Char(31), crv(j)
   70       Format (7a1,1x,a7,)
            Call tekcrd(legend +500, 245, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(legend +1050,245, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,30) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                   hiY2, extr2, lwY2, hiX2, lwX2, Char(31)
          ENDIF
          legend = legend + 1200
  100   CONTINUE

        Tx = 0
        Ty = 100
        Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)
        Write (fid,80) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, Char(31)
   80   Format(7a1)
        Read (*,'(a1)') 

        RETURN
        END
