;;; ucs-irv.el --- C0 Controls and Basic Latin

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, C0 Controls, Basic Latin

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(let ((i 0))
  (while (<= i 32)
    (ucs-set-char i (make-char 'ascii i))
    (setq i (1+ i))
    )
  (while (<= i 126)
    (or (memq i '(?\\ ?~))
	(ucs-set-char i (make-char 'latin-jisx0201 i)))
    (ucs-set-char i (make-char 'ascii i))
    (setq i (1+ i))
    )
  )

(ucs-set-char 127 (make-char 'ascii 127))

;;; ucs-irv.el ends here
