/* LocaleInformation_cs.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_cs extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|MKD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|XBC|XBB|XBA|KID|SHP";

  private static final String currenciesDisplayNameValues = "Din\u00e1r jord\u00e1nsk\u00fd|Mvdol|Zlato|Koruna Faersk\u00fdch ostrov\u016f|Libra libanonsk\u00e1|Euro|\u0160ilink tanzansk\u00fd|Peso|Riel|Asijsk\u00e1 pen\u011b\u017en\u00ed jednotka|Boliviano (1863-1962)|Riel star\u00fd|Libra zambijsk\u00e1|Libra australsk\u00e1|Frank BEAC/CFA|Libra maltsk\u00e1|Ghana Revalued Cedi|Kwacha|Libra ghansk\u00e1|Boliviano|Ghana Old Cedi|Lira maltsk\u00e1|Dolar australsk\u00fd|Dolar americk\u00fd (t\u00fd\u017e den)|Lira italsk\u00e1|Dolar americk\u00fd (p\u0159\u00ed\u0161t\u00ed den)|Cedi|Dolar singapursk\u00fd|Balboa|Kip|Som|Frank \u0161v\u00fdcarsk\u00fd|\u0160ilink|Dolar americk\u00fd|Dolar etiopsk\u00fd|Dolar brunejsk\u00fd|Libra jamajsk\u00e1|Birr etiopsk\u00fd|Frank al\u017e\u00edrsk\u00fd germinal|Frank nov\u00fd al\u017e\u00edrsk\u00fd|Din\u00e1r al\u017e\u00edrsk\u00fd|Guarani|Libra lybijsk\u00e1|Dolar jamajsk\u00fd|Koruna islandsk\u00e1|Peseta \u0161pan\u011blsk\u00e1|Libra bermudsk\u00e1|Din\u00e1r lybijsk\u00fd|Dolar bermudsk\u00fd|Zlat\u00fd holandsk\u00fd|Ouguiya|Rij\u00e1l \u00edr\u00e1nsk\u00fd|Koruna \u0161v\u00e9dsk\u00e1|Nakfa|\u0160ilink ke\u0148sk\u00fd|Frank St\u0159edoafrick\u00e9 republiky CFA|Peso argentinsk\u00e9|Peso argentinsk\u00e9 (1983-1985)|Peso argentinsk\u00e9 Moneda Nacional|Dolar tchajvansk\u00fd nov\u00fd|Libra s\u00fad\u00e1nsk\u00e1|Lari|Georgian Kupon Larit|Frank martiniksk\u00fd|Libra falklandsk\u00e1|Austral|Din\u00e1r s\u00fad\u00e1nsk\u00fd|Din\u00e1r ir\u00e1ck\u00fd|Dolar tuvalsk\u00fd|Rupie seychelsk\u00e1|Rubl loty\u0161sk\u00fd|Libra fid\u017eijsk\u00e1|Lat loty\u0161sk\u00fd|Zaire kon\u017esk\u00fd|Frank Kon\u017esk\u00e9 republiky|Frank kon\u017esk\u00fd|Dolar fid\u017eijsk\u00fd|Cordoba oro|Pataca|Cordoba zlat\u00e1|Cordoba|Markka (1860-1962)|Markka|Dolar \u0160alamounov\u00fdch ostrov\u016f|Frank lucembursk\u00fd|Dolar star\u00fd Trinidad a Tobago|Escudo angolsk\u00e9|Kwanza reajustado (1995-1999)|Tugrik|Forint|Frank burundsk\u00fd|Kwanza nov\u00e1 (1990-2000)|Kwanza (1977-1990)|Dolar Trinidad a Tobago|Lilangeni|Frank Nov\u00fdch Hebrid CFP|Libra \u0161terlink\u016f|Rij\u00e1l saudsk\u00fd sovereign|Rij\u00e1l saudsk\u00fd|Talon|Rupie indick\u00e1|Escudo portugalsk\u00e9|Kwanza|Conto portugalsk\u00e9|Litus litevsk\u00fd|Tenge|Rubl kaza\u0161sk\u00fd|Dolar Britsk\u00fdch Panensk\u00fdch ostrov\u016f|Libra nigerijsk\u00e1|Naira|Gourde|Libra syrsk\u00e1|Libra palestinsk\u00e1|Din\u00e1r bahrajnsk\u00fd|Kyat|Zlat\u00fd Nizozemsk\u00fdch Antil|Koruna \u010desk\u00e1|Libra \u0161terlink\u016f Ostrov Man|Loti|Frank gabonsk\u00fd CFA|Lev Bulharsk\u00fd (1879-1952)|Lev Bulharsk\u00fd|Lev Bulharsk\u00fd socialistick\u00fd|Dolar kanadsk\u00fd|Lev|Lira tureck\u00e1|Dolar Kajmansk\u00fdch ostrov\u016f|Libra kypersk\u00e1|\u0160ekel nov\u00fd izraelsk\u00fd|Dolar guyansk\u00fd|Dram arm\u00e9nsk\u00fd|Libra izraelsk\u00e1|Frank malijsk\u00fd|\u0160ekel izraelsk\u00fd|Bolivar|Dolar liberijsk\u00fd|Albanian Lek Valute|Kuna chorvatsk\u00e1|Frank Reunion|Dinar chorvatsk\u00fd|Lek|Libra \u0161terlink\u016f Jersey|Lek (1946-1961)|Den\u00e1r (1992-1993)|Den\u00e1r|Pataca timorsk\u00e1|Frank CFP|Frank finan\u010dn\u00ed|Peso Guinnea-Bissau|Din\u00e1r kuvajtsk\u00fd|Portuguese Guinea Mil Reis|Frank belgick\u00fd|Escudo timorsk\u00e9|Frank konvertibiln\u00ed|Escudo guinejsk\u00e9|Colon salvadorsk\u00fd|Zlat\u00fd Curacao|Taka|Libra \u0161terlink\u016f ton\u017esk\u00e1|Frank BCEAO/CFA|Rubl|Rubl nov\u00fd|Frank Nov\u00e9 Kaledonie germinal|Escudo kapverdsk\u00e9|Frank Francouzsk\u00fdch Antil CFA|Rand|Peso dominik\u00e1nsk\u00e9|Libra jihoafrick\u00e1|Rand finan\u010dn\u00ed|Din\u00e1r tunisk\u00fd|Peso kub\u00e1nsk\u00e9|French Guyana Franc Guiana|\u0160ilink ugandsk\u00fd|Rupie cejlonsk\u00e1|Affars and Issas Franc|Lira Vatik\u00e1nu|Escudo Svat\u00e9ho Tom\u00e1\u0161e|\u0160ilink ugandsk\u00fd (1966-1987)|Dobra|Dolar Marshallov\u00fdch ostrov\u016f|Libra novoz\u00e9landsk\u00e1|Tala|Libra Z\u00e1padn\u00ed Samoa|Lempira|Manat|Quetzal|Dolar novoz\u00e9landsk\u00fd|Libra skotsk\u00e1|Dolar barbadosk\u00fd|Dolar namibijsk\u00fd|Frank madagaskarsk\u00fd|Ariary madagaskarsk\u00fd|Libra egyptsk\u00e1|Dolar Britsk\u00e9ho Hondurasu|Zlot\u00fd (1950-1995)|Nov\u00fd Din\u00e1r Bosny a Hercegoviny|Marka konvertibiln\u00ed|Dolar belizsk\u00fd|Din\u00e1r Bosny a Hercegoviny|Zlot\u00fd|Rij\u00e1l jemensk\u00fd|Zlat\u00fd surinamsk\u00fd|Koruna \u010deskoslovensk\u00e1|Won jihokorejsk\u00fd|Rubl b\u011blorusk\u00fd|Rij\u00e1l jemensk\u00fd imadi|Rubl b\u011blorusk\u00fd (1992-1994)|Koruna \u010deskoslovensk\u00e1|Won star\u00fd jihokorejsk\u00fd|Hwan jihokorejsk\u00fd|Rubl nov\u00fd b\u011blorusk\u00fd (1994-1999)|Somaliland Shilling|Drachma nov\u00e1 \u0159eck\u00e1|Rupie p\u00e1kist\u00e1nsk\u00e1|Afgh\u00e1n|Dolar zimbabwsk\u00fd|Rupie sr\u00edlansk\u00e1|Drachma|Libra irsk\u00e1|Afgh\u00e1n (1927-2002)|Din\u00e1r jemensk\u00fd|Frank rwandsk\u00fd|Col\u00f3n kostarick\u00fd|Somoni|Tajikistan Ruble|Kroon|Equatorial Guinea Peseta Guineana|Moldovan Ruble Cupon|Dolar hongkongsk\u00fd|Koruna d\u00e1nsk\u00e1|Leu moldavsk\u00fd|Equatorial Guinea Franco|Equatorial Guinea Ekwele Guineana|Rupie indon\u00e9zsk\u00e1|Dirham SAE|Won severokorejsk\u00fd|Indonesian New Rupiah|Pula|Moldovan Leu Cupon|Indonesian Java Rupiah|Indonesian Nica Guilder|Vatu|Din\u00e1r isl\u00e1msk\u00fd|\u0160ilink som\u00e1lsk\u00fd|Peseta andorrsk\u00e1|Rubl rusk\u00fd (1991-1998)|Frank guadeloupsk\u00fd|Frank d\u017eibutsk\u00fd|Diner andorrsk\u00fd|Frank monack\u00fd germinal|Frank nouveau monack\u00fd|Ecuador Unidad de Valor Constante (UVC)|Sucre ekv\u00e1dorsk\u00fd|Frank lichten\u0161tejnsk\u00fd|Rubl rusk\u00fd|Peso filip\u00ednsk\u00e9|Sum uzbeck\u00fd|Peso kolumbijsk\u00e9|Baht|Libra severoirsk\u00e1|Rupie barmsk\u00e1|Krank kon\u017esk\u00fd CFA|Kyat barmsk\u00fd|Peso kolumbijsk\u00e9|Uzbekistan Coupon Som|Karbovanec|Rij\u00e1l katarsk\u00fd|H\u0159ivna|Guinea Syli|Juan renminbi|Metical|Dolar lidov\u00e9 banky|Peso uruguaysk\u00e9|Frank guinejsk\u00fd (1960-1972)|Lira San Marino|Escudo Mosambiku|Juan jen min piao|Kina|Rij\u00e1l om\u00e1nsk\u00fd saidi|Frank guinejsk\u00fd|Peso uruguaysk\u00e9 (1975-1993)|Rij\u00e1l om\u00e1nsk\u00fd|Frank UIC|Zaire|Rupie bh\u00fat\u00e1nsk\u00e1|Frank marock\u00fd|Dirham marock\u00fd|Ngultrum|Frank zlat\u00fd|Peso uruguaysk\u00e9 fuerte|Ringgit malajskijsk\u00fd|Zaire nov\u00fd|Manat \u00e1zerbajd\u017e\u00e1nsk\u00fd|Libra gambijsk\u00e1|Frank komorsk\u00fd|Dalasi|Evropsk\u00e1 m\u011bnov\u00e1 jednotka|Libra bahamsk\u00e1|Frank kamerunsk\u00fd CFA|Mexican Unidad de Inversion (UDI)|Frank BCEAEC/CFA|Dolar bahamsk\u00fd|Peso st\u0159\u00edbrn\u00e9 mexick\u00e9 (1861-1992)|Peso mexick\u00e9|Sol|Greenland Krone|Cruzeiro (1942-1967)|Nuevo sol|Peso chilsk\u00e9|Koruna slovensk\u00e1|Inti|Cruzeiro real|SDR|Frank francouzsk\u00fd germinal/Frank poincare|Frank francouzsk\u00fd|Cruzado nov\u00e9|Unidades de fomento|Escudo chilsk\u00e9|Real brazilsk\u00fd|Condor chilsk\u00fd|Cruzeiro (1990-1993)|Sperrmark n\u011bmeck\u00e1|Libra malawijsk\u00e1|Cruzado|Cruzeiro (1967-1986)|Kwacha|Transdniestria Ruble|Marka n\u011bmeck\u00e1|Frank \u010dadsk\u00fd CFA|Transdniestria New Ruble|Transdniestria Ruble Kupon|Rupie nep\u00e1lsk\u00e1|Dolar Cookov\u00fdch ostrov\u016f|Jen|Rufiyaa|Frank Nouveau CFA|Rupie maledivsk\u00e1|Dolar v\u00fdchodokaribsk\u00fd|Tolar|Din\u00e1r jugosl\u00e1vsk\u00fd reformovan\u00fd|Zlat\u00fd arubsk\u00fd|Marka NDR|Din\u00e1r jugosl\u00e1vsk\u00fd|Din\u00e1r jugosl\u00e1vsk\u00fd|Koruna Turks a Caicos|Din\u00e1r jugosl\u00e1vsk\u00fd 1994|Din\u00e1r jugosl\u00e1vsk\u00fd federativn\u00ed|Lei nov\u00fd|Din\u00e1r jugosl\u00e1vsk\u00fd nov\u00fd|Lei|Slovenia Tolar Bons|Koruna norsk\u00e1|Rupie mauricijsk\u00e1|Evropsk\u00e1 jednotka \u00fa\u010dtu 17 (XBD)|Libra gibraltarsk\u00e1|Evropsk\u00e1 jednotka \u00fa\u010dtu 9 (XBC)|Evropsk\u00e1 pen\u011b\u017en\u00ed jednotka|Evropsk\u00e1 sm\u00ed\u0161en\u00e1 jednotka|Dolar kiribatsk\u00fd|Libra Svat\u00e9 Heleny";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|MKD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|MYR|ZRN|AZM|GMP|KMF|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|XBC|XBB|XBA|KID|SHP";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|INR|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|NGN|HTG|LS|PSP|BD|MMK|NA f.|K\u010d|IMP|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3|ILS|G$|dram|ILP|MLF|ILL|Be|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|MDen|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|MZE|CNP|PGK|OMS|GF|UYP|RO|XFU|ZRZ|BTR|MAF|MAD|XFO|Nu|UYF|RM|ZRN|AZM|GMP|CF|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|XBC|XBB|XBA|KID|SHP";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "1.",
    "2.",
    "3.",
    "4.",
    "5.",
    "6.",
    "7.",
    "8.",
    "9.",
    "10.",
    "11.",
    "12.",
    null,
  };

  private static final String[] months = {
    "Leden",
    "\u00danor",
    "B\u0159ezen",
    "Duben",
    "Kv\u011bten",
    "\u010cerven",
    "\u010cervenec",
    "Srpen",
    "Z\u00e1\u0159\u00ed",
    "\u0158\u00edjen",
    "Listopad",
    "Prosinec",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "ne",
    "po",
    "\u00fat",
    "st",
    "\u010dt",
    "p\u00e1",
    "so",
  };

  private static final String[] weekdays = {
    null,
    "ned\u011ble",
    "pond\u011bl\u00ed",
    "\u00fater\u00fd",
    "st\u0159eda",
    "\u010dtvrtek",
    "p\u00e1tek",
    "sobota",
  };

  private static final String[] eras = {
    "p\u0159.Kr.",
    "po Kr.",
  };

  private static final String[] ampms = {
    "dop.",
    "odp.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Pacifick\u00fd standardn\u00ed \u010das", "PDT", "Pacifick\u00fd letn\u00ed \u010das",  "America/Los_Angeles" },
    { "GMT", "Greenwichsk\u00fd st\u0159edn\u00ed \u010das", "GMT", "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",  "Africa/Casablanca" },
    { "EST", "V\u00fdchodn\u00ed standardn\u00ed \u010das", "EDT", "V\u00fdchodn\u00ed letn\u00ed \u010das",  "America/New_York" },
    { "AST", "Alja\u0161sk\u00fd standardn\u00ed \u010das", "ADT", "Alja\u0161sk\u00fd letn\u00ed \u010das",  "America/Anchorage" },
    { "GMT", "Greenwichsk\u00fd st\u0159edn\u00ed \u010das", "GMT", "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",  "Etc/GMT" },
    { "CTT", "\u010c\u00ednsk\u00fd standardn\u00ed \u010das", "CDT", "\u010c\u00ednsk\u00fd standardn\u00ed \u010das",  "Asia/Shanghai" },
    { "AST", "Atlantick\u00fd standardn\u00ed \u010das", "ADT", "Atlantick\u00fd letn\u00ed \u010das",  "America/Halifax" },
    { "CET", "St\u0159edoevropsk\u00fd standardn\u00ed \u010das", "CEST", "St\u0159edoevropsk\u00fd letn\u00ed \u010das",  "Europe/Paris" },
    { "MST", "Horsk\u00fd standardn\u00ed \u010das", "MDT", "Horsk\u00fd letn\u00ed \u010das",  "America/Denver" },
    { "IST", "Izraelsk\u00fd standardn\u00ed \u010das", "IDT", "Izraelsk\u00fd letn\u00ed \u010das",  "Asia/Jerusalem" },
    { "HST", "Havajsk\u00fd standardn\u00ed \u010das", "HST", "Havajsk\u00fd standardn\u00ed \u010das",  "Pacific/Honolulu" },
    { "CNT", "Newfoundlandsk\u00fd standardn\u00ed \u010das", "CDT", "Newfoundlandsk\u00fd letn\u00ed \u010das",  "America/St_Johns" },
    { "EST", "V\u00fdchodn\u00ed standardn\u00ed \u010das", "EST", "V\u00fdchodn\u00ed standardn\u00ed \u010das",  "America/Indianapolis" },
    { "CST", "Centr\u00e1ln\u00ed standardn\u00ed \u010das", "CDT", "Centr\u00e1ln\u00ed letn\u00ed \u010das",  "America/Chicago" },
    { "EET", "V\u00fdchodoevropsk\u00fd standardn\u00ed \u010das", "EEST", "V\u00fdchodoevropsk\u00fd letn\u00ed \u010das",  "Europe/Bucharest" },
    { "JST", "Japonsk\u00fd standardn\u00ed \u010das", "JST", "Japonsk\u00fd standardn\u00ed \u010das",  "Asia/Tokyo" },
    { "MST", "Horsk\u00fd standardn\u00ed \u010das", "MST", "Horsk\u00fd standardn\u00ed \u010das",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "V\u00fdchodn\u00ed Timor|Tokelau|T\u00e1d\u017eikist\u00e1n|Thajsko|Togo|Francouzsk\u00e1 ji\u017en\u00ed teritoria|Guyana|\u010cad|Ostrovy Caicos a Turks|Guinea-Bissau|Guam|Guatemala|Ji\u017en\u00ed Georgie a Ji\u017en\u00ed Sandwichovy ostrovy|\u0158ecko|Rovn\u00edkov\u00e1 Guinea|Guadeloupe|Svazijsko|S\u00fdrie|Guinea|Gambie|Gr\u00f3nsko|El Salvador|Svat\u00fd Tom\u00e1\u0161|Gibraltar|Ghana|Surinam|Francouzsk\u00e1 Guyana|Serbia|Gruzie|Som\u00e1lsko|Grenada|Senegal|San Marino|Velk\u00e1 Brit\u00e1nie|Sierra Leone|Gabon|Slovensko|Svalbard a Jan Mayen|Slovinsko|Svat\u00e1 Helena|Singapur|\u0160v\u00e9dsko|S\u00fad\u00e1n|Seychely|\u0160alamounovy ostrovy|Sa\u00fadsk\u00e1 Ar\u00e1bie|Francie|Faersk\u00e9 ostrovy|Mikron\u00e9sie, federativn\u00ed st\u00e1t|Rwanda|Falklandsk\u00e9 ostrovy|Rusko|Fid\u017ei|Finsko|Rumunsko|R\u00e9union|Etiopie|\u0160pan\u011blsko|Eritrea|Z\u00e1padn\u00ed Sahara|Egypt|Estonsko|Ekv\u00e1dor|Al\u017e\u00edrsko|Katar|Dominik\u00e1nsk\u00e1 republika|Paraguay|Dominika|Palau|D\u00e1nsko|D\u017eibuti|Portugalsko|Palestinian Territory|Portoriko|N\u011bmecko|Pitcairn|Svat\u00fd Pierre a Miquelon|Polsko|P\u00e1kist\u00e1n|Filip\u00edny|Papua-Nov\u00e1 Guinea|Francouzsk\u00e1 Polyn\u00e9sie|\u010cesk\u00e1 republika|Peru|Kypr|V\u00e1no\u010dn\u00ed ostrovy|Kapverdy|Panama|Kuba|Kostarika|Kolumbie|\u010c\u00edna|Kamerun|Chile|Cookovy ostrovy|Pob\u0159e\u017e\u00ed slonoviny|\u0160v\u00fdcarsko|Kongo|St\u0159edoafrick\u00e1 republika|Kongo, demokratick\u00e1 republika|Kokosov\u00e9 ostrovy|Om\u00e1n|Kanada|Belize|B\u011blorusko|Botswana|Ostrov Bouvet|Bh\u00fat\u00e1n|Bahamy|Braz\u00edlie|Nov\u00fd Z\u00e9land|Bol\u00edvie|Brunej Darussalam|Bermudy|Niue|Benin|Burundi|Bahrajn|Nauru|Bulharsko|Burkina Faso|Nep\u00e1l|Belgie|Norsko|Banglad\u00e9\u0161|Barbados|Zimbabwe|Nizozemsko|Bosna a Hercegovina|Nikaragua|Nig\u00e9rie|Norfolk|\u00c1zerb\u00e1jd\u017e\u00e1n|Niger|Nov\u00e1 Kaledonie|Aruba|Zambie|Namibie|Austr\u00e1lie|Rakousko|Americk\u00e1 Samoa|Argentina|Antarktida|Mosambik|Angola|Malajsie|Nizozemsk\u00e9 Antily|Mexiko|Arm\u00e9nie|Malawi|Alb\u00e1nie|Maladivy|Ji\u017en\u00ed Afrika|Mauricius|Malta|Anguila|Montserrat|Maurit\u00e1nie|Antigua a Barbuda|Martinik|Afgh\u00e1nist\u00e1n|Severn\u00ed Mariany|Spojen\u00e9 arabsk\u00e9 emir\u00e1ty|Macao S.A.R., China|Andorra|Mongolsko|Myanmar (Burma)|Mali|Macedonia|Jugosl\u00e1vie|Mayotte|Marshallovy ostrovy|Madagaskar|Moldavsko, republika|Monako|Maroko|Jemen|Libye|Loty\u0161sko|Lucembursko|Litva|Lesotho|Lib\u00e9rie|Sr\u00ed Lanka|Lichten\u0161tejnsko|Svat\u00e1 Lucie|Libanon|Lidov\u011b demokratick\u00e1 republika Laos|Kazachst\u00e1n|Kajmansk\u00e9 ostrovy|Kuvajt|Ji\u017en\u00ed Korea|Severn\u00ed Korea|Svat\u00fd Kitts a Nevis|Komory|Kiribati|Samoa|Kambod\u017ea|Kyrgyzst\u00e1n|Ke\u0148a|Wallis a Futuna|Japonsko|Jord\u00e1nsko|Jamajka|Vanuatu|Vietnam|Americk\u00e9 Panensk\u00e9 ostrovy|Britsk\u00e9 Panensk\u00e9 ostrovy|Venezuela|Svat\u00fd Vincent a Grenadiny|Svat\u00fd stolec|It\u00e1lie|Island|\u00cdr\u00e1n|Ir\u00e1k|Uzbekist\u00e1n|Britsk\u00e9 \u00fazem\u00ed v Indick\u00e9m oce\u00e1nu|Uruguay|Indie|Izrael|Spojen\u00e9 st\u00e1ty|Irsko|Indon\u00e9sie|Men\u0161\u00ed odlehl\u00e9 ostrovy USA|Uganda|Ukrajina|Ma\u010farsko|Haiti|Chorvatsko|Tanzanie|Honduras|Ostrovy Heard a McDonald|Tchaj-wan|Tuvalu|Hongkong, zvl\u00e1\u0161tn\u00ed administrativn\u00ed oblast \u010c\u00edny|Trinidad a Tobago|Turecko|Tonga|Tunisko|Turkmenist\u00e1n";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u0160pan\u011bl\u0161tina|Kurd\u0161tina|Esperanto|Ka\u0161m\u00edr\u0161tina|Angli\u010dtina|\u0158e\u010dtina|Ke\u010du\u00e1n\u0161tina|Korej\u0161tina|Kannad\u0161tina|Kambod\u017e\u0161tina|Gr\u00f3n\u0161tina|Kazach\u0161tina|Wolof|Gruz\u00edn\u0161tina|Bh\u00fat\u00e1n\u0161tina|Jav\u00e1n\u0161tina|Portugal\u0161tina|Pashto (Pushto)|N\u011bm\u010dina|Pol\u0161tina|D\u00e1n\u0161tina|Volapuk|Japon\u0161tina|Vietnam\u0161tina|Vel\u0161tina|Pa\u0148d\u017e\u00e1b\u0161tina|\u010ce\u0161tina|Inuktitut\u0161tina|Ital\u0161tina|Korsi\u010dtina|Island\u0161tina|Uzbe\u010dtina|Oriya|Inupiak\u0161tina|Urd\u0161tina|Oromo (Afan)|Katal\u00e1n\u0161tina|Interlingue|Indon\u00e9\u0161tina|Ukrajin\u0161tina|Interlingua|Occitan|Uighur\u0161tina|Arm\u00e9n\u0161tina|Breta\u0148\u0161tina|Ma\u010far\u0161tina|Tibet\u0161tina|Beng\u00e1l\u0161tina|Chorvat\u0161tina|Bisl\u00e1m\u0161tina|Twi|Bihar\u0161tina|Bulhar\u0161tina|Tatar\u0161tina|Nor\u0161tina|B\u011bloru\u0161tina|Tsonga|Hind\u0161tina|Ture\u010dtina|Holand\u0161tina|Zulu|Baskir\u0161tina|Tonga|Hebrej\u0161tina|Setswan\u0161tina|Tagalog|Turkmen\u0161tina|Hausa|Nep\u00e1l\u0161tina|Azerbajd\u017e\u00e1n\u0161tina|Tigrinij\u0161tina|Aym\u00e1r\u0161tina|Thaj\u0161tina|T\u00e1d\u017ei\u010dtina|Nauru|Telug\u0161tina|\u010c\u00edn\u0161tina|Assam\u00e9\u0161tina|Arab\u0161tina|Tamil\u0161tina|Gujarat\u0161tina|Barm\u0161tina|Amhar\u0161tina|Zhuang|Malt\u0161tina|Malaj\u0161tina|Guaran\u0161tina|Svahil\u0161tina|Marathi|\u0160v\u00e9d\u0161tina|Hali\u010d\u0161tina|Sundan\u0161tina|Afrik\u00e1n\u0161tina|Sesotho|Moldav\u0161tina|Siswat\u0161tina|Mongol\u0161tina|Srb\u0161tina|Alb\u00e1n\u0161tina|Malabar\u0161tina|Abch\u00e1z\u0161tina|Makedon\u0161tina|Afar\u0161tina|Som\u00e1l\u0161tina|Shona|Maor\u0161tina|Skotsk\u00e1 gal\u0161tina|Samoy\u0161tina|Slovin\u0161tina|Malga\u0161tina|Sloven\u0161tina|Ir\u0161tina|Yoruba|Sinh\u00e1l\u0161tina|Srbochorvat\u0161tina|Sangho|Jidi\u0161|Sindhi|Fr\u00ed\u0161tina|Sanskrt|Francouz\u0161tina|Loty\u0161tina|Litev\u0161tina|Faer\u0161tina|Kinyarwand\u0161tina|Ru\u0161tina|Lao\u0161tina|Fid\u017ei|Lingal\u0161tina|Fin\u0161tina|Rumun\u0161tina|Kirundi|R\u00e9torom\u00e1n\u0161tina|Per\u0161tina|Latina|Xhosa|Baski\u010dtina|Kirgiz\u0161tina|Eston\u0161tina";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GuMtkHmsSEDFwWahKzUeygAZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "d.M.yy" },
    { "mediumDateFormat", "d.M.yyyy" },
    { "longDateFormat", "d. MMMM yyyy" },
    { "fullDateFormat", "EEEE, d. MMMM yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
